program tempest ;
{ COPYRIGHT (C) 1982 BRUCE LADENDORF }
EXPORTS {****************************************************************}

IMPORTS CmdParse FROM CmdParse;
IMPORTS Rand FROM Rand;

CONST
    NUMNODES = 41;
    LOWNODES = 0;
    HIGHNODES = LOWNODES + NUMNODES - 1;
    
    NUMLINKS = 75;
    LOWLINKS = 0;
    HIGHLINKS = LOWLINKS + NUMLINKS - 1;
    
    STARTNODE = 0;
    FINISHNODE = 40;

    NONE = 0;
    YELLOW = 1;
    GREEN = 2;
    RED = 4;
    PURPLE = 8;
    ALL = YELLOW + GREEN + RED + PURPLE;

    BOGUSLINK = LOWLINKS-1;

TYPE
    PathType = record
        path : array [1..NUMLINKS+1] of integer;
        numinpath : integer;
    end;
{    smallStatetype = record 
        lightson : integer;
        score : integer;
        numflags : integer;
        curnode : integer;
        lostpoints : integer;
        linkused : integer;
        nextnode : integer;
    end;}
    StateType = record
        linkfree : array [LOWLINKS..HIGHLINKS] of boolean;
        lightson : integer;
        score : integer;
        numflags : integer;
        curnode : integer;
    end;
    SubGraph = array [LOWLINKS..HIGHLINKS] of boolean;
VAR
    assumesg, stdsubgraph : subgraph;
    sgmaxflags : integer;
    ValOfNode : array [LOWNODES..HIGHNODES] of integer;
    ColorOfNode : array [LOWNODES..HIGHNODES] of integer;
    GetThereFromHere : 
        array [LOWNODES..HIGHNODES, LOWNODES..HIGHNODES] of integer;
    Lon, Loff : array [LOWNODES..HIGHNODES] of integer;
    
    numlightson : array [0..7] of integer;
    
    hasflag : array [LOWLINKS..HIGHLINKS] of integer;
    smallend, bigend : array [LOWLINKS..HIGHLINKS] of integer;

    linksfrom, tonode : array [LOWNODES..HIGHNODES, 1..8] of integer;
    nlinksfrom : array [LOWNODES..HIGHNODES] of integer;
    maxvisits : array [LOWNODES..HIGHNODES] of integer;

    MainPath : pathtype;

    { replacement variables for complete search }
    globlightson : array [1..NUMLINKS] of integer;
    globscore : array [1..NUMLINKS] of integer;
    globnumflags : array [1..NUMLINKS] of integer;
    globcurnode : array [1..NUMLINKS] of integer;
    globlinks : array [LOWLINKS..HIGHLINKS] of boolean; { sort of replacement }

    { search variables for new complete search }
    { at 2222, all arrays and variables are valid for 1..curdepth-1,
        except nexnode[curdepth] }
    curdepth : integer;
    nextnode : array [1..NUMLINKS] of integer;
    linkused : array [1..NUMLINKS] of integer;
    lostpoints : array [1..NUMLINKS] of integer;
    numvisits : array [LOWNODES..HIGHNODES] of integer;
    flagstoget : array [1..NUMLINKS] of integer;
    totlostpoints : integer;
    Numbumpers : integer;
    nodelastuse : array [LOWNODES..HIGHNODES] of integer;
    nodesbackup : array [LOWNODES..HIGHNODES, 1..4] of integer;
    nodenumbackup : array [LOWNODES..HIGHNODES] of integer;
    badnews : array [1..NUMLINKS] of integer;
    bndepth : integer;

    { misc vars for complete search }
    pointThreshold : integer;
    compath : pathtype;

CONST
    NEWMAXEDGES = 30;

VAR
    i : integer;
    badlinks : array [LOWLINKS..HIGHLINKS] of integer;
        { > 0 IFOF link is not to be used in further searching}
    oddnodes : array [LOWNODES..HIGHNODES] of boolean;
        { TRUE if node currently has odd number of links }
    curlinks : array [1..NEWMAXEDGES] of integer;
    linktried : array [1..NEWMAXEDGES] of integer;
    thelinks : array [1..NEWMAXEDGES, 1..NUMLINKS] of integer;
{    curdepth : integer;}
    numodd :integer;
    firsttime : boolean;
    foundone : boolean;
    linkis : integer;
    startlink : integer;
    numsolutions : integer;

PRIVATE
IMPORTS T3Sub FROM T3Sub;

{FUNCTION InUpperBound (sg : subgraph) : integer; forward;
procedure CommandLoop (prompt : string; var inchan : text); forward;}



PROCEDURE CompleteSearch ;
LABEL
    2222, 3333;
CONST
    VERBOSE = FALSE;
VAR
    i, j, tempnext, newnode, bestscore, lastuse : integer;
    upperlimit : integer;
    thisdepth, otherdepth : integer;
    isbadnews : boolean;
    nodecount : long;
    ch : char;
BEGIN
    writeln ('Doing a New Complete Search');
    bestscore := 0;
    nodecount := 0;
    upperlimit := InUpperBound (stdsubgraph);
    {$IFC VERBOSE THEN}
        writeln ('Threshold That is to be used is ', upperlimit:1);
    {$ENDC}
    
    { inits }
    for i := LOWNODES to HIGHNODES do nodenumbackup[i] := 0;
    nodelastuse[0] := 1;
    nodenumbackup[0] := 1;
    bndepth := 0;

    { init from the subgraph stdsubgraph }
    curdepth := 2;
    globlightson[1] := NONE;
    globscore[1] := 0;
    globnumflags[1] := 0;
    globcurnode[1] := STARTNODE;
    for i := LOWLINKS to HIGHLINKS do globlinks[i] := stdsubgraph[i];

    nextnode[1] := 1; { for completeness }
    linkused[1] := 1;
    lostpoints[1] := 0;
    flagstoget[1] := 21;
    numbumpers := 0;
    totlostpoints := 0;

    { start by going deeper }
    nextnode[curdepth] := 0;
    goto 2222;
    
  2222: ; { try next node }
    nodecount := nodecount + 1;
    if (curdepth <= 1) then begin
        writeln ('Threshold was ', pointThreshold:1);
        writeln ('Num Nodes was ', nodecount:1);
        exit (completesearch);
    end;

    {$IFC VERBOSE THEN}
        writeln ;
        writeln ('S T A T E');
        writeln ('CD L SCOR FL CN NN FG LU LPs');
        for i := 1 to curdepth-1 do begin
            write (i:2, ' ',
                globlightson[i]:1, ' ',
                globscore[i]:4, ' ',
                globnumflags[i]:2, ' ',
                globcurnode[i]:2, ' ',
                nextnode[i]:2, ' ', 
                flagstoget[i]:2, ' ',
                linkused[i]:2, ' ',
                lostpoints[i]:3, ' ');
            writeln ;
        end;
        writeln ;
        writeln ('NextN NumB TotPts');
        writeln (nextnode[curdepth]:5, ' ', 
            numbumpers:4, ' ',
            Totlostpoints:6);
        for j := LOWLINKS to HIGHLINKS do
          if (not globlinks[j]) then
            write (j:1, ' ');
        writeln ;
        for j := 1 to curdepth-1 do
            write (linkused[j]:1, ' ');
        writeln ;
        writeln ;
    {$ENDC}

  {$IFC FALSE THEN}
    writeln ;
    writeln ('NUKE THIS PATH??? [No]');
    if (eoln ) then readln 
    else begin
        readln (ch);
        if (ch = 'y') then goto 3333;
    end;
  {$ENDC}

    if (upperlimit-totlostpoints < pointThreshold) then begin
        { truncate this path because of threshold }
        {$IFC VERBOSE THEN}
            writeln ('THRESHOLD ', upperlimit-totlostpoints);
        {$ENDC}
        goto 3333;
    end;
    tempnext := nextnode[curdepth]+1;
    nextnode[curdepth] := tempnext;
    if (tempnext>nlinksfrom[globcurnode[curdepth-1]]) then begin
        { go up }
        {$IFC VERBOSE THEN}
            writeln (' No more, go up');
        {$ENDC}
      3333: ;
        if ((globcurnode[curdepth-1] = 18)or(globcurnode[curdepth-1]=23)) then 
                numbumpers := numbumpers - 1;
        totlostpoints := totlostpoints - lostpoints[curdepth-1];
        globlinks[linkused[curdepth-1]] := TRUE;
        curdepth := curdepth - 1;
        if (bndepth > 0) then if (badnews[bndepth] >= curdepth) then
            bndepth := bndepth-1;
        nodelastuse[globcurnode[curdepth]] := 
            nodesbackup[globcurnode[curdepth],
              nodenumbackup[globcurnode[curdepth]] ];
        nodenumbackup[globcurnode[curdepth]] := 
            nodenumbackup[globcurnode[curdepth]] - 1;
        goto 2222;
    end;
    {$IFC VERBOSE THEN}
        write (' Trying son ', tonode[globcurnode[curdepth-1],tempnext]:1);
    {$ENDC}
    newnode := tonode[globcurnode[curdepth-1],tempnext];

    if (not globlinks[linksfrom[globcurnode[curdepth-1], tempnext]]) then begin
        { goto next son }
        {$IFC VERBOSE THEN}
            writeln (' Bad Node, skip son');
        {$ENDC}
        goto 2222;
    end;

    if (newnode = FINISHNODE) then begin
        { report score, then go up }
        {$IFC VERBOSE THEN}
            writeln (' Made it',
                ' score ', globscore[curdepth-1]:4);
        {$ENDC}
        if (globscore[curdepth-1] > bestscore) then begin
            writeln ('NEWBEST ', globscore[curdepth-1]:4);
            bestscore := globscore[curdepth-1];
            for i := 1 to curdepth-1 do compath.path[i] := globcurnode[i];
            compath.numinpath := curdepth-1;
            printpath (compath, output);
        end;
        if (globscore[curdepth-1] < pointThreshold) then goto 2222;
        Writeln ('GOT A GREAT SOLUTION!!!!!, score ', globscore[curdepth-1]:1);


        { going up... }
        goto 2222;
    end;

    { go down }
{    if (Lon[newnode] <> NONE) then
        globlightson[curdepth] := LOR (globLightsOn[curdepth-1], Lon[newnode]);
    if (Loff[newnode] <> ALL) then
        GlobLightsOn[curdepth] :=
            LAnd (GlobLightsOn[curdepth-1], Loff[newnode]);}
    globlightson[curdepth] := 
        LAND (Loff[newnode], LOR (Lon[newnode], globlightson[curdepth-1]) );
    globcurnode[curdepth] := newnode;
    linkused[curdepth] := linksfrom[globcurnode[curdepth-1], tempnext];
    globnumflags[curdepth] := 
        globnumflags[curdepth-1] + hasflag[linkused[curdepth]];
    globscore[curdepth] := globscore[curdepth-1] + FasterDeltaScore (newnode);
    globlinks[linkused[curdepth]] := FALSE;
    lostpoints[curdepth] := FasterLosePoints (newnode);
    if ((newnode = 18) or (newnode = 23)) then numbumpers := numbumpers+1;
    totlostpoints := totlostpoints + lostpoints[curdepth];
    {$IFC VERBOSE THEN}
        writeln (' OK Go Down, lost ', lostpoints[curdepth]:3);
    {$ENDC}
    curdepth := curdepth + 1;
    nextnode[curdepth] := 0;
    case newnode of
      18,23,35,37,2,3,4,24,31:
        begin
            bndepth := bndepth + 1;
            badnews[bndepth] := curdepth-1;
        end;
    end; {case}
    nodenumbackup[newnode] := nodenumbackup[newnode] + 1;
    nodesbackup[newnode, nodenumbackup[newnode]] := nodelastuse[newnode];
    nodelastuse[newnode] := curdepth-1;
    flagstoget[curdepth-1] := flagstoget[curdepth-2];
                   
  {$IFC TRUE THEN}
    if (nodenumbackup[globcurnode[curdepth-1]] > 1) then begin
        { consider zapping this path as having a redundant loop }
        {$IFC VERBOSE THEN}
            writeln ('Considering zapping because of loop');
        {$ENDC}
        thisdepth := curdepth-1;
        otherdepth := nodesbackup[globcurnode[curdepth-1], 
            nodenumbackup[globcurnode[curdepth-1]] ];
        if (globcurnode[thisdepth-1] > globcurnode[otherdepth+1]) then begin
            { first step nodes are not in order, if no bad news then
              zap path. }
            isbadnews := FALSE;
            for i := bndepth downto 1 do begin
                if ((badnews[i] > otherdepth) and (badnews[i] < thisdepth))then
                    isbadnews := TRUE;
            end;
            if (NOT isbadnews) then begin
                {$IFC VERBOSE THEN}
                    writeln ('zapped');
                {$ENDC}
                goto 3333;
            end;
        end;
    end;
  {$ENDC}

    goto 2222;
END;


{PRIVATE {****************************************************************}

BEGIN
    { global inits }
    Initialize ;
    InitRandom ;

    { init sole global variable of command program }
    MainPath.numinpath := 0;

    CommandLoop ('T> ', input);
END.
{ }
