module Speech;
{*****************************************************************}
{
{ Speech -- COUSIN speech recognition interface
{
{       Copyright (C) 1982
{       Carnegie-Mellon University
{       Computer Science Department
{       Pittsburgh, Pa.  15213
{
{ 
{ Author: J. Eugene Ball 
{ Date:   1 Feb 1982
{
{ 
{
{ Abstract:
{   
{ 
{-----------------------------------------------------------------}
{ History:
{   1 Feb 82  V1.0  JEB   Created.
{     Mar 82  BL: Added body for StrtoWid, Widtostr
{  18 Mar 82 FAA: Added body for RecogString
{*****************************************************************}



{***********************}  EXPORTS   {****************************}


const
  SpeechVersion = 'COUSIN Speech Version 1.0';
  HIGHWORDID = 511;

type
  WordID = 0..HIGHWORDID; { id's of distinct vocabulary entries }
  WordSet = set of 0..511;
{  WordSet = packed array [0..HIGHWORDID] of boolean;}
      { set of words active for recognition }
{  Confidence = 0..100;          { confidence of recognition, 100 = certain }
  Confidence = -2..32767;        
    { confidence is the average frame-to-frame distance of best match }
  SpeechFile = file of integer;

const
  SILENCE      = 0;  { returned when no speech occurred }
  UNRECOGNIZED = 1;  { returned for utterance that didn't match anything }

{**************************
 *  Vocabulary
 *   1: command context
 *     Check-mail     -- tell me about new messages
 *     Read-messages  -- start reading mail
 *     Send           -- create a message
 *     Quit-listening -- turn off recognition (except for Listen-to-me)
 *     Listen-to-me   -- restart recognition
 *
 *   2: mail reading
 *     Next-message  -- read next message
 *     Repeat        -- re-read current message
 *     Backup        -- re-start from 15 secs back
 *     Answer        -- enter MailPrep to reply
 *     Play  <digit>*
 * 
 *   3: mail preparation
 *     Destination
 *     Copies
 *     Record-body   -- records till 10 sec. silence
 *     More          -- add more at end
 *     Playback      -- play message so far
 *     Deliver
 *
 *   4: recipients
 *     Ball
 *     Hayes
 *     Adams
 *     Cerf
 *     Postel
 *     Thomas
 *     Forsdick
 *     Spell <letter>*
 *
{*************************}

var
  MaxWordID:  WordID;           { max ID in current vocabulary }

 

{*  StrToWordID
 *    translate a string to the corresponding word ID
 *}
function StrToWordID(s: string): WordID;


{*  WordIDToStr
 *    translate a word ID to the corresponding string
 *}
function WordIDToStr(i: WordID): string;


{*  VocabSubset
 *    select a subset of full vocabulary for recognition
 *}
procedure VocabSubset(ws: WordSet);


{*  Recognize
 *    try to recognize speech input-- return ID of recognized word
 *}
procedure Recognize(var wid: WordID; var conf: Confidence; TimeOut : integer);


{*  RecogString
 *    recognize a string--
 *      doesn't have to be in the current vocabulary subset, could be 
 *       spelled out
 *}
procedure RecogString(var s: string; ws: WordSet; var conf: Confidence);

  
{*  InitSpeech
 *    initialize Speech subsystem to recognize from the specified vocabulary
 *}
procedure InitSpeech(vocabname: string);


{*  RecordSpeech
 *    record vocoder input into speech file --
 *      terminated by 15 secs silence or other input
 *}
procedure RecordSpeech(filename:string; numsecs:integer);


{*  Play
 *    play vocoder from speech file for specified time
 *}
procedure Play(filename : string);
   

{***********************}  PRIVATE   {****************************}

imports DefUtt from DefUtt;
imports SUIFace from NewSUIFace;
imports suvoc from suvoc;
{imports SpellBe from SpellBe;}

{****************************************************************}
function StrToWordID(s: string): WordID;
{ translates a string to a word ID, returns Maximum value if bogus }
var
    i : integer;
begin
    for i := 1 to numrefs do begin
        if (refs.vec^[i].called = s) then begin
            if (i-1 <= HIGHWORDID) then StrToWordID := i-1
            else StrToWordID := HIGHWORDID;
            exit (StrToWordID);
        end;
    end;
    StrToWordID := HIGHWORDID;
end;

{****************************************************************}
function WordIDToStr(i: WordID): string;
{ translates a wordID to a string, returns 'BOGUS' if bogus wordID }
begin
    WordIDtoStr := 'BOGUS';
    if ((i >= 0) and (i <= HIGHWORDID) and (i+1 <= numrefs)) then 
        WordIDtoStr := refs.vec^[i+1].called;
end;

{****************************************************************}
procedure VocabSubset(ws: WordSet);
var
    i : integer;
begin
    for i := 1 to numrefs do begin
        if ((i-1) in ws) then begin
            refs.vec^[i].uttkind := REF
        end
        else refs.vec^[i].uttkind := NOTREF;
    end;
    SetRefs (refs);
end;

{****************************************************************}
procedure Recognize(var wid: WordID; var conf: Confidence; TimeOut : integer);
{ conf = -1 means bogus length }
{ conf = -2 means timeout }
begin
    NsRecogWord (wid, conf, TimeOut);
end;

{****************************************************************}
procedure RecogString(var s: string; ws: WordSet; var conf: Confidence);
Var
    start: boolean;
{    pVec: VowelProb;}
    wid: WordID;

begin
{    s := 'ERROR';
{    start := true;
{    InitSpellBE (ws);
{
{    repeat
{        case GetLetter (pVec) of
{            R_SOUND: wid := Match (pVec, 0, start);
{            R_SILENCE: writeln ('Cat got your tounge ?');
{            R_ERROR: Begin
{                      conf := 0;
{                      Exit (RecogString);
{                   End;
{        end;
{        
{        start := false;
{    until wid <> 0;
{
{    conf := 100;
{    s := WordIdToStr (wid); }
end;

{****************************************************************}
procedure InitSpeech(vocabname: string);
begin
    NsInitSpeech ;
    MaxWordID := numrefs-1;
end;

{****************************************************************}
procedure RecordSpeech(filename:string; numsecs:integer);
begin
    RecFile (filename, numsecs);
end;

{****************************************************************}
procedure Play(filename : string);
begin
    PlayFile (filename);
end.
{ }
