module Reader;


{-----------------------------------------------------------------------------
{
{       Reader - Stream package input conversion routines.
{       J. P. Strait   ca. 1 Jan 81.
{       Copyright (C) Three Rivers Computer Corporation, 1981.
{ 
{ Abstract:
{       Reader is the character input module of the Stream package.  It is
{       called by code generated by the Pascal compiler in response to Read
{       or Readln.  It is one level above Module Stream and uses Stream's
{       lower-level input routines.
{
{-----------------------------------------------------------------------------}


{ 4 Jun 81  V2.1  John Strait.
{ Add Virgil headers and comments.
{ }

{ 12 May 81  V2.0  John Strait.
{ 1. Use exceptions rather than StreamError.
{ 2. Fix bug in read routines caused by not clearing CharReady.
{ }

exports
 

imports Stream from Stream;
 
 
 procedure ReadBoolean( var F: FileType; var X: boolean );
 procedure ReadCh( var F: FileType; var X: char; Field: integer );
 procedure ReadChArray( var F: FileType; var X: ChArray; Max, Len: integer );
 procedure ReadIdentifier( var F: FileType; var X: integer;
                           var IT: IdentTable; L: integer );
 procedure ReadInteger( var F: FileType; var X: integer );
 procedure ReadString( var F: FileType; var X: String; Max, Len: integer );
 procedure ReadX( var F: FileType; var X: integer; B: integer );


private
