module gpib;
{-----------------------------------------------------------
{
{ Abstract:
{    Support routines for PERQ GPIB devices.  The package maintains a
{    buffer (gpCommandBuffer) which holds either data bytes (sent with
{    procedure gpPutByte) or Auxiliary commands (sent with gpAuxCommand).
{    The buffer is sent to the 9914 when full, or when gpFlushBuffer is
{    called.  If the buffdr has data bytes when gpAuxCommand is called,
{    it will do a gpFlushBuffer.  Similarly, when gpPutByte is called,
{    it will flush the buffer, if auxiliary commands are in
{    gpCommandBuffer.
{
{  writen by Brian Rosen
            Copyright(C) 1980, Three Rivers Computer Corporation
{----------------------------------------------------------------
{
{   Change log:
{  
  27 Jan 82  V1.3  WJH added GPIBerror
                       added first test of gpBufPtr in gpAuxCommand
            
  15-Jun-81  V1.2  DAS Changed to compiler under POS D.
  
  2-Jan-81   V1.1  BR  fixed names of Controller Command Codes and
                       apAuxiliaryCommands to have "gp" prefix
                       to avoid name conflicts (especially get)
}


exports
 const GpibVersion = '1.3';
       gpBufSize = 32;
       gpBufMax = 31; {gpBufSize - 1}
 { the following codes are the IEE488-1975 Controller Command Codes
   they are issued by the Controller-In-Charge while asserting ATN }
       gpacg = #000; {addressed group command}
       gpdcl = #024; {device clear}
       gpget = #010; {group execute trigger}
       gpgtl = #001; {go to local}
       gplag = #040; {listen address group}
       gpllo = #021; {local lockout}
       gpmla = #040; {my listen address}
       gpmta = #100; {my talk address}
       gpmsa = #140; {my secondary address}
       gpppc = #005; {parallel poll configure}
       gpppe = #140; {parallel poll enable}
       gpppd = #160; {parallel poll disable}
       gpppu = #025; {parallel poll unconfigure}
       gpscg = #140; {secondary copmmand group}
       gpsdc = #004; {selected device clear}
       gpspd = #061; {serial poll disable}
       gpspe = #060; {serial poll enable}
       gptct = #011; {take control}
       gptag = #100; {tahk address group}
       gpuag = #020; {universal address group}
       gpunl = #077; {unlisten}
       gpunt = #137; {untalk}
 type  { these commands are the major state change control commands
         of the TMS9914 chip which forms the interface to the GPIB
         Consult the TI documentation on the TMS9914 for more information}
       
       {These definitions are order dependent}
       gpAuxiliaryCommands = (gpswrst,   {Chip Reset}
                              gpdacr,    {Release DAC holdoff}
                              gprhdf,    {Release RFD holdoff}
                              gphdfa,    {Holdoff all data}
                              gphdfe,    {Holdoff on End}
                              gpnbaf,    {Set NewByteAVailable false}
                              gpfget,    {Force Group Execute Trigger}
                              gprtl,     {Return to Local}
                              gpfeoi,    {force End or Identify}
                              gplon,     {Listen Only}
                              gpton,     {Talk Only}
                              gpgts,     {GoTo Standby}
                              gptca,     {Take Control Asynchronously}
                              gptcs,     {Take Control Synchronously}
                              gprpp,     {Request Parallel Poll}
                              gpsic,     {Set Interface Clear}
                              gpsre,     {Set Remote Enable}
                              gprqc,     {Request Control}
                              gprlc,     {Release Control}
                              gpdai,     {Disable All Interrupts}
                              gppts,     {Pass Through next Secondary}
                              gpstdl,    {Set T1 Delay}
                              gpshdw);   {Shadow Handshake}
       gpParmType = (gpOff, gpOn, gpDontCare);  {parameters for Aux Commands}
       gpByte = 0..255;    {Data byte for gpib transactions}
       gpRange = 0..gpBufSize;
       gpDeviceAddress = 0..31;         {legal addresses for devices on GPIB}
       gpBuffer = packed array [gpRange] of gpByte;
       gppBuffer = ^gpBuffer;
 var   gpCommandBuffer: gppBuffer;      {place to put commands}
       gpBufPtr: 0..gpBufSize;          {pointer to gpCommandBuffer}
       gpHaveDataBytes, gpHaveAuxiliaryCommands: boolean;{true if buffer in use}
       
{   The package maintains a buffer (gpCommandBuffer) which holds
    either Data bytes (sent with proceedure gpPutByte)
    or Auxialiary Commands (sent with gpAuxCommand)
    The buffer is sent to the 9914 when full, or when ghForceBuffer
    is called.  If the buffer has data bytes when gpAuxilairyCommand is
    called, it will do a gpForceBuffer.  Similarly, when gpPutByte
    is called, it will force the buffer if auxiliary commands are in
    gpCommandBuffer
}

           { Initialze GPIB package, called once only, turns off tablet }
 procedure gpInit;
 
 
           { Send an auxiliary command to TMS9914
             some commands require a parameter (gpOff/gpOn) }
 procedure gpAuxCommand(gpCmd: gpAuxiliaryCommands; gpParm:gpParmType);
 
           { Put a data byte or a Control byte out on the data bus
             TMS9914 must be in Controller Actives State if the byte is a
             controller command byte.  Must be in Talk Only if a data byte }
 procedure gpPutByte(gpData: integer);
 
           { Sends all bytes in buffer }
 procedure gpFlushBuffer;
 
           { Set TMS9914 to be a Talker, set a device to be a listener
             This procedure takes control of the bus, unlistens and untalks
             all devices (including itself), and sets a listener with
             MyListenAddress then sets TMS9914 to be the talker with TalkONly }
 procedure gpITalkHeListens(gpAddr: gpDeviceAddress);
 
           { Set TMS9914 to be a Listener, set a device to be a talker
             This procedure takes control of the bus, unlistens and untalks
             all devices (including itself), and sets a talker with
             MyTalkAddress then sets TMS9914 to be the listener with ListenONly}
 procedure gpHeTalksIListen(gpAddr: gpDeviceAddress);

           { turn the BitPad (device addres #10) off }
 procedure gpTbltOn;
           { turn the BitPad back on again }
 procedure gpTbltOff;
           { Send a buffer of user data to the 9914 }
 procedure gpSend(var gpBuf: gppBuffer; gpCount: gpRange);
           {Get a buffer of data from the 9914 (Not implemented yet) }
 procedure gpReceive(var gpBuf: gppBuffer; gpCount: gpRange);
           { Get a byte of data from the GPIB }
 function  gpGetByte: gpByte;
 
exception GPIBerror(SoftStatus: integer);
{------------------------------------------
{Abstract:
{  Raised when GPIB encounters an error indication in softstatus from
{  UnitIO or IOCRead.  The condition should be corrected and the operation
{  retried.
{  The most likely error is a timeout: IOETIM (See IOErrors).
{-----------------------------------------}

private
