module Dynamic;
{-----------------------------------------------------------------------------
{
{       Dynamic - Perq dynamic memory allocation and de-allocation.
{       J. P. Strait      1 Jan 80.
{       Copyright (C) Three Rivers Computer Corporation, 1980, 1981,1982.
{
{ Abstract:
{       Dynamic implements Pascal dynamic allocation - New and Dispose.
{       Memory of a given size with a given alignment may be allocated from
{       any data segment.  If the data segment is full (doesn't contain
{       enough free memory to allocate), the segment is increased in
{       multiples of the segment's increment size until there is enough
{       free memory to allocate.  Similarly, memory that was once allocated
{       may be deallocated.
{
{ Design:
{       Free memory within each segment is linked into a circular freelist
{       in order of address.  Each free node is at least two words long and
{       is of the form
{
{       record Next:   Integer;
{              Length: Integer;
{              Rest:   2*Length - 2 words
{              end;
{
{       Where Next*2 is the address of the next free node and Length*2 is the
{       number of free words.
{
{-----------------------------------------------------------------------------}


{ 26 Oct 81  V1.4  JPS
{ Make certain that the segment passed to NewP and DisposeP is a data segment.
{ }

{ 12 May 81  V1.3  JPS
{ Use exceptions rather than MemoryError.
{ }

{ 23 Mar 81  V1.2  JPS
{ Convert to standard documentation form.
{ }

{ 13 Jan 81  V1.1  JPS
{ Fix assignment of nil in New and Dispose.
{ Change bad constant #200000 to #100000.
{ Move $R- to private part.
{ }

exports


const DynamicVersion = '1.4';


imports Memory from Memory;


 procedure NewP( S: SegmentNumber; A: integer; var P: MMPointer; L: integer );
 procedure DisposeP( var P: MMPointer; L: integer );


private
