module Code;

{-----------------------------------------------------------------------------
{
{       Code.Pas - Common definitions for the Linker and Loader.
{       J. P. Strait         10 Feb 81.  Rewritten as a module.
{       Copyright (C) Three Rivers Computer Corporation, 1981.
{
{ Abstract:
{
{       Code.Pas defines constants and types shared by the Linker and the
{ Loader.  These include definitions of the run file and of offsets in the
{ stack segment.
{
{ Design:
{       When the format of run files is changed, the constant RFileFormat
{ must also be changed.  This is necessary to prevent the procedures which
{ read run files from failing.
{
{-----------------------------------------------------------------------------}


{  6 Jan 82  1.8  Brad Myers
{ Changed qcode version number to 3.
{ }

{  6 Jan 82  1.7  Brad Myers
{ Fixed definition of SegBlock to include Version and Copyright strings.
{ }

{ 21 Jul 81  1.6  John Strait
{ Add Hints to the segment information node.
{ }

{ 18 May 81  1.5  Brad Myers
{ Increment Q-Code version number.
{ }

{  9 Apr 81  1.4  John Strait
{ Change RunInfo to be a record that just contains the header information
{ and define a pointer to it.
{ Change node definitions in order to implement RunFiles module.
{ }

{  8 Apr 81  1.3  John Strait
{ Add "ProgramSN" to RunHeader.  This is the ISN of the program segment.
{ }

{ 19 Mar 81  1.2  Miles A. Barel
{ Increased size of SEG and RUN file names and added QCode Version stuff
{ }

{ 23 Feb 81  1.1   Don Scelza
{ Changed the name Header to RunHeader.  There was a name
{ conflict with the C-MU file system.
{ }

{ 10 Feb 81  1.0  John Strait
{ Start file.
{ }

exports


  imports GetTimeStamp from GetTimeStamp;



const   CodeVersion = '1.7';
        RFileFormat = 2;

        QCodeVersion = 3;       { Current QCode Version Number }
        FileLength   = 100;     { max chars in a file name }
        SegLength    = 8;       { max chars in a segment name }
        StackLeader  = 2;       { number of leader words in stack before }
                                { XSTs (must be even)                    }
                                { Currently contains initial TP and GP   }
        DefStackSize = #20;     { default stack segment size (in blocks) }
        DefHeapSize  = #4;      { default heap segment size (in blocks) }
        DefIncStack  = #4;      { default stack size increment (in blocks) }
        DefIncHeap   = #4;      { default heap size increment (in blocks) }
        FudgeStack   = #2000;   { fudge space between system and user GDB's }
                                { this must hold all loader variables at }
                                { maximum configuration in LoadStack }

        CommentLen   = 80;      { the length of comment and version str in seg}
        


type
        SNArray = packed array[1..SegLength] of Char;  { segment name }

        pFNString = ^FNString;
        
        FNString = String[FileLength];  { file name }
        
        QVerRange = 0..255;             { range of QCode version numbers }


        SegHint = record case Integer of
                    1: (Fid   : Integer;      { file id }
                        Update: TimeStamp);   { update time }
                    2: (Word1 : Integer;
                        Word2 : Integer;
                        Word3 : Integer)
                    end;
        
        
        pSegNode = ^SegNode;
        
        pImpNode = ^ImpNode;


        { Segment information record:}

        SegNode = record
                   SegId    : SNArray;     { segment name }
                   RootNam  : pFNString;   { file name without .Pas or .Seg }
                   Hint     : SegHint;     { hint to the segment file }
                   GDBSize  : integer;     { size of this segment's GDB }
                   XSTSize  : integer;     { size of this segment's XST }
                   GDBOff   : integer;     { StackBase offset to GDB }
                   ISN      : integer;     { segment number inside Linker }
                   CodeSize : integer;     { number of blocks in .Seg file }
                   SSN      : integer;
                   UsageCnt : integer;
                   ImpList  : pImpNode;
                   Next     : pSegNode
                   end;


        { Import information record }
                   
        ImpNode = record
                   SId      : SNArray;     { name of imported segment }
                   FilN     : pFNString;   { file name of imported segment }
                   XGP      : integer;     { global pointer of import }
                   XSN      : integer;     { internal number of import }
                   Seg      : pSegNode;
                   Next     : pImpNode
                   end;


        { Run file: }
        
        RunElement = (RunHeader,SysSegment,UserSegment,Import,SegFileNames);
        
        RunInfo = record   { run header }
                   RFileFormat:integer;
                   Version:    integer;
                   System:     boolean;
                   InitialGP:  integer;
                   CurOffset:  integer;
                   StackSize:  integer;
                   StackIncr:  integer;
                   HeapSize:   integer;
                   HeapIncr:   integer;
                   ProgramSN:  integer;
                   SegCount:   integer
                   end;

        RunFileType = file of Integer;


        { Segment file: }
        
        pSegBlock = ^SegBlock;
        
        SegBlock = packed record case boolean of       { .SEG file definition }
                    { first block: }
                    true: (ProgramSegment: boolean;
                           SegBlkFiller  : 0..127;
                           QVersion      : QVerRange;
                           ModuleName    : SNArray;
                           FileName      : FNString;
                           NumSeg        : integer;
                           ImportBlock   : integer;
                           GDBSize       : integer;
                           Version       : String[CommentLen];
                           Comment       : String[CommentLen]);
                    false:(Block: array[0..255] of integer)
                    end;
        
        CImpInfo = record case boolean of   { Import List Info - as generated }
                                            { by the compiler }
                        true: ( ModuleName: SNArray;  { module identifier }
                                FileName:   FNString  { file name }
                              );
                        false:( Ary: array [0..0] of integer)
                     end;
                     
        SegFileType = file of SegBlock;



private
