module Arith;
{----------------------------------------------------------------------------
 Implements interim Double precision arithmetic package
      Needed until Pascal compiler supports type long.
 Copyright (C) 1980 Carnegie-Mellon University
----------------------------------------------------------------------------}
{----------------------------------------------------------------------------
 Versions:
   1-Jun-81  Brad Myers       V2.2 Added comments
  14-Apr-81  George Robertson V2.1 Fixed bug in IntDouble
  12-Apr-81  George Robertson V2.0 Converted to use microcode support
  19-Mar-81  Brad Myers       V1.3 Fixed to import FileDefs
   2-Feb-81  George Robertson at Carnegie-Mellon University
                              V1.0 Fixed DoubleInt to handle negative integers.
                                   Fixed DoubleMul to handle
                                   multiplicands > 2^15
                                   by using Knuth's algorithm on p.233 of Knuth
                                   vol.2.
----------------------------------------------------------------------------}
exports

imports FileDefs from FileDefs;  { to get FSBitnn }

type
  MyDouble = packed record
             case integer of
               1:
                 (
                   Lsw : integer;
                   Msw : integer
                 );
               2:
                 (
                   Ptr : FSBit32
                 );
               3:
                 (
                   Byte0 : FSBit8;
                   Byte1 : FSBit8;
                   Byte2 : FSBit8;
                   Byte3 : FSBit8
                 )
             end;
             
function DoubleAdd(a,b : FSBit32) : FSBit32;
function DoubleSub(a,b : FSBit32) : FSBit32;
function DoubleNeg(a   : FSBit32) : FSBit32;
function DoubleMul(a,b : FSBit32) : FSBit32;
function DoubleDiv(a,b : FSBit32) : FSBit32;
function DoubleInt(a   : integer) : FSBit32;
function IntDouble(a   : FSBit32) : integer;
function DoubleBetween(a,start,stop : FSBit32) : boolean;

function DoubleMod(a,b : FSBit32) : FSBit32;
function DoubleAbs(a   : FSBit32) : FSBit32;

function DblEql(a,b : FSBit32) : boolean;
function DblNeq(a,b : FSBit32) : boolean;
function DblLeq(a,b : FSBit32) : boolean;
function DblLes(a,b : FSBit32) : boolean;
function DblGeq(a,b : FSBit32) : boolean;
function DblGtr(a,b : FSBit32) : boolean;

private
