Program Faces;


{ Demo Program from SCR - modified by Miles A. Barel (3RCC)
  Slides four pictures about the screen.
  
  Parameters :
  
      First Arg[1]: Step Size for Slide
      Second Arg[30]: Delay between quick moves
      Third Arg[30]: Delay between major steps of demo
      Fourth Arg[1]: Slide Speed
      Fifth Arg[-1]: Number of sets to run (-1 = infinite)
      Sixth Arg[0]: Increment to Step Size on each iteration

  Pictures are Faces1.Pic, Faces2.Pic, Faces3.Pic Faces4.Pic
}

Imports Raster from Raster;
Imports Memory from Memory;
Imports SigUtils from SigUtils;
Imports Screen from Screen;
Imports System from System;
Imports CmdParse from CmdParse;
Imports FileSystem from FileSystem;
Imports Sleep from Sleep;
Imports IO from IO;
Imports IOErrors from IOErrors;
imports gpib from gpib;


Const ScreenW = 48;


Type Picture = Record
             Width: Integer;
             Height: Integer;
             ScanLength: Integer;
             BlockCount: Integer;
             LeftX,TopY: Integer;
             pPixels: RasterPtr;
           End;
     pPicture = ^Picture;
          
var   Pic: pPicture;
      ScrnPtr: RasterPtr;
      FileName, Style: string;
      X, Y, W, H: integer;
      MinX, MinY, MaxX, MaxY: integer; { window dimensions }
      StepSize: integer;
      Dum: boolean;
      Title: string;
      ClearFlag: boolean;
      SegNum, Delay1, Delay2, Delay3, Times, Incr: Integer;

Function Min( a, b: Integer):Integer;
Begin
  If a < b Then Min := a Else Min := b;
End;

Function Max( a, b: Integer ): Integer;
Begin
  If a > b Then Max := a Else Max := b;
End;



Function GetPic( FileName: String ): pPicture;
Var Blks, Bits, Filen, Blkn: Integer;
    P: pPicture;
Begin
   Filen := FSLookup( FileName, Blks, Bits );
   If Filen = 0
     Then GetPic := Nil
     Else Begin
       CreateSegment( SegNum, Blks, 1, Blks );
       For Blkn := 0 to Blks-1
         do FSBlkRead( Filen, Blkn, MakePtr( SegNum, Blkn*256, pDirBlk ) );
       P := MakePtr( SegNum, 0, pPicture );
       P^.pPixels := MakePtr( SegNum, 256, RasterPtr );
       P^.LeftX := 0;
       P^.TopY := 0;
       GetPic := P;
       End;
end;

Procedure DelPic( P: pPicture );
Var Hack: record case boolean of
             true: (Ptr: pPicture);
             false: (Seg, Ofst: Integer)
          End;
Begin
   Hack.Ptr := P;
   DecRefCount( Hack.Seg );
End;


Function SavePic( FileName: String; X, Y, W, H: Integer ):Boolean;
Begin
    SavePic := False;
End;

{ straight copy to screen }
Procedure Copy(X, Y, W, H: integer);
  begin
    RasterOp(RRpl, W, H,
      X, Y, ScreenW, ScrnPtr,
      0, 0, Pic^.ScanLength, Pic^.pPixels);
  end;


{ Left-to-right wipe }
Procedure LWipe(X, Y, W, H: integer);
  var i: integer;
  begin
  for i := 1 to W do
    begin
    RasterOp(RRpl, 1, H,
      X+i-1, Y, ScreenW, ScrnPtr,
      i-1, 0, Pic^.ScanLength, Pic^.pPixels);
    end;
  end;

{ Top-to-bottom wipe }
Procedure TWipe(X, Y, W, H: integer);
  var i: integer;
  begin
  for i := 1 to H do
    begin
    RasterOp(RRpl, W, 1,
      X, Y+i-1, ScreenW, ScrnPtr,
      0, i-1, Pic^.ScanLength, Pic^.pPixels);
    end;
  end;

{ Right-to-left wipe }
Procedure RWipe(X, Y, W, H: integer);
  var i: integer;
  begin
  for i := 1 to W do
    begin
    RasterOp(RRpl, 1, H,
       X + (W - i), Y, ScreenW, MakePtr(ScreenSeg,0,RasterPtr),
       0 + (W - i), 0, Pic^.ScanLength, Pic^.pPixels);
    end;
  end;

{ Bottom-to-top wipe }
Procedure BWipe(X, Y, W, H: integer);
  var i: integer;
  begin
  for i := 1 to H do
    begin
    RasterOp(RRpl, W, 1,
      X, Y + (H - i), ScreenW, ScrnPtr,
      0, 0 + (H - i), Pic^.ScanLength, Pic^.pPixels);
    end;
  end;

{ Horizontal Center-out wipe }
Procedure HOutWipe(X, Y, W, H: integer);
  var i, CtrX: integer;
  begin
  CtrX := X + (W div 2);
  for i := 1 to (W div 2) do
    begin
    RasterOp(RRpl, i * 2, H,
      CtrX - i, Y, ScreenW, ScrnPtr,
      (W div 2) - i, 0, Pic^.ScanLength, Pic^.pPixels);
    end;
  end;

{ Vertical Center-out wipe }
Procedure VOutWipe(X, Y, W, H: integer);
  var i, CtrY: integer;
  begin
  CtrY := Y + (H div 2);
  for i := 1 to (H div 2) do
    begin
    RasterOp(RRpl, W, i * 2,
      X, CtrY - i, ScreenW, ScrnPtr,
      0, (H div 2) - i, Pic^.ScanLength, Pic^.pPixels);
    end;
  end;

{ Simultaneous vert. and horiz. Center-out wipe }
Procedure HVOutWipe(X, Y, W, H: integer);
  var i, CtrX, CtrY: integer;
      MaxWH, width, height: integer;
  begin
  CtrX := X + (W div 2);
  CtrY := Y + (H div 2);
  if W > H then MaxWH := W else MaxWH := H;
  for i := 1 to (W div 2) do
    begin
    width := i * 2;
    height := width;
    if width > W then width := W;
    if height > H then height := H;
    RasterOp(RRpl, width, height,
      CtrX - (width div 2), CtrY - (height div 2),
      ScreenW, ScrnPtr,
      (W - width) div 2, (H - height) div 2,
      Pic^.ScanLength, Pic^.pPixels);
    end;
  end;

Procedure SwapH( Y, LeftX, RightX, W, H, Step: Integer );
Var Store: RasterPtr;
    S, ScanL, Left, Right, NewX1, NewX2: Integer;
    pages,X1,X2: Integer;
    i: Integer;
Begin
    ScanL := ((W + 63) div 64) * 4;
    pages := ((H*ScanL)+255) div 256;
    CreateSegment( S, pages, 1, pages );
    Store := MakePtr( S, 0, RasterPtr );
    RasterOp( RRpl, W, H, 0, 0, ScanL, Store, RightX, Y, 48, ScrnPtr );
    X1 := LeftX;
    X2 := RightX;
    While X1 < RightX
      do Begin
        NewX1 := Min( RightX, X1 + Step );
        NewX2 := Max( LeftX, X2 - Step );
        RasterOp( RRpl, W, H, NewX1, Y, 48, ScrnPtr, X1, Y, 48, ScrnPtr );
        If NewX2 < NewX1      {coming out from under}
          Then
            RasterOp( RRpl, NewX1 - NewX2, H, NewX2, Y, 48, ScrnPtr,
                                        0, 0, ScanL, Store );
        Left := Min( NewX2, NewX1 );
        If Left > X1  {some to remove}
          Then
            RasterOp( RXor, Left-X1, H,
                              X1, Y, 48, ScrnPtr, X1, Y, 48, ScrnPtr );
        If NewX2 > NewX1  {still disappearing}
          Then
            RasterOp( RRpl, NewX2 - NewX1, H, NewX1+W, Y, 48, ScrnPtr,
                                        W-(NewX2-NewX1), 0, ScanL, Store );
        Right := Max( NewX2+W, NewX1+W );
        If Right < X2+W   {some to remove}
          Then
            RasterOp( RXor, X2+W-Right, H, Right, Y, 48, ScrnPtr,
                                     Right, Y, 48, ScrnPtr );
        X1 := NewX1;
        X2 := NewX2;
        For i := 1 to Delay3 do X1 := X1;
        End;
    DecRefCount( S );
End;


Procedure SwapV( X, TopY, BottomY, W, H, Step: Integer );
Var Store: RasterPtr;
    S, ScanL, Top, Bottom, NewY1, NewY2: Integer;
    pages,Y1,Y2: Integer;
    i: Integer;
Begin
    ScanL := ((W + 63) div 64) * 4;
    pages := ((H*ScanL)+255) div 256;
    CreateSegment( S, pages, 1, pages );
    Store := MakePtr( S, 0, RasterPtr );
    RasterOp( RRpl, W, H, 0, 0, ScanL, Store, X, BottomY, 48, ScrnPtr );
    Y1 := TopY;
    Y2 := BottomY;
    While Y1 < BottomY
      do Begin
        NewY1 := Min( BottomY, Y1 + Step );
        NewY2 := Max( TopY, Y2 - Step );
        RasterOp( RRpl, W, H, X, NewY1, 48, ScrnPtr, X, Y1, 48, ScrnPtr );
        If NewY2 < NewY1      {coming out from under}
          Then
            RasterOp( RRpl, W, NewY1 - NewY2, X, NewY2, 48, ScrnPtr,
                                        0, 0, ScanL, Store );
        Top := Min( NewY2, NewY1 );
        If Top > Y1  {some to remove}
          Then
            RasterOp( RXor, W, Top-Y1,
                              X, Y1, 48, ScrnPtr, X, Y1, 48, ScrnPtr );
        If NewY2 > NewY1  {still disappearing}
          Then
            RasterOp( RRpl, W, NewY2 - NewY1, X, NewY1+H, 48, ScrnPtr,
                                        0, H-(NewY2-NewY1), ScanL, Store );
        Bottom := Max( NewY2+H, NewY1+H );
        If Bottom < Y2+H   {some to remove}
          Then
            RasterOp( RXor, W, Y2+H-Bottom, X, Bottom, 48, ScrnPtr,
                                     X, Bottom, 48, ScrnPtr );
        Y1 := NewY1;
        Y2 := NewY2;
        For i := 1 to Delay3 do Y1 := Y1;
        End;
    DecRefCount( S );
End;



procedurem move4;
 
var
  i,j,segno : integer;
  bufptr    : RasterPtr;


begin
  
  {set up temp buffer}
  CreateSegment(segno,48,1,48);
  BufPtr := MakePtr( segno, 0, RasterPtr );
    
  {rotate 4 quarters }
    {copy q1 to buf}
    Rasterop(RRpl,
             384,
             512,
             0,
             0,
             24,
             bufptr,
             0,
             0,
             48,
             scrnptr);
     
     
    {copy q2 to q1}
    Rasterop(RRpl,
             384,
             512,
             0,
             0,
             48,
             scrnptr,
             384,
             0,
             48,
             scrnptr);
     
    {copy q3 to q2}
    Rasterop(RRpl,
             384,
             512,
             384,
             0,
             48,
             scrnptr,
             384,
             512,
             48,
             scrnptr);
     
    {copy q4 to q3}
    Rasterop(RRpl,
             384,
             512,
             384,
             512,
             48,
             scrnptr,
             0,
             512,
             48,
             scrnptr);
     
    {copy buff to q4}
    Rasterop(RRpl,
             384,
             512,
             0,
             512,
             48,
             scrnptr,
             0,
             0,
             24,
             bufptr);
     
     
 
 {waste time}
 If Delay1 > 0 Then Nap(Delay1);

 DecRefCount( segno ); 
end;


procedure screendump;
{  Program to dump Perq Display Screen on HP1310A printer  
     assumes  printer is gpib address 1
     
   written by Brian Rosen
              Copyright (C) 1980 - Three Rivers Computer Corporation
              
   V0.1   2-Jan-81  BR  made printer device a constant,
                        got screenseg from SegNumbers
}

const version = '0.1';
      printerdevice = 1;

type parray = packed array [0..95] of gpByte;  {A scan line of screen}
     pparray = ^parray;
var a: pparray;
    line,i: integer;
begin
   gpInit;
   gpITalkHeListens(printerdevice);    {address HP1310A}
   gpPutByte(#33);  {ESC}
   gpPutByte(ord('*')); {raster/binary}
   gpPutByte(ord('r')); {raster}
   gpPutByte(ord('i')); {initialize}
   gpPutByte(ord('A')); {start raster picture}
   for line := 5 to 1023 do  {ther are 1023 scan lines on the printer}
    begin
     a := MakePtr(ScreenSeg,Line*48,pparray);  {48 words per scan line}
     gpPutByte(#33); {ESC}
     gpPutByte(ord('*')); {raster/binary}
     gpPutByte(ord('b')); {binary}
     gpPutByte(ord('9')); {90 bytes}
     gpPutByte(ord('0'));
     gpPutByte(ord('W')); {Whole scan line}
     for i := 0 to 89 do gpPutByte(a^[LXor(i,1)]); {printer has 90 bytes
                           per line, low byte is transmitted first,
                           high byte must be printed first}
    end;
   gpPutByte(#33);  {ESC}
   gpPutByte(ord('*'));
   gpPutByte(ord('r'));
   gpPutByte(ord('B'));  {end raster picture}
   gpTbltOn;
end;
          
Procedure WaitForKey;
Var Ch: Char;
Begin
  While IOCRead( TransKey, Ch ) <> IOEIOC do ;
End;


    
Procedure QuitChk;
Var Ch:Char;
Begin
  If IOCRead(TransKey,Ch) = IOEIOC
    Then If (CH = 'Q') or (Ch = 'q')
       Then Begin
            ScreenInit;
            Exit(Faces);
            End
       Else If (Ch = 'p') or (Ch = 'P')
           Then ScreenDump;
End;


Procedure Get4;
Begin
  Pic := GetPic( 'Faces1.pic' );
  If Pic <> Nil
    Then Begin
      Copy( 0,0,384,512 );
      DelPic(Pic);
      End;
  Pic := GetPic( 'Faces2.Pic' );
  If Pic <> Nil
    Then Begin
      Copy( 384,0,384,512 );
      DelPic(Pic);
      End;
  Pic := GetPic( 'Faces3.pic' );
  If Pic <> Nil
    Then Begin
      Copy( 0,512,384,512 );
      DelPic(Pic);
      End;
  Pic := GetPic( 'Faces4.pic' );
  If Pic <> Nil
    Then Begin
      Copy( 384,512,384,512 );
      DelPic(Pic);
      End;
End;


Procedure Demo1;
Var i,j,count: Integer;
Begin
  ScreenInit;
  Get4;
  while Times <> 0 do
      begin
      If Delay2 > 0 Then Nap(Delay2);
      SwapH( 0, 0, 384, 384, 512, StepSize );
      QuitChk;
      If Delay2 > 0 Then Nap(Delay2);
      SwapV( 384, 0, 512, 384, 512, StepSize );
      QuitChk;
      If Delay2 > 0 Then Nap(Delay2);
      SwapH( 512, 0, 384, 384, 512, StepSize );
      QuitChk;
      If Delay2 > 0 Then Nap(Delay2);
      SwapV( 0, 0, 512, 384, 512, StepSize );
      QuitChk;
      If Delay1 > 0 Then Nap(Delay1);
      For i := 1 to 10 do
          Begin
          Move4;
          QuitChk;
          End;
      StepSize := StepSize + Incr;
      if Times > 0 then Times := Times-1;
      end
End;

Procedure ParseCmd;
Begin
NextArgStr( Style );   {discard cmd}
if length (UsrCmdLine) <> 0 then
    NextArgInt(StepSize)
else
    StepSize := 1;
if length (UsrCmdLine) <> 0 then
    NextArgInt(Delay1)
else
    Delay1 := 30;
if length (UsrCmdLine) <> 0 then
    NextArgInt(Delay2)
else
    Delay2 := 30;
if length (UsrCmdLine) <> 0 then
    NextArgInt(Delay3)
else
    Delay3 := 1;
if length (UsrCmdLine) <> 0 then
    NextArgInt(Times)
else
    Times := -1;
if length (UsrCmdLine) <> 0 then
    NextArgInt(Incr)
else
    Incr := 0;
End;

begin
Reset(Input);
Rewrite(Output);
ScrnPtr := MakePtr( ScreenSeg, 0, RasterPtr );
ParseCmd;
Demo1;
end.
