program cursdemo;

imports FileSystem from FileSystem;
imports Transcript from Transcript;
imports SigUtils from SigUtils;
imports XScreen from XScreen;
imports IO_Others from IO_Others;


var s, fileOfCurs: string;
    press,replay: boolean;
    x,y,i,xoffset,yoffset,winx,winy,w,h,numPerLine,blks,curs,numPress:integer;
    buttons: PressRec;
    cursors: Array[0..100] of CurPatPtr;
    fid: FileID;
    win: WinRange;
     
Procedure WaitNoPress;
  begin
  repeat
    press := GetAction(x,y,TRUE, buttons);
  until not press;
  end;

begin

IOSetModetablet(RelTablet);

if ArgCount <> 6 then
  begin
  WriteLn('** Usage: CursDemo win# numPerLine fileOfCurs numPress replay');
  exit(cursdemo);
  end;

NextArgStr(s);
nextArgInt(i);
win := i;
ChangeWindow(win);
XSRedrawWindow(win, 'Multiple User-defined Cursors');
Write(FF);

NextArgInt(numPerLine);
nextArgStr(fileOfCurs);
NextArgInt(numPress);
NextArgInt(i);
replay := RECAST(i, boolean);

InitTranscript('CursDemo.Transcript',replay);

XSGetUseWindow(win, winx, winy, w, h);
fid := FSLookup(fileOfCurs, blks, i);
if fid = 0 then exit(Cursdemo);
xoffset := winx+20;
yOffset := winY+20;

for y := 0 to (blks div numPerLine)-1 do
 for x := 0 to numPerLine-1 do
    begin
    NEW(0, 4, cursors[y*numPerLine+x]);
    FSBlkRead(fid, y*numPerLine+x, RECAST(cursors[y*numPerLine+x],pDirBlk));
    RasterOp(RRpl, 64, 64, xOffset+x*64, yOffset+y*64, SScreenW, SScreenP,
                           0, 0, 4, cursors[y*numPerLine+x]);
    end;

  i := 0;
  
  repeat
    press := GetAction(x,y,TRUE, buttons);
    if press then 
       begin
       curs := ((x-xOffset) div 64) + ((y-yOffset) div 64) * numPerLine;
       if curs <= blks then IOLoadCursor(cursors[curs], 0, 0)
       else write(chr(7));
       i := i + 1;
       WaitNoPress;
       end;
  until i > numPress;

IOCursorMode(offCursor);
CloseTranscript;

end.

  
  
  
       