Program TestSend;

Imports Ether10IO from Ether10IO;
Imports EBuffer from EBuffer;

Procedure printptr (p: pointer; s: string);

        var     bullshit: record case boolean of
                        true:  (ptr: pointer);
                        false: (os: integer;
                                sg: integer);
                        end;

        Begin
        with bullshit do
            begin
            ptr := p;
            writeln (s, ' is from segment ', sg:1, ' offset ', os:1);
            end;
        End;

Procedure printaddr (ea: EtherAddress; s: String);

        Begin
        with ea do
            writeln (s, High:1, ', ', Mid:1, ', ', Low:1, '.');
        End;

Procedure GetAddress (Var Address: EtherAddress; s: String);

        Begin
        with Address do
            begin
            write (s, ':  High? ');
            readln (High);
            write ('Mid? ');
            readln (Mid);
            write ('Low? ');
            readln (Low);
            end;
        End;

Procedure printadrec (AdRec: pEtherAdRec);

        Var     i: Integer;

        Begin
        with AdRec^ do
            begin
            i := LowAddress;
            writeln ('LowAddress is ', i:1);
            i := MCB;
            writeln ('Multicast command is ', i:1);
            i := MultCst1;
            writeln ('Multicast address #1 is ', i:1);
            i := MultCst2;
            writeln ('Multicast address #2 is ', i:1);
            i := MultCst3;
            writeln ('Multicast address #3 is ', i:1);
            i := MultCst4;
            writeln ('Multicast address #4 is ', i:1);
            i := MultCst5;
            writeln ('Multicast address #5 is ', i:1);
            end;
        End;

Procedure GetAdRec (AdRec: pEtherAdRec);

        Var     i: Integer;

        Begin
        with AdRec^ do
            begin
            write ('LowAddress? ');
            readln (i);
            LowAddress := i;
            write ('Multicast command? ');
            readln (i);
            MCB := i;
            write ('Multicast address #1? ');
            readln (i);
            MultCst1 := i;
            write ('Multicast address #2? ');
            readln (i);
            MultCst2 := i;
            write ('Multicast address #3? ');
            readln (i);
            MultCst3 := i;
            write ('Multicast address #4? ');
            readln (i);
            MultCst4 := i;
            write ('Multicast address #5? ');
            readln (i);
            MultCst5 := i;
            end;
        End;

Procedure xPrintStatus (Stat: pEtherStatus);

        Var     i: Integer;
                b: Boolean;

        Begin
        with Stat^ do
            begin
            b := CRCError;
            writeln ('CRCError is ', b);
            b := Collision;
            writeln ('Collision is ', b);
            b := RecvTrans;
            writeln ('RecvTrans is ', b);
            b := Busy;
            writeln ('Busy is ', b);
            b := ClockOver;
            writeln ('ClockOver is ', b);
            b := PIP;
            writeln ('PIP is ', b);
            b := Carrier;
            writeln ('Carrier is ', b);
            i := RetryTime;
            writeln ('RetryTime is ', i:1);
            b := SendError;
            writeln ('SendError is ', b);
            b := CmdInProg;
            writeln ('CmdInProg is ', b);
            i := BitsRecv;
            writeln ('BitsRecv is ', i:1);
            end;
        End;

Procedure GetStatus (Stat: pEtherStatus);

        Var     i: Integer;
                b: Boolean;

        Begin
        with Stat^ do
            begin
            write ('CRCError (T/F) ? ');
            readln (b);
            CRCError := b;
            write ('Collision (T/F) ? ');
            readln (b);
            Collision := b;
            write ('RecvTrans (T/F) ? ');
            readln (b);
            RecvTrans := b;
            write ('Busy (T/F) ? ');
            readln (b);
            Busy := b;
            write ('ClockOver (T/F) ? ');
            readln (b);
            ClockOver := b;
            write ('PIP (T/F) ? ');
            readln (b);
            PIP := b;
            write ('Carrier (T/F) ? ');
            readln (b);
            Carrier := b;
            write ('RetryTime (0 .. 15) ? ');
            readln (i);
            RetryTime := i;
            write ('SendError (T/F) ? ');
            readln (b);
            SendError := b;
            write ('CmdInProg (T/F) ? ');
            readln (b);
            CmdInProg := b;
            write ('BitsRecv (Integer) ? ');
            readln (i);
            BitsRecv := i;
            end;
        End;

Procedure printcontents (buf: pEtherBuffer; size: Integer);

        Var     i: Integer;

        Begin
        writeln ('There are ', size:1, ' words in the buffer.');
        write (buf^ [0] :1);
        for i := 1 to size - 1 do
            write (', ', buf^ [i] :1);
        writeln;
        End;

Procedure getcontents (buf: pEtherBuffer; var size: Integer);

        Var     i: Integer;

        Begin
        write ('How many words in the buffer? ');
        readln (size);
        for i := 0 to size - 1 do
            begin
            write ('Word #', i:1, '? ');
            readln (buf^ [i]);
            end;
        End;

Procedure printhelp;

        Begin
        writeln ('x - transmit packet');
        writeln;
        writeln ('h - print out Header');
        writeln ('H - get new Header');
        writeln ('d - print out Dest Address');
        writeln ('D - get new Dest Address');
        writeln ('f - print out From Address');
        writeln ('F - get new From Address');
        writeln;
        writeln ('s - print out Status');
        writeln ('S - get new Status');
        writeln;
        writeln ('c - print out Contents');
        writeln ('C - get new Contents');
        writeln;
        writeln ('a - print out Address Record');
        writeln ('A - get new Address Record');
        writeln ('r - reset');
        writeln;
        writeln ('m - print out my address');
        writeln ('p - print out everything');
        writeln;
        writeln ('q - quit');
        End;


Var     SendBuf: pEtherBuffer;
        SendHead: pEtherHeader;
        SendStat: pEtherStatus;
        AdRec: pEtherAdRec;
        MyAddress: EtherAddress;
        cmd: String;
        quit: Boolean;
        internalsize, sendsize: Integer;

Begin
EB_Alloc (1, AdRec);
EB_Buffers (SendHead, SendBuf, SendStat);
writeln ('Buffers Allocated.');
printptr (AdRec, 'AdRec');
printptr (SendHead, 'SendHead');
printptr (SendBuf, 'SendBuf');
printptr (SendStat, 'SendStat');
E10Init;
MyAddress := E10GetAdr;
printaddr (MyAddress, 'My address is ');
quit := false;
repeat
    write ('Command? ');
    readln (cmd);
    if (length (cmd) < 1) then printhelp
    else Case cmd [1] of
        'A': begin
            GetAdRec (AdRec);
            end;
        'C': begin
            GetContents (SendBuf, internalsize);
            end;
        'D': begin
            GetAddress (SendHead^ . Dest, 'Dest Address ');
            end;
        'F': begin
            GetAddress (SendHead^ . Src, 'From Address ');
            end;
        'H': begin
            GetAddress (SendHead^ . Src, 'From Address ');
            GetAddress (SendHead^ . Dest, 'Dest Address ');
            write ('What type? ');
            readln (SendHead^ . EType);
            end;
        'S': begin
            GetStatus (SendStat);
            end;
        'a': begin
            printadrec (AdRec);
            end;
        'c': begin
            printcontents (SendBuf, internalsize);
            end;
        'd': begin
            printaddr (SendHead^ . Dest, 'Dest Address ');
            end;
        'f': begin
            printaddr (SendHead^ . Src, 'From Address ');
            end;
        'h': begin
            printaddr (SendHead^ . Src, 'From Address ');
            printaddr (SendHead^ . Dest, 'Dest Address ');
            writeln ('Type is ', SendHead^ . EType:1);
            end;
        'm': begin
            printaddr (MyAddress, 'My address is ');
            end;
        'p': begin
            writeln ('    HEADER:');
            printaddress (SendHead^ . Src, 'From Address ');
            printaddress (SendHead^ . Dest, 'Dest Address ');
            writeln ('Type is ', SendHead^ . EType:1);
            writeln ('    STATUS:');
            xprintstatus (sendstat);
            writeln ('    ADREC:');
            printadrec (AdRec);
            end;
        'q': begin
            quit := true;
            end;
        'r': begin
            E10Reset (AdRec);
            writeln ('Reset ethernet.');
            end;
        's': begin
            xprintstatus (sendstat);
            end;
        'x': begin
            sendsize := internalsize * 2;
            if sendsize < MinDataBytes
                then sendsize := MinDataBytes
                else if sendsize > MaxDataBytes
                    then begin
                        writeln ('Buffer overflow!');
                        sendsize := MaxDataBytes;
                        end;
            writeln ('Sending ', sendsize:1, ' data bytes.');
            E10WIO (ESend, SendHead, SendBuf, SendStat, sendsize);
            writeln ('Sent packet.');
            end;
        Otherwise: begin
            printhelp;
            end;
        end;
    until quit;

End.
