program echo;

imports PascalInit from PascalInit;
imports CmdParse from CmdParse;
imports Spice_String from Spice_String;

const
  (* Commands/Switches *)
  cmdNoLine = 1;
  cmdNewLine = 2;

  numCmds = 2;

var
  lineFeed: Boolean;
  first: Boolean;

  id: CString;
  isSwitch: Boolean;
  c: Char;
  
  cmds: CmdArray;

label 99;

begin
  (* Initialize global values *)
  lineFeed := true;
  first := true;

  (* Initialize command/switch array *)
  cmds[cmdNoLine] := 'NOLINE';
  cmds[cmdNewLine] := 'NEWLINE';

  (* Ignore the program name *)
  c := NextID( id, isSwitch );

  (* Check for global switches *)
  c := NextID( id, isSwitch );
  while isSwitch do begin
    ConvUpper(id);
    case UniqueCmdIndex( id, cmds, numCmds ) of

      cmdNoLine:
        lineFeed := false;

    end {case};
    c := NextID( id, isSwitch );
  end;

  while true do begin
    if isSwitch then begin
      ConvUpper(id);
      case UniqueCmdIndex( id, cmds, numCmds ) of

        cmdNewLine:
          begin
            writeln;
            first := true;
          end;

      end {case};
    end

    else begin
      if not first then
        write( ' ' );
      write( id );
      first := false;
    end;
      
    if c = CCR then
      goto 99;

    c := NextID( id, isSwitch );
  end;
  
99:
  if lineFeed then
    writeln;
end.
