program SUEval ;
{ program for running evaluations of speed and accuracy }
{ COPYRIGHT (C) 1982 CMU SPEECH GROUP }
imports defutt from defutt;
imports defcoefs from defcoefs;
imports subend from subend;
imports suread from suread;
imports suwrite from suwrite;
imports suwarp from suwarp;
imports suyank from suyank;
imports tick from tick;
imports CmdParse from CmdParse;
imports Sail_Strin from Sail_String;
imports System from System;

CONST
    MAXREFS = 500;

VAR
    inchan : TEXT;
    infile : string;
    refs : uttvectype;


{****************************************************************}
FUNCTION WordNum (inline : string; num : integer) : string;
{ reads inline and returns the NUMth argument }
var
    i : integer;
    workstr, tempstr, curSymbol : string;
begin
    workstr := inline;
    curSymbol := '';
    for i := 0 to num do begin
        GetSymbol (workstr, curSymbol, ' ,', tempstr);
        RemDelimeters (workstr, ' ,', tempstr);
    end;
    WordNum := curSymbol;
end;

{****************************************************************}
FUNCTION AquireArg (num : integer) : string;
{ reads the command line and returns the NUMth argument }
var
    i : integer;
    workstr, tempstr, curSymbol : string;
begin
    workstr := UsrCmdLine;
    curSymbol := '';
    for i := 0 to num do begin
        GetSymbol (workstr, curSymbol, ' ,', tempstr);
        RemDelimeters (workstr, ' ,', tempstr);
    end;
    AquireArg := curSymbol;
end;

{****************************************************************}
PROCEDURE Eval (VAR inchan : text);
VAR
    outchan, refchan : text;
    curvocabfile, curoutfile, thisline : string;
    refsetlow, refsethigh, expB, expE, pruning, onlysummary : integer;
    i, refnum : integer;
    phrase, refset : array [1..MAXREFS] of integer;
    dataset, recog, dist : integer;
    totlength : long;
BEGIN
    { scan through lines of file, getting:
        vocab file, refsetlow, refsethigh, expandB, expandE, outfilename }
    WHILE (not eof (inchan)) DO BEGIN
        while (eoln (inchan) and (not eof (inchan))) DO readln (inchan);
            { skip blank lines }
        readln (inchan, curvocabfile);
        readln (inchan, curoutfile);
        readln (inchan, refsetlow, refsethigh, expB, expE, pruning,
            onlysummary);
        writeln ('Working on Vocab file ', curvocabfile);
        writeln ('Outputfile is ', curoutfile);
        writeln ('other args are: ', refsetlow:1, ' ',
            refsethigh:1, ' ',
            expB:1, ' ',
            expE:1, ' ',
            pruning:1, ' ',
            onlysummary:1);
        
        { read in vocab }
        SUReadVocab (refs, curvocabfile);


        { aquire refsets }
        reset (refchan, curvocabfile);
        readln (refchan);     { skip cvocab file }
        refnum := 0;
        WHILE not eof (refchan) do BEGIN
            readln (refchan, thisline);
            refnum := refnum + 1;
            phrase[refnum] := CVD (wordnum (thisline, 1));
            refset[refnum] := CVD (wordnum (thisline, 2));
        END;
        close (refchan);

{        writeln ('refnum, curutts ', refnum:1, ' ', refs.curutts:1);
        for i := 1 to refnum do begin
            writeln ('i, phrase, refset ',
                i:1, ' ', phrase[i]:1, ' ', refset[i]:1);
        end;
}

        { open tally file }
        rewrite (outchan, curoutfile);
        totlength := 0;
        TickInit ;

        for dataset := refsetlow to refsethigh do begin
            { set up refs }
            for i := 1 to refs.curutts do BEGIN
                if (refset[i] = dataset) then refs.vec^[i].uttkind := REF
                else refs.vec^[i].uttkind := NOTREF;
            END;
            InitRefs (refs);
            { do tests }
            for i := 1 to refs.curutts do
              if (refs.vec^[i].uttkind <> REF) then BEGIN
                TickResetTime ;
                warp (refs, refs.curutts, refs.vec^[i], recog, dist, pruning);
                Tick (1);
                writeln (outchan, phrase[i]:2, ' ', phrase[recog]:2, ' 1   ',
                    dist:4, ' ', refset[i]:1, ' ', dataset:1);
                totlength := totlength + 
                    20*(refs.vec^[i].endtime-refs.vec^[i].begintime+1);
                
            END;
        end;
        TickAddString (1, '0 0 0 Tot time,Warping only');
        TickReport (outchan);
        writeln (outchan, '0 0 0 total length is ', totlength:1, ' msec');
        close (outchan);
        

{$IFC FALSE THEN}
        { open tally file }
        rewrite (outchan, curoutfile);

        { loop through datasets }
        for dataset := 1 to 6 do begin
        { set up refs }
        for i := 1 to 60 do refs.vec^[i].uttkind := NOTREF;
        for i := 1 to 10 do refs.vec^[i+(dataset-1)*10].uttkind := REF;
        InitRefs (refs);
        { loop through tests }
        for i := 1 to 60 do if (refs.vec^[i].uttkind <> REF) then begin
            warp (refs, 60, refs.vec^[i], recog, dist, 100);
            writeln (outchan, i mod 10 :2, ' ', recog mod 10 :2, ' 1   ',
                dist:4, ' ', (i+9)DIV 10:1, ' ', dataset:1);
        end;
    end;
    close (outchan);
{$ENDC}
    END;
end;

{****************************************************************}
begin
    { random inits }
    InitCoefs ;
    InitWarp {does InitArrays} ;
    InitSURead ;

    { init refs }
    InitVec (refs);
    VecGetsMemory (refs, MAXREFS);

    { get input source and call evaluation routine }
    infile := AquireArg (1);
    if (length (infile) <= 0) then BEGIN
        writeln ('No Argument given on command line');
        exit (SUEval);
    END;
    writeln ('COMMAND INPUT FILE IS ', infile);
    reset (inchan, infile);
    Eval (inchan);
end.
{ }