{ Module that provides the Discrete Probability Distribution
  Abstract Data Type }
MODULE ProbDist ;
EXPORTS

CONST
    MAXPOINTS = 513;

type
    probdist = record
        pairs : array [0..MAXPOINTS] of record
            value : integer;
            prob : real;
        end;
        issorted : boolean;
        isnormalized : boolean;
        curvalues : integer;
        maxvalues : integer;
    end;

procedure AddDist (var x, y : probdist; VAR z : probdist);
procedure SubDist (var x, y : probdist; VAR z : probdist);
procedure WriteDist (var x : probdist);
procedure HistDist (var x : probdist);
procedure NormalizeDist (VAR x : probdist);
procedure SortDist (VAR x : probdist);
function IntegrateDist (var x : probdist; val : integer) : real;
function ValOfDist (var x : probdist; val : integer) : real;
procedure AddValDist (VAR x : probdist; val : integer; weight : real);
procedure InitDist (VAR x : probdist);
procedure DestroyDist (VAR x : probdist);
function QuerySortDist (var x : probdist) : boolean;
function QueryNormDist (var x : probdist) : boolean;
function RealMeanDist (var x : probdist) : real;
function MeanDist (var x : probdist) : integer;
function StandDevDist (var x : probdist) : integer;
function MaxDist (var x : probdist) : integer;
function MinDist (var x : probdist) : integer;

PRIVATE

{
function ConvolveDist (var x, y : probdist) : probdist;
begin
end;
}

{****************************************************************}
procedure AddDist (var x, y : probdist; VAR z : probdist);
var
    i, j : integer;
    answer : probdist;
begin
    InitDist (answer);
    for i := 0 to x.curvalues-1 do with y do
        for j := 0 to curvalues-1 do begin
            AddValDist (answer, x.pairs[i].value + pairs[j].value, 
                x.pairs[i].prob * pairs[j].prob);
        end;
    z := answer;
end;

{****************************************************************}
procedure SubDist (var x, y : probdist; VAR z : probdist);
var
    i, j : integer;
    answer : probdist;
begin
    InitDist (answer);
    for i := 0 to x.curvalues-1 do with y do
        for j := 0 to curvalues-1 do begin
            AddValDist (answer, x.pairs[i].value - pairs[j].value,
                x.pairs[i].prob * pairs[j].prob);
        end;
    z := answer;
end;

{****************************************************************}
procedure WriteDist (var x : probdist);
CONST
    PRINTTOT = TRUE;
var
    i : integer;
    tot : real;
begin
    {$IFC PRINTTOT THEN}
    tot := 0.0;
    {$ENDC}
    with x do for i := 0 to curvalues-1 do begin
        {$IFC PRINTTOT THEN}
        tot := tot + pairs[i].prob;
        {$ENDC}
        writeln ('value ', pairs[i].value : 5, ' prob ', pairs[i].prob : 9:6);
    end;
    {$IFC PRINTTOT THEN}
    writeln ('tot prob ', tot : 9:6);
    {$ENDC}
end;

{****************************************************************}
procedure HistDist (var x : probdist);

var
    i, j, histval : integer;
    maxprob, scaleval, ival: real;
begin
    with x do
    if curvalues > 0 then begin
        { get maximum prob }
        maxprob:=pairs[0].prob;
        i:=1;
        while (i < curvalues) do begin
            if pairs[i].prob > maxprob then maxprob:=pairs[i].prob;
            i:=i+1
        end;
        scaleval:=50.0/maxprob;
       
        if not issorted then SortDist(x);
        
        { write histogrammed values }
        for i:=MinDist(x) to MaxDist(x) do begin
            ival:=ValOfDist(x,i);
            histval:=round(scaleval*ival);
            write (i:6, ' | ');
            for j:=1 to histval do write ('*');
            writeln
        end
    end
end;

{****************************************************************}
procedure NormalizeDist (VAR x : probdist);
var
    i : integer;
    tot : real;
begin
    tot := 0.0;
    with x do for i := 0 to curvalues-1 do begin
        tot := tot + pairs[i].prob;
    end;

    if (tot <> 0.0) then with x do for i := 0 to curvalues-1 do begin
        pairs[i].prob := pairs[i].prob / tot;
    end;
end;

{****************************************************************}
procedure SortDist (VAR x : probdist);
{ bubble sort of pairs by value }
label
    1111;
var
    i, j : integer;
    savevalue : integer;
    saveprob : real;
begin
    with x do for i := 1 to curvalues-1 do BEGIN
        if (pairs[i].value < pairs[i-1].value) then BEGIN
            saveprob := pairs[i].prob;
            savevalue := pairs[i].value;
            for j := i-1 downto 0 do BEGIN
                if (pairs[j].value <= savevalue) then BEGIN
                    pairs[j+1].value := savevalue;
                    pairs[j+1].prob := saveprob;
                    goto 1111;
                END
                else BEGIN
                    { move pairs[j] to pairs[j+1] }
                    pairs[j+1] := pairs[j];
                    if (j = 0) then BEGIN
                        {oops, this fixes a bug! }
                        pairs[0].value := savevalue;
                        pairs[0].prob := saveprob;
                    END;
                END;
            END; {for j}
          1111: ;
        END; {if}
    END; {for i}
    x.issorted := TRUE;
end;

{****************************************************************}
function IntegrateDist (var x : probdist; val : integer) : real;
var
    i : integer;
    totprob : real;
begin
    totprob := 0.0;
    with x do for i := 0 to curvalues-1 do begin
        if (pairs[i].value <= val) then
            totprob := totprob + pairs[i].prob;
    end;
    IntegrateDist := totprob;
end;

{****************************************************************}
function ValOfDist (var x : probdist; val : integer) : real;
label
    1111;
var
    i : integer;
begin
    with x do for i := 0 to curvalues-1 do begin
        if (pairs[i].value = val) then begin
            ValOfDist := pairs[i].prob;
            goto 1111;
        end;
    end;
    
    { val not found, return 0.0 }
    ValOfDist := 0.0;
  1111: ;
end;

{****************************************************************}
procedure AddValDist (VAR x : probdist; val : integer; weight : real);
label
    1111;
var
    i : integer;
begin
    with x do for i := 0 to curvalues-1 do begin
        if (pairs[i].value = val) then begin
            pairs[i].prob := pairs[i].prob + weight;
            isnormalized := FALSE;
            goto 1111;
        end;
    end;
    
    { val not found, add if room exits }
    with x do begin
        if (curvalues < maxvalues) then begin
            pairs[curvalues].value := val;
            pairs[curvalues].prob := weight;
            isnormalized := FALSE;
            issorted := FALSE;
            curvalues := curvalues + 1;
        end
        else begin
            writeln ('ERROR, AddValDist, Too Many Values, new value ignored');
        end;
    end;
  1111: ;
end;

{****************************************************************}
procedure InitDist (VAR x : probdist);
begin
    x.maxvalues := MAXPOINTS;
    x.curvalues := 0;
    x.isnormalized := FALSE;
    x.issorted := TRUE;
end;

{****************************************************************}
procedure DestroyDist (VAR x : probdist);
{ is no-op }
begin
end;

{****************************************************************}
function QuerySortDist (var x : probdist) : boolean;
begin
    QuerySortDist := x.issorted;
end;

{****************************************************************}
function QueryNormDist (var x : probdist) : boolean;
begin
    QueryNormDist := x.isnormalized;
end;

{****************************************************************}
function RealMeanDist (var x : probdist) : real;
var
    i : integer;
    totval, totprob, aveval : real;
begin
    totval := 0.0;
    totprob:= 0.0;
    with x do for i := 0 to curvalues-1 do begin
        totval := totval + pairs[i].value * pairs[i].prob;
        totprob := totprob + pairs[i].prob;
    end;
    if (totprob <> 0.0) then aveval := totval / totprob
    else aveval := 0.0;
    
    RealMeanDist := aveval;
end;

{****************************************************************}
function MeanDist (var x : probdist) : integer;
begin
    MeanDist := round (RealMeanDist (x));
end;

{****************************************************************}
function sqrt (num : real) : real;
{ iteration approx to sqrt }
CONST
    NUMITERATIONS = 50;
VAR
    i : integer;
    temp, numdiv2 : real;
begin
    if (num <= 0.0) then begin
        sqrt := 0.0;
        exit (sqrt)
    end;

    temp := num / 4.0;
    numdiv2 := num / 2.0;
    for i := 1 to NUMITERATIONS do begin
        temp := temp / 2.0 + numdiv2 / temp;
    end;
    sqrt := temp;
end;

{****************************************************************}
function StandDevDist (var x : probdist) : integer;
var
    i : integer;
    mean, totval, totprob, aveval : real;
begin
    mean := RealMeanDist (x);
    totval := 0.0;
    totprob := 0.0;
    with x do for i := 0 to curvalues-1 do begin
        totval := totval + sqr (mean - pairs[i].value) * pairs[i].prob;
        totprob := totprob + pairs[i].prob;
    end;
    if (totprob <> 0.0) then aveval := totval / totprob
    else aveval := 0.0;
    
    StandDevDist :=  round (sqrt(aveval));
end;

{****************************************************************}
function MaxDist (var x : probdist) : integer;
var
    i, max : integer;
begin
    max := x.pairs[0].value;
    with x do for i := 1 to curvalues-1 do begin
        if (max < pairs[i].value) then max := pairs[i].value;
    end;

    if (x.curvalues > 0) then MaxDist := max
    else begin
      MaxDist := -32768;
      writeln('Warning, Probdist, null probdist in MaxDist, returning -HUGE');
    end;
end;

{****************************************************************}
function MinDist (var x : probdist) : integer;
var
    i, min : integer;
begin
    min := x.pairs[0].value;
    with x do for i := 1 to curvalues-1 do begin
        if (min > pairs[i].value) then min := pairs[i].value;
    end;

    if (x.curvalues > 0) then MinDist := min
    else begin
        MinDist := 32767;
        writeln('Warning, Probdist, null probdist in MinDist, returning HUGE');
    end;
end.
{}
