program testPane;

imports PascalInit      from PascalInit;
imports PM              from PMUser;
imports Panes           from Panes;
imports Except          from Except;
imports Spice_String    from Spice_String;
imports Browser         from Browser;
imports Arrows          from Arrows;
imports Sapph           from SapphUser;

type
  BrowseList = Array[1..16] of String;

const
  debug = false;

var
  w, h: Integer;
  i: Integer;

  pan: Array[Pane] of record
                        browse: pBrowser;
                        w, h: Integer;
                      end;
  list: ^BrowseList;
  pn: Pane;
  event: PaneEvent;

exception DebugIt;

(*handler Abort( msg: String );
  var
    answer: String;
    gr: GeneralReturn;

  begin {Abort handler}
    writeln( msg );
    write( 'DEBUG [y]? ' );
    readln( answer );
    if (answer = '') or (answer[1] = 'y') or (answer[1] = 'Y') then
      gr := PMMakeDebugProcess( PMPort, KernelPort, 0, 0 )
    else
      raise ExitProgram;
  end {Abort handler};
*)
handler ExitProgram;
  begin {ExitProgram handler}
    exit(testPane);
  end {ExitProgram handler};

handler Impossible( msg: String );
  begin {Impossible handler}
    raise Abort( concat( '** IMPOSSIBLE: ', msg ) );
  end {Impossible handler};

handler UserError( msg: String );
  begin {UserError handler}
    raise Abort( concat( '** USER ERROR: ', msg ) );
  end {UserError handler};

handler EmergMsg;
  begin {EmergMsg}
    PaneEmergMsg;
  end;

(*handler All( es, er, PStart, PEnd: Integer );
  var
    answer: String;
    gr: GeneralReturn;

  begin {All handler}
    writeln( 'Uncaught exception' );
    write( 'DEBUG [y]? ' );
    readln( answer );
    if (answer = '') or (answer[1] = 'y') or (answer[1] = 'Y') then
      gr := PMMakeDebugProcess( PMPort, KernelPort, es, er )
    else
      raise ExitProgram;
  end {All handler};
*)
procedure RefreshOdd( pn: Pane );
  begin
    if debug then
      writeln( 'Drawing lines.' );
    PaneLine( pn, DrawLine, 0, 0, pan[pn].w + 10, pan[pn].h + 20 );
    PaneLine( pn, DrawLine, 0, pan[pn].h + 20, pan[pn].w + 10, 0 );
  end;
  
procedure HandleOdd( pn: Pane );
  type
    arrowType = ( arUp, arLeft, arRight );
  var
    typ:  arrowType;
    event: PaneEvent;
  label 1;
  begin
    typ := arUp;
    event := PaneEv;

    repeat
      with event do begin
        case cmd of
          cYellowUp:
            typ := arUp;
          cWhiteUp:
            typ := arLeft;
          cGreenUp:
            typ := arRight;
        end {case};
        
        case typ of
          arUp:
            arrowUp( pn, event.x, event.y, ROr );
          arLeft:
            arrowLeft( pn, event.x, event.y, RXor );
          arRight:
            arrowRight( pn, event.x, event.y, RXor );
        end {case};

      end {with event};
      event := GetPaneEvent( KeyDontWait );
    1:
    until (event.pn <> pn);
  end;
  
handler PaneExcept( pn: Pane; exc: PaneExceptType; ptr: Pointer );
  var
    pSize: pPaneSize;

  begin {PaneExcept}
    case exc of

      exResizePane:
        begin
          pSize := recast(ptr,pPaneSize);
          if debug then
            writeln( 'Resizing pane #', pn:1, ' to ', 
                     pSize^.width:1, ' by ', pSize^.height:1 );
          if pn mod 2 = 0 then
            ResizeBrowser( pan[pn].browse, pSize^.width, pSize^.height )
          else begin
            pan[pn].w := pSize^.width;
            pan[pn].h := pSize^.height;
            RefreshOdd( pn );
          end
        end;
        
      exExposePane:
        begin
          if debug then
            writeln( 'Redrawing pane #', pn:1, '.' );
          if pn mod 2 = 0 then
            RedrawBrowser( pan[pn].browse )
          else
            RefreshOdd( pn );
        end;
        
    end {case};
  end {PaneExcept};

begin
  w := ASKUSER;
  h := ASKUSER;
  InitPanes( ASKUSER, ASKUSER, w, h, 'Tiles' );
  InitArrows;

  new(list);
  for i := 1 to 16 do
    list^[i] := CVS(i);

  for i := 1 to 8 do begin
    pn := CreatePane( PN_DEFAULT, PN_DEFAULT, PN_DEFAULT, PN_DEFAULT,
                      concat( 'Pane ', CVS(i) ) );
    PaneSize( pn, pan[pn].w, pan[pn].h );
    if pn mod 2 = 0 then begin
      pan[pn].browse := CreateBrowser( pn, 2*i, recast(list,pNameList) );
      RedrawBrowser(pan[pn].browse);
    end
    else
      RefreshOdd(pn);
  end;

  while true do begin
    if PaneEv.pn mod 2 = 0 then
      ListenBrowser( pan[PaneEv.pn].browse )
    else
      HandleOdd( PaneEv.pn );
  end;
end.

