module Panes;

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      This module implements a generalized tiled window interface.
 *      It deals with the problems of creation, deletion and user
 *      interaction.
 *
 *    -----------
 *    CHANGE LOG:
 *      Aug 16 1984     Lee Iverson     Added emergency message handling.
 *      Jul 24 1984     Lee Iverson     Pane structure hidden from user.
 *      Jun 27 1984     Lee Iverson     Remodularized Panes.
 *      Jun 19 1984     Lee Iverson     ** Created **
 *
 ***********************************************************************)

exports

imports SapphDefs from SapphDefs;
imports Except    from Except;
imports PaneDefs  from PaneDefs;
imports PaneKDefs from PaneKDefs;
imports Colors    from Colors;

var
  PaneEv: PaneEvent;

function 
  CreatePane(
    x: Integer;
    y: Integer;
    w: Integer;
    h: Integer;
    PaneName: String
  ): Pane;

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Create a new window with the given position and size.
 *
 ***********************************************************************)

function
  GetPaneEvent(
    howToWait: KeyHowWait
  ): PaneEvent;

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Handle all keyboard and/or puck events.
 *
 ***********************************************************************)

function
  GetPaneListener
  : Pane;

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Return the listener pane.
 *
 ***********************************************************************)

function
  GetPaneRectangle(
    pn: Pane;
    left: Integer;
    top: Integer;
    width: Integer;
    height: Integer;
    data: pVPIntegerArray;
    arSize: Integer;
    wordsAcross: Integer;
    ux: Integer;
    uy: Integer
  ): Boolean;

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Reads the data from an area of the screen and places it in the
 *        data array.  Returns true if the data is available.
 *
 ***********************************************************************)

procedure
  GetPaneRegionCursor(
        pn: Pane;
        regionNum: Integer;
    var cursorImage: CursorSet;
    var cursorIndex: Integer;
    var cursorFunc: CursorFunction;
    var track: Boolean
  );
  
(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Get information about the cursor in the given region.
 *
 ***********************************************************************)

procedure
  GetPaneRegionParms(
        pn: Pane;
        regionNum: Integer;
    var absolute: Boolean;
    var speed: Integer;
    var minX: Integer;
    var maxX: Integer;
    var minY: Integer;
    var maxY: Integer;
    var modX: Integer;
    var posX: Integer;
    var modY: Integer;
    var posY: Integer
  );
  
(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Get information about the region settings.
 *
 ***********************************************************************)

procedure
  InitPanes(
        left: Integer;
        top: Integer;
    var width: Integer;
    var height: Integer;
        progName: ProgStr
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Initialize the Pane interface.
 *
 ***********************************************************************)

procedure
  PaneBox(
    pn: Pane;
    lf: LineFunct;
    left: Integer;
    top: Integer;
    width: Integer;
    height: Integer
  );

(***********************************************************************
 *
 *    AUTHOR: Lee Iverson
 *    ABSTRACT:
 *      Draws a box outline with the given top corner and size.
 *
 ***********************************************************************)

procedure
  PaneClear(
    Pn: Pane
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Clear the view region for the Pane.
 *
 ***********************************************************************)

procedure
  PaneColorRect(
    Pn: Pane;
    clr: ColorFunct;
    left: Integer;
    top: Integer;
    width: Integer;
    height: Integer
  );
  
(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Color the clipped rectangular area in the given pane.
 *
 ***********************************************************************)

procedure
  PaneDeleteRegion(
    pn: Pane;
    regionNum: Integer
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Delete the top region from the pane's region list.
 *
 ***********************************************************************)

procedure
  PaneEmergMsg;
  
(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Handle an emergency message.  Should be called from the user's
 *        EmergMsg handler.  Passes control off to emergMsgHandler.
 *
 ***********************************************************************)
  
procedure
  PaneLine(
    pn: Pane;
    lf: LineFunct;
    x1: Integer;
    y1: Integer;
    x2: Integer;
    y2: Integer
  );
  
(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Draw a clipped line from (x1,y1) to (x2,y2) in the pane.
 *
 ***********************************************************************)
  
function
  PaneLoadCursors(
        name: String;
    var numCursors: Integer
  ): CursorSet;

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Load the named cursor set and return it.  The number of cursors
 *        in the file is stored in the variable numCursors.
 *
 ***********************************************************************)

function
  PaneLoadFont(
    name: String
  ): Viewport;

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Load the named font, and return a viewport which specifies it.
 *
 ***********************************************************************)

procedure
  PaneModifyRegion(
    pn: Pane;
    regionNum: Integer;
    left: Integer;
    top: Integer;
    width: Integer;
    height: Integer
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Modify the given region's shape.
 *
 ***********************************************************************)

procedure
  PanePushRegion(
    pn: Pane;
    regionNum: Integer;
    left: Integer;
    top: Integer;
    width: Integer;
    height: Integer
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Push the defined region onto the pane's region list.
 *
 ***********************************************************************)

procedure
  PanePutRectangle(
    pn: Pane;
    funct: RopFunct;
    left: Integer;
    top: Integer;
    width: Integer;
    height: Integer;
    data: pVPIntegerArray;
    arSize: Integer;
    wordsAcross: Integer;
    ux: Integer;
    uy: Integer
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Performs a RasterOp from a data array to a pane.
 *
 ***********************************************************************)

procedure
  PanePutString(
        pn: Pane;
        font: Viewport;
        funct: RopFunct;
        adj: AdjustFunct;
        dx: Integer;
        dy: Integer;
        str: String;
        first: Integer;
        last: Integer
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Display a string in a pane.  The adjusting function is used to
 *        determine how to display the string with reference to the 
 *        start point specified.  This will automatically clip against the
 *        edges of the viewport.
 *
 ***********************************************************************)

procedure
  PaneScroll(
    pn: Pane;
    lx: Integer;
    ty: Integer;
    w: Integer;
    h: Integer;
    xAmount: Integer;
    yAmount: Integer
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Moves a rectangular area inside a pane by the amounts specified.
 *        The areas moved from are cleared.
 *
 ***********************************************************************)

procedure
  PaneSize(
        pn: Pane;
    var width: Integer;
    var height: Integer
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Get the inside dimensions of the requested pane.
 *
 ***********************************************************************)
  
procedure
  PaneString(
        pn: Pane;
        font: Viewport;
        funct: RopFunct;
        adj: AdjustFunct;
    var dx: Integer;
    var dy: Integer;
    var str: String;
        first: Integer;
    var last: Integer
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Display a string in a pane.  The adjusting function is used to
 *        determine how to display the string with reference to the 
 *        start point specified.  This will automatically clip against the
 *        edges of the viewport.  The values in (dx,dy) on return will
 *        represent the origin of the next character to be displayed after
 *        the string is actually written.
 *
 ***********************************************************************)

procedure
  SetPaneListener(
    pn: Pane
  );

(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Set the listener pane to be the pane described.
 *
 ***********************************************************************)

procedure
  SetPaneRegionCursor(
    pn: Pane;
    regionNum: Integer;
    cursorImage: CursorSet;
    cursorIndex: Integer;
    cursorFunc: CursorFunction;
    track: Boolean
  );
  
(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Get information about the cursor in the given region.
 *
 ***********************************************************************)

procedure
  SetPaneRegionParms(
    pn: Pane;
    regionNum: Integer;
    absolute: Boolean;
    speed: Integer;
    minX: Integer;
    maxX: Integer;
    minY: Integer;
    maxY: Integer;
    modX: Integer;
    posX: Integer;
    modY: Integer;
    posY: Integer
  );
  
(***********************************************************************
 *
 *      AUTHOR: Lee Iverson
 *      ABSTRACT:
 *        Define the region settings.
 *
 ***********************************************************************)

private

{$include Panes.impl}.
