program pasmac;
{++}
{ abstract:
{	pascal macro preprocessor
{--}


{++}
{ history
{
{ *++
{ version:		1B(103)
{ date:			10-jul-81
{ by:			gal
{ perq version
{ *--
{
{ *++
{ version:		1A(102)
{ date:			22-jun-81
{ by:			gal
{ better handeling of error for unterminated string 
{ in a macro.
{ *--
{
{ *++
{ version:		1A(101)
{ date:			19-jun-81
{ by:			gal
{ fixing bug that causes hard memory error when
{ an unterminated pascal string is passed in a macro
{ call.
{ *--
{
{ *++
{ version: 	1A(100)
{ date:		18-jun-81
{ by:		gal
{ installed this version on the vax.
{ left code for the perq in comments
{ *--
{--}


   imports pasmac1 from pasmac1;
   imports pasmac2 from pasmac2;
   imports pasmac3 from pasmac3;
   
imports PERQ_String from perq_string;
imports system from system;
imports cmdparse from cmdparse;
imports utilprogress from utilprogress;


(*forward procedures*)
procedure prmassign;forward;
function readparam:chunkpnt;forward;
procedure prmvardef(isglobal:boolean);forward;
procedure prmif(var c:chunkpnt;p:putplace);forward;
procedure prmexp(var c:chunkpnt;p:putplace);forward;
procedure callmacro(t:tabpnt;r:readplace;p:putplace;var c:chunkpnt);forward;

{ BEGIN PERQ CODE **************** }
var 
  response : char;
  WaitCnt  : integer;
  WhereAmI : integer;
{ END PERQ CODE *************** }


function samename (str1, str2 : string255) boolean;
var i : integer;
begin
samename := true;
for i := 0 to ord(str1[0])
do if ord(uppercase(str1[i])) <> ord(uppercase(str2[i]))
   then begin
	samename := false;
	exit(samename);
	end
end {samename};

procedure callmvar(t:tabpnt;p:putplace;var c:chunkpnt);

(* this procedure performs a call of a macro variable. t is a pointer
to the appropriate tabrec representing that mvar (it may be within
the global hashtable mactable or a within the localmvar list), p specifies
the location where the expansion of the mvar should be written to, and
c is a pointer to the chunk which must be written into  in the case where
p specifies that the putplace is chk(a chunk).  the procedure behaves
in a natural way, simply writing out the string, boolean, or integer value
of the mvar to the appropriate place. if the mvar is of type minteger,
the function intstring will return the string representation of that
integer within the array intexp. oldend is used so that space within
the intexp array may be reused. *)

var
  oldend:integer;
begin
if dotrace then writeln(output,'callmvar');
case t^.vartype of
   mstring: begin
            if dotrace then printtabentry(t);
            writeinfo(t^.strval,nil,c,body,p);
            end;
   mboolean:writeinfo(boolstring(t^.boolval),nil,c,trfal,p);
   minteger:begin
            oldend := intexpend;
            writeinfo(intstring(t^.intval),nil,c,intexp,p);
            intexpend := oldend;
            end
   end;
end;


function readvaxfilename (src: chunkarr; var f: vaxfile): boolean;
        { LWE 3/13/80: reads in from src an expression of the form
        "<filename>", where <filename> is some random zero-byte 
        terminated string of non-blank characters. }
var ch: char; foundclose: boolean; stringindex: integer;
begin (* readvaxfilename *)
        stringindex := 1;
        foundclose := false;
        repeat
                if (stringindex >filenamelen) 
                then begin foundclose := true; readvaxfilename := false; end
                else begin
                        ch := src[stringindex];
                        if (ch=' ') 
                        then begin
                                readvaxfilename := true;
                                foundclose := true;
                             end
                        else if (ch = pred(''))
                        then begin
                                foundclose := true;
                                if (stringindex = 1)
                                then readvaxfilename := false
                                else readvaxfilename := true;
                             end
                        else 
                         if not((ch >= '!') and (ch <= '~')) 
                         then begin foundclose := true; 
                                    readvaxfilename := false;
                              end
                         else  begin    
                                        f[stringindex] := ch;
                                        stringindex := stringindex+1;
                               end;
                        end;
        until foundclose;
        f[stringindex] := pred('');
end (* readvaxfilename *);

procedure prminclude;
(* this procedure performs the inclusion of a file, which is invoked
by the minclude statement [ minclude(<filename>) ]. notice that at
most  8 files deep may be included at any one time. because of the 
restrictive rules pascal imposes on the use of file variables, i
was forced to limit this number and keep 8 global file variables 
called file1 thru file8 (the names of these files are for convenience
sake alone, but may have been called anything else).
   anytime a file is included, the program is told that reading will
now commence from a file (currplace = afile). moreover, the program
must remember where it was reading from before so that it may return
to this reading place once the included file is exhausted. this reading
place can only be another file (necessarily filei-1 where filei is the
included file and input is file0) or the bodyarray. the inclusion
array is used as a stack to remember this information. *)

var
        (* LWE 3/11/80: extensively modified from CMU Pascal version
        to implement UNIX files. Any attempt to leave things commented-in
        for a possible re-conversion to TOPS-10 Pascal has been completely
        aborted. *)
	(* dzg 4/3/81: introduced the filstr parameter (Perq Pascal
	string) to give a reasonable parameter to the reset calls *)

   filstr: string;  filstrindex: integer;
   fil: vaxfile;
   c: chunkpnt; (* chunk to temporarily hold file name *)
   badfile:boolean;
begin
if dotrace then writeln(output,'prminclude');
gettoken(dummychunk, nowhere);
if newtoktype <> lparentok then error(15);
c := readparam;
if not (readvaxfilename (c^.arr,fil)) then error (39);
(* dzg *)
{$R-}      (* turn off range checking *)
filstrindex := 1;
while fil[filstrindex]<>chr(000) do
  begin
  filstr[filstrindex] := fil[filstrindex];
  filstrindex := filstrindex + 1;
  end;
filstr[0] := chr(filstrindex-1);    { Perq Pascal strings have the first byte
                                   (byte 0) equal to the no. of characters }
{$R+}
(* end dzg *)


if filenum = 8 then error(14); (*can't include another file *)
case filenum of 
     0: begin reset(file1,filstr); badfile := eof(file1) end;
     1: begin reset(file2,filstr); badfile := eof(file2) end;
     2: begin reset(file3,filstr); badfile := eof(file3) end;
     3: begin reset(file4,filstr); badfile := eof(file4) end;
     4: begin reset(file5,filstr); badfile := eof(file5) end;
     5: begin reset(file6,filstr); badfile := eof(file6) end;
     6: begin reset(file7,filstr); badfile := eof(file7) end;
     7: begin reset(file8,filstr); badfile := eof(file8) end
     end;
writeln(tty,'including file: ',filstr,'.');
if badfile then writeln(tty,' ***warning: non-existent or empty file.');
if newtoktype <> rparentok then error(16);
inclusion[inctop] := bodyextent;
                                   (* we must remember where we were in the*)
inclusion[inctop+1] := currbodypos;(* body array if minclude occured there *)
case currplace of
   afile:inclusion[inctop+2] := wasfile;
   bodyarray:inclusion[inctop+2] := wasbody;
   charray:writeln(output,'error minclude');
   end;
inctop := inctop+3;
currplace := afile;
filenum := filenum+1;
end;

function isparam(id:ident; var n:parno):boolean;
(* this function returns an indication whether or not the name given by
the parameter id is the name of a formal parameter of the macro currently
being called (if one is indeed being called!). it is used so that expansion
of formal parameters can be done. the var parameter n will receive which
number parameter  id represents if it is indeed the name of  a parameter.*)

var
  b:boolean;  (* the value to be returned by the function *)
  i:integer;  (*  a counter *)
begin
if dotrace then writeln(output,'isparam');
b := false;
if currmacro <> nil then
   begin
   i := 1;
   while (not b) and (i <= currmacro^.numpar) do
      begin
      if id = currmacro^.parname[i] then
         begin
         n := i;
         b := true;
         end;
      i := i+1;
      end;
   end;
isparam := b;
end;

procedure expandscan(var c:chunkpnt; p:putplace);
(* this procedure is a very important one, called by many others within
the processor. it performs the 'expansion' of a token that has just been
read in, and also makes sure that another token is read in before exiting.
such an expansion may be one of the following:
   performance of an mif, minclude,massign,or mexp statement
   expansion of a formal parameter
   call of a macro or local or global mvar
   concatenation of text separated by a single &
   stripping off of a layer of double quotes ( " ) 
parameter p indicates where this expansion should be written to, and the 
case where p is chk (a chunk) , a pointer to this chunk is needed (c). *)

var
  tabentry:tabpnt; (* a pointer to an mvar or macro tabrec *)
  bnd:bndpnt; (* boundary of a double quoted string  with quotes stripped off*)
  id:ident;   (* the name of a token of type identtok *)
  n:parno;    (* the number of a formal parameter *)
  i:integer;  (* a counter *)
  havenext:boolean;  (* have we already read in the next token? *)
begin
(* dzg *)
n := 1;      { initialize to be inside range }
havenext := false;
if newtoktype = mkwdtok then   (* we have mif,minclude,massign,or mexp *)
   begin
   if newmkeytype = miftok then
      prmif(c,p)
   else
   if newmkeytype = mincludetok then
      begin
      if haveblanks then writeinfo(blanks,nil,c,work,p);
      prminclude;
      end
   else
   if newmkeytype = massigntok then
      begin
      if haveblanks then writeinfo(blanks,nil,c,work,p);
      prmassign;
      end
   else
   if newmkeytype = mexptok then
      begin
      if haveblanks then writeinfo(blanks,nil,c,work,p);
      prmexp(c,p);
      end
   else
      error(17);
   end
else
(* expandscan continued *)

   begin
   (* dzg *)   n := 1;   { must be initialized because it is a bounded var! }
   if haveblanks then writeinfo(blanks,nil,c,work,p);
   if newtoktype = identtok then  (* may be a macro or mvar call, or a formal *)
      begin
      idstring(newtok,id);
      if macrocalltime and membertab(id,false,tabentry) then (* local mvar *)
         callmvar(tabentry,p,c)
      else
      if macrocalltime and isparam(id,n) then  (* a formal parameter *)
         writeinfo(nil,pararray[currmacpar+n-1],c,chk,p)
      else
      if membertab(id,true,tabentry) then
         begin
         case tabentry^.macflavor of
            mvar:callmvar(tabentry,p,c); (* global mvar *)
            macro:callmacro(tabentry,currplace,p,c) (* macro call *)
            end;
         end
      else
         writeinfo(newtok,nil,c,work,p);
      end
   else
   if newtoktype = amptok then   (* text concatenation *)
      begin
      gettoken(c,p);
      if newtoktype = amptok then
         writeinfo(newtok,nil,c,work,p)
      else
         havenext := true;
      end
   else
   if newtoktype = nametok then  (* strip off double quotes off newtok *)
      begin
      i := newtok^.first + 1;
      new(bnd);
      while i <= newtok^.last - 1 do
          begin 
          if workarea[i] = '"' then
             begin
             if i = newtok^.last-1 then writeln(output,'error expandscan 1');
             if workarea[i+1] <> '"' then writeln(output,'error expandscan 2');
             i := i+1;
             end;
          bnd^.first := i;
          bnd^.last := i;
          writeinfo(bnd,nil,c,work,p);
          i := i+1;
          end;
      dispose(bnd)
      end 
   else
      writeinfo(newtok,nil,c,work,p);
   end;

if not havenext then gettoken(c,p);
end;

procedure callmacro;
(* this procedure performs the call of a macro. it's parameters are as
follows: t a pointer to the tabrecord in the global hashtable representing
           the macro being called
         r the place we were previously reading from
         p the place we will be expanding the macro to
         c a pointer to the appropriate chunk, if we are expanding to a chunk
           ( note that c is a var parameter).
locals: 
  i         a counter
prevmcalltime used to stack the global macrocalltime during recursive
        macro body expansions. added to fix bug: 16-aug-79 /rwt.
prbodypos<<these two variables are used to save context information about the 
prbodyext<< the body array if we had been reading there before the macro call
oldend      a temporary used so that we may reuse space within intexparea
prevlocals << the  local mvars and macro name of the macro previously called
prevmacro  << this is so that we may bounce back a call level at macro-call exit
prevlookahead remembers if the scanner had a lookahead when the macro got called
nextchar      this is the character that was the lookahead, if there was one
newpar      holds pointer to  a parameter being expanded
prevparpos  the position in the pararray we must bounce back to at macro-call exit
newparpos   the position in the pararray holding the first parameter, for this call
*)
var
  i,prbodypos,prbodyext,oldend:integer;
  prevlocals,prevmacro:tabpnt;
  prevmcalltime, prevlookahead:boolean;
  nextchar:char;
  newpar:chunkpnt;
  prevparpos,newparpos:parsize;
begin
if dotrace then writeln(output,'callmacro');
newparpos := parend;

(*the procedure operates in a very straightforward way. first it reads in
the appropriate number of parameters. these parameters are expanded, evaluated
if necessary, and  in any case, then turned into strings stored as chunks.
they are placed on the parameter stack, pararray. *)

if t^.numpar > 0 then
   begin
   gettoken(c,p);
   if newtoktype <> lparentok then error(18);
   { dzg - had to insert a recast }
   for i := 1 to recast(t^.numpar,integer) do
       begin
       newpar := readparam;
       if dotrace then 
          begin   writeln(output,'the parameter read is:');
                  writeinfo(nil,newpar,dummychunk,chk,out);
                  writeln(output);
          end;
       if t^.partype[i] = mboolean then
          writeinfo(boolstring(boolexpr(newpar)),nil,pararray[parend],trfal,chk)
       else
       if t^.partype[i] = minteger then
          begin
          oldend := intexpend;
          writeinfo(intstring(arithexpr(newpar)),nil,pararray[parend],intexp,chk);
          intexpend := oldend;
          end
       else
          pararray[parend] := newpar;
       parend := parend+1;
       end;
   end;
(*callmacro continued*)

(* next, the procedure saves alot of context information which will
be restored once the macro has been expanded and the call is finished. in
essence, we create an 'activation record'. we save:  the local mvars of
the previous macro call(prevlocals); the name of the previously called macro
(prevmacro); information about previous locations within the bodyarray
if we had just been expanding another macro (prbodypos,prbodyext);
where we should bounce back to in the parameter array once the call is
completed(prevparpos); whether or not we had scanning lookahead when
we made the call(prevlookahead) and what that character was(nextchar).
   finally we get ready to call the macro. we set up the array of local
mvars(localmvar), we reset currmacro to t, set new starting position in
parameter array (currmacpar),and also get ready to read from the 
appropriate place in the body array, holding the body of the macro we will
call. *)

prevlocals := localmvar;
prevmacro := currmacro;
prbodypos := currbodypos;
prbodyext := bodyextent;
prevparpos := currmacpar;
prevlookahead := havelookahead;
nextchar := ch;
localmvar := nil;
currmacro := t;
currmacpar := newparpos;
prevmcalltime := macrocalltime;
macrocalltime := true;
currplace := bodyarray;
havelookahead := false;
if dotrace then writeln(output,'macro bounds: ',t^.macbnd^.first,',',t^.macbnd^.last);
currbodypos := t^.macbnd^.first;
bodyextent := t^.macbnd^.last;

(* now we perform the expansion. we set up any local mvars if there are any,
and then expand the macro, reading from the body array and expanding to place p *)

gettoken(c,p);
if newtoktype <> mkwdtok then error(19);
if newmkeytype = mvartok then
   prmvardef(false);
if (newtoktype <> mkwdtok) or (newmkeytype <> mbegintok) then error(20);
gettoken(c,p);
haveblanks := false;
while havetok do
   expandscan(c,p);
 
(*callmacro continue*)

(*finally we restore all old context information. we also release the chunks
that stored the local parameters for reuse by using dispose *)

localmvar := prevlocals;
currmacro := prevmacro;
currbodypos := prbodypos;
bodyextent := prbodyext;
havelookahead := prevlookahead;
ch := nextchar;
parend := currmacpar;
if dotrace then writeln(output,'got here 1');
for i := currmacpar to currmacpar + t^.numpar - 1 do 
  while pararray[i] <> nil do
    begin
      newpar := pararray[i]^.nxt;
      dispose(pararray[i]);
      pararray[i] := newpar
    end;
currmacpar := prevparpos;
macrocalltime := prevmcalltime;
currplace := r;
if dotrace then writeln(output,'exit from macro ',t^.name);
end;

procedure prmexp;
(* this procedure performs the call of an mexp statement, which basically 
serves the function of performing a rescan.  its parameters are p - the place
the mexp text should be expanded to, and var c, a chunk pointer in case p
is a chunk.
   the procedure simply reads in the parameter passed to mexp, expanding it
like a normal macro parameter, and then rescans(reexpands) it. *)

var
  scan:chunkpnt;    (* points to the expanded parameter *)
  rdplace:readplace;(* remembers where we were reading from when the procedure was 
                       called*)

begin
if dotrace then writeln(output,'prmexp');
gettoken(dummychunk,nowhere);
if newtoktype <> lparentok then error(38);
scan := readparam;
if dotrace then 
   begin
   writeln(output,'the first scanning gives you:');
   writeinfo(nil,scan,dummychunk,chk,out);
   end;
rdplace := currplace;
currplace := charray;
globalchunk := scan;
currchunkpos := 1;
gettoken(c,p);
while havetok do
   expandscan(c,p);
if haveblanks then writeinfo(blanks,nil,c,work,p);
currplace := rdplace;
end;

procedure prmif;

(* this procedure performs the expansion of the mif statement, ie. conditional
insertion of code. it has the two parameters p and c, the place we expand to,
and if that place is a chunk, a pointer to it.
   its operation is very simple... expand and evaluate the conditional branching
expression, and expand the appropriate code, depending on the truth or falsehood
of that branch.  a count is kept [count] of nesting levels of the mif statements
within the code that is not inserted , so that we find the correct melse and mfi
that delimits the end of that block of code. *)

var
  count:integer;    (* counter as described above *)
  boolchunk:chunkpnt; (* a chunk which hold the expanded text of the conditional *)
  switch:boolean;   (* the boolean value of boolchunk after it's been evaluated *)
begin
if dotrace then writeln(output,'prmif');
count := 0;
new(boolchunk);
boolchunk^.pos := 0;
boolchunk^.nxt := nil;
gettoken(c,p);
 
while (newtoktype <> mkwdtok) or (newmkeytype <> mthentok) do
   expandscan(boolchunk,chk);
switch := boolexpr(boolchunk);

if not switch then (* we will execute 'else' portion.... so eat up 'then ' block*)
   begin
   gettoken(c,p);
   while (count<>0) or (newtoktype <> mkwdtok) or
         ((newmkeytype<>melsetok) and (newmkeytype<>mfitok))  do
      begin
      if newtoktype = mkwdtok then
         begin
         if newmkeytype = miftok then
            count := count+1
         else
         if newmkeytype = mfitok then
            count := count-1;
         end;
      gettoken(c,p);
      end
   end;
 
if (newmkeytype=melsetok) or (newmkeytype = mthentok) then 
   begin (*expand appropriate block*)
   gettoken(c,p);
   while (newtoktype<>mkwdtok) or ((newmkeytype<>melsetok) and
                                       (newmkeytype<>mfitok))      do
       expandscan(c,p);

   end;
 
(*prmif continued *)

if switch and (newmkeytype = melsetok) then
   begin   (* if we expanded 'then ' portion, eat up any existing 'else' block*)
   gettoken(c,p);
   while (count<>0) or (newtoktype <> mkwdtok) or (newmkeytype<>mfitok) do
      begin
      if newtoktype = mkwdtok then
         begin
         if newmkeytype = miftok then
            count := count+1
         else
         if newmkeytype = mfitok then
            count := count-1;
         end;
      gettoken(c,p);
      end
   end;
 
if newmkeytype<> mfitok then error(21);
end;

function readparam;
(* this function reads in a parameter, expands it into a chunklist, and then
returns a pointer to that list. counts are kept of the nesting levels of ()'s
and []'s so that comma's and right paren's at a nonzero count level are not 
significant parameter delimiters. *)

var
   count1,count2:integer; (* nesting level counters *)
   parchunk:chunkpnt;  (* pointer to the parameter chunk *)
 
begin
count1 := 0;
count2 := 0;
new(parchunk);
parchunk^.pos := 0;
parchunk^.nxt := nil;
gettoken(parchunk,chk);
 
while (((newtoktype <> rparentok) and (newtoktype <> commatok))
      or (count1<>0) or (count2<>0)) and (not (endmac)) and
      (newtoktype <> semitok) do
   begin
   if newtoktype=lparentok then
      begin
      count1 := count1+1;
      if haveblanks then writeinfo(blanks,nil,parchunk,work,chk);
      writeinfo(newtok,nil,parchunk,work,chk);
      gettoken(parchunk,chk);
      end
   else
   if newtoktype=rparentok then
      begin
      count1 := count1-1;
      if haveblanks then writeinfo(blanks,nil,parchunk,work,chk);
      writeinfo(newtok,nil,parchunk,work,chk);
      gettoken(parchunk,chk);
      end
   else
   if newtoktype=lbracktok then
      begin
      count2 := count2+1;
      if haveblanks then writeinfo(blanks,nil,parchunk,work,chk);
      writeinfo(newtok,nil,parchunk,work,chk);
      gettoken(parchunk,chk);
      end
   else
   if newtoktype=rbracktok then
      begin
      count2 := count2-1;
      if haveblanks then writeinfo(blanks,nil,parchunk,work,chk);
      writeinfo(newtok,nil,parchunk,work,chk);
      gettoken(parchunk,chk);
      end
   else
   expandscan(parchunk,chk);
   end;
 
if haveblanks then writeinfo(blanks,nil,parchunk,work,chk);
readparam := parchunk;
if (newtoktype = semitok) then error (2);
if endmac then error (43); {unexpected eof}
end;

function readconst:chunkpnt;

(* this function is used to read in and expand the string containing the value 
of a macro variable at mvar definition time. the string representing the mvar 
value is delimited by ':=' (which has already been seen when readconst is called)
and ';'.  the function returns this expanded (but not evaluated) mvar string as
a pointer to the chunklist into which it has been expanded *)

var
  conststr:chunkpnt; (* the mvar string *)
 
begin
if dotrace then writeln(output,'readconst');
new(conststr);
conststr^.pos := 0;
conststr^.nxt := nil;
gettoken(conststr,chk);
 
while newtoktype<>semitok do
   expandscan(conststr,chk);
 
if haveblanks then writeinfo(blanks,nil,conststr,work,chk);
readconst := conststr;
end;

procedure prmacrodef;

(* this procedure reads in and sets up the definition of a macro. its
operation is fairly simple. first it must create a tabrec record corresponding
to the macro. it puts in the macro name, and the fact that  it is a macro
(not an mvar).  the complicated part of this procedure is  reading in the
names and types of the formal parameters, and inserting them into the tabrec
record as well. the total number of parameters is also indicated within this
record. then, the body of the macro is just scanned and inserted into the
bodyarray. the bounds of the macro body within this array are also indicated
within the tabrec record. then this record must also be inserted to the global
hash table of macros and global mvars *)
 
var
  tabentry:tabpnt;  (* the record representing this macro *)
  start,i,j:integer;(* variables used as counters and to keep track of 
                       parameter #'s *)
  newone:boolean;   (* is this a new macro name? *)
  mtype:mactype;    (* temporary for type of a parameter *)
  id:ident;         (* temporary for macro and parameter names *)

begin
if dotrace then writeln(output,'prmacrodef');
new(tabentry);
gettoken(dummychunk,nowhere);
if newtoktype <> identtok then error(22);
idstring(newtok,id);
tabentry^.name := id;
tabentry^.macflavor := macro;
gettoken(dummychunk,nowhere);
tabentry^.numpar := 0;
 
if newtoktype = lparentok then
   begin (*get parameters*)
   i := 0;
   repeat
      begin    (*get parameters of same type*)
      gettoken(dummychunk,nowhere);
      start := i+1; (* start is the number of the 1st param of a give type *)
      repeat
         begin
         if newtoktype <> identtok then error(23);
         i := i+1;
         if i > maxparno then error(24);
         idstring(newtok,id);
         tabentry^.parname[i] := id;
         gettoken(dummychunk,nowhere);
         if newtoktype = commatok then
            gettoken(dummychunk,nowhere);
         end
      until newtoktype=colontok;
      gettoken(dummychunk,nowhere);
      if (newtoktype <> mkwdtok) or not(newmkeytype in mactypeword) then
         error(25);
      case newmkeytype of
         mstringtok: mtype := mstring;
         minttok:mtype := minteger;
         mbooltok:mtype := mboolean;
      end;
      for j := start to i do  (* install the macro type for the previous list
                                 of parameters *)
          tabentry^.partype[j] := mtype;
(* prmacrodef continued *)


      gettoken(dummychunk,nowhere);
      if (newtoktype <> semitok) and (newtoktype <> rparentok) then
         error(26);
      end
   until newtoktype=rparentok;
   tabentry^.numpar := i;
   gettoken(dummychunk,nowhere);
   end;
 
if newtoktype<>semitok then error(27);
 
(* now read in body of macro *)
new(tabentry^.macbnd);
tabentry^.macbnd^.first := bodyend;
gettoken(dummychunk,body);
 
while (newtoktype <> mkwdtok) or (newmkeytype <> mendtok) do
   begin
   if haveblanks then
      writeinfo(blanks,nil,dummychunk,work,body);
   writeinfo(newtok,nil,dummychunk,work,body);
   gettoken(dummychunk,body);
   end;

tabentry^.macbnd^.last := bodyend-1;
inserttab(tabentry,true,newone);
if not newone then  error(28); (* no redefinition of macros allowed *)
 
end;

procedure prmvardef;

(* this procedure reads in and sets up a list of macro variable definitions. it
takes as a parameter isglobal, which is a boolean variable indicating whether or
not the mvars are global or local. for each mvar, a tabrec record is set up.
first the name of the mvar is found and placed into the record. then the
record records that this is an mvar (not a macro) and procedes to find the
mvar value. first it reads and expands the string representing this value
into conststr, and then it evaluates that string if the mvar is of type minteger
or mboolean. the mvar value is also stored in this record. (either as an integer
or boolean, or a pointer  to a string stored in the bodyarray). the record is
then inserted into the appropriate data structure, depending on isglobal *)
   
var
  tabentry:tabpnt; (* a pointer to a tabrec record being set up *)
  mtype:mactype;   (* the type of the mvar *)
  id:ident;        (* the name of the mvar *)
  newone:boolean;  (* is this mvar name a legal one? *)
  conststr:chunkpnt;(* a pointer to the chunklist containing the mvar value string*)
  n:parno; (*dummy parameter for  isparam *)
 
begin (*get list of mvar definitions*)
(* dzg - initialize n ! *)
n := 1;
if dotrace then writeln(output,'prmvardef');
gettoken(dummychunk,nowhere);
repeat
   begin
   new(tabentry);
   if newtoktype <> identtok then error(29);
   idstring(newtok,id);
   if not isglobal then
      begin
      (* dzg - added to prevent subrange out of bounds *)
      n := 1;
      if isparam(id,n) then error(30); (* make sure this isnt a formal name *)
      end;
   tabentry^.name := id;
   tabentry^.macflavor := mvar;
   gettoken(dummychunk,nowhere);
   if newtoktype <> colontok then error(31);
   gettoken(dummychunk,nowhere);
   if (newtoktype <> mkwdtok) or 
     not (newmkeytype in mactypeword) then error(25);
   case newmkeytype of
      mstringtok : mtype := mstring;
      minttok: mtype := minteger;
      mbooltok: mtype := mboolean;
   end;
   tabentry^.vartype := mtype;
   gettoken(dummychunk,nowhere);
   if newtoktype <> assigntok then error(32);
   if dotrace then writeln(output,'getting constant value for mvar');
   conststr := readconst; (* get mvar value-string *)
   case mtype of
      mstring : tabentry^.strval := chunktobody(conststr);
      mboolean: tabentry^.boolval := boolexpr(conststr);
      minteger: tabentry^.intval := arithexpr(conststr)
      end;
   if mtype <> mstring then dispose(conststr);
   inserttab(tabentry,isglobal,newone);
   if not newone then error(28);
   gettoken(dummychunk,nowhere);
   end
until newtoktype <> identtok;
end;

procedure prmassign;

(* this procedure is very similar to prmvardef, in that it also reads
in and evaluates a new value for a macro variable. however, massign can be
used only to reassign to an already defined mvar. first it reads in the
mvar name, and checks that this is the name of a defined macro variable.
note that if we are currently within a macro call, local mvars are checked
first. then the mvar value-string is expanded, and then evaluated. the
tabrec record representing this mvar is appropriately changed to reflect 
the mvar's new value *)

var 
  tabentry:tabpnt; (* a pointer to the mvar's tabrec record *)
  mtype:mactype;   (* the type of the mvar *)
  id:ident;        (* the name of the mvar *)
  conststr:chunkpnt;(* the expanded value-string of the mvar *)

begin
if dotrace then writeln(output,'prmassign');
gettoken(dummychunk,nowhere);
if newtoktype <> lparentok then error(33);
gettoken(dummychunk,nowhere);
if newtoktype <> identtok then error(34);
idstring(newtok,id);
if macrocalltime then
   begin
   if not membertab(id,false,tabentry) then
      if not membertab(id,true,tabentry) then error(35);
   end
else
if not membertab(id,true,tabentry) then error(35);
if tabentry^.macflavor <> mvar then error(36);
mtype:= tabentry^.vartype;
gettoken(dummychunk,nowhere);
if newtoktype <> commatok then error(37);
conststr := readparam;
case mtype of
   mstring : tabentry^.strval := chunktobody(conststr);
   mboolean: tabentry^.boolval:= boolexpr(conststr);
   minteger: tabentry^.intval := arithexpr(conststr)
   end;
if mtype <> mstring then dispose(conststr);
end;

procedure processheading;

(* this procedure gets us to the point where we expect to read in macro
and mvar definition. ie. it skips over the header page and the program
heading. note that minclude's will be expanded. *)

begin
if dotrace then writeln(output,'processheading');
repeat
  gettoken(dummychunk,out);
  while (newtoktype <> mkwdtok) and (not endmac) do
    begin

{ BEGIN PERQ CODE ****************}
       WaitCnt := WaitCnt + 1;
       if WaitCnt > 50 then
         begin
           WaitCnt := 0;
           WhereAmI := WhereAmI + 1;
           ShowProgress(Land(WhereAmI,1023));
         end;

{ END PERQ CODE **************** }

      if haveblanks then writeinfo(blanks,nil,dummychunk,work,out);
      writeinfo(newtok,nil,dummychunk,work,out);
      gettoken(dummychunk,out)
    end;
  if (not endmac) and (newmkeytype = mincludetok) then prminclude
until (newmkeytype <> mincludetok) or endmac
end;

procedure processdef;

(* this procedure reads in and sets up all global mvar and macro definitions.
it will also expand mif's, massign's, and minclude's at this time as well *)

var
  done,gottoken:boolean; (* done indicates whether it is time to start expanding
                          the source text.  gottoken tells us if we have already
                          read ahead a token. this happens if we process a list
                          of mvar defs *)

begin
if dotrace then writeln(output,'processdef');
gottoken := true;
 
repeat
   begin

{ BEGIN PERQ CODE **************** }
{ show progress on the screen }
       WaitCnt := WaitCnt + 1;
       if WaitCnt > 10 then
         begin
           WaitCnt := 0;
           WhereAmI := WhereAmI + 1;
           ShowProgress(Land(WhereAmI,1023));
         end;
{ END PERQ CODE ****************}

   if not gottoken then 
       gettoken(dummychunk,out)
   else
       gottoken := false;
   if (newtoktype = mkwdtok) and (newmkeytype in startword) then
      begin
      case newmkeytype of
         macrotok: prmacrodef;
         mvartok:  begin
                   prmvardef(true);
                   gottoken := true;
                   end;
         miftok:   prmif(dummychunk,out);
         massigntok: prmassign;
         mincludetok: prminclude;
      end;
      done := false;
      end
   else
      done := true;
   end
until done;
end;


procedure processtext;

(* this procedure runs the expansion of source text until the end of the program
is reached *)

begin
if dotrace then writeln(output,'processtext');
repeat
   begin


{ BEGIN PERQ CODE **************** }
{ show progress on the screen }
       WaitCnt := WaitCnt + 1;
       if WaitCnt > 50 then
         begin
           WaitCnt := 0;
           WhereAmI := WhereAmI + 1;
           ShowProgress(Land(WhereAmI,1023));
         end;
{ END PREQ CODE **************** }

   expandscan(dummychunk,out)
   end
until endmac;
end;



(* main procedure *)
var 
  infilename, outfilename, console: string; 
  CmdLine         : string[255];
  Broke           : string;

begin
{set version number}
writeln( 'Vax PASMAC Version 1B(103) 10-jul-81');
dotrace := false;


{ BEGIN PERQ CODE **************** }
  CmdLine := UsrCmdLine;
  RemDelimiters(CmdLine,' ',Broke);

  GetSymbol(CmdLine,infilename,' ',Broke);
  RemDelimiters(CmdLine,' ',Broke);
  GetSymbol(CmdLine,infilename,' ',Broke);
  RemDelimiters(CmdLine,' ',Broke);
  GetSymbol(CmdLine,outfilename,' ',Broke);

  if length(infilename) = 0 then
      begin
      write('Input file name: ');
      readln(infilename);
      end;
      
  if PosC(infilename,'.') = 0 then
    begin
      infilename := Concat(infilename,'.PasMac');
    end;
  if length(outfilename) = 0 then
      begin
        outfilename := infilename;
        Adjust(outfilename,PosC(infilename,'.')-1);
        outfilename := Concat(outfilename,'.Pas');
      end;

if samename (infilename, outfilename)
then begin
     write ('input and output filenames are the same. ok? ');
     readln (response);
     if not ord(UpperCase(response)) = ord('Y');
     then begin
          write ('Output file name: ');
	  readln(outfilename);
	  end;
     end;
     
{ END PERQ CODE **************** }

{ BEGIN VAX CODE **************** }
{ COMMENTED OUT
if argc < 2
then begin
     write (tty, 'input filename: ');
     readln (infilename);
     end
else argv (1, infilename);

if argc < 3
then begin
     write (tty, 'output filename: ');
     readln (outfilename);
     end
else argv (2, outfilename);
{ END VAX CODE **************** }


rewrite(tty, 'console:');     { error messages }
reset(input,infilename);
rewrite(output,outfilename);
init;

{ BEGIN PERQ CODE **************** }
{ show progress on the screen }
LoadCurs;
WhereAmI := 0;
WaitCnt  := 0;
{ END PERQ CODE **************** }

processheading;
if not endmac then processdef;
if not endmac then processtext; 
writeln(output);
close (output);    { dzg }
{   99: dzg }
end.
