module MoveCommands;

{*****************************************}
{
{        Pepper:  Spice Interim Editor
{        Move and Selection Commands
{        Richard Cohn
{        April 1, 1981
{
{*****************************************}


exports

imports RegionEditor from RegionEdit;

procedure MoveForChar (count: integer);
procedure MoveBakChar (count: integer);
function  GetForWords (P: Position; count: integer):  Position;
function  GetBackWords (P: Position; count: integer):  Position;
procedure MoveForWord (count: integer);
procedure MoveBackWord (count: integer);
procedure MoveUpLine (count: integer);
procedure MoveDownLine (count: integer);
procedure MoveUpPage (count: integer);
procedure MoveDnPage (count: integer);
procedure MoveBottomWindow;

procedure SelectText;
procedure SelectAllText;

procedure ScrollText;
procedure ThumbText;


private

imports ScreenUtilities from EdScreen;
imports TextUtilities from EdText;


{****************************************************************}

procedure MoveForChar (count: integer);
var P:  Position;
    OldPosCR:  boolean;
    L:  LineIndex;
    C:  ColumnIndex;

begin
if DEBUG [2] then Status ('Enter MoveForChar');
P := GetPosition (CurWin^.CurLine, CurWin^.CurCol);
Attach (Cursor1, P, ReadCursor);
while (count > 0) and not Eot (Cursor1.Pos) do
    begin
    count := count - 1;
    OldPosCR := Cursor1.Ch = CR;
    Add1C (Cursor1);
    if OldPosCR and (Cursor1.Ch = LF) then
        Add1C (Cursor1);
    if GT (Cursor1.Pos, CurWin^.ScreenLast) then
        ScrollUp (0, CurWin^.LastLine, 1);
    GetLC (Cursor1.Pos, L,C);
    MoveTextPointer (L,C);
    end;
Detach (Cursor1);
if DEBUG [2] then Status ('Exit MoveForChar')
end; { MoveForChar }


{****************************************************************}

procedure MoveBakChar (count: integer);
var P:  Position;
    L:  LineIndex;
    C:  ColumnIndex;

begin
if DEBUG [2] then Status ('Enter MoveBakChar');
P := GetPosition (CurWin^.CurLine, CurWin^.CurCol);
Attach (Cursor1, P, ReadCursor);
while (count > 0) and not Bot (Cursor1.Pos) do
    begin
    count := count - 1;
    Sub1C (Cursor1);
    if Cursor1.Ch = LF then
        begin
        Sub1C (Cursor1);
        if Cursor1.Ch <> CR then
            Add1C (Cursor1)
        end;
    if LT (Cursor1.Pos, CurWin^.ScreenFirst) then
        ScrollDown (0, CurWin^.LastLine, 1);
    GetLC (Cursor1.Pos, L, C);
    MoveTextPointer (L,C)
    end;
Detach (Cursor1);
if DEBUG [2] then Status ('Exit MoveBakChar')
end; { MoveBakChar }


{****************************************************************}

function  GetForWords (P: Position; count: integer):  Position;

var OldPosCR:  boolean;

begin
if DEBUG [2] then Status ('Enter GetForWords');
Attach (Cursor1, P, ReadCursor);
while Cursor1.Ch = Blank do
    Add1C (Cursor1);
while (count > 0) and not Eot (Cursor1.Pos) do
    begin
    count := count - 1;
    if Cursor1.Ch in WordChars then
        repeat
            OldPosCR := Cursor1.Ch = CR;
            Add1C (Cursor1)
        until not (Cursor1.Ch in WordChars)
    else
        begin
        OldPosCR := Cursor1.Ch = CR;
        Add1C (Cursor1)
        end;
    if OldPosCR and (Cursor1.Ch = LF) then
        Add1C (Cursor1)
    end;
GetForWords := Cursor1.Pos;
Detach (Cursor1);
if DEBUG [2] then Status ('Exit GetForWords')
end; { GetForWords }


{*******************************************************************}

function GetBackWords (P:  Position; count: integer):  Position;

var OldPosNotLF:  boolean;

begin
if DEBUG [2] then Status ('Enter GetBackWords');
Attach (Cursor1, P, ReadCursor);
while (count > 0) and not Bot (Cursor1.Pos) do
    begin
    count := count - 1;
    repeat Sub1C (Cursor1)
    until Cursor1.Ch <> Blank;
    if Cursor1.Ch in WordChars + [LF] then
        begin
        repeat
            OldPosNotLF := Cursor1.Ch <> LF;
            Sub1C (Cursor1)
        until not (Cursor1.Ch in WordChars);
        if OldPosNotLF or (Cursor1.Ch <> CR) then
            Add1C (Cursor1)
        end
    end;
GetBackWords := Cursor1.Pos;
Detach (Cursor1);
if DEBUG [2] then Status ('Exit GetBackWords')
end; { GetBackWords }


{******************************************************************}

procedure MoveForWord (count: integer);
var P, Q:  Position;
    L:  LineIndex;
    C:  ColumnIndex;
begin
if DEBUG [2] then Status ('Enter MoveForWord');
P := GetPosition (CurWin^.CurLine, CurWin^.CurCol);
Q := GetForWords (P, count);
while GT (Q, CurWin^.ScreenLast) do
    ScrollUp (0, CurWin^.LastLine, 1);
GetLC (Q, L, C);
MoveTextPointer (L,C);
if DEBUG [2] then Status ('Exit MoveForWord')
end; { MoveForWord }


{****************************************************************}

procedure MoveBackWord (count: integer);
var P, Q:  Position;
    L:  LineIndex;
    C:  ColumnIndex;
begin
if DEBUG [2] then Status ('Enter MoveBackWord');
P := GetPosition (CurWin^.CurLine, CurWin^.CurCol);
Q := GetBackWords (P, count);
while LT (Q, CurWin^.ScreenFirst) do
    ScrollDown (0, CurWin^.LastLine, 1);
GetLC (Q, L, C);
MoveTextPointer (L,C);
if DEBUG [2] then Status ('Exit MoveBackWord')
end; { MoveBackWord }

{****************************************************************}

procedure MoveUpLine (count: integer);

var L:  LineIndex;
    C:  ColumnIndex;
    i:  integer;

begin
if DEBUG [2] then Status ('Enter MoveUpLine');
with CurWin^ do
for i := 1 to count do
    begin
    L := CurLine;
    C := CurCol;
    if L > 0 then
        L := L - 1
    else
        ScrollDown (0, LastLine, 1);
    MoveTextPointer (L, C)
    end; { for }
if DEBUG [2] then Status ('Exit MoveUpLine')
end; { MoveUpLine }


{****************************************************************}

procedure MoveDownLine (count: integer);

var L:  LineIndex;
    C:  ColumnIndex;
    i:  integer;

begin
if DEBUG [2] then Status ('Enter MoveDownLine');
with CurWin^ do begin
for i := 1 to count do
    begin 
    L := CurLine;
    C := CurCol;
    if L < LastLine then
        L := L + 1
    else
        ScrollUp (0, LastLine, 1);
    MoveTextPointer (L, C)
    end; { for }
if Eot (GetPosition (CurLine, CurCol)) then
    begin
    GetLC (FilledLast, L, C);
    MoveTextPointer (L, C)
    end
end; { with }
if DEBUG [2] then Status ('Exit MoveDownLine')
end; { MoveDownLine }


{****************************************************************}

procedure MoveUpPage (count: integer);

{ If count = 1 then scroll the text down 3/4 page, keeping the pointer
{ at the same position if possible.  Otherwise, scroll down count lines.  }

var
    p:  Position;
    l:  lineIndex;
    c:  ColumnIndex;

begin
with CurWin^ do
    if count = 1 then
        begin
        p := GetPosition (curLine, curCol);
        ScrollDown (0, LastLine, 3 * LastLine div 4 + 1);
        GetLC (p, l, c);
        if l <= lastLine then
            MoveTextPointer (l, c);
        end
    else
        begin
        while count > LastLine do
            begin
            count := count - LastLine;
            ScrollDown (0, LastLine, LastLine)
            end;
        ScrollDown (0, LastLine, count)
        end
end; { MoveUpPage }


{****************************************************************}

procedure MoveDnPage (count: integer);

{ If count = 1 then scroll the text up 3/4 page, keeping the pointer
{ at the same position if possible.  Otherwise, scroll up count lines.  }

var
    p:  Position;
    l:  lineIndex;
    c:  ColumnIndex;

begin
with CurWin^ do
    if count = 1 then
        begin
        p := GetPosition (curLine, curCol);
        ScrollUp (0, LastLine, 3 * LastLine div 4 + 2);
        GetLC (p, l, c);
        if l >= 0 then
            MoveTextPointer (l, c);
        end
    else
        begin
        count := count + 1;  { ScrollUp scrolls up one line too few }
        while count > LastLine do
            begin
            count := count - LastLine;
            ScrollUp (0, LastLine, LastLine)
            end;
        ScrollUp (0, LastLine, count)
        end
end; { MoveDownPage }


{****************************************************************}

procedure MoveBottomWindow;

var L:  LineIndex;
    C:  ColumnIndex;

begin
with CurWin^ do
    begin
    L := LastLine;
    if EQ (Ln [L].Start, FilledLast) then
        GetLC (FilledLast, L, C);
    MoveTextPointer (L,0)
    end { with }
end; { MoveBottomWindow }


{****************************************************************}

procedure SelectText;

{ Keystroke selections coded as UpSelChar, not down to end loops
{ conveniently. }

var
    OrigFirstSelect, OrigLastSelect, MidSelect:  Position;
    OldFirstSelect, OldLastSelect:  Position;
    P, OldP:  Position;
    SelectKind: (Ch, Word, Line, Extend);
    UpSelection:  integer;
    OldWin:  pTextWindow;
    

{*****************************}

function Average (P, Q:  Position):  Position;
begin
Average := Add (P, Subtract (Q, P) div 2)
end;
    

{*****************************}

procedure GetWord (var First, Last:  Position);
    begin { GetWord }
    if DEBUG [2] then Status ('Enter GetWord');
    Attach(Cursor1,First,ReadCursor);
    if Cursor1.Ch = Blank then
        begin
        repeat Sub1C (Cursor1)
        until Cursor1.Ch <> Blank;
        Add1C (Cursor1)
        end
    else if Cursor1.Ch in WordChars then
        begin
        repeat Sub1C(Cursor1)
        until not (Cursor1.Ch in WordChars);
        Add1C (Cursor1);
        First := Cursor1.Pos
        end;
    ReAttach(Cursor1,Last);
    while Cursor1.Ch = Blank do
        Add1C (Cursor1);
    if Cursor1.Ch in WordChars then
        begin
        repeat Add1C(Cursor1)
        until not (Cursor1.Ch in WordChars);
        Last := Add(Cursor1.Pos,-1)
        end;
    Detach(Cursor1);
    CheckCRLF(First,Last);
    if DEBUG [2] then Status ('Exit GetWord')
    end { GetWord };
  
  
{*****************************}

procedure GetLine (var First, Last:  Position);
var L:  LineIndex;
    C:  ColumnIndex;
    begin { Line }
    if DEBUG [2] then Status ('Enter GetLine');
    with CurWin^ do
        begin
        GetLC (First, L, C);
        First := Ln [L].Start;
        GetLC (Last, L, C);
        Last  := Ln [L].Finish
        end;
    if DEBUG [2] then Status ('Exit GetLine')
    end { GetLine };


{*****************************}

begin { SelectText }
if DEBUG [2] then Status ('Enter SelectText');
with NewEvent do
    if Cmd in UpMouseCmds then
        begin
        x := 0;
        y := 0;
        ReturnKey (inputQueue, newEvent);
        if Cmd = UpSelChar then
            Cmd := SelChar
        else if Cmd = UpSelWord then
            Cmd := SelWord
        else if Cmd = UpSelLine then
            Cmd := SelLine
        else
            Cmd := ExtendSel
        end;
if NewEvent.Cmd = SelChar then
    begin
    Prompt ('Select by character');
    SelectKind := Ch
    end
else if NewEvent.Cmd = SelWord then
    begin
    Prompt ('Select by word');
    SelectKind := Word
    end
else if NewEvent.Cmd = SelLine then
    begin
    Prompt ('Select by line');
    SelectKind := Line
    end
else 
    begin
    Prompt ('Extend selection');
    SelectKind := Extend
    end;
with CurWin^, Bufary [SelectB] do
    begin
    P := GetPosition (CurLine, CurCol);
    if Eot (P) then
        if Bot (P) then
            begin
            Warn ('Window empty--no text to select');
            repeat LookForCommand (CanvKeybd)
            until NewEvent.Cmd in UpMouseCmds;
            Exit (SelectText)
            end
        else
            Sub1 (P);
    if SelectKind = Extend then
        begin
        if SelectWindow <> CurWin then
            begin
            Warn ('Selection not in window--can''t extend');
            repeat LookForCommand (CanvKeybd)
            until NewEvent.Cmd in UpMouseCmds;
            exit (SelectText)
            end;
        OrigFirstSelect := First;
        OrigLastSelect := Last;
        MidSelect := Average (First, Last);
        OldP := NilPosition;  { a position guaranteed <> P }
        end
    else
        begin
        if SelectWindow <> nil then
            begin
            OldWin := CurWin;
            ChangeTextWindow (SelectWindow);
            Underline (First, Last, Erase);
            SelectWindow := nil;
            UpdateThumbBar;
            ChangeTextWindow (OldWin);
            end;
        OrigFirstSelect := P;
        OrigLastSelect := P;
        if SelectKind = Word then
            GetWord (OrigFirstSelect, OrigLastSelect)
        else if SelectKind = Line then
            GetLine (OrigFirstSelect, OrigLastSelect);
        SelectWindow := CurWin;
        CheckCRLF (OrigFirstSelect, OrigLastSelect);
        if Eot (OrigLastSelect) then
            OrigLastSelect := Add (OrigLastSelect, -1);
        UnderLine (OrigFirstSelect, OrigLastSelect, ThinBlack);
        First := OrigFirstSelect;
        Last := OrigLastSelect;
        DrawLn (SelectB);
        OldP := P
        end;
    TBarOn := false;
    repeat
        if NE (OldP, P) then
            begin
            OldP := P;
            OldFirstSelect := First;
            OldLastSelect := Last;
            if LE (P, OrigFirstSelect) then
                begin
                First := P;
                Last := OrigLastSelect
                end
            else if GT (P, OrigLastSelect) then
                begin
                First := OrigFirstSelect;
                if SelectKind in [Ch, Extend] then
                    Last := Add (P, -1)
                else
                    Last := P
                end
            else if SelectKind = Extend then
                if LE (P, MidSelect) then
                    begin
                    First := P;
                    Last := OrigLastSelect;
                    OrigFirstSelect := P;
                    MidSelect := Average (First, Last)
                    end
                else
                    begin
                    First := OrigFirstSelect;
                    Last := Add (P, -1);
                    OrigLastSelect := Last;
                    MidSelect := Average (First, Last)
                    end
            else { needed for initial time thru loop }
                begin
                First := OrigFirstSelect;
                Last := OrigLastSelect
                end;
            if SelectKind = Word then
                GetWord (First, Last)
            else if SelectKind = Line then
                GetLine (First, Last);
            CheckCRLF (First, Last);
            if Eot (Last) then
                Sub1 (Last);
            if LT (First, OldFirstSelect) then
                UnderLine (First, OldFirstSelect, ThinBlack)
            else if GT (First, OldFirstSelect) then
                UnderLine (OldFirstSelect, Add (First,-1), Erase);
            if GT (Last, OldLastSelect) then
                UnderLine (Add (OldLastSelect,1), Last, ThinBlack)
            else if LT (Last, OldLastSelect) then
                begin
                P := Add (Last,1);
                Attach (Cursor2, P, ReadCursor);
                if Cursor2.Ch = LF then
                    begin
                    Sub1C (Cursor1);
                    if Cursor2.Ch = CR then
                        P := Cursor2.Pos
                    end;
                Detach (Cursor2);
                UnderLine (P, OldLastSelect, Erase)
                end;
            end; { if NE (OldP,P) }
        LookForCommand (CanvKeybd);
        DisplPointer (xPointer, yPointer);
        repeatCount := 1;
        case NewEvent.Cmd of
            ForChar:    MoveForChar (repeatCount);
            BackChar:   MoveBakChar (repeatCount);
            ForWord:    MoveForWord (repeatCount);
            BackWord:   MoveBackWord (repeatCount);
            BeginLine:  MoveTextPointer (CurLine,0);
            EndLine:    MoveTextPointer (CurLine, Ln [CurLine].Length-1);
            UpLine:     MoveUpLine (repeatCount);
            DownLine:   MoveDownLine (repeatCount);
            UpPage:     MoveUpPage (repeatCount);
            DownPage:   MoveDnPage (repeatCount);
            TopWindow:  MoveTextPointer (0,0);
            BottomWindow:  MoveBottomWindow;
            BeginFile:  Show (Add(FilledFirst,2), 0, LastLine);
            EndFile:    Show (FilledLast, 0, LastLine);
            PosToSelect:if SelectWindow = CurWin then
                            Show (Bufary [SelectB].First, 0, LastLine)
                        else
                            Warn ('No selection in this window');
            FindMark:   if Mark <> NilPosition then
                            begin
                            P := GetPosition (CurLine, CurCol);
                            Show (Mark, 0, LastLine);
                            Mark := P
                            end
                        else
                            Warn ('No mark set in this window');
            otherwise:  if not (NewEvent.Cmd in MouseCmds + UpMouseCmds +
                            [NullCmd]) then
                            begin
                            ReturnKey (inputQueue, newEvent);
                            NewEvent.Cmd := UpSelChar { to leave loop }
                            end
            end;  { case }
        P := GetPosition (CurLine, CurCol);
    until NewEvent.Cmd in UpMouseCmds
    end; { with }
DrawLn (SelectB);
TBarOn := true;
UpdateThumbBar;
NeedPrompt := true;
ImmedPrompt := true;
if DEBUG [2] then Status ('Exit SelectText')
end; {SelectText }


{****************************************************************}

procedure SelectAllText;
begin
if DEBUG [2] then Status ('Enter SelectAllText');
if (SelectWindow <> CurWin) and (SelectWindow <> nil) then
    UnSelect;
SelectWindow := CurWin;
with Bufary [SelectB] do
    begin
    First := Add (CurWin^.FilledFirst, 2);
    Last := Add (CurWin^.FilledLast, -1);
    UnderLine (First, Last, ThinBlack)
end;
DrawLn (SelectB);
UpdateThumbBar;
if DEBUG [2] then Status ('Exit SelectAllText')
end; { SelectAllText }


{****************************************************************}

procedure ScrollText;

var OldLine, NewLine:  integer;
    OldYP:  integer;
    xFixed:  integer;
    ScrollCmds:  set of KeyCommand;

begin
Prompt ('Scroll mode:  ');
ScrollCmds := MouseCmds + UpMouseCmds + [OneUp, OneDown];
with CurWin^ do
    begin
    xFixed := xScroll + Bound^.xMin;
    if CurrentPtr <> ScrollPtr then
        begin
        xPointer := xFixed;
        if CurrentPtr = ThumbPtr then
            yPointer := yHome;
        DisplPointer (xPointer, yPointer)
        end;
    repeat
        if NeedPrompt then
            Prompt ('Scroll mode:');
        LookForCommand (CanvKeybd);
        DisplPointer (xPointer, yPointer);
        if yPointer <= yHome then
            yPointer := yHome
        else if yPointer >= yLastLine then
            yPointer := yLastLine;
        OldLine := CurLine;
        if NewEvent.Cmd = OneUp then
            begin
            if OldLine > 0 then
                yPointer := yPointer - LineHeight
            end
        else if NewEvent.Cmd = OneDown then
            begin
            if OldLine < LastLine then
                yPointer := yPointer + LineHeight
            end
        else if NewEvent.Cmd = ScrollTop then
            ScrollUp (0, LastLine, OldLine)
        else if NewEvent.Cmd = ScrollBottom then  
            ScrollDown (0, LastLine, OldLine)
        else if NewEvent.Cmd in [Cont1Scroll, Cont2Scroll] then
            begin
            Prompt ('Scroll mode:  continuous scrolling');
            NeedPrompt := true;
            OldYP := yHome + OldLine * LineHeight - 
                CursorPtr [ScrollPtr].yOrigin;
            RasterOp (ROr, ScrollWidth-xFixed, LineHeight,
                xFixed, OldYP, SScreenW, SScreenP,
                0, 0, 4, CursorPtr [BScrollPtr].Pattern);
            repeat
                LookForCommand (CanvKeybd);
                DisplPointer (xScroll, yPointer);
                if NewEvent.Cmd = OneUp then
                    begin
                    if OldLine > 0 then
                        yPointer := yPointer - LineHeight
                    end
                else if NewEvent.Cmd = OneDown then
                    if OldLine < LastLine then
                        yPointer := yPointer + LineHeight;
                if not (NewEvent.Cmd in [Stop1Scroll, Stop2Scroll, Reject])
                    then
                    begin
                    if curLine > OldLine then
                        ScrollDown (0, LastLine, curLine - OldLine)
                    else if curLine < OldLine then
                        ScrollUp (0, LastLine, OldLine - curLine)
                    end
            until NewEvent.Cmd in [Stop1Scroll, Stop2Scroll, Reject];
            RasterOp (RXOr, ScrollWidth-xFixed, LineHeight,
                xFixed, OldYP, SScreenW, SScreenP,
                xFixed, OldYP, SScreenW, SScreenP);
            xPointer := xFixed;
            end
        else if NewEvent.Cmd in LeaveTSCmds then
            begin
            ReturnKey (inputQueue, newEvent);
            NewEvent.Cmd := ToggleScroll
            end;
        if NewEvent.Cmd = Reject then
            NewEvent.Cmd := ToggleScroll
    until (CurrentPtr <> ScrollPtr) or (NewEvent.Cmd = ToggleScroll);
    if NewEvent.Cmd = ToggleScroll then
        xPointer := xHome
    else
        ReturnKey (inputQueue, newEvent);
    ImmedPrompt := true
    end; {with }
end; { ScrollText }


{****************************************************************}

procedure ThumbText;
var
  ySelect:  integer;
  numChars: long;
  thumbChar: long;
  temp: integer;

{ from CurWin:  xTBarOrigin, yTBarOrigin, TBFillWidth, xSelect, FilledLast }


  procedure ThumbToChar(charNum: long);
  var
    P:  pChunk;
    Q:  Position;
    OldX:  integer;
    cPos: long;
  begin { ThumbToChar }
    OldX := xPointer;
    with CurWin^ do
      begin
        cPos := -2;
        P := nil;
        repeat
          if P = nil then
            P := FilledFirst.Chunk
          else
            P := P^.next;
          cPos := cPos + P^.length;
        until cPos > charNum;
        cPos := cPos - P^.length;
        Q.Chunk := P;
        Q.Offset := shrink(charNum - cPos);
        if EQ(Q,FilledFirst) then
          Q := Add (Q, 2)
        else
          begin
            Attach(DrawCursor, Q, ReadCursor);
            repeat
              repeat
                Sub1C(DrawCursor);
              until (DrawCursor.Ch = LF) or Bot(DrawCursor.Pos);
              Sub1C(DrawCursor);
              if DrawCursor.Ch <> CR then
                Add1C(DrawCursor);
            until (DrawCursor.Ch = CR) or Bot(DrawCursor.Pos);
            Q := Add (DrawCursor.Pos, 2);
            Detach(DrawCursor);
          end; { else }
        Show (Q, LastLine div 2 - 1, LastLine div 2 + 1);
        { Show moves pointer to Q, so it must be moved back. }
        xPointer := OldX;
        yPointer := yTBarOrigin;
        DisplPointer(xPointer, yPointer);
      end; { with }
  end { ThumbToChar };


{************************************}

begin { ThumbText }
  Prompt ('In thumbing region:');
  with CurWin^ do
    begin
      if CurrentPtr <> ThumbPtr then
        begin
          yPointer := yTBarOrigin;
          xPointer := xTBarOrigin
        end;
      with filledLast.chunk^ do
        begin
          temp := length;
          numChars := (stretch(orderP) * 512) + stretch(orderC) +
                      stretch(temp) - 3;
        end;
      ySelect := yTBarOrigin + (TBarHeight + CharHeight + 1) div 2;
      repeat
        LookForCommand (CanvKeybd);
        DisplPointer (xPointer, yPointer);
        if CurrentPtr = ThumbPtr then
          if NewEvent.Cmd = MoveRight then  
            begin
              xPointer := xPointer + TBFillWidth;
              if xPointer > xTBarOrigin + TBarWidth then
                xPointer := xTBarOrigin + TBarWidth
            end
          else if NewEvent.Cmd = MoveLeft then  
            begin
              xPointer := xPointer - TBFillWidth;
              if xPointer < xTBarOrigin then
                xPointer := xTBarOrigin
            end
          else if NewEvent.Cmd in MouseCmds + UpMouseCmds then
            begin
              repeat
                if not (NewEvent.Cmd in UpMouseCmds) then
                  LookForCommand (CanvKeybd);
                if xPointer < xTBarOrigin then
                  xPointer := xTBarOrigin
                else if xPointer > xTBarOrigin + TBarWidth then
                  xPointer := xTBarOrigin + TBarWidth;
                yPointer := yThumb;
                DisplPointer (xPointer, yPointer)
              until NewEvent.Cmd in UpMouseCmds + [Reject];
              if NewEvent.Cmd <> Reject then
                begin
                  thumbChar := (numChars *
                                stretch(xPointer - xTBarOrigin) +
                                (TBarWidth div 2)) div TBarWidth;
                  if thumbChar > numChars then
                    thumbChar := numChars
                  else if thumbChar < 0 then
                    thumbChar := 0;
                  ThumbToChar(thumbChar);
                end;
            end { if NewEvent.Cmd = Down... }
          else if NewEvent.Cmd in LeaveTSCmds then
            begin
              ReturnKey (inputQueue, NewEvent);
              NewEvent.Cmd := ToggleThumb
            end;
          if NewEvent.Cmd = Reject then
            NewEvent.Cmd := ToggleThumb
      until (CurrentPtr <> ThumbPtr) or (NewEvent.Cmd = ToggleThumb)
    end; { with }
  if NewEvent.Cmd = ToggleThumb then
    MoveTextPointer (0,0)
  else
    ReturnKey (inputQueue, NewEvent);
  ImmedPrompt := true
end. { ThumbText }
