Module Screen;
{---------------------------------------------------------------}
{ Perq Screen Driver                                            }
{ Written By: Miles A. Barel    July 1, 1980                    }
{             Three Rivers Computer Corporation                 }
{             Pittsburgh, PA 15213                              }
{ Abstract: Provides the interface to the PERQ screen including }
{           rudimentary support for multiple windows            }
{---------------------------------------------------------------}

{----------------------------------------------------------------
   Change Log:

  Version  3.12 20-Jan-82  Brad A. Myers  Fix title line to quote characters
                                          Fixed cursorOutside exception from
                                              ChangeTitle after SSetSize.
                                          Fixed SBackSpace comment.
  Version  3.11 13-Aug-81  Brad A. Myers  Raise an exception if SSetCursor
                                            outside a window
  Version  3.10 26-Jun-81  Brad A. Myers  Export the Window Table
  Version  3.9  26-Jun-81  Brad A. Myers  Export all internal procedures
                                             used by SPutChr for XSPutChr
                                          Add new procedure for window change
                                             to full size.
                                          Fixed bug when ask for current window
                                             size.
                                          Fixed bug in SSetSize.
  Version  3.8  23-May-81  John P. Strait Use IOKeyDisable in ChangeTitle.
  Version  3.7  13-May-81  Brad A. Myers  Added new exceptions
  Version  3.6  17-Mar-81  Brad A. Myers  Changed SClearChar and SBackSpace to
                                           take a char; made name compatible
  Version  3.5   3-Mar-81  Brad A. Myers  Removed BS special char and added
                                           SBackSpace and SClearChar procedures
                                           Removed SRasterOp
                                           and SLine and SIsCurOn; SCursorOn
                                           vble exported
  Version  3.4  24-feb-81  Brad A. Myers  Added return param to GetWindowParms
                                           to tell HasTitle;
  Version  3.3  24-feb-81  Brad A. Myers  Added param to SSetSize to leave
                                           screen displayed
  Version  3.2  20-feb-81  Brad A. Myers  Changed to have a fixed number of
                                           windows; added refresh command and
                                           SIsCurOn; fixed dot in lower-right
                                           corner
  Version  3.1  19-feb-81  Brad A. Myers  BS to previous line added; restrict
                                           number of chars printed on line to
                                           255;
  Version  3.0  18-feb-81  Brad A. Myers  Added Window relative RasterOp and
                                           Line routines; changed windows to
                                           be a list rather that record;
                                           changed module name; added extra
                                           scan line to title and margin below;
                                           changed to separate CR-LF
  Version  2.2   9-Feb-81  Brad A. Myers  fixed broken screen size; make screen
                                           export SScreenP and SScreenW
  Version  2.1  14-Jan-81  Brad A. Myers  fixed cursor bug
  Version  1.0   1-Jul-80  Miles A. Barel started
----------------------------------------------------------------}

Exports

Imports Raster from Raster;

Const   ScreenVersion = 'V3.12';
        VarWin = false;  {if true then can have an arbitrary number of windows
                          and storage for them has to be allocated off a heap.
                          If false then there are 17 windows max, and
                          storage is in screens global data. 
                          NOTE: There are still bugs in VarWin true}

Type
        FontPtr = ^Font;
        Font = Packed Record    { Contains character sets }
                Height:integer; { Height of the KSet }
                Base: integer;  { distance from top of characters to base-line }
                Index: Array [0..#177] of { Index into character patterns }
                    Packed Record case boolean of
                      true: (Offset: 0..767; { position of character in patterns }
                        Line: 0..63;    { Line of patterns containing char }
                        Width: integer); { Width of the character }
                       false:(Loc:integer; Widd: integer)
                    end;
                Filler: array[0..1] of integer;
                Pat: Array [0..0] of integer;  { patterns go here }
                                        { We turn off range checking to }
                                        { access patterns, hence allowing }
                                        { KSets of different sizes }
            end;
{$ifc VarWin then}
      WindowP = ^WindowType;
{$endc}
      WindowType = Packed Record
{$ifc VarWin then}
                       winNumber: Integer;  {this window number}
{$endc}
                       winBY, winTY, winLX, winRX,   { Limits of window area }
                       winHX, winHY, winMX, winMY,   { Limits of useable area }
                       winCurX, winCurY, winFunc: integer;
                       winKSet: FontPtr;
                       winCrsChr: char;
                       winHasTitle, winCursorOn, defined: boolean;
{$ifc VarWin then}
                       winNext: WindowP;
{$endc}
                       end;
{$ifc VarWin then}
Const   MaxWIndx = 32767;
{$elsec}
Const   MaxWIndx = 17;
{$endc}

Type    WinRange = 0..MaxWIndx;        
        LineStyle = (DrawLine,EraseLine,XorLine);

        LS = String[255];
        
Procedure ScreenInit;           { CALL THIS ONCE AT BOOT }
Procedure ScreenReset;          { This procedure de-allocates storage for
                                  all windows and sets up the default window. }
Procedure SPutChr(CH:char);     { put character CH out to current position }
                                { on the screen.  Chars FF, CR, and LF }
                                { have special meanings unless #200 bit set: }
                                {       FF - clear screen               
                                {       CR - move left to margine
                                {       LF - move vertically down one 
                                {       BS - erase previous character   }
Procedure SSetCursor(X,Y: integer);     { Set Cursor Position to X,Y }
Procedure SReadCursor(var X,Y: integer);{ Read Cursor Position }
Procedure SCurOn;                       { Enable display of Cursor }
Procedure SCurOff;                      { Disable display of Cursor }
Procedure SCurChr(C: char);             { Set cursor character }
Procedure SChrFunc(F: integer);         { Set raster-op function for SPutChr }
Procedure SSetSize(Lines: integer; complemented, screenOff: Boolean);
                                        { Set Screen Size; lines must be a
                                          multiple of 128; screenOff if true
                                          turns off display in part below lines
                                          in which case, complemented 
                                          describes off part of screen }
Procedure CreateWindow(WIndx: WinRange;
                       OrgX, OrgY, Width, Height: integer; Title: string);
Procedure ChangeWindow(WIndx: WinRange);
Procedure GetWindowParms(var WIndx: WinRange;
          var OrgX, OrgY, Width, Height: integer; var hasTitle: Boolean);
Procedure ChangeTitle(Title: string);
Procedure SetFont(NewFont: FontPtr);
Function GetFont: FontPtr;

Procedure SClearChar(c: Char; funct: Integer); {delete prev char}
                                       { c BETTER NOT be CR or LF}
Procedure Line(Style: LineStyle; X1, Y1, X2, Y2: integer; Origin: RasterPtr);
Procedure SBackSpace(c: Char); {move back over last char of curLine}
                                       { c BETTER NOT be CR or LF}
Procedure RefreshWindow(WIndx: WinRange); {redraws window outline and title
                                            area. DOES NOT REDRAW TITLE}

Exception WBadSize; {parameter to SSetSize bad}
{-----------------------------------------------------------------------------
 Abstract: Raised if the lines parameter to SSetSize is not a multiple of
           128 or is <=0.  Also raised if a window is totally below area to
           release so will disappear then if window # 0 or is the current
           window, then Raises WBadSize.
-----------------------------------------------------------------------------}

Exception BadWNum;  {indx is invalid}
{-----------------------------------------------------------------------------
 Abstract: Raised if a window number parameter is illegal (not defined or out
           of range.
-----------------------------------------------------------------------------}

Exception WTooBig;
{-----------------------------------------------------------------------------
 Abstract: Raised if parameters for new window specify an area that would
            extend off screen.
-----------------------------------------------------------------------------}

Procedure StartLine;
Procedure ToggleCursor;
Procedure NewLine;
Procedure SaveLineEnd(x: Integer);
Procedure SFullWindow;

Const SScreenW = 48;       {for use when want Screen in RasterOp or Line}
Var   SScreenP: RasterPtr; {for use when want Screen in RasterOp or Line}
      SCursorOn: boolean;
      SFunc: integer;      { Raster-op function for SPutChr }

{$ifc VarWin then}
      FirstWindp,             { first window's pointer; better not be NIL }
      CurWindp: WindowP;      { current window's pointer }
{$elsec}
      CurWind: WinRange;
      WinTable: Array[WinRange] of WindowType;
{$endc}

Exception CursOutSide;
{-----------------------------------------------------------------------------
 Abstract: Raised if try to set the cursor outside of the current window.
 Resume:  Allowed.  If resume, then cursor is NOT moved (same effect as if
          signal is caught but not resumed).  
-----------------------------------------------------------------------------}


Private
