(****)
Module PopUp;
(*****)
(*****
Program PopUp(input, output);
(******)

{----------------------------------------------------------------------------
 PopUp displays "popUp" menu windows 
 
 Written by  Brad A. Myers 16-Nov-80
  
 Abstract: This program produces pop up windows that replace the screen
            area at a specified cursor location. The cursor is then changed and
            PopUp waits for a press.  Whenever the cursor is inside the window,
            the command at that point is highlighted.  If a press is done
            inside the window, the highlighted command is selected.  The
            user can control whether one or more than one command should
            be selected before window is removed.  If a press outside
            outside, no command is executed.  In any case, the window is
            erased and the original contents of that area is returned

 Copyright (C) 1981 - The Three Rivers Computer Corporation
-----------------------------------------------------------------------------}


{----------------------------------------------------------------------------
 Change Log:
      19 Jan 82  Brad A. Myers V2.4  Handle the exception HelpKey.
      17 Sep-81  Brad A. Myers V2.3  fixed comments.  Made so will work with
                                     any current font.
      28-Aug-81  Brad A. Myers V2.2  Fixed histerises for bottom command.
                                     Made it harder to select the bottom
                                       command when trying to hit the scroll
                                       bar.
      22-Jul-81  Brad A. Myers V2.1  Handlers for ^C and ^Shift-C.
      22-Jul-81  Brad A. Myers V2.0  removed interface to TheFront.
      20-Nov-80  Brad A. Myers V1.1  Changed interface to TheFront.
      16-Nov-80  Brad A. Myers V1.0  Started.
-----------------------------------------------------------------------------}


{-*-*-*-*-*-*-*-*-*-*-*-*-*-*-} EXPORTS {-*-*-*-*-*-*-*-*-*-*-*-*-*-*-}

EXCEPTION BadMenu;
{-----------------------------------------------------------------------------
Abstract: Raised when parameters are illegal.
-----------------------------------------------------------------------------}

EXCEPTION Outside;
{-----------------------------------------------------------------------------
Abstract: raised when press outside of menu.
-----------------------------------------------------------------------------}

Type s25 = String[25];
     NameAr = Array[1..1] of s25;
     pNameAr = ^NameAr;
     NameDesc = Record
                   header: s25;
                   numCommands: integer;
                   commands: NameAr;
                 End;
     pNameDesc = ^NameDesc;

     ResRes = ^ResArray;
     ResArray = Record
                 numIndices: integer;
                 indices: Array[1..1] of integer;
                End;

PROCEDURE Menu(names: pNameDesc; isList: boolean;
               first, last, curX, curY, maxYsize: integer; VAR res: ResRes);

PROCEDURE InitPopUp;
PROCEDURE DestroyRes(var res: ResRes);

PROCEDURE AllocNameDesc(numNames, seg: Integer; Var names: pNameDesc);
PROCEDURE DestroyNameDesc(Var names: pNameDesc);

{-*-*-*-*-*-*-*-*-*-*-*-*-*-*-} PRIVATE {-*-*-*-*-*-*-*-*-*-*-*-*-*-*-}
