Module IO_Unit;
{-----------------------------------------------------------------------------
{
{ IO_Unit - Unit IO routines.
{ Miles A. Barel  ca. 1 Jan 80.
{ Copyright (C) 1980, Three Rivers Computer Corporation
{
{ Abstract:
{       IO_Unit exports procedures to perform IO on the various IO Units
{       (devices).
{
{ Design:
{       1) UnitIO must increment and decrement the IOCount of the segments
{          which are involved in IO.
{       2) Segment faults must *never* happen while interrupts are off.
{
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------
{ Change Log:
{
{ 29 Jan 82  WJHansen V6.2  made time out 300000
{
{ 10 Dec 81  WJHansen V6.1  removed Arith; use long for Time
{                           add timeout for all other devices
{                              (especially GPIB and RS232)
{
   4-Nov-81  DAS  V6.0  Fixed to work with 10 megabuad ethernet.

   1-Jul-81  BAM  V5.4  Change Screen name to ScreenOut.

   3-Jun-81  JPS  V5.3  Add Virgil headers and comments.

  23-May-81  JPS  V5.2  Use new IOKeyDisable/IOKeyEnable in place of old
                        DisCtlC/EnaCtlC.
  
  16-Apr-81  GGR  V5.1  Add 3MHz Ethernet Drivers (JEB).
  
  11-May-81  JPS  V5.0  Split IO into several modules.
  
   6-May-81  JPS  V4.7  1. Use new form of the SetCylinder StartIO.
                        2. Don't bother doing 10 trys in FindSize since only
                           the last result was believed regardless of success
                           or failure.
                        3. Hang if we cannot figure out the size of the disk.
  
  11-Apr-81  JPS  V4.6  Changes for virtual memory.
  
  19-Mar-81  BAM  V4.5  Changed name of included modules to IO_Init and IO_Proc
  
   3-Mar-81  JPS  V4.4  1) Fix LocateDskHeads and FindSize to agree with V4.3.
                        2) Teach the HardDisk timeout code about multi-sector
                           operations.

  28-Feb-81  JPS  V4.3  No longer do conversions on Disk Physical block
                        numbers (reinstating changes made in V4.0).

  25-Feb-81  GGR  V4.2  Added setting/reading of DskFill1 in UnitIO.
                        Moved new/dispose of CB from UnitIO to IO.Init.

  16-Feb-81  BAM  V4.1  Put back in conversions on Disk Physical block
                        numbers; fixed botCursF bug.  Del XXX procedures;
                        Changed to use new screen
  
   9-Feb-81  BAM  V4.0  No longer does conversions on Disk Physical block
                        numbers; fixed CursorUpdate to allow partial screen
                        display and added procedure IOScreenSize to set a 
                        new size.
  
  13-Jan-81  JPS  V3.3  Move creation of the IOSeg to memory manager init.
                        Move $R- to private part.

  20-Nov-80  JPS  V3.2  Initialize TabFifoInx in InitTablet.
  
  17-Nov-80  JPS  V3.1  Export the interrupt table.
                        Check SystemInitialized for control-C abort.
  
  16-Nov-80  BAM  V3.0  Radically changed Cursor and Tablet interface.  New
                        time procedures.  Split into another include file.
  
  10-Oct-80  JPS  V2.2  Added support for the diagnostic display (DDS).
 
  27-Sep-80  DAS  V2.1  Added timeout code to UnitIO for the
                        hard disk.
 

  19-Sep-80  DAS  V2.0  Added code for 24 MByte disks.
  
{-----------------------------------------------------------------------------}

{*******************************}   Exports   {*****************************}



Imports SystemDefs from SystemDefs;


Const
        { Device Code Assignments }
        MaxUnit = 18;           { highest legal device code }
        FakeUnits = 2;          { Number of units which don't have StartIO's }
        IOStart = 0;            { Master Z-80 control }
        HardDisk = 1;
{$ifc Ether3MBaud then}
        Ether3 = 2;
{$elsec}
{$ifc Ether10MBaud then}
        Ether10 = 2;
{$endc}
{$endc}

        Floppy = 3;
        Speech = 4;
        GPIBIn = 11;
        GPIBOut = 5;
        Z80Monitor = 6;
        Tablet = 7;
        KeyBoard = 8;
        RS232In = 9;
        RS232Out = 10;
        SpPutSts = 12;          { Put/Get Status }
        SpGetSts = 13;
        SpPutCir = 14;          { Put/Get from Circular Buffer }
        SpGetCir = 15;
        { Fake Units Begin Here }
        TransKey = 16;          { Translated Keyboard }
        ScreenOut = 17;         { Screen Display }
        Clock = 18;             { Used only for Put/Get Status }
        LastUnit = Clock;       { for unit validity checking }

Type
        IOBufPtr = ^IOBuffer;
        IOBuffer = array[0..0] of integer;
        
        CBufPtr = ^CBufr;
        CBufr = packed array[0..0] of char;     { same as Memory, except for }
                                                { character buffers }
        BigStr = String[255];                   { A big String }
        
        UnitRng = 0..MaxUnit;
        
        IOStatPtr = ^IOStatus;
        IOStatus = record
                HardStatus: integer;            { hardware status return }
                SoftStatus: integer;            { device independent status }
                BytesTransfered: integer
            end;
            
        IOHeadPtr = ^IOHeader;
        IOHeader = record                       { Hard disk header record }
                       SerialNum: Double;       { Serial number of the file }
                       LogBlock: integer;       { The logical block number }
                       Filler: integer;
                       NextAdr: Double;         { Address of next block in the file} 
                       PrevAdr: Double          { Address of previous block }
                     end;

        DevTabPtr = ^DeviceTable;
        DeviceTable = array [UnitRng] of packed record
                CtlPtr: IOBufPtr;               { actually pointer to ChrCntlBlk or IOCB, }
                                                { but we'll coerce later }
                BlockSize: integer;             { 0 = variable size }
                                                { 1 = character device (uses circ buf) }
                                                { >1 = fixed blocksize (= blocksize ) }
                IntrMask: integer;              { interrupt mask bits }
                IntrPriority: integer;          { decoded iterrupt priority (0..14) }
                PSCode: 0..255;                 { Special code for PutStatus }
                GSCode: 0..255;                 { Special code for GetStatus }
                Name: packed array[0..3] of char
            end;

Const           { RS-232 Speeds }
        RS9600 = 1;
        RS4800 = 2;
        RS2400 = 4;
        RS1200 = 8;
        RS600 = 16;
        RS300 = 32;
        RS150 = 64;
        RS110 = 87;
        
Type
        Z80Readings = packed record       { Z80 Voltage/Temp Monitor Readings }
                Ground: integer;
                Volts5: integer;
                Volts12: integer;
                Minus12: integer;
                VRef: integer;
                Net: integer;
                CRTemp: integer;
                BaseTemp: integer;
                Volts55: integer;
                Volts24: integer
            end;
            
        Z80Settings = packed record     { Z80 Voltage/Temp Monitor Settings }
                MinGround: integer;
                MaxGround: integer;
                Min5: integer;
                Max5: integer;
                Min12: integer;
                Max12: integer;
                MinMinus12: integer;
                MaxMinus12: integer;
                MinVRef: integer;
                MaxVRef: integer;
                MinNet: integer;
                MaxNet: integer;
                MinCRTemp: integer;
                MaxCRTemp: integer;
                MinBaseTemp: integer;
                MaxBaseTemp: integer;
                Min55: integer;
                Max55: integer;
                Min24: integer;
                Max24: integer
            end;
        
        

        DevStatusBlock = packed record
                ByteCnt: integer;       { # of status bytes }
                case UnitRng of
                    KeyBoard,
                    Tablet,
{$ifc Ether3MBaud then}
                    Ether3,
{$endc}
                    Clock: (DevEnable: boolean);
                    
                    RS232In,
                    RS232Out: (RSRcvEnable: boolean;
                               RSFill: 0..127;
                               RSSpeed: 0..255;
                               RSParity: (NoParity, OddParity, IllegParity,
                                          EvenParity);
                               RSStopBits: (Syncr,Stop1,Stop1x5,Stop2);
                               RSXmitBits: (Send5,Send7,Send6,Send8);
                               RSRcvBits: (Rcv5,Rcv7,Rcv6,Rcv8));
                    Z80Monitor: (Z80Enable: boolean;
                                 Z80Fill: 0..32767;
                                 case boolean of { Get or Put; true = Get }
                                   true: (       { Get Status }
                                          GetRead: Z80Readings;
                                          GetLimits: Z80Settings
                                         );
                                   false:(      { Put Status }
                                          PutLimits: Z80Settings
                                         ));
                    Floppy: (case integer of { Get or Put }
                              1: (           { Get Status }
                                  FlpUnit: 0..3;
                                  FlpHead: 0..1;
                                  FlpNotReady: boolean;
                                  FlpEquipChk: boolean;
                                  FlpSeekEnd: boolean;
                                  FlpIntrCode: 0..3;
                                 case integer of
                                  1 {IORead, IOWrite, IOFormat}:
                                   (FlpMissAddr: boolean; { in data or header }
                                    FlpNotWritable: boolean;
                                    FlpNoData: boolean;
                                    FlpFill1: 0..1;
                                    FlpOverrun: boolean;
                                    FlpDataError: boolean; { in data or header }
                                    FlpFill2: 0..1;
                                    FlpEndCylinder: boolean;
                                    FlpDataMissAddr: boolean; { in data }
                                    FlpBadCylinder: boolean;
                                    FlpFill3: 0..3;
                                    FlpWrongCylinder: boolean;
                                    FlpDataDataError: boolean; { in data }
                                    FlpFill4: 0..3;
                                    FlpCylinderByte:   0..255;
                                    FlpHeadByte:       0..255;
                                    FlpSectorByte:     0..255;
                                    FlpSizeSectorByte: 0..255
                                   );
                                  2 {IOSeek}:
                                   (FlpPresentCylinder: 0..255
                                   )
                                  );
                              2: (           { Put Status }
                                  FlpDensity: 0..255; { single = 0,
                                                        double = #100 }
                                  FlpHeads: 0..255;   { 1 or 2 heads }
                                  FlpEnable: boolean
                                 );
                              3: (           { Byte access }
                                  FlpByte1: 0..255;
                                  FlpByte2: 0..255;
                                  FlpByte3: 0..255;
                                  FlpByte4: 0..255;
                                  FlpByte5: 0..255;
                                  FlpByte6: 0..255;
                                  FlpByte7: 0..255
                                 )
                            )
                end;


Type
    IOCommands = (IOReset, IORead, IOWrite, IOSeek, IOFormat,
                  IODiagRead, IOWriteFirst, IOIdle, IOWriteEOI, IOConfigure);


Var
        DevTab: DevTabPtr;              { pointer to system device table }
        CtrlSPending: boolean;          { if ^S has halted screen output }
        IOInProgress: boolean;          { false when speech is active }
        IO24MByte: boolean;             { true if the disk is 24 MBytes }
        


Function IOCRead(Unit: UnitRng; var Ch: char): integer;
                                            { read a character from a }
                                            { character device and return }
                                            { status: IOB no char available }
                                            {         IOC character returned }
Function IOCWrite(Unit: UnitRng; Ch: char): integer;
                                            { write Ch to character device }
                                            { and return status:           }
                                            {       IOB buffer full        }
                                            {       IOC character sent     }

                  
Procedure UnitIO(Unit: UnitRng;                 { IO to block structured }
                 Bufr: IOBufPtr;                { devices }
                 Command: IOCommands;
                 ByteCnt: integer;
                 LogAdr: double;
                 HdPtr: IOHeadPtr;
                 StsPtr: IOStatPtr);

Procedure IOWait(var Stats: IOStatus);          { hang until I/O completes }
Function IOBusy(var Stats: IOStatus): boolean;  { true if I/O not complete }
Procedure IOPutStatus(Unit: UnitRng; var StatBlk: DevStatusBlock);
                                            { Set status on device Unit }
Procedure IOGetStatus(Unit: UnitRng; var StatBlk: DevStatusBlock);
                                            { Reads status on device Unit }
Procedure IOBeep;                           { You guessed it, BEEP! }


{$ifc Ether3MBaud then}
Function Ether3Transmit(Buff: IOBufPtr; WdCnt: integer) : integer;

Function Ether3Receive(Buff: IOBufPtr; var WdCnt: integer; timeout: integer)
                      : integer;

Function Ether3Start(Promiscuous, Restart: boolean) : integer;
{$endc}


        


{*******************************}   Private   {*****************************}
