Module IO_Private;
{-----------------------------------------------------------------------------
{
{ IO_Private - IO system private definitions and interrupt routines.
{ Miles A. Barel  ca. 1 Jan 80.
{ Copyright (C) 1980, Three Rivers Computer Corporation
{
{ Abstract:
{       IO_Private exports interrupt routines and definitions which are private
{       to the modules which make up the IO system.
{
{ Design:
{       Interrupt routines must *never* cause segment faults.
{
{-----------------------------------------------------------------------------}

{ 
   2 Dec-81  BAM  V5.9  Added Help switch.
  16-Nov-81  DAS  V5.8  (JPS) Put in John's changes for megabyte memory.

   4-Nov-81  DAS  V5.8  Fixed for 10 MBaud Ethernet.

  25-Jun-81  JPS  V5.7  Get rid of EnTabUpdate and EnCurUpdate since they
                        didn't work anyway.

   4-Jun-81  JPS  V5.6  Fix Beep when type ahead too far (for the last time
                        I hope).

   3-Jun-81  JPS  V5.5  Add Virgil headers and comments.

  23-May-81  JPS  V5.4  Use new IOKeyDisable/IOKeyEnable in place of old
                        DisCtlC/EnaCtlC.  Reinstate Beep when type ahead too
                        far.

  22-May-81  JPS  V5.3  Fix control-c processing.  Remove Beep when type
                        ahead too far.
  
  16-Apr-81  GGR  V5.2  Add 3MHz Ethernet Drivers (JEB)
  
  31-Mar-81  GGR  V5.1  Added 4-button mouse support.
  
  11-May-81  JPS  V5.0  Split IO into several modules.
  
   6-May-81  JPS  V4.7  1. Use new form of the SetCylinder StartIO.
                        2. Don't bother doing 10 trys in FindSize since only
                           the last result was believed regardless of success
                           or failure.
                        3. Hang if we cannot figure out the size of the disk.
  
  11-Apr-81  JPS  V4.6  Changes for virtual memory.
  
  19-Mar-81  BAM  V4.5  Changed name of included modules to IO_Init and IO_Proc
  
   3-Mar-81  JPS  V4.4  1) Fix LocateDskHeads and FindSize to agree with V4.3.
                        2) Teach the HardDisk timeout code about multi-sector
                           operations.

  28-Feb-81  JPS  V4.3  No longer do conversions on Disk Physical block
                        numbers (reinstating changes made in V4.0).

  25-Feb-81  GGR  V4.2  Added setting/reading of DskFill1 in UnitIO.
                        Moved new/dispose of CB from UnitIO to IO.Init.

  16-Feb-81  BAM  V4.1  Put back in conversions on Disk Physical block
                        numbers; fixed botCursF bug.  Del XXX procedures;
                        Changed to use new screen
  
   9-Feb-81  BAM  V4.0  No longer does conversions on Disk Physical block
                        numbers; fixed CursorUpdate to allow partial screen
                        display and added procedure IOScreenSize to set a 
                        new size.
  
  13-Jan-81  JPS  V3.3  Move creation of the IOSeg to memory manager init.
                        Move $R- to private part.

  20-Nov-80  JPS  V3.2  Initialize TabFifoInx in InitTablet.
  
  17-Nov-80  JPS  V3.1  Export the interrupt table.
                        Check SystemInitialized for control-C abort.
  
  16-Nov-80  BAM  V3.0  Radically changed Cursor and Tablet interface.  New
                        time procedures.  Split into another include file.
  
  10-Oct-80  JPS  V2.2  Added support for the diagnostic display (DDS).
 
  27-Sep-80  DAS  V2.1  Added timeout code to UnitIO for the
                        hard disk.
 

  19-Sep-80  DAS  V2.0  Added code for 24 MByte disks.
}

{*******************************}   Exports   {*****************************}




Imports SystemDefs from SystemDefs;
Imports IO_Unit from IO_Unit;
Imports IO_Others from IO_Others;
Imports Raster from Raster;



Const
        
        CirBufSize = #100-3;    { size of circular buffers - made so that }
                                { total size of CirularBuffer = #100 }
        
        DskBlockSize = 512;     { block sizes for fixed block size devices }
        FlpBlockSize = 128;     { Size is in BYTES }
        SpkBlockSize = 128;
        TabBlockSize = 8;
        Z80BlockSize = 20;
        GPIBBlockSize = 1;
        Last12Sector = 202 * 4 * 30 -1; {Tracks * Heads * Sectors.  0 start }
        
        DskPriority = 0;       { interrupt priorities }
        FlpPriority = 3;
        SpkPriority = 2;
{$ifc Ether3MBaud then}
        Ether3Priority = 12;
{$elsec}
{$ifc Ether10MBaud then}
        Ether10Priority = 12;
{$endc}
{$endc}
        GPIBInPriority = 11;
        GPIBOutPriority = 1;
        TabPriority = 10;
        KeyPriority = 5;
        RSIPriority = 6;
        RSOPriority = 7;
        Z80Priority = 8;
        PutPriority = 9;
        GetPriority = 4;
        
        PSFloppy = #14;           { Put Status Special Codes }
        PSGPIB = 0;
        PSZ80Monitor = #11;
        PSTablet = 6;
        PSKeyBoard = 7;
        PSRS232 = 5;
        PSClock = #12;
        
        GSFloppy = #40;           { Get Status Special Codes }
        GSGPIB = #100;
        GSZ80Monitor = #10;
        GSTablet = #2;
        GSKeyBoard = #4;
        GSRS232 = #1;
        GSClock = #20;
        
        DisCst0 = #1154;     { consts to terminate Display List; add in funct }
        DisCst1 = #1351;
        MinCurY = 0;           { Minimum Y value for cursor }
        MaxCurY = 1023;        { Maximum Y value for cursor }
        SegSize = 128;         { # lines / display segment }
        CrsHeight = 64;        { Height of the cursor }
        CrsConst0 = #370;      { constants to compute funny X position }
        VisOnly = #2000;       { mode bits - Visual screen only }
        VisAndCur = #2400;     { visual screen and cursor }
        Map = #100000;         { cursor map function }
        
        
        CtrlC = chr(#3);
        CtrlS = chr(#23);
        CtrlQ = chr(#21);
        BlamCh = Chr(#303);      { untranslated shift-control-C }
        DumpCh = Chr(#304);      { untranslated shift-control-D }
        
{$ifc Ether3MBaud then}
        E3TIntEnable = #4;     { Ether3 constants }
        E3TDone = #2000;
        E3TError = #4000;
        E3TGo = #10;
        E3RIntEnable = #1;
        E3RDone = #400;
        E3RPromiscuous = #20;
        E3RError = #1000;
        E3RGo = #2;
        E3XmtMask = E3TDone + E3TError + E3TGo;
        E3XmtSucc = E3TDone + E3TGo;
        E3RecMask = E3RDone + E3RError + E3RGo;
        E3RecSucc = E3RDone + E3RGo;
        
        PackBuffLen = 511;
        E3RecCount = PackBuffLen - 4;
        MAXE3RECERRS = 20;
{$endc}
        
Type
        IOPtrKludge = record case integer of
                        1: (Buffer: IOBufPtr);
                        2: (Offset: Integer;
                            Segment: Integer)
                        end;
                        
{$ifc Ether3MBaud then}
        EtherBuff = array [0..PackBuffLen] of integer;
        pEtherBuff = ^EtherBuff;
{$endc}
        
        CirBufPtr = ^ CircularBuffer;
        CBType = (KDBType, RSIType, RSOType, StdType);{ types of circular bufs }
        CirBufItem = packed record      { what we put in circular buffers }
                ch: char;               { the character }
                case CBType of          { and device specific condition bits }
                    KDBType: (KDBUnused: 0..63;
                              KDBOverrun: boolean;      { true = overrun }
                              KDBError: boolean);       { OR of all error bits }
                    RSIType: (RSIUnused: 0..7;
                              RSIBreak: boolean;        { true=break received }
                              RSIModem: boolean;        { true=modem change }
                              RSIParErr: boolean;       { true=parity error }
                              RSIOverrun: boolean;      { true=overrun error }
                              RSIError: boolean);       { OR of all error bits }
                    RSOType: (RSOUnused: 0..255);
                    StdType: (StdHiByte: 0..255)
                end;
        
        
        CircularBuffer = packed record  { circular buffer used for character }
                                        { devices, SpGetCir and SpPutCir }
                Length: integer;        { # chars in the buffer }
                RdPtr: integer;         { where to get chrs out }
                WrPtr: integer;         { where to put them in }
                Buffer: packed array[0..CirBufSize-1] of CirBufItem
                                        { last, the buffer }
            end;

        TabBufPtr = ^TabletBuffer;
        TabletBuffer = packed record    { buffer used for tablet, clock and }
                TabX: 0..#77777;        { Z80 Monitor Info }
                TabSwitch: boolean;
                TabY: 0..#77777;
                Fill: 0..1;
                ClkTime: double;
                Z80Mon: Z80Readings
            end;

        DispPtr = ^DisplayFile;
        DisplayFile = array[0..11] of
                packed record case boolean of
                    true: (int: integer);
                    false:(LineCount: 0..127;
                           StartOver: boolean;
                           ShowCursor: boolean;
                           VerticalRetrace: boolean;
                           ShowScreen: boolean;
                           DisableMicroInterrupt: boolean;
                           WriteBadParity: boolean;
                           Map: (CursOnly, CCursOnly, Compl, ComplInv,
                                 Normal, Invert, CursComp, InvCursCompl))
                end;
        
        ScrCtlPtr = ^ ScrCtlBlock;
        ScrCtlBlock = packed record
                Cmd: DispPtr;
                ScreenBase: Integer;
                CursorBase: Integer;
                Unused1: Integer;
                Unused2: Integer;
                CursX: integer;
                filler: integer
            end;
        
Const
        DskSPC = 30;            { Sectors Per Cynlinder }
        DskHds = 8;             { Max number of dsk heads }
        DskExHds = 0;           { Extra heads not in use }
        DskCyls = 202;          { Number of cylinders }
        FlpUnits = 4;           { 0 is the only valid unit }
        FlpSPC = 26;            { numbered 1 to 26 }
        FlpHds = 2;             { numbered 0 to 1 }
        FlpCyls = 77;           { numbered 0 to 77, 0 should not be used }
        
        TabAverage = 4;         { number of tablet points to average }
                                { this MUST be 4 }
        TabIgnore = 2;          { number of points to ignore when finger is }
                                { picked up or put down }
        TabFifoLen = TabAverage + TabIgnore;
        TabFifoMax = TabFifoLen - 1;
        GPIBxFudge = 38;        { actual range in X and Y for BitPad: 0..2200 }
        GPIByFudge = 1061;      { of TX and TY: 0..1100 }
                                { of TabAbsX: 0..1100 }
                                { of TabAbsY: 0..1100 }
                                { of TabRelX: -38..1062   limited to 0..767 }
                                { of TabRelY: 1061..-39   limited to 1023..0 }
        STopY = 0;
        SLeftX = 0;
        SRightX = 767;
        

Type
        DskCmds = (DskIdle, DskRdCheck, DskDiagRead, DskWrCheck,
                   DskWrFirst, DskFormat, DskSeek, DskClear);
                   
{$ifc Ether3MBaud then}
        Ether3Cmds = (E3Rset, E3Status, E3Receive,
                      E3PromiscReceive, E3Transmit);
{$endc}

        FlpCmds = (FlpUnUsed, FlpRead, FlpWrite, FlpFormat, FlpSeek, FlpReset);
        
        GPIBCmds = (GPIBNop, GPIBWrite, GPIBWrEOI, GPIBCntl);
        
                   { Types of block devices }
        IOCBType = (DskType, FlpType, SpkType, GPIBType,
{$ifc Ether3MBaud then}
                                                         Ether3Type,
{$endc}
                    GenType);


        IOCBPtr = ^IOCB;
        IOCB = packed record { IOCBs must be 8 word aligned }
                Buffer: IOBufPtr; { data buffer for transaction }
                case IOCBType of
                    DskType:
                      ( DskCommand: 0..255;
                        DskNumSect: 0..255;
                       (* NEW FS [*)
                        DskAddr: Integer;
                       (* NEW FS *)
                       (* OLD FS [)
                        DskSector: 0..DskSPC-1;
                        DskHead: 0..DskHds+DskExHds-1;
                        DskCylinder: 0..DskCyls-1;
                       (* OLD FS *)
                        DskSerialNum: double;
                        DskLogBlk: integer;
                        DskFill1: integer;
                        DskNextAdr: double;
                        DskPrevAdr: double;
                        DskCntlError: ( OK,
                                        AddrsErr,       { address error }
                                        PHCRC,          { Physical Header CRC }
                                        LHSer,          { Logical Serial Wrong }
                                        LHLB,           { Logical Block Wrong }
                                        LHCRC,          { Logical Header CRC }
                                        DaCRC,          { Data CRC }
                                        Busy);
                        DskFill2: boolean;
                        DskTrackZero: boolean;
                        DskWriteFault: boolean;
                        DskSeekComplete: boolean;
                        DskDriveRead: boolean;
                        DskNextIOCB: IOCBPtr);
                    FlpType:
                      ( FlpUnit: 0..FlpUnits-1;
                        FlpHead: 0..FlpHds-1;
                        FlpFill1: 0..31;
                        FlpCylinder: 0..255 { 0..FlpCyls-1 };
                        FlpSector: 0..255 { 1..FlpSPC };
                        FlpCommand: 0..255 { FlpCmds };
                        FlpByteCnt: integer { 0..256 };
                        FlpFill2: array [4..11] of integer;
                        FlpResult: integer;     { Not yet defined }
                        FlpNextIOCB: IOCBPtr);
                    SpkType:
                      ( SpkFill0: 0..255;
                        SpkNumBufs: 0..255;
                        SpkFill1: array[3..11] of integer;
                        SpkFill2: 0..16383;
                        SpkAddrErr: boolean;
                        SpkError: boolean;
                        SpkNextIOCB: IOCBPtr);
                    GPIBType: 
                       (GPIBCommand: GPIBCmds;
                        GPIBF0: 0..63;
                        GPIBNumBufs: 0..255;
                        GPIBByteCount: 0..255;
                        GPIBF1: array [4..11] of integer;
                        GPIBResult: integer; {Not Implemented}
                        GPIBNextIOCB: IOCBPtr);
{$ifc Ether3MBaud then}
                    Ether3Type:
                      ( Ether3Cmd: integer;
                        Ether3Delay: integer;
                        Ether3WdCnt: integer;
                        Ether3Status: integer;
                        Ether3NextIOCB: IOCBPtr );
{$endc}
                    GenType:    { General Purpose entry }
                      ( GenCmd: 0..255;
                        NumBlks: 0..255;
                        GenFill0: array[3..11] of integer;
                        Result: integer;
                        NextIOCB: IOCBPtr)
            end { IOCB };
                
Var
        KRBuf,                          { Keyboard Raw Buffer }
        KTBuf,                          { Keyboard translated buffer }
        RSIBuf,                         { RS-232 In Buffer }
        RSOBuf: CirBufPtr;              { RS-232 Out Buffer }
        TabBuf: TabBufPtr;              { Tablet/Clock Buffer }
        ScrBuf: ScrCtlPtr;              { Screen control blocks }
        DisFile0,DisFile1: DispPtr;     { Screen Display lists - double bufrs }
        OldCurY,                        { previous Cursor Y position }
        OldCurX: integer;               { previous Cursor X position MOD 8 }
        Cursor: CurPatPtr;              { Cursor Pattern }
        CursorX, CursorY: integer;      { new cursor coordinates }
        PointX, PointY: integer;        { the point of the cursor }
        TabFifo: array[0..TabFifoMax] of
                  record X,Y: integer end;  { fifo of tablet points }
        TabFifoInx: integer;            { index into tablet fifo }
        TabCount: integer;              { counter for ignoring tablet points }
        SumX, SumY: integer;            { sum of 4 points for averaging }
        FlpLastCylinder: integer;       { last cylinder referenced }
        FlpLastHead: integer;           { last head referenced }
        GPIBTabletState: integer;       { GPIB tablet current state }
        GPIBxTablet, GPIByTablet: integer;  { GPIB tablet coordinates }
        GPIBInBuf: CirBufPtr;           { GPIB input buffer }
        StanleyTablet: boolean;         { if Stanley tablet is enabled }
        CurDskHds: integer;             { number of heads on this disk.  4 or 8}
        CursF: integer;                 { function currently in use}
        BotCursF: integer;              { function for area below used area}
        BotComplemented: boolean;       { whether bot is complemented or not}
        SBottomY: integer;              { bottom of displayed area }
        TabMode: TabletMode;            { Current mode of the tablet }
        CCursMode: CursMode;            { Current mode of cursor }
        newFunct: Boolean;              { Tells when have a new function to
                                          insure that cursor redisplayed }        
        CB : IOCBPtr;                   { Pointer to IOCB used by UnitIO }



Type
        IntTabPtr = ^IntVecTable;
        IntVecTable = array [0..MaxUnit-FakeUnits] of
                        record                 { NO Fake Units Included Here! }
                            SSN: integer;
                            GPtr: integer;
                            Rtn: 0..255;
                            SLink: integer
                        end;

Var
        IntTab: IntTabPtr;              { pointer to interrupt vector table }
        IOPriv1Unused: boolean;         { ***** Unused ***** }
        IOPriv2Unused: boolean;         { ***** Unused ***** }
        KeyEnable: boolean;             { if keyboard interrupts are enabled }


{$ifc Ether3MBaud then}
Var     etherCB: IOCBPtr;               { Pointer to IOCB used by Ethernet }
        pEBuff: IOBufPtr;               { Pointer to Ethernet IO buffer }
        
        E3Restart,                      { Ether3 state }
        E3IsPromiscuous,
        E3InProgress,
        E3IsReceiving: boolean;
        E3RecErrs: integer;
{$endc}



  { interrupt routines: }
  
  Procedure DiskIntr;     { hard disk }

  Procedure FloppyIntr;   { floppy disk }

  Procedure SpeechIntr;   { speech out }

  Procedure GPIBOutIntr;  { GPIB out }

  Procedure GPIBInIntr;   { GPIB in }

  Procedure TabIntr;      { tablet (actually video retrace }

  Procedure Z80Intr;      { Z80 monitor }

  Procedure KeyIntr;      { keyboard }

  Procedure RSIIntr;      { RS232 in }

  Procedure RSOIntr;      { RS232 out }

  Procedure PutIntr;      { PutStatus completion }

  Procedure GetIntr;      { GetStatus completion }

{$ifc Ether3MBaud then}
  Procedure Ether3Intr;   { 3 MBaud EtherNet completion }
  Function E3Reset: integer;
  Procedure E3RecStart;
{$endc}


{*******************************}   Private   {*****************************}
