Module IO_Others;
{-----------------------------------------------------------------------------
{
{ IO_Others - Miscellaneous IO routines.
{ Miles A. Barel  ca. 1 Jan 80.
{ Copyright (C) 1980, Three Rivers Computer Corporation
{
{ Abstract:
{       IO_Others exports routines for the Cursor, Table, Screen, Time, and
{       Keyboard.
{
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------
{  Change Log:
{
  28 Jan 82  WJH  V5.7  increment ErrorCnt in IOSetModeTablet

  22 Dec 81  WJH  V5.6  fix IOGetTime for calls while booting
  
  25-Jun-81  JPS  V5.5  Add new TabletMode: offTablet which disables the
                        tablet.  Make all other TabletModes enable it.
                        Get rid of EnTabUpdate and EnCurUpdate--go back to
                        disabling and enabling interrupts during tablet and
                        cursor code.  This means that loading and reading the
                        cursor pattern must use IncIOCount to ensure that the
                        client's segment is swapped in.

   4-Jun-81  JPS  V5.4  Export new IOKeyClear procedure.

   3-Jun-81  JPS  V5.3  Add Virgil headers and comments.

  23-May-81  JPS  V5.2  Replace enable/disable of control-c processing
                        (exported by System) with enable/disable of KeyBoard
                        interrupts (exported by IO_Others).
  
  31-Mar-81  GGR  V5.1  Added 4-button mouse support.

  11-May-81  JPS  V5.0  Split IO into several modules.
                        Removed IOSetTime procedure
  
   6-May-81  JPS  V4.7  1. Use new form of the SetCylinder StartIO.
                        2. Don't bother doing 10 trys in FindSize since only
                           the last result was believed regardless of success
                           or failure.
                        3. Hang if we cannot figure out the size of the disk.
  
  11-Apr-81  JPS  V4.6  Changes for virtual memory.
  
  19-Mar-81  BAM  V4.5  Changed name of included modules to IO_Init and IO_Proc
  
   3-Mar-81  JPS  V4.4  1) Fix LocateDskHeads and FindSize to agree with V4.3.
                        2) Teach the HardDisk timeout code about multi-sector
                           operations.

  28-Feb-81  JPS  V4.3  No longer do conversions on Disk Physical block
                        numbers (reinstating changes made in V4.0).

  25-Feb-81  GGR  V4.2  Added setting/reading of DskFill1 in UnitIO.
                        Moved new/dispose of CB from UnitIO to IO.Init.

  16-Feb-81  BAM  V4.1  Put back in conversions on Disk Physical block
                        numbers; fixed botCursF bug.  Del XXX procedures;
                        Changed to use new screen
  
   9-Feb-81  BAM  V4.0  No longer does conversions on Disk Physical block
                        numbers; fixed CursorUpdate to allow partial screen
                        display and added procedure IOScreenSize to set a 
                        new size.
  
  13-Jan-81  JPS  V3.3  Move creation of the IOSeg to memory manager init.
                        Move $R- to private part.

  20-Nov-80  JPS  V3.2  Initialize TabFifoInx in InitTablet.
  
  17-Nov-80  JPS  V3.1  Export the interrupt table.
                        Check SystemInitialized for control-C abort.
  
  16-Nov-80  BAM  V3.0  Radically changed Cursor and Tablet interface.  New
                        time procedures.  Split into another include file.
  
  10-Oct-80  JPS  V2.2  Added support for the diagnostic display (DDS).
 
  27-Sep-80  DAS  V2.1  Added timeout code to UnitIO for the
                        hard disk.
 

  19-Sep-80  DAS  V2.0  Added code for 24 MByte disks.

{-----------------------------------------------------------------------------}

{*******************************}   Exports   {*****************************}



Imports SystemDefs from SystemDefs; 



{ tablet/cursor procedures }

Type    CursFunction = (CTWhite, CTCursorOnly, CTBlackHole, CTInvBlackHole,
                        CTNormal, CTInvert, CTCursCompl, CTInvCursCompl);
        TabletMode = (relTablet, scrAbsTablet, tabAbsTablet, offTablet);
        CursMode = (OffCursor, TrackCursor, IndepCursor);
        CursorPattern = array[0..63,0..3] of integer;
        CurPatPtr = ^CursorPattern;


Var     TabRelX, TabRelY: integer;      { tablet relative coordinates }
        TabAbsX, TabAbsY: integer;      { tablet absolute coordinates }
        TabFinger: boolean;             { finger on tablet }
        TabSwitch: boolean;             { switch pushed down }
        TabWhite   : boolean;       { True if white button down }
        TabGreen   : boolean;       { True if green button down }
        TabBlue    : boolean;       { True if blue button down }
        TabYellow  : boolean;       { True if yellow button down }
        TabMouse   : integer;       { Actual output from mouse }
        DefaultCursor: CurPatPtr;       { default cursor pattern }

Procedure IOLoadCursor(Pat: CurPatPtr; pX, pY: integer);
                                                { load user cursor pattern }

Procedure IOReadTablet(var tabX, tabY: integer); { read tablet coordinates }

Procedure IOSetFunction(f: CursFunction);

Procedure IOSetModeTablet(m: TabletMode); { set the mode to tell what kind of
                                           tablet is currently in use }

Procedure IOCursorMode (m: CursMode); { if track is true, then Tablet
                                            coordinates are copied every 1/60th
                                            second into the cursor position. if
                                            indep, then coordinates are changed
                                            only by user.  If off, then no
                                            cursor displayed }

Procedure IOSetCursorPos(x,y: Integer); { if trackCursor is false, then sets
                                         cursor x and y pos.  If tracking, then
                                         sets both tablet and cursor. }

Procedure IOSetTabPos (x,y: Integer);  { if trackCursor is false, then sets
                                         tablet x and y pos.  If tracking, then
                                         sets both tablet and cursor }
                                         
Procedure IOReadCursPicture(pat: CurPatPtr; var px, py: integer);
                                        { copies current cursor picture into
                                          pat and sets px and py with the 
                                          offsets for the current cursor }



Procedure IOGetTime(var t: double);  { Get the double word 60 Hertz time }
        


{Procedure to change screen size}

Procedure IOScreenSize(newSize: integer; complement: Boolean);
                                        { newSize is number of scan lines in
                                          new screen; must be a multiple of 
                                          128. Complement tells whether the 
                                          rest of the screen should be the
                                          opposite color from the displayed
                                          part }

{ disable/enable keyboard interrupts }

Procedure IOKeyDisable( var OldKeyEnable: Boolean );

Procedure IOKeyEnable( OldKeyEnable: Boolean );

{ clear the IO type-ahead buffer }

Procedure IOKeyClear;


{*******************************}   Private   {*****************************}
