Module FileDir;
{-----------------------------------------------------------------------------
{
{ Abstract:
{
{ The directory structure for PERQ FileSystem
{ Written by:  CMU Spice Group
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------
  Versions:  
     V2.6  20-Apr-81  John Strait Use DiskSegment for allocation.
     V2.5   3-Apr-81  Brad Myers  Fixed bug when creating file with name that
                                   contains ..
     V2.4  30-Mar-81  Brad Myers  Changed name from SpiceDir
                                   Changed length of Default strings
     V2.3  26-Mar-81  Brad Myers  Added comments
     V2.2  19-Mar-81  Brad Myers  PERQ_String
     V2.1  11-Mar-81  Brad Myers  Fixed Get- Put-InDir so don't read filename
                                   if not inuse
     V2.0   9-Mar-81  Brad Myers  Changed directory syntax to dev:part>dir>fn
     V1.1   1-Mar-81  Brad Myers  Changed to smaller HASHFRAMESIZE and smaller
                                    entry size
     V1.0  ??-???-??  CMU people  Started
-----------------------------------------------------------------------------}

{************************}Exports{**********************************}

imports FileDefs from FileDefs;

function  GetFileID(name : PathName) : SegID;
function  PutFileID(var name : PathName; id : SegID) : boolean;
function  DeleteFileID(name : PathName) : SegID;
function  GetDisk(var name : PathName; var partition : integer) : boolean;

var
  DefaultPartitionName : SimpleName; {includes device name and ends in a ">" }
  DefaultDeviceName    : SimpleName; {ends in a colon}


{************************}Private{**********************************}
