module Except;
{-----------------------------------------------------------------------------
{
{ Except - Perq Pascal Exception Routines.
{ J. P. Strait   10 Dec 80.
{ Copyright (C) Three Rivers Computer Corporation, 1980.
{ 
{ Abstract:
{       Module Except provides the following things:
{
{       1) Definitions of the microcode generated exceptions.
{
{       2) A procedure to tell the microcode which segment number these
{          exceptions are defined in.
{
{       3) The default handler of all exceptions.  The compiler enables
{          this handler in every main program.
{
{       4) A Pascal routine to search the stack in when an exception is
{          raised.
{
{ Design:
{       The file Except.Dfs is included into Perq.Micro as well
{       as into this module.  It defines routine numbers for the exceptions
{       generated by the microcode.  Note that there must be agreement
{       between these constants and the routine numbers of the exception
{       definitions.  No program checks these--if you add or remove
{       exception definitions you must be sure to update Except.Dfs
{       in the appropriate way.
{
{       The routine number of RaiseP is also defined in Except.Dfs
{       as 0.  Since the microcode must know this, it is strongly
{       suggested that it not be modified.
{
{       The routine number of InitExceptions is not needed by the compiler
{       or Perq.Micro, but it has been assigned routine number 1 so that
{       its number will not change when new exceptions are defined.  This
{       means that new exceptions may be defined without requiring that the
{       operating system be re-linked.
{
{-----------------------------------------------------------------------------}

{-----------------------------------------------------------------------------
{ Change Log:
{
{ 28 Dec 81  V2.9  Michael R. Kristofic
{ Define RealDiv0 and Real2Int
{
{ 23 Dec 81  V2.8  Brad Myers
{ Fixed handler reraise bug
{
{ 20 Dec 81  V2.7  Michael R. Kristofic
{ Define  OverReal and UndeReal
{
{  3 Dec 81  V2.6  Brad Myers.
{ Export ExcSeg.
{ Make Handle All not handle Stack Overflow or SegFault.
{ }

{ 28 May 81  V2.5  Brad Myers.
{ Change name of STLate exception (so no conflict with Qcodes.dfs
{ }

{ 28 May 81  V2.4  John Strait.
{ Take out special test for InPmd (exception raised while in Scrounge).
{ This will be replaced by a handler of All exceptions in Scrounge.
{ }

{ 23 May 81  V2.3  John Strait.
{ Allow StackOverflow while in Scrounge (just like SegmentFault).
{ }

{ 18 May 81  V2.2  John Strait.
{ New exception for Long Integer overflow.
{ }

{ 12 May 81  V2.1  Brad A. Myers.
{ New IO imports.
{ }

{  5 May 81  V2.0  Brad A. Myers.
{ Added preliminary debugger.
{ }

{ 23 Mar 81  V1.2  J. P. Strait.
{ Add support for virtual memory.
{ }

{ 14 Mar 81  V1.1  J. P. Strait.
{ Add PMD and try to get it working.
{ }

{ 10 Dec 80  V1.0  J. P. Strait.
{ Start module as part of a proposal.
{ }
{-----------------------------------------------------------------------------}

exports


const ExceptVersion = '2.9';


procedure RaiseP( ES, ER, PStart, PEnd: Integer );
procedure InitExceptions;

exception Abort( Message: String );
exception Dump( Message: String );
exception XSegmentFault( S1,S2,S3,S4: Integer );  { segment fault }
exception XStackOverflow;                         { stack overflow }
exception DivZero;   { division by zero }
exception MulOvfl;   { overflow in multiplication }
exception StrIndx;   { string index out of range }
exception StrLong;   { string to be assigned is too long }
exception InxCase;   { array index or case expression out of range }
exception STLATETooDeep; { parameter in STLATE instruction is too large }
exception UndfQcd;   { execution of an undefined Q-code }
exception UndfInt;   { undefined device interrupt detected }
exception IOSFlt;    { segment fault detected during I/O }
exception MParity;   { memory parity error }
exception EStack;    { E-stack wasn't empty at INCDDS }
exception OvflLI;    { Overflow in conversion to integer from Long Integer }
exception OverReal;  { floating point overflow }
exception UndeReal;  { floating point underflow }
exception RealDiv0;  { floating point division by zero }
exception Real2Int;  { floating point real to integer overflow }

var ExcSeg: Integer;

private
