module CFileDefs;
exports
imports AccentType from AccentType;
imports TimeDefs from TimeDefs;
type
LString =String[255];
pFirstBlock =^FirstBlock;
FirstBlock =
record
FileVersion :integer;
FileSize :long;
FileTimeStamp :Internal_Time;
SymbolAreaSize :long;
TextAreaSize :long;
DataAreaSize :long;
BSSAreaSize :long;
DestAddr :long;
StartAddr :long;
MainAddr :long;
InitialLocalSize :long;
StackBaseAddress :long;
StackSizeInPages :long;
end;
{$IFC (WORDSIZE(FirstBlock) > 256) THEN}
?Error:First block is too big!
{$ENDC}
const
CFileVersion =-4;
PrimaryDef =10;
PascalProcedure =1;
LocalProcedure =2;
GlobalProcedure =3;
InitializedSymbol =5;
LocalLabel =6;
UndefinedSymbol =7;
UndefinedGlobal =UndefinedSymbol;
DefinedGlobal =InitializedSymbol;
DefinedLocal =LocalLabel;
OffsetDef =11;
ChainHead =12;
AbsoluteDef =13;
AbsoluteLocalDef =14;
LibraryDef =90;
TextState =0;
DataState =1;
Data2State =2;
PCInText =TextState;
PCInData =DataState;
PCInData2 =Data2State;
OFFSETBASE =16000;
procedure PutPrimaryDef(var BytePtr :long;
SimKind :Bit8;
AreaDesg :Bit8;
AreaOffset :long;
SymSize :long;
SymName :LString);
procedure GetPrimaryDef(var BytePtr :long;
var SimKind :Bit8;
var AreaDesg :Bit8;
var AreaOffset :long;
var SymSize :long;
var SymName :LString);
procedure PutOffsetDef(var BytePtr :long;
WdOffsetAmt :long);
procedure GetOffsetDef(var BytePtr :long;
var WdOffsetAmt :long);
procedure PutChainHead(var BytePtr :long;
AreaDesg :Bit8;
ByteAreaOff :long);
procedure GetChainHead(var BytePtr :long;
var AreaDesg :Bit8;
var ByteAreaOff :long);
procedure PutAbsoluteDef(var BytePtr :long;
ByteAddress :long;
Name :LString);
procedure GetAbsoluteDef(var BytePtr :long;
var ByteAddress :long;
var Name :LString);
procedure PutAbsoluteLocalDef(var BytePtr :long;
ByteAddress :long;
Name :LString);
procedure GetAbsoluteLocalDef(var BytePtr :long;
var ByteAddress :long;
var Name :LString);
procedure PutLibraryDef(var BytePtr :long;
LibraryFileName :LString;
LibraryTimeStamp :Internal_Time;
LibraryLoc :long);
procedure GetLibraryDef(var BytePtr :long;
var LibraryFileName :LString;
var LibraryTimeStamp :Internal_Time;
var LibraryLoc :long);
function ByteSizeOfAbsoluteSymbol(var sym:string):long;
function ByteSizeOfAbsoluteLocalSymbol(var sym:string):long;
function ByteSizeOfLibrarySymbol(var libname:string):long;
function SegmentOf(Addr:long):integer;
function SegBaseAddr(Segnum:integer):long;
procedure RoundTo(var Value:long;Boundary:integer);
function GetCodeByte(var ByteAddr :long):Bit8;
procedure SetCodeByte(var ByteAddr :long;NewValue:Bit8);
function GetCodeWord(var ByteAddr :long):integer;
procedure SetCodeWord(var ByteAddr :long;NewValue:integer);
function GetAsmlong(var ByteAddr :long):long;
procedure SetCodelong(var ByteAddr :long;NewValue:long);
procedure SetDataLong(var ByteAddr :long;NewValue:long);
procedure SetAsmLong(var ByteAddr :long;NewValue:long);
function GetAsmString(var ByteAddr :long):LString;
procedure SetAsmString(var ByteAddr :long;NewValue:LString);
function KOEName(x:Bit8):string;
function PCStateName(x:Bit8):string;
function SECName(x:Bit8):string;
private
 { Stub created by MakeStub at15-Feb-84  17:22:40 }
begin
end.
