using System;
using System.Collections.Generic;
using System.Text;

namespace PERQDisk
{
    /// <summary>
    /// Helper functions that are used in various places in the code...
    /// </summary>
    public class Helper
    {
        public static byte ReadByte(byte[] data, int offset)
        {            
            return data[offset];
        }

        public static ushort ReadWord(byte[] data, int offset)
        {            
            return (ushort)(data[offset] | (data[offset + 1] << 8));
        }

        public static uint ReadDWord(byte[] data, int offset)
        {            
            return (uint)(Helper.ReadWord(data, offset) | (Helper.ReadWord(data, offset + 2) << 16));
        }

        public static string ReadString(byte[] data, int offset, int count)
        {            
            StringBuilder sb = new StringBuilder();

            for (int i = offset; i < offset + count; i++)
            {
                sb.Append((char)data[i]);
            }

            return sb.ToString();
        }
    }
}
