Page	60,132
Title	-Firmware Variable Definitions
;
;
;	Copyright (c) 1983
;	Zenith Data Systems
;	St. Joseph, Michigan
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 18_Jan_86
;
;
%Out	Var.asm
page
;----------------------------------------------------------------------
; Equates and Public Declarations
;--------------------------------
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing


; Include Files
;--------------
;	Rom.lit
;	Intr.lit
;	Sys.lit
;	Video.lit
;	Disk.lit
;	Keyboard.lit
;	Icon.lit
;	Calc.lit
;	Pequ.lit
;
	.xlist
	Include ..\Rom\Rom.lit
	Include ..\Rom\Intr.lit
	Include	..\Rom\Sys.lit
	Include	..\Video\Video.lit
	Include	..\Disk\Disk.lit
	Include	..\Io\Keyboard.lit
	Include	..\Icon\Icon.lit
	Include ..\Icon\Calc.lit
	Include ..\Icon\Pequ.lit
	.list
	page

	public	SERIAL_TABLE, PRINTER_TABLE, IO_CONFIG, EXT_TEST, MEMORY_SIZE
	public	SHIFT_STATUS, LOCK_STATUS, INPUT_VALUE, LAST_KEY, KEY_BUFF
	public	RECAL_STATUS, DRIVE_STATUS, DRIVE_MOTOR_COUNT, DISK_STATUS
	public	DISK, VIDEO_MODE, NUMBER_OF_COLUMNS, PAGE_SIZE, CRT_START_ADDRESS
	public	CURSOR_POSITION, CURSOR_STYLE, DISPLAYED_PAGE, VIDEO_BASE
	public	VIDEO_HW_MODE, CURRENT_COLORS, EXT_ROM_INIT, EXT_INTR_FLAG
	public	TOD, BREAK_FLAG, RESET_FLAG, PRINTER_TIME_OUT
	public	SERIAL_TIME_OUT, KEY_BUFF_START, KEY_BUFF_END, PRINT_SCREEN_STATUS
	public	SCROLL_MODE, CURRENT_PAGE, ROW_INCREMENT, COLUMN_INCREMENT
	public	NUMBER_OF_PAGES, PAGE_BASE, PAGE_START, DATA_SEGMENT
	public	START_OF_PAGE, END_OF_PAGE, BOOT_DRIVE, CURRENT_DRIVE
	public	EOI_FLAG, SCREEN, END_OF_PART, END_OF_SCREEN, BOOT_CODE
	public	BOOT_STRING
	public	System_Stack
	public	Stack_Top
	public	BUS_MEMORY_SIZE
	public	MANUFACTURING_BOOT
	public	Stack_Level
	public	Local_Stack_Top
	public	KEY_BUFF_SEGMENT, OLD_VIDEO_MODE, RETRY_COUNT
	public	WINCHESTER_CMD, WINCHESTER_STAT, WINCHESTER_STATUS
	public	WINCHESTER_DRIVES, WINCHESTER_CTRL, WINCHESTER_PORT_OFFSET
	public	FEED_KEY
	public	VIDEO_SEGMENT, CRT_CONTROL
	public	NO_BOOT_FLAG, OLD_DISPLAYED_PAGE, LAST_ROW, TEXT_SCREEN_MASK
	public	VIDEO_ACTIVE, SUPER_COMPATIBLE, DRIVE_COUNT, BUFF_8087
	public	OLD_COLUMNS, DISK_RETRIES, SS_SAVE, SP_SAVE, IP_SAVE
	public	DISK0_TURN_OFF_LIMIT, DISK1_TURN_OFF_LIMIT, FDC_POWER_FLAG
	public	Disk_Reset_Count, Disk_Turn_Off_Count, Disk_Use_Status

	public	CURSOR_FLAG
	public	CURSOR_PTR

	public	Irq_Mask_Save
	public	Nmi_AX_Save
	public	Nmi_BX_Save
	public	Nmi_CX_Save
	public	Nmi_DX_Save
	public	Nmi_SS_Save
	public	Nmi_SP_Save
	public	Nmi_Flags_Save

	public	Nmi_Return
	public	Nmi_IP_Save
	public	Nmi_CS_Save

	public	Nmi_Stack
	public	Nmi_PStack
	public	Nmi_PStack_Size

	public	LoBatt_Disp
	public	LoBatt_On_Cnt
	public	LoBatt_Off_Cnt
	public	NovRam_Stat
	public	Dcr_Save		;Display Control Register Save Value

	public	Clock_HdSec
	public	Clock_Second
	public	Clock_Minute
	public	Clock_Hour
	public	Clock_Day
	public	Clock_Month
	public	Clock_Year
	public	Clock_Last_Day
	public	Clock_Set_Flag

	public	Serial_Setup
	public	System_Setup
	public	Modem_Setup
	public	Mono_Exist		; True if Memory exists at B000:0
	public	Modem_Exist		; True if serial device at Com2
	public	Spiot			; copy of serial/parallel i/o table
	public	Big_Time_Ok		; Flag to suppress Time Display

	public	RTC_Compare		;reserved area for checking RAM & RTC
	public	NovRam_Setup		;Start of Setup Save Area
	public	N_System_Setup		;Saved system setup
	public	N_Serial_Setup		;Serial port setup
	public	N_Modem_Setup		;Saved modem setup
	public	N_Year			;Current year from setup
	public	N_Month			;Month machine turned on

	public	No_Task_Change		;Flag to DisAble Long Tasks
	public	Last_Task_ID		;Last Task's Id
	public	Current_Task_ID		;Current Task's Id
	public	Scr_Save_Base		;Base of Screen Area
	public	Current_State		;Base of the Current State Table
	public	SC_Task			;State Change -- Desired Task
	public	SC_State		;State Change -- Desired State

	public	Stk_LoBatt		;Nmi Stack Area Definitions
	public	Stk_Clock
	public	Stk_Phone
	public	Stk_Calc
	public	Stk_Alarm
	public	Stk_Alt_Clk

	public	Reg_Phone		;Nmi Register Save Areas
	public	Reg_Disk
	public	Reg_Calc

	public	Vid_LoBatt1		;Nmi Video Save Areas
	public	Vid_Phone
	public	Vid_Disk
	public	Vid_Calc
	public	Vid_Alarm

	public	DFlags
	public	Scan_Array
	public	Xor_Flag
	public	L_Edge
	public	xDot
	public	yDot

	public	Disp_Year
	public	Disp_Day
	public	Disp_Month
	public	Disp_Zone

	public	Skip_Dir		;last direction moved
	public	MOffset			;month offset  0 = sunday
	public	NmDays			;number of days in month
	public	Upd_Mode  		;function being updated
	public	Upd_Cmp			;compare value for reverse vid

	public	WinPos			;Global Calculator Variables
	public	DspIm
	public	vmode
	public	Calc_Ram

	public	MVLGH			;CalcMain Variables
	public	CST
	public	KOP
	public	TOP
	public  MFLAG
	public	DPFLAG
	public	NZFLAG
	public	CURPOS
	public	DIGCTR
	public	ENTFLG

	public	MRG
	public	DRG
	public	TRG
	public	KRG
	public	ERG
	public	RRG

	public	RG			;CalcMath Variables

	public	BAT1ST			;First location in battery RAM
	public	CHKSUM			;Checksum on battery RAM contents

	public	ALMTIME			;Time next alarm HiByte=hour,LoByte=min.
	public	ALMYR			;Year as offset from 1985 (i.e. 1986=1)
	public	ALMMD			;Month and day
	public	ALMPEND			;Alarm pending counter

	public	Check_Delay		;Time delay to limit NovRam access
	public	AREACD			;Current area code
	public	PREFIX			;Dial prefix up to 11 digit prefix
	public	CALTIM			;Call time (hrs, min, sec)
	public	REDIAL			;Re-dial number ( 64 char re-dial buffer)

	public	RAMTOP			;Pointer to first byte of stored data
	public	APP1ST			;Pointer to first appointment record

	public	RAMBOT			;Starting location of stored data
	public	Minute_Count		;counter for the Appointment Alarm

	public	Term_Col		; current screen col
	public	Term_Row		; current screen row
	public	Term_Attr		; attribute for screen
	public	Term_Port		; com1 / com2 port number
	public	Term_Carr		; hangup on carrier loss if true
	public	Term_Esc_Rcvd		; true if escape processing
	public	Term_Sbufp		; next store pointer
	public	Term_Rbufp		; next remove pointer
	public	Term_Bufc		; number of chars in buffer
	public	Term_Sbuf		; ring buffer for com chars
	public	Term_Sbufe		; end of ring buffer

	public	Old_Shift_Status	; used to check if Shift_Status changed

	public	Diag_Load_Addr		; Base of the Diagnostics Area


	public	page_map		;For software video paging


page
;======================================================================
Interrupt_Segment Segment At (00h)
;=================================
;

Interrupt_Segment EndS

page
;======================================================================
Rom_Data Segment At (40H)
;========================
;
			; Hardware configuration variables
Serial_Table		dw	4 Dup (?)	;Actual addrs of serial ports
Printer_Table		dw	4 Dup (?)	;Actual addrs of printers
IO_Config		dw	?		;Power-up I/O configuration
Ext_Test		db	?		;External test mode
Memory_Size		dw	?		;Memory size in K bytes
Bus_Memory_Size		dw	?		;Memory beyond first 64K

			; Compatible keyboard variables
Shift_Status		db	?		;Current shift status
Lock_Status		db	?		;Current locking-key status
Input_Value		db	?		;ALT-nnn code entry storage
Key_Buff		KBuff	<>		;Keyboard buffer and pointers

			; Compatible disk variables
Recal_Status		db	?		;Drive-recalibrated status
Drive_Status		db	?		;Motor-on status of drives
Drive_Motor_Count 	db	?		;Count-down timer for motor
Disk_Status		db	?		;Status of last disk I/O
Winchester_Cmd		equ	this Byte	;Winchester command string
Winchester_Stat		equ	this Byte	;Winchester status variables
Disk			Disk_Results <>		;Disk I/O results structure

			; Compatible video variables
Video_Mode		db	?		;Current CRT mode
Number_of_Columns	dw	?		;Width of screen in chars
Page_Size		dw	?		;Number of bytes/page
Crt_Start_Address	dw	?		;Current display start addr
Cursor_Position		dw	8 Dup (?) 	;Cursor posn for current card
Cursor_Style		dw	?		;Current cursor style
Displayed_Page		db	?		;Currently displayed page
Video_Base		dw	?		;Base addr of CRT controller
Video_HW_Mode		db	?		;Video hardware mode
Current_Colors		db	?		;Storage for color pallette

			; Pointer to external interface ROM
Ext_Rom_Init		dd	?		;External ROM init routine
Ext_Intr_Flag		db	?		;External ROM interrupt flag

			; System real-time clock variables
Tod			TIME	<>		;Current time-of-day

			; Break/Initialization flags
Break_Flag		db	?		;Break-in-progress flag
Reset_Flag		dw	?		;Software reset flag

			; Additional storage for winchester variables
Winchester_Status	db	?		;Winchester error status
Winchester_Drives	db	?		;Number of winchester drives
Winchester_Ctrl		db	?		;Control for winchester drives
Winchester_Port_Offset	db	?		;Offset of winchester controller

			; Parallel/Serial device driver timeouts
Printer_Time_Out	db	4 Dup (?)	;Timeouts for parallel ports
Serial_Time_Out		db	4 Dup (?)	;Timeouts for serial ports

Rom_Data	EndS

page
;======================================================================
Print_Screen_Seg Segment At (50h)
;================================
;
			; Print-Screen status byte
Print_Screen_Status	db	?		;Print screen status byte

Print_Screen_Seg	EndS

page
;======================================================================
Monitor_Segment Segment Word Public
;==================================
;	1) Extended system variables in monitor RAM
;
ZReserved1		db	?		;Reserved to keep compatible locations
Data_Segment		dw	?		;Current ROM data segment (can
						;be ROM_DATA or MONITOR_DATA)

			; Extended video display variables
Old_Video_Mode		db	?		;Old (current) video mode
Scroll_Mode		db	?		;Current scrolling mode
Current_Page		db	?		;Currently active (I/O) page
Row_Increment		dw	?		;Increment to next row
Column_Increment	dw	?		;Increment to next column

Number_of_Pages		db	?		;Number of pages possible
Page_Base		dw	9 Dup (?) 	;Base address of each page
Page_Start		dw	9 Dup (?) 	;Start addr of each page
Start_of_Page		dw	?		;Start addr of current page
End_of_Page		dw	?		;End address of current page

Cursor_Flag		db	?		;Flag - cursor enable/on ctrl
Cursor_Ptr		dw	?		;Pointer to cursor location
			db	?		;Save room here for compatibility
			db	2 Dup (?)	;Save space to preserve later addresses

Crt_Control		db	?		;Value written to CRT ctrl port
Video_Segment		dw	?		;Segment for video I/O
Old_Displayed_Page	db	?		;Old value of displayed page
Last_Row		db	?		;Last row number on screen
Text_Screen_Mask	dw	?		;Mask for screen page size
Video_Active		db	?		;Scroll-in-progress flag
Super_Compatible	db	?		;Ultra-compatible (slow) disp flag
Old_Columns		db	?		;Old number of columns for POKEs
Page_Map		db	8 dup(?)	;Page map for alpha video pages
			db	4 DUP (?)	;Room for future expansion

			; 8087 buffer
Buff_8087		dd	?		;Buffer for testing 8087 presence

			; Extended disk variables in monitor RAM
Drive_Count		db	?		;Number of floppy drives
Disk_Retries		db	?		;Maximum retries to perform
Retry_Count		db	?		;Number of disk retries
Current_Drive		db	?		;Drive currently 'on'
Boot_Drive		db	?		;Drive to boot from
Boot_String		db	?		;Boot string for mass storage
Disk0_Turn_Off_Limit	db	?		;Count of tics till power to drive 0 goes off
Disk1_Turn_Off_Limit	db	?		;Count of tics till power to drive 1 goes off
Disk_Turn_Off_Count	db	?		;Disk turn off counter
FDC_Power_Flag		db	?		;Floppy controller power flag
Disk_Reset_Count	db	?		;Reset count
Disk_Use_Status		db	?		;765 in use flag

			; Reserved Space -- Puts Key_buff_Ssegemnt at fixed Loc
ZReserved2		db	105 Dup (?)	;Pad to keyboard variables

			; Extended keyboard variables in monitor RAM
Key_Buff_Segment	dw	?		;Segment for keyboard buffer
Key_Buff_Start		dw	?		;Start offset of keybd buffer
Key_Buff_End		dw	?		;End offset of keybd buffer
Last_Key		db	?		;Last key entered
Eoi_Flag		db	?		;End-of-intr-sent flag
Feed_Key		db	?		;Feed key mode flag

			; Internal Monitor Stack
Stack_Level		db	?		;Stack recursion level counter
SP_SAVE			dw	?		;Monitor stack ptr save
SS_SAVE			dw	?		;Monitor stack segment save
IP_SAVE			dw	?		;Save buffer for return address
Local_Stack		dw	100 Dup (?)	;Internal monitor stack
Local_Stack_Top		equ	this Byte	;Top of monitor stack

			; Auto-boot disable flag
No_Boot_Flag		db	?		;TRUE = No Auto-Boot

			; Stack buffer
System_Stack		dw	100 Dup (?)	;System (monitor) stack buff
Stack_Top		equ	This Word

page
;----------------------------------------------------------------------
; Task Handeler (Nmi) Variables (7_Aug_85)
;-----------------------------------------
;
		dw	60 Dup (?)	;NMI stack
Nmi_Stack	Label	Near

Irq_Mask_Save	db	?		;Entry Value of the Interrupt Mask Byte
Nmi_AX_Save	dw	?		;Spot to save AX
Nmi_BX_Save	dw	?		;Spot to save BX
Nmi_CX_Save	dw	?		;Spot to save CX
Nmi_DX_Save	dw	?		;Spot to save DX
Nmi_SS_Save	dw	?		;Spot to save SS
Nmi_SP_Save	dw	?		;Spot to save SP
Nmi_Flags_Save	dw	?		;Spot to save Nmi flags


Nmi_Return Label Near
;--------------------
;	Code to return from Nmi
		db	?		;Space to assemble CLI/STI
		db	?		;Space for jump far
Nmi_IP_Save	dw	?		;IP for jump far
Nmi_CS_Save	dw	?		;CS for jump far


Current_Task_Id	db	?		;Integer: Task Currently Running
Last_Task_Id	db	?		;Integer: Last Task Run
SC_Task		db	?		;Byte:    State Change -- Desired Task
SC_State	db	?		;Byte:    State Change -- Desired State
No_Task_Change	db	?		;Boolean: Disable Nmi Task Changes
Scr_Save_Base	dw	?		;Segment Base of the Screen Save Area


Current_State Label Byte
;-----------------------
;
		db	?		;LoBatt2
		db	?		;Cursor
		db	?		;LoBatt1
		db	?		;EL_Panel
		db	?		;Clock
		db	?		;Phone
		db	?		;Disk
		db	?		;Calc
		db	?		;Ac_Changed            
		db	?		;Alarm
		db	?		;Alt_Clock
		db	?		;Alt_Phone
		db	?		;Alt_Disk
		page

;Task Stacks
;-----------
;
		dw	30 Dup (?)	;Stack for Low/Dead Battery
Stk_LoBatt	Label	Near
		dw	192 Dup (?)	;Stack for the Clock Icon
Stk_Clock	Label	Near
		dw	128 Dup (?)	;Stack for the Phone Icon
Stk_Phone	Label	Near
		dw	80 Dup (?)	;Stack for the Calculator Icon
Stk_Calc	Label	Near
		dw	30 Dup (?)	;Stack for Appointment Alarm
Stk_Alarm	Label	Near
		dw	50 Dup (?)	;Stack for Diagnostics
Stk_Alt_Clk	Label	Near
		page

; Register Save Area
;-------------------
;
Reg_Phone	db	(Size Reg_Block) dup (?)
Reg_Disk	db	(Size Reg_Block) dup (?)
Reg_Calc	db	(Size Reg_Block) dup (?)


; Video Parameter Save Area
;--------------------------
;
Vid_LoBatt1	db	(size Video_Param) dup (?)
Vid_Phone	db	(size Video_Param) dup (?)
Vid_Disk	db	(size Video_Param) dup (?)
Vid_Calc	db	(size Video_Param) dup (?)
Vid_Alarm	db	(size Video_Param) dup (?)

page
;----------------------------------------------------------------------
; Icon Data Area (7_Aug_85)
;--------------------------
;
		;Lo Battery Handeler and NovRam Control Variables
LoBatt_On_Cnt	db	?		;Lo_Batt1 is Counting Down in State 1
LoBatt_Off_Cnt	db	?		;Lo_Batt1 is Counting Down in State 2
LoBatt_Disp	db	?		;Lo_Batt1 Display is Active
NovRam_Stat	db	?		;NovRam/Rtc Read/Write Status (0=Rd)
Dcr_Save	db	?		;Display_Control_Register Value Save

Minute_Count	dw	?		;counter for the Appointment Alarm
Old_Shift_Status db	?		;Used to check Shift_Status
Check_Delay	db	?		;Time delay to limit NovRam accesses

Skip_Dir	db	?		;last direction moved
Upd_Mode  	db	?		;function being updated
Upd_Cmp		db	?		;compare value for reverse vid

		;Graphics Support Definitions
DFlags		db	?
Scan_Array	db	8 dup (?)	;temp storage for scan line data
Xor_Flag	db	?
L_Edge		dw	?
xDot		dw	?
yDot		dw	?

page
;----------------------------------------------------------------------
Diag_Load_Addr Label Word; (7_Aug_85)
;------------------------------------
;	1) This is the base of the Diagnostics Area. from here to the
;	   Nmi Stack is reserved for loading diagnostics from the 80c39.
;	2) All of the data following this label is wiped out when the
;	   diagnostics are loaded.
;

;----------------------------------------------------------------------
; World Map/Setup Data
;---------------------
;
Disp_Day	db	?
Disp_Month	db	?
Disp_Year	dw	?
Disp_Zone	db	?

Clock_HdSec	db	?		;1/100's of Seconds
Clock_Second 	db	?		;Seconds
Clock_Minute	db	?		;Minutes
Clock_Hour	db	?		;Hours
Clock_Day 	db	?		;Day
Clock_Month	db	?		;Month
Clock_Year	dw	?		;Year
Clock_Last_Day	db	?
Clock_Set_Flag	db	?

Serial_Setup 	dw	?
Modem_Setup 	dw	?
System_Setup	dw	?
Big_Time_Ok	db	?		;Flag to Suppress Big Time Display

Mono_Exist	db	?		; True if Memory exists at B000:0
Modem_Exist	db	?		; True if Serial device at com2
Spiot		db	3*4+2*8 dup(?)	; serial/parallel i/o table

		;Indices to Month data
MOffset		db	?		;month offset  0 = sunday
NmDays		db	?		;number of days in month

page
;----------------------------------------------------------------------
; Calculator Data Area (29_Apr_85)
;---------------------------------
;
		;Global Calculator Variables
WinPos		db	0		;Window Side Left (will get toggled)
DspIm		db	20 DUP(?)	;Display Image
VMode		db	?		;current video mode (REPLACE w/ EXEC's)

		;CalcMain Variables
MVLGH		db	?		;Memory Value Image Length
CST		dw	?		;Calculator State
KOP		db	?		;Constant Operation
TOP		db	?		;Temporary Operation
MFLAG		db	?		;Memory Value Displayed Flag
DPFLAG		db	?		;DP Entered
NZFLAG		db	?		;Non-Zero Digit Entered
CURPOS		db	?		;Cursor Position
DIGCTR		db	?		;Digit Counter
ENTFLG		db	?		;Entry Display Flag

MRG		Num	<,,>		;Memory Register
DRG		Num	<,,>		;Display Register
TRG		Num	<,,>		;Total Register
KRG		Num	<,,>		;Constant Register
ERG		Num	<,,>		;Temporary Register
RRG		Num	<,,>		;Round Register

		;CALCMATH VARIABLES
RG		db	2*L+4 DUP(?)	;Working Register

page
;----------------------------------------------------------------------
; Terminal Emulator Variables (22_May_85)
;----------------------------------------
;
Term_Col	db	?		; current screen col
Term_Row	db	?		; current screen row
Term_Attr	db	?		; attribute for screen
Term_Port	db	?		; com1 / com2 port number
Term_Carr	db	?		; hangup on carrier loss if true
Term_Esc_Rcvd	db	?		; true if escape processing

Term_Sbufp	dw	?		; next store pointer
Term_Rbufp	dw	?		; next remove pointer
Term_Bufc	dw	?		; number of chars in buffer

Term_Sbuf	db	256 dup (?)	; ring buffer for com chars
Term_Sbufe	db	?		; end of ring buffer

;---------------------------------------;
; Public		Battery_Low	;
; Battery_Low	dw	?		; Save Low Battery Starting Time
;					;
; Public		Battery_Dead	;
; Battery_Dead	dw	?		; Save Dead Battery Time
;					;
; Public		Battery_Flag	;
; Battery_Flag	db	?		;
;---------------------------------------;

page
;----------------------------------------------------------------------
; Morrow Hardware NMI Stack is located here
;------------------------------------------
;
Nmi_PStack_Size	equ	32
		org	(1000H-Nmi_PStack_Size)
Nmi_PStack	Label	Word
		db	Nmi_PStack_Size Dup(?)
Nmi_PStack_Top	equ	This Word

page
;----------------------------------------------------------------------
; NovRam -- Initialization and Clock Variables (29_Apr_85)
;---------------------------------------------------------
;
RTC_Compare	dw	4 Dup (?)	;reserved area for checking RAM & RTC

NovRam_Setup	Label	Byte		;Start of Setup Save Area
N_System_Setup	dw	?		;Saved system setup
N_Serial_Setup	dw	?		;Serial port setup
N_Modem_Setup	dw	?		;Saved modem setup
N_Year		dw	?		;Current year from setup
N_Month		db	?		;Month machine turned on

;----------------------------------------------------------------------
; NovRam -- Calculator Variables (29_Apr_85)
;-------------------------------------------
;
Calc_Ram	db	2*L+4 Dup (?)	;Beginning Of Calculator Ram Area


;======================================================================
PhNovRam Segment At (0F110h)
;===========================
;	1) Phone and Appointment Scheduler Variables
;	2) Use the routines RHOLE and RERASE to allocate and de-allocate from
;	   RAMBOT up to the end of battery RAM.
;
Bat1st Label Byte			;First location in battery RAM for Phone

ChkSum		db	?		;Checksum on battery RAM contents

AlmTime		dw	?		;Time next alarm Hi-Byte=hour,Lo-Byte=min.
AlmYr		db	?		;Year as offset from 1985 (i.e. 1986=1)
AlmMd		dw	?		;Month and day
AlmPend		db	?		;Alarm pending counter

AreaCd		db	4 DUP(?)	;Current area code
Prefix		db	11 DUP(?)	;Dial prefix up to 11 digit prefix
CalTim		db	3 DUP(?)	;Call time (hrs, min, sec)
ReDial		db	DILMAX+1 DUP(?)	;Re-dial number (64 char re-dial buffer)

RamTop		dw	?		; Pointer to first byte of stored data
App1st		dw	?		; Pointer to first appointment record

RamBot Label Byte			; Starting location of stored data

PhNovRam	EndS

page
;----------------------------------------------------------------------
; Pad to fill Code segment to start of ROM memory
;------------------------------------------------
;
Rom_Ofs		equ	Near Ptr (0FFFFh - Rom_Length + 1)

		org	Rom_Ofs		;Pad to bottom of ROM
		Public	Rom_Start

Rom_Start	equ	This Near	;Start of code in ROM


; Copyright message at start of ROM (1_Jul_85)
;---------------------------------------------
;	1) Be sure to keep 'ZDS' in the same place for compatibility
;	2) The second '20' has been inserted to keep the Zds debugger happy.
;
	extrn	Nmi_Interrupt:Near	;Morrow needs NMI vector at corresponding

	DB	'03/14/85'
	DD	Nmi_Interrupt		;offset to vector 2 (i.e. 0000:0008)

	DB	'ZDS CORP'
	DB	'20'					;Compatability Version #
	DB	VERSION/10+'0', VERSION MOD 10+'0' 	;Version #

Monitor_Segment EndS

page
;======================================================================
Mono_Segment Segment At (0B000h)
;===============================
;	1) Monochrome video RAM segment
;
Mono_Segment EndS


;======================================================================
Screen_Segment Segment At (0B800h)
;=================================
;	1) Color video RAM segment
;
Screen			db	(Screen_Bytes Shr 1) Dup (?)
End_of_Part		equ	$ - 1		;End of graphics partition

			db	(Screen_Bytes Shr 1) Dup (?)
End_of_Screen		equ	$ - 1		;End of screen RAM

Screen_Segment EndS

page
;======================================================================
Interrupt_Segment Segment At (00H)
;=================================
;	1) Disk Boot Buffer
;
		org	7C00h		;Absolute disk boot address
Boot_Code	equ	this Far	;Sector buffer for boot

Interrupt_Segment EndS


;======================================================================
Interrupt_Segment Segment At (00H)
;=================================
;	1) Manufacturing Boot Buffer
;
		   org	500h		;Start of manufacturing boot code
Manufacturing_Boot equ	this Far	;Manufacturing boot buffer

Interrupt_Segment EndS

		  End
 