	PAGE	,132
	TITLE	Z-150 Console Output Routines

;**********************************************************************
;
;                      -------------------------
;---------------------- Console Output Routines -----------------------
;                      -------------------------
;
;	       Copyright (C) 1983, by Zenith Data Systems
;
;**********************************************************************

MONITOR_SEGMENT SEGMENT WORD PUBLIC

	ASSUME	CS:MONITOR_SEGMENT, DS:ROM_DATA, ES:NOTHING

	INCLUDE ../ROM/ROM.LIT
	INCLUDE ../ROM/INTR.LIT
	INCLUDE ../VIDEO/VIDEO.LIT
	INCLUDE ../VIDEO/VIDEO.EXT
	INCLUDE ../SYS/SYS.EXT
	INCLUDE ../KEYBOARD/KEYBOARD.LIT
	INCLUDE ../KEYBOARD/KEYBOARD.EXT

	EXTRN	VIDEO_IO_INTERRUPT:NEAR, SCROLL_UP:NEAR, GET_KEY_BUFF:NEAR
	EXTRN	GET_CUR_POSN:NEAR, GET_KEY_STATUS:NEAR, COMMAND_LOOP:NEAR


;**********************************************************************
; DISP_DEC_WORD: (WORD)
;
;	Disp_Dec_Word displays a word as a decimal number, in
; ASCII digits on the console.  Leading zeros are suppressed.
;
; Input:
;	AX: Word value to be displayed
;
; Note: This routine uses a recursive algorithm to convert a number,
;	so it will use as much as DIGITS*3 levels of stack space.
;**********************************************************************
DISP_DEC_WORD PROC NEAR
	PUBLIC	DISP_DEC_WORD
DDW1:	PUSHREG	<AX,CX,DX>		;Save registers
	MOV	DX,0			;Extend number to a dword
	MOV	CX,10			;Divide current number by 10
	DIV	CX
	TEST	AX,AX			;Have we reached leading zeros yet?
	JZ	DDW2			;Yes - display M.S. digit
	CALL	DDW1			;No, display leading digits
DDW2:	MOV	AX,DX			;Get character in AX
	ADD	AL,'0'			;Convert character to decimal
	CALL	CONSOLE_OUTPUT		;Display a char of the number
	POPREG	<DX,CX,AX>		;Restore registers
	RET
DISP_DEC_WORD ENDP



;**********************************************************************
; DISP_HEX_POINTER: (POINTER)
;
;	Disp_Hex_Ptr displays the contents of a pointer in ASCII on
; the console.  The contents are displayed in the traditional segment:
; offset format, with leading zeros.
;
; Input:
;    ES:DI: Segment to be displayed.
;**********************************************************************
DISP_HEX_POINTER PROC NEAR
	PUBLIC	DISP_HEX_POINTER
	PUSHREG	<AX>			;Save register(s)
	MOV	AX,ES			;Get the segment portion of the ptr
	CALL	DISP_HEX_WORD		;Display it in the console
	MOV	AL,':'			;Display address separator
	CALL	CONSOLE_OUTPUT		;...following the segment
	MOV	AX,DI			;Now, get the pointer's offset
	CALL	DISP_HEX_WORD		;Display this in hex, as well
	POPREG	<AX>			;Restore register(s)
	RET
DISP_HEX_POINTER ENDP



;**********************************************************************
; DISP_HEX_WORD: (WORD)
; DISP_HEX_BYTE: (BYTE)
; DISP_HEX_NIBBLE: (NIBBLE)
;
;	Disp_Hex_Word displays the contents of AX as a 4 character
; ASCII string on the console.  Disp_Hex_Byte displays AL as two 
; ASCII-Hex chars, and Disp_Hex_Nibble displays the nibble in AL as 
; a single character.
;
; Input:
;	AX: Word, or ...
;	AL: Byte, or ...
;	AL: Nibble to be displayed.
;
; Note: Register AX is destroyed by this call
;**********************************************************************
DISP_HEX_WORD PROC NEAR
	PUBLIC	DISP_HEX_WORD, DISP_HEX_BYTE, DISP_HEX_NIBBLE
	PUSH	AX			;Save the word being output
	MOV	AL,AH			;Get the low byte first
	CALL	DISP_HEX_BYTE		;Print the low byte
	POP	AX			;Restore word, display low byte
DISP_HEX_BYTE:
	PUSH	AX			;Save low nibble on stack
	PUSH	CX			;Save CX
	MOV	CL,4			;Get the high nibble first
	SHR	AL,CL			;... into AL
	POP	CX			;Restore register CX
	CALL	DISP_HEX_NIBBLE		;Display the high nibble
	POP	AX			;Retrieve and display low nibble
DISP_HEX_NIBBLE:
	AND	AL,0FH			;Make sure we only have a nibble
	ADD	AL,'0'			;Convert char to hex
	CMP	AL,'9'			;Is the character a digit?
	JBE	DHW1			;Yes - display character
	ADD	AL,'A'-'9'-1		;No, convert char to 'A'-'F'
DHW1:	CALL	CONSOLE_OUTPUT		;Display the converted character
	RET
DISP_HEX_WORD ENDP



;**********************************************************************
; BACK_SPACE:
;
;	Back_Space echos a BS, ' ', BS sequence to delete the previously
; displayed character from the display.
;**********************************************************************
BACK_SPACE PROC NEAR
	PUBLIC	BACK_SPACE
	PUSHREG	<SI>
	MOV	SI,OFFSET BS_MSG	;Point to the backspace sequence
	CALL	DISP_STRING		;Display it on the console
	POPREG	<SI>
	RET
BACK_SPACE ENDP



;**********************************************************************
; CRLF:
;
;	CRLF displays an ASCII 'newline', ie, Carriage Return followed
; by a Line Feed, on the console.  It also polls the console to
; determine if the user wishes to pause or abort the display.  If
; a pause has been detected (Scroll-Lock or CTRL-S), then CRLF will
; pause - if an abort is entered, then CRLF will exit directly to the 
; DEBUG command processor, rather than returning to the caller.
; Valid abort characters are ESCAPE, Ctrl-C, and Ctrl-Break.
;**********************************************************************
CRLF PROC NEAR
	PUBLIC	CRLF
	PUSHREG	<AX,SI>			;Save register(s)
	CALL	GET_KEY_STATUS		;Has a key been pressed?
	JZ	CL1			;No, display a newline
	CMP	AL,CTRL_S		;Was a pause character entered?
	JNE	CL1			;No, continue
	CALL	GET_KEY_BUFF		;Flush the pause from the key buffer
	CALL	GET_KEY_BUFF		;Wait for another char to be typed
	CMP	AX,BREAK_CODE		;Was a break entered?
	JE	CL2			;Yes - abort to the command processor
	CMP	AL,ESC			;Was this an Escape?
	JE	CL2			;Yes - display newline and abort
	CMP	AL,CTRL_C		;Was the key a CTRL_C?
	JE	CL2			;Yes - display newline abort
CL1:	TEST	SHIFT_STATUS,SCROLL_LOCK;Is Scroll-Lock active?
	JNZ	CL1			;Yes - wait until it is disabled
	MOV	SI,OFFSET CRLF_MSG	;Point to the CRLF sequence
	CALL	DISP_STRING		;Display it on the console
	CALL	GET_KEY_STATUS		;Get the keyboard status again
	JZ	CL5			;No key entered - return to caller
	CMP	AX,BREAK_CODE		;Key entered - is it a break?
	JE	CL3			;Yes - abort
	CMP	AL,ESC			;Was this an Escape?
	JE	CL3			;Yes - abort
	CMP	AL,CTRL_C		;Was the key a CTRL_C?
	JNE	CL5			;No, return to the caller
	JMP	SHORT CL3		;Yes - abort directly
CL2:	MOV	SI,OFFSET CRLF_MSG	;Point to the CRLF sequence
	CALL	DISP_STRING		;Display it on the console
	JMP	SHORT CL4		;Exit to the command processor
CL3:	CALL	GET_KEY_BUFF		;Flush the abort key from the buffer
CL4:	JMP	COMMAND_LOOP		;ABORT directly to command processor
CL5:	POPREG	<SI,AX>			;Restore register(s)
	RET
CRLF ENDP



;**********************************************************************
; DISP_STRING: (STRING)
;
;	Disp_String displays a null (00H) terminated string on
; the console.
;
; Input:
;	SI: Pointer to string (assumed to be in the monitor segment).
;**********************************************************************
DISP_STRING PROC NEAR
	PUBLIC	DISP_STRING
	PUSHREG	<AX,SI>
DDS1:	MOV	AL,BYTE PTR CS: [SI]	;Get a character to be displayed
	INC	SI			;Point to the next character
	TEST	AL,AL			;Reached the end of the string?
	JZ	DDS2			;Yes - return
	CALL	CONSOLE_OUTPUT		;No, display this character
	JMP	SHORT DDS1		;Loop until whole string displayed
DDS2:	POPREG	<SI,AX>
	RET
DISP_STRING ENDP



;**********************************************************************
; TAB_POSN: (COLUMN)
;
;	Tab_Posn is used to tab the cursor over to a specific column
; number on the current line.
;
; Input:
;	AH: Desired column for cursor.
;**********************************************************************
TAB_POSN PROC NEAR
	PUBLIC	TAB_POSN
	PUSHREG	<AX,CX,DX>
	CALL	GET_CUR_POSN		;Read the current cursor position
	SUB	AH,DL			;Subtract current col. from desired
	CALL	SPACE			;Advance cursor to desired column
	POPREG	<DX,CX,AX>
	RET
TAB_POSN ENDP



;**********************************************************************
; SPACE: (COUNT)
;
;	Space is used to send an arbitrary number of spaces to the
; console.
;
; Input:
;	AH: Number of spaces to be displayed
;**********************************************************************
SPACE PROC NEAR
	PUBLIC	SPACE
	PUSHREG	<AX>
SP1:	MOV	AL,' '			;Get a space character
	CALL	CONSOLE_OUTPUT		;Display it on the console
	DEC	AH			;Displayed enough yet?
	JNZ	SP1			;No, display some more!
	POPREG	<AX>
	RET
SPACE ENDP



;**********************************************************************
; CONSOLE_OUTPUT: (CHAR)
;
;	Console_Output is called to output characters on the screen in
; the current video mode.  This routine differentiates itself from the
; Terminal_Display routines in that it detabs - ie, TABs which are
; displayed are converted to a sequence of spaces which will advance
; the cursor to the next 8-character tab stop.  The cursor is updated
; upon return to the next character location.
;	In addition to the above, the CONSOLE_OUTPUT routine ignores
; NULL characters.
;
; Input:
;	AL: Character to be displayed
;
; Note:	This routine is reentrant (via the SPACE routine), in the
;	event of a TAB.
;**********************************************************************
CONSOLE_OUTPUT PROC NEAR
	PUBLIC	CONSOLE_OUTPUT
	PUSHREG	<AX,BX,CX,DX>		;Save registers
	TEST	AL,AL			;Is the character a null?
	JZ	CO2			;Yes - ignore it
	CMP	AL,TAB			;Is this a horizontal tab?
	JNE	CO1			;No, display the character
	CALL	GET_CUR_POSN		;Read the current cursor position
	MOV	AH,DL			;Get the current column number
	AND	AH,TAB_MASK		;Find start of current tab
	ADD	AH,TAB_SIZE		;Find next tab stop
	SUB	AH,DL			;Find number of spaces to display
	CALL	SPACE			;Display them!
	JMP	SHORT CO2		;Return to caller
CO1:	MOV	AH,14			;Set terminal-display mode
	MOV	BL,03H			;Set color in case med-res graphics
	INT	VIDEO_IO_INTR		;Display the character on the screen
CO2:	POPREG	<DX,CX,BX,AX>		;Restore registers
	RET
CONSOLE_OUTPUT ENDP



;**********************************************************************
; 	    G E N E R A L   M E S S A G E   S T R I N G S
;**********************************************************************
BS_MSG		DB	BS,' ',BS,0	;Backspace sequence message
CRLF_MSG	DB	CR,LF,0		;CRLF - ASCII newline message


MONITOR_SEGMENT ENDS

	END

