Subttl	Icon I/O Utilities
Page	60,132
;Title	Icon I/O Utilities
;
;	Copyright 1985
;	Morrow Designs, Inc.
;	San Leandro, Ca.
;	Last Update 27_Jun_85
;
;----------------------------------------------------------------------
; Equates
;--------
;
; Include Files
;--------------
;	Rom.lit
;	Intr.lit
;	Io.lit
;	Icon.lit
;
;	.xlist
;	Include ..\Rom\Rom.lit		;Basic System Definitions
;	Include ..\Rom\Intr.lit		;Interrupt Routine Definitions
;	Include ..\Rom\Io.lit		;Io Port and control mask Defintions
;	Include	..\Icon\Icon.lit	;Include the Common Equates
;	.list
;
;======================================================================
Screen_Segment Segment at (0B800H)
;=================================
;
	;Define the Base of the Video Ram

Screen_Segment	EndS

page
;======================================================================
;Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment

	extrn	DFlags:Byte
	extrn	Scan_Array:Byte
	extrn	Old_Video_Mode:Byte
	extrn	NovRam_Stat:Byte	;Current NovRam Status
	extrn	Dcr_Save:Byte		;Current Display Control Register Value

;----------------------------------------------------------------------
; Fixed Data Area (26_Apr_85)
;----------------------------
;
Dir_Tbl	dw	00000h			; right, no update needed
	dw	000FFh			; down
	dw	0FFFEh			; left
	dw	0FEFFh			; up

;----------------------------------------------------------------------
Put_String_Imm Proc Near; (8_Apr_85)
;-----------------------------------
;	1) Print the string pointed to by the return address (on the stack)
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Put_String_Imm

	pop	si			;get pointer to string data
	call	Put_String		;put data up
	jmp	si			;return to just after data

Put_String_Imm	EndP

page
;----------------------------------------------------------------------
Put_String_N Proc Near; (8_Apr_85)
;---------------------------------
;	1) This routine puts the n-th string out to display
;	2) on entry, al = string to put up
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Put_String_N

	push	es			;save es
	push	cs			;move cs to es
	pop	es
	mov	ah,al			;ah = number of string to put up
	mov	di,offset MonthTable	;di points to start of table
	mov	al,0			;al = string terminator
	mov	cx,offset TextEnd-offset MonthTable ;set length of table
	cld
	jmp	short	mindl2		;jump to entry point for search
mindl1:
	repnz	scasb			;skip to next string
mindl2:	dec	ah			;decrement string number
	jg	mindl1			;if <> 0 then skip a string
	pop	es			;else, di is offset to string,
					;es is no longer needed
	mov	si,di			;point si to the string to be output
	call	Put_String
	ret				;Return

Put_String_N	EndP

page
;----------------------------------------------------------------------
Put_String Proc Near; (20_May_85)
;--------------------------------
;	1) Put the string pointed to by cs:si to the console.
;	2) Character Attributes are set using the system variable DFlags
; 	3) String values:
; 		0	= End of String
; 		1	= Set Direction Right
; 		2	= Set Direction Down
; 		3	= Set Direction Left
; 		4	= Set Direction Up
; 		5..28	= Repeat Next Character this many times
; 		29	= Display String n here
; 		30	= Move Cursor to Column, Row Immediate
; 		31	= Move Cursor to Column Immediate
; 		32..255 = Character Code
;	4) Entry Register Values:
;		BL -> Character Attribute
;		DX -> Cursor Location
;		SI -> Pointer to a String of Characters/Commands
;	5) Exit Register Values:
;		DX -> Left at the Next Cursor Location
;		SI -> Pointing to the end of the last string
;		DI -> Word describing the current direction
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing
Public	Put_String

	PushReg	<ax,cx>
	mov	di,0			;DI:= Initial Direction (right)
PsLp1:	mov	cx,1			;Loop	CX:= Default Repeat Count
PsLp2:	cld
	lods	Byte Ptr cs:[si]	;	AL:= Character or Command
	cmp	al,32			;	If (Print Character)
	jb	PsSk1

PsLp3:	PushReg	<ax,di>			;		Repeat
	call	Put_Chr			;			Print Char
	PopReg	<di,ax>

	add	dx,di			;			adj direction
	loop	PsLp3			;		Until (Count eq 0)
	jmp	PsLp1

PsSk1:	cmp	al,30			;	Else If (Move Cursor Command)
	jb	PsSk2

	lods	byte ptr cs:[si]
	mov	dl,al		 	;		DL:= New Column
	jnz	PsLp2			;		If (Set Row (code 31))

	lods	byte ptr cs:[si]
	mov	dh,al			;			DH:= New Row
	jmp	PsLp2

PsSk2:	cmp	al,29			;	Else If (Display String N)
	jb	PsSk3

	lods	byte ptr cs:[si]	;		AL:= String Number
	push	si
	call	Put_String_N		;		put up new string n
	pop	si
	jmp	PsLp1

PsSk3:	cmp	al,5			;	Else If (Repeat Count)
	jb	PsSk4

	mov	cl,al			;		CL:= Repeat Count
	jmp	PsLp2

PsSk4:	cmp	al,1			;	Else If (Set Direction)
	jb	PsSk5

	mov	ah,0			;		AH:= New Direction
	mov	di,ax			;		DI:= New Direction
	add	di,ax			;		(adjust for word index)
	mov	di,dir_tbl[di-2]	;		get Direction from table
	jmp	PsLp2			;		get next byte of string

PsSk5:	PopReg	<cx,ax>
	ret				;	Else Return

Put_String	EndP

page
;----------------------------------------------------------------------
Put_Ascii_Word Proc Near; (18_May_85)
;------------------------------------
;	1) This routine prints a 16 bit number in Ascii up to 9999
;	2) Entry Register Values:
;		AX -> value
;		BL -> Character Attribute
;		DX -> Location
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Put_Ascii_Word

	PushReg	<ax,cx>
	mov	cl,100
	cmp	ah,cl			;If (Number is Not in Range)
	jc	pasc2

	mov	ah,99			;	correct if not in range
pasc2:	div	cl
	call	Put_Ascii		;put up first two digits
	mov	al,ah			;and remainder
	and	DFlags,NOT Zer_Sup 	;make sure no zero suppression
	call	Put_Ascii
	PopReg	<cx,ax>
	ret				;Return

Put_Ascii_Word	EndP

;----------------------------------------------------------------------
Put_Ascii Proc Near; (8_Apr_85)
;------------------------------
;	1) Convert and Print an 8 bit number in AL in Ascii at position DX
;	   with Leading Zero Suppression.
;	2) Entry Register Values:
;		AL -> Number to Print
;		BL -> Character Attribute
;		DX -> Location (DH:=Row, DL:=Column)
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Put_Ascii

	push	ax
	aam				;convert to 2 digits
	xchg	ah,al			;get high digit in al
	add	ax,3030h		;make decimal
	test	DFlags,Zer_Sup		;check if zero suppression requested
	je	pa2			;if ( (zero suppression active) And

	cmp     al,'0'			;     (Character is a 0) )
	jne	pa2

	mov	al,' '			;	Replace Character with a Space
pa2:	push	ax			;save high part
	call	Put_Chr			;put out the character
	pop	ax			;get back the rest

	mov	al,ah			;get remainder
	call	Put_Chr			; and put it up also
	pop	ax
	ret

Put_Ascii	EndP

page
;-----------------------------------------------------------------------
Put_Chr Proc Near; (18_May_85)
;----------------------------
;	1) On Entry:
;		AL -> Character
;		BL -> Character Attribute
;		DX -> Location (DH:=Row, DL:=Column)
;		DFlags -> Attribute and Large/Small Characters for graphics
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Put_Chr

	PushReg	<ax,bx,cx>
	mov	bh,0			;select video page
	mov	ah,2			;put cursor at dh:row, dl:column
	int	Video_IO_Intr

	cmp	cs:Old_Video_Mode,3	;If (current video mode eq Alpha)
	jg	PcSk1

	mov	cx,1			;	CX:= Character Count
	mov	ah,9			;	AH:= Print Character Function
	int	Video_IO_Intr		;	Print the Character
	jmp	PcDone

PcSk1:	mov	bh,cs:DFlags 		;Else	BH:= type of char requested
	mov	bl,Normal		;	BL:= normal attributes
	test	bh,Rev_Chr		;	If (reverse video required)
	jz	PcSk2

	mov	bl,reverse		;		BL:= Reverse Attribute
PcSk2:	test	bh,big_chr		;	If (big chars NOT selected)
	jnz	PcSk3

	mov	bh,0			;		BH:= Page Number
	mov	ah,9			;		AH:= Print Char Funct.
	mov	cx,1			;		CX:= Char Count
	int	Video_IO_Intr		;		Print the Character
	cmp	bl,70h			;		if (Attrib. eq reverse)
	jne	PcSk4

	call	Rev_Char		;			reverse it
	jmp	PcSk4

PcSk3:	call	Draw_Big		;		Else	Print Big Chars
PcSk4:	test	bh,Big_Chr		;	If (doing big characters)
	jz	PcDone

	inc	dl			;		Column:= Column + 1
PcDone:	inc	dl			;Column:= Column + 1
	PopReg	<cx,bx,ax>
	ret				;Return

Put_Chr		EndP

page
;-------------------------------------------------------------------------
Rev_Char Proc Near; (18_May_85)
;------------------------------
;	1) Used to make a character that was written on the screen into a
;	   reverse video character.  On entry, dx = row/column of the
;	   character.  The routine first calculates where the character
;	   starts in screen memory, and then inverts the data written
;	   for the character.
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Screen_Segment

	PushReg	<bx,cx,di,es>
	call	Get_Scrn_Addr		;ES[DI]:= address of top scan line
	call	Rev_Four		;reverse half the Character
	or	di,2000h		;reverse other half of Character
	call	Rev_Four
	PopReg	<es,di,cx,bx>
	ret

Rev_Four:				;reverses 4 scan lines of char
	mov	cx,4			;CX:= Counter (4 bytes at this segment)
	mov	bx,0			;BX:= Offset
RcLp1:	mov	al,es:[di+bx]		;Loop	get a byte
	not	al			;	invert it
	mov	es:[di+bx],al		;	put it back on screen
	add	bx,80			;	point to next scan line
	loop	RcLp1
	ret				;Return

Rev_Char	EndP

page
;-----------------------------------------------------------------------
Draw_Big Proc Near; (18_May_85)
;------------------------------
;	1) Draws a big character at location dh: row, dl, column.
;	2) This routine gets the character rom data, converts it into a
;	   16 bit wide format, and puts it on the screen one scan line
;	   at a time.
;	3) If the character was to be reversed, it will use Rev_Chr to do it.
;	4) Register Entry Values
;		AL -> Character
;		DX -> Location
;		BL -> Attribute (if 70h then char reversed, else normal)
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Screen_Segment

	PushReg	<bx,cx,di,si,es>

	call	Get_Scan_Data		;get data to Scan array
	call	Get_Scrn_Addr		;ES:[DI] address of char on screen
	mov	cx,8			;CX:= Counter (8 scan lines to be done)
	mov	si,0			;SI:= offset into scan array
	mov	bx,0			;BX:= offset into screen memory

DbLp1:	mov	al,Scan_Array[si]	;Loop	get a byte from array
	call	Double_Bits		;	make it a word
	xchg	ah,al			;	may not be needed	

	mov	es:[di+bx],ax		;	put 1 double char scan line up
	xor	di,2000h		;	point to other half of screen

	mov	es:[di+bx],ax		;	put up second scan line
	xor	di,2000h		;	point back to first 1/2 of screen

	add	bx,80			;	point to next section
	inc	si
	loop	DbLp1

	PopReg	<es,si,di,cx,bx>
	ret				;Return

Draw_Big	EndP

page
;-----------------------------------------------------------------------
Double_Bits Proc Near; (18_May_85)
;---------------------------------
;	1) Convert scan line char data to a word
;	2) This routine is used to create double high, double wide characters
;	3) Entry Register Values:
;		AL -> Character to be doubled
;	4) Exit Register Values:
;		AX -> Doubled Data
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing

	PushReg	<cx,bx>
	mov	cx,8			;CX:= Counter (8 bits to be doubled)

DuLp1:	sal	al,1			;Loop	move a bit to the carry flag
	jnc	DuSk1			;	if (carry set) then 

	rcl	bx,1			;		move bit into bx...
	stc				;		set carry again
	rcl	bx,1			;		move it again
	jmp	DuSk2

DuSk1:	rcl	bx,1			;	Else	move 0's into bx
	clc
	rcl	bx,1

DuSk2:	Loop	DuLp1
	mov	ax,bx			;AX:= Result

	PopReg	<bx,cx>
	ret				;Return

Double_Bits	EndP

page
;-----------------------------------------------------------------------
Get_Scrn_Addr Proc Near; (8_Apr_85)
;----------------------------------
;	1) Get the Current Screen Address
;	2) Used by Draw_Big and Rev_Char to calculate the address on the
;	   screen of the top scan line for the character at the row / column
;	   address contained in DX.
;	3) Entry Register Values:
;		DH -> Screen Row Number
;		DL -> Screen Column Number
;	4) Exit Register Values:
;		ES:[DI] -> pointing to the byte in screen ram.
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Screen_Segment

	PushReg	<ax,bx,dx>

	mov	ax,Screen_Segment
	mov	es,ax			;ES:= Start of Screen Memory

	mov	al,dh			;get row number in ax
	xor	ah,ah			;clear ah and dh
	mov	dh,ah
	shl	al,1
	shl	al,1

	mov	bh,EIGHTY
	mul	bh			;ax = [ROW * 4] * 80
	add	ax,dx			;ax = [[ROW * 4] * 80] + COLUMN
	mov	di,ax			;move it to di

	PopReg	<dx,bx,ax>		;(restore row/column)
	ret				;Return

Get_Scrn_Addr	EndP

page
;-----------------------------------------------------------------------
Get_Scan_Data Proc Near; (18_May_85)
;-----------------------------------
;	1) Gets the bit map character image and moves it to the scan line
;	   array. During the move, if the reverse attribute has been set,
;	   it will invert the data.
;	2) Entry Register Values:
;		AL = character
;		BL = attribute
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Monitor_Segment

	PushReg	<ax,cx,di,si,es>
	push	cs
	pop	es			;ES:= Base of Monitor Segment
	mov	si,Offset Font		;SI:= Start of Character Font Codes

	mov	ah,0
	shl	ax,1			;compute offset to start of char data
	shl	ax,1
	shl	ax,1
	add	ax,si
	mov	si,ax			;ES:[SI]:= pointer 1st byte char data
	mov	cx,8			;CX:= Counter (8 bytes will be moved)
	mov	di,0			;DI:= pointer for array storage

GsLp1:	mov	al,es:[si]		;Loop	AL:= Next byte of Char Data
	cmp	bl,70h			;	If (reverse video selected)
	jnz	GsSk1

	not	al			;		Invert Bits
GsSk1:	mov	cs:Scan_Array[di],al	;	Save data in scan array
	inc	si			;	SI:= Next Char Location
	inc	di			;	DI:= Next Array Location
	loop	GsLp1

	PopReg	<es,si,di,cx,ax>
	ret				;Return

Get_Scan_Data	EndP

page
;----------------------------------------------------------------------
R_W_RTC_Ram Proc Near; (27_Jun_85)
;---------------------------------
;	1) Enables or Disables Writes to the NovRam and RTC. In addition,
;	   It disables reads of the RTC, and puts it in power down mode.
;	2) Register Values on Entry
;		AL = 0 -> Disable RTC and NovRam
;		AL = 1 -> Enable RTC and NovRam
;		AL = 2 -> Return Current NovRam Status
;	3) On Exit ALL register preserved.
;		
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing
Public	R_W_RTC_Ram

	push	ds
	push	cs
	pop	ds			;DS:= Monitor Segment

	cmp	al,1			;If (AL eq Request for NovRam Status)
	jle	RW_1

	mov	al,NovRam_Stat		;	AL:= Current Status of Novram
	pop	ds
	ret				;	Return

RW_1:	push	ax			;Else
	push	cx
	mov	NovRam_Stat,al		;	Update NovRam Status

	mov	ah,Dcr_Save		;	AH:= Display Control Reg Value
	and	ah,Not Nov_Enable	;	(remove NovRam Enable bit)
	or	ah,al			;	AH:= New Value of Dcr
	and	ah,Nov_Enable + Cursor_Ram_Enable ;(mask off unused bits)
	mov	Dcr_Save,ah		;	(save current value of Dcr)

	mov	al,Display_Control_Register
	call	Out_Morrow_6845		;	Enable/Disable NovRam

	mov	cx,15			;	CX:= Delay Time
AdLp1:	loop	AdLp1			;	Wait for NovRam On/Off
	pop	cx
	pop	ax
	pop	ds
	ret				;	Return

R_W_RTC_Ram	EndP

page
;Monitor_Segment	EndS
;		End
