page	60,132
Title	-Graphics Utilities
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 10_Apr_85
;
;
%Out	Draw.asm
page
;======================================================================
Screen_Segment Segment at (0B800H)
;=================================
;
	;Define the Base of the Video Ram

Screen_Segment	EndS

;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	extrn	Xor_Flag:Byte
	extrn	L_Edge:Word
	extrn	xDot:Word
	extrn	yDot:Word
	extrn	MapDat:Byte

;----------------------------------------------------------------------
; Fixed Data Area for Draw (8_Apr_85)
;------------------------------------
;
Masks:	db	10000000b		;masks for pixel positions
	db	01000000b
	db	00100000b
	db	00010000b
	db	00001000b
	db	00000100b
	db	00000010b
	db	00000001b

page
;----------------------------------------------------------------------
Draw_Map Proc Near; (8_Apr_85)
;-----------------------------
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Draw_Map

	push	ds			;(Save data segment)
	push	cs
	pop	ds			;DS:= pointer to the Code Seg

	mov	si,Offset MapDat	;DS:SI = Source of Data
	mov	al,28			;AL:= Column Offset (Right 28 Spaces)
	mov	bl,24			;BL:= Row    Offset (24 scan lines)
	call	Draw_Graph		;Draw the map

	pop	ds			;(Restore data segment)
	ret

Draw_Map	EndP

;----------------------------------------------------------------------
Draw_Graph Proc Near; (8_Apr_85)
;-------------------------------
;	1) Entry Values:
;		DS:SI pointing to data for the Graph
;		AL is offset from left in character to start of image
;		BL is offset in scan lines from top to start
;	2) While in the body of this routine the:
;		AX = Current Row
;		BX = Current Column
;		CX = Length of the current line
;	3) Grapsh Data Format:
;		0000 0000  -- end of screen
;		1000 0000  -- end of line
;		1nnn nnnn  -- n bits of ones
;		0nnn nnnn  -- n bits of zeroes
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	push	ds			;(save the entry value of the CS)
	push	cs
	pop	ds			;DS:= Entry Code Seg

	mov	ah,8			;compute starting column of map
	mul	ah
	mov	L_Edge,ax		;save the starting column of the graph
	xor	bh,bh
	mov	Xor_Flag,bh		;clear xor flag
	xchg	ax,bx			;AX:= Row,  BX:= Column

DgLp1:	xchg	ax,cx			;Loop
	lodsb				;	AX:= Next Byte of Graph
	xchg	ax,cx

	xor	ch,ch			;	(clear AH)
	test	cl,cl			;	If (End of Graph eq True)
	jnz	DgSk1

	pop	ds			;		(DS:= Entry Data Seg)
	ret				;		Return

DgSk1:	cmp	cl,080h			;	If (End of Line ne True)
	jz	DgSk3

	test	cl,80h			;		If (Drawing 1's)
	jz	DgSk2

	and	cl,7FH			;			Remove Flag
	push	es
	push	si
	call	Draw_Horizontal		;			Draw line segment
	pop	si
	pop	es

DgSk2:	add	bx,cx			;		AX:= New Row
	jmp	DgLp1
	
DgSk3:	inc	ax			;	Else	AX:= Next Row
	mov	bx,L_Edge		;		BX:= Starting Column
	jmp	DgLp1
	

Draw_Graph	EndP

page
;----------------------------------------------------------------------
Draw_Horizontal Proc Near ;(7_Mar_85)
;------------------------------------
;	ydot = row
;	xdot = column
;	CX   = Length of run
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Draw_Horizontal

	push	ax			; Save parameters on entry
	push	bx
	push	cx

	mov	yDot,ax
	mov	xDot,bx
DhLp1:	call	Dot			;Repeat	plot the dot
	inc	xdot			;	increment the column position
	loop	DhLp1			;Until (all points plotted)

	pop	cx			; restore parameters for return
	pop	bx
	pop	ax
	ret				;Return

Draw_Horizontal	EndP


;----------------------------------------------------------------------
Draw_Vertical Proc Near ;(7_Mar_85)
;----------------------------------
;	ydot = row
;	xdot = column
;	CX   = Length of run
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment
Public	Draw_Vertical

	push	ax			; Save parameters on entry
	push	bx
	push	cx

	mov	yDot,ax
	mov	xDot,bx
DvLp1:	call	Dot			;Repeat	plot the dot
	inc	ydot			;	increment the row position
	loop	DvLp1			;Until (all points plotted)

	pop	cx			; restore parameters for return
	pop	bx
	pop	ax
	ret				;Return

Draw_Vertical	EndP

page
;----------------------------------------------------------------------
Dot Proc Near ;(6_Mar_85)
;------------------------
;	1) dot sets the dot described by the row number in AL, and the
;	   column number in DX.
;	2) entry: YDot = row
;		  XDot = column
;		  Masks = 2 bit pixel masks
;	3) registers altered: AX,DX,DI,SI
;	4) low order bit has even/odd scan lines (0000-2000 offset)
;	5) multiply high order 7 bits by 80 to get row address (scan line)
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Screen_Segment

	mov	ax,Screen_Segment
	mov	es,ax			;ES:= Start of Screen_Segment
	mov	ax,ydot

	xor	di,di			;bit was 0 - major offset address in DI
	shr	al,1			;calc 80 byte offset addr. AX=7bit addr
	jnc	even			;the low order bit was 1

	mov	di,2000h		;major offset address in DI
even:	mov	dh,80
	mul	dh			;calc secondary offset in AX (AX * 80)
	add	di,ax			;DI=offset address of row (scan line)
	mov	dx,xdot
	mov	si,dx			;save the column number in SI
	shr	dx,1			;shift out the two low order bits,
	shr	dx,1			;********* added 2-25-85
	shr	dx,1			;DX has column byte
	add	di,dx			;DI has byte address
	and	si,07h			;SI has 0..7, position of bit in byte
	mov	al,Byte Ptr cs:[masks+si]
	cmp	Xor_Flag,0
	jne	do_xor

	or	al,es:[di]		;get byte from graphics board memory
	mov	es:[di],al		;write updated byte to memory
	ret				;return to HPLOT caller
do_xor:
	xor	al,es:[di]
	mov	es:[di],al
	ret

Dot	EndP

Monitor_Segment	EndS
		End

