;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
PAGE ,132
	TITLE	PSCP920 - Print Screen Utility

;***	PSCP920 - Print Screen Utility
;
;	PSC is a print screen utility. It intercepts INT 5 from
;	the BIOS (generated when <shift f12> is struck), and prints
;	the contents of the screen onto the PRN device.
;
;	Zenith Data Systems
;	April 8, 1983
;	Copyright (C) 1983, Zenith Data Systems
;
;	To assemble:
;		NOTE: xxxx is replaced by the type of printer you
;			have, for instance PSCMX80 is for the MX-80
;			printer.
;
;	MASM PSCxxxx;
;	LINK PSCxxxx+GETPNT;
;	EXE2BIN PSCxxxx .COM
;	ERASE PSCxxxx.exe
;
;	To execute:
;
;	PSCxxxx
;
;	To activate:
;
;	Press SHIFT and F12 simultaneously.
;	Or generate an INT 5 from a user program.
;
;	Once PSCxxxx has been executed, it remains permanently in RAM and
;	does not need to be executed again.
;

FALSE	=	0
TRUE	=	NOT FALSE
Z150	=	TRUE

	IF	Z150

	.XLIST
	INCLUDE ..\COMMONS\MSDOS.DEF
	INCLUDE ..\COMMONS\Z150ROM.DEF
	.LIST

Z150ROWS	=	200
Z150COLSA	=	640
Z150COLS	=	Z150COLSA/6+1		; Characters/line

	ELSE

	INCLUDE	\DEVEL\DOS20\INC\DEFBIOS.ASM
	INCLUDE	\DEVEL\DOS20\INC\DEFMTR.ASM
	INCLUDE	\DEVEL\DOS20\INC\DEFCHR.ASM
	INCLUDE	\DEVEL\DOS20\INC\DEFMS.ASM

Z100COLSA	=	640
Z100COLS	=	Z100COLSA/6+1		; Characters/line
	ENDIF


CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H

	EXTRN	GETPNT:NEAR,INT_END:NEAR

;*	Entry point
;

BEGIN:
	JMP	NEAR PTR START

;*	INT 5 handler
;

INT_5:
	PUSH	DS			; Save his data segment
	PUSH	AX

	IF	Z150

;	See if print screen in progress

	SUB	AX,AX
	MOV	DS,AX
	MOV	AL,1
	XCHG	BYTE PTR DS:[500H],AL
	CMP	AL,1
	JZ	INT_5_EXIT
	ENDIF

	MOV	CS:INT_SP,SP
	MOV	CS:INT_SS,SS		; Save his stack

	MOV	AX,CS
	MOV	SS,AX			; Set local stack
	MOV	SP,OFFSET INT_STACK

	STI				; Now allow interrupts to come in

	PUSH	ES
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI

	MOV	DS,AX
	MOV	ES,AX			; Set up my segments

	IF	Z150
;	Get the current video state
	MOV	AH,VIO_CVS
	INT	VIDEO_IO_INTR
	MOV	VMODE,AL
	CMP	AL,4			; Skip graphics PSC if not in graphics mode
	JB	INT1
	ENDIF

	CALL	INT_SIZE		; Size screen
	CALL	INT_SCRN		; Process the screen

	IF	Z150
INT1:
	ENDIF

	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	ES

	CLI				; INTs off while messing around
	MOV	AX,INT_SP
	MOV	SP,AX
	MOV	AX,INT_SS		; Restore his stack
	MOV	SS,AX

	IF	Z150
	SUB	AX,AX
	MOV	DS,AX
	MOV	BYTE PTR DS:[500H],0
	ENDIF

	POP	AX
	POP	DS

	IF	Z150
	CMP	BYTE PTR CS:VMODE,4
	JB	LINK
	ENDIF
	IRET				; Back to BIOS

	IF	Z150
	LINK:
	JMP	DWORD PTR CS:OLD_INT5

INT_5_EXIT:
	POP	AX
	POP	DS
	IRET
	ENDIF

INT_SS	DW	0			; Saved stack values
INT_SP	DW	0

	IF	Z150
OLD_INT5	LABEL	DWORD
OLDOFF	DW	?
OLDSEG	DW	?

	PUBLIC	VMODE
VMODE	DB	?
	ENDIF

INT_CX	DW	0			; Current X location
INT_CY	DW	0			; Current Y location
MYCHR	DW	0			; Character at position
	IF	Z150
MYLINE	DB	Z150COLS DUP(0)		; Line buffer
	ELSE
MYLINE	DB	Z100COLS DUP (0)	; Line buffer
	ENDIF
LINES	DW	0			; Number of lines valid on screen
LTFLG	DB	0			; != 0 if last time
INCREMENT	DB	1		; Skip 1 line first time

	DW	128 DUP (?)
INT_STACK LABEL	NEAR			; Internal stack

;*	INT_SIZE - Size Screen
;
;	INT_SIZE checks to see if the 25th line is enabled. If
;	it is, LINES is modified to be 25, so all lines are
;	printed
;

INT_SIZE:
	IF	Z150
	MOV	LINES,Z150ROWS

	ELSE

	MOV	WORD PTR LINES,225-9	; Assume not
	MOV	SI,OFFSET INT_SIZA	; Print first line
	CLI				; Don't interrupt me now
	CALL	INT_PLINE		; Output line
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX			; Get data segment
	MOV	DS,DS:[MTR_DS]
	MOV	AL,DS:[MTR_VERP]	; AL = horiz. position of cursor
	POP	DS
	PUSH	AX
	MOV	SI,OFFSET INT_SIZB	; Put cursor back
	CALL	INT_PLINE		; Output line
	STI
	POP	AX
	CMP	AL,24
	JNZ	INT_SIZ1		; If not on 24th line

;	Cursor moved to 25th line, must be enabled

	ADD	WORD PTR LINES,9
	ENDIF

INT_SIZ1:
	RET

	IF	NOT Z150
INT_SIZA LABEL	NEAR
	DB	01BH,'j'		; Save cursor
	DB	01BH,'Y',25+31,1+31	; Go here
	DB	-1			; End of message

INT_SIZB LABEL	NEAR
	DB	01BH,'k'		; Restore cursor
	DB	-1

;*	INT_PLINE - Print line on console
;

INT_PLINE:
	MOV	AL,BYTE PTR [SI]	; Get character
	INC	SI			; Bump for next time
	CMP	AL,-1
	JZ	INT_PLIN1		; If end of text
	PUSH	SI
	MOV	AH,CHR_WRITE
	CALL	FAR PTR BIOS_CONFUNC	; Output it
	POP	SI
	JMP	SHORT INT_PLINE		; Do next
INT_PLIN1:
	RET
	ENDIF


;*	INT_SCRN - Interrupt time Screen Processor
;

INT_SCRN:
	CALL	INIT
	MOV	WORD PTR INT_CX,0
	MOV	WORD PTR INT_CY,0	; Show line 0, column 0

INT_LINE:
	MOV	SI,OFFSET MYLINE	; Save one line here

;	Do a screen line

INT_SCRN1:
	MOV	CX,6
	MOV	BL,20H
	XOR	AH,AH
INT_SCRN1A:
	PUSH	AX			; Save current character
	PUSH	CX			; Save loop counter
	PUSH	BX			; Save bit cell
	MOV	CX,WORD PTR INT_CX
	MOV	BX,WORD PTR INT_CY
	MOV	AL,0
	CMP	CX,640
	JNC	SKIPDOT			; If >640, skip this dot
	CALL	GETPNT			; Read the point
SKIPDOT:
	INC	WORD PTR INT_CX
	POP	BX
	POP	CX

	OR	AL,AL			; Any point here?
	POP	AX

	JZ	INT_SCRN1B
	OR	AH,BL			; If so, fire top pin
INT_SCRN1B:
	SHR	BL,1			; Next pin
	LOOP	INT_SCRN1A

INT_SCRN2:

;	Save character

	ADD	AH,'@'
	MOV	BYTE PTR [SI],AH	; Save pin code
	INC	SI

	IF	Z150
	CMP	INT_CX,Z150COLSA
	ELSE
	CMP	INT_CX,Z100COLSA
	ENDIF
	JC	INT_SCRN1J		; If can do more

;	End of character line, print the whole thing

	CALL	OLINE			; Output this one

	MOV	WORD PTR INT_CX,0	; Start a new line
	INC	WORD PTR INT_CY		; next horizontal line
	MOV	AX,LINES
	CMP	WORD PTR INT_CY,AX
	JC	INT_SCRN2J

	CALL	CLEANUP
	RET

;	Stepping stone for near conditional jumps

INT_SCRN1J:
	JMP	NEAR PTR INT_SCRN1

INT_SCRN2J:
	JMP	NEAR PTR INT_LINE

;	INITIALIZATION CODES

GMODE	DB	01BH,'Q'			; Enter graphics mode
CRLF	DB	0DH,0AH,0AH
CLEARALL DB	01BH,'[t'

;*	INIT - Set up vertical spacing mode

INIT:
	MOV	BX,OFFSET GMODE
	MOV	CX,2
	JMP	NEAR PTR OUTCHR

;*	Exit all special mode settings

CLEANUP:
	MOV	BX,OFFSET CLEARALL
	MOV	CX,3
	JMP	NEAR PTR OUTCHR

;*	Output a line to the printer

OLINE:
	MOV	BX,OFFSET MYLINE
	IF	Z150
	MOV	CX,Z150COLS
	ELSE
	MOV	CX,Z100COLS
	ENDIF

;	Check line for all zeros

	PUSH	BX
	PUSH	CX
OLINE1:
	CMP	BYTE PTR [BX],'@'
	JNZ	OLINE2
	INC	BX
	LOOP	OLINE1

;	CX = 0 if line is all blank

OLINE2:
	JCXZ	OLINE3
	POP	CX
	POP	BX

;	Not all blank, truncate trailing blanks

	CALL	TRUNCATE
	CALL	OUTCHR			; Output the data

	JMP	SHORT OLINE4

OLINE3:
	POP	CX
	POP	BX

;	Terminate line

OLINE4:
	MOV	BX,OFFSET CRLF
	MOV	CX,3
	JMP	OUTCHR

;	Truncate line, exits with CX = # of characters to print

TRUNCATE:
	IF	Z150
	MOV	BX,OFFSET MYLINE+Z150COLS-1
	MOV	CX,Z150COLS
	ELSE
	MOV	BX,OFFSET MYLINE+Z100COLS-1	; BX over last one
	MOV	CX,Z100COLS			; CX is byte count
	ENDIF
TRUNC1:
	CMP	BYTE PTR [BX],'@'
	JNZ	TRUNC2			; If found a good one
	DEC	BX
	DEC	CX			; Keep looking
	JMP	SHORT TRUNC1
TRUNC2:
	MOV	BX,OFFSET MYLINE	; BX = FWA of line buffer
	RET

OUTCHR:
	PUSH	CX
	MOV	AL,BYTE PTR [BX]
	PUSH	BX

	IF	Z150
OUTCHR1:
	PUSH	AX
	PUSH	DX
	SUB	DX,DX
	MOV	AH,PIO_WRITE
	INT	PRINTER_IO_INTR
	TEST	AH,1
	POP	DX
	POP	AX
	JNZ	OUTCHR1

	ELSE

	MOV	AH,CHR_WRITE
OUTCHR1:
	PUSH	AX
	CALL	FAR PTR BIOS_PRNFUNC	; Print it
	POP	AX
	JC	OUTCHR1
	ENDIF

	POP	BX
	POP	CX
	INC	BX
	LOOP	OUTCHR
	RET

;*	Main entry point
;

START:
	MOV	SP,OFFSET INT_STACK		; Good place for it

	IF	NOT Z150
;	Check for version compatibility

	MOV	AH,DOSF_GETVER
	INT	21H				; Version < 2.00 error here
	OR	AL,AL				; AL = 0 if <1.28 dos
	JNZ	CHKOK				; If ok, must be good

;	For pre 1.28 msdos - Check the BIOS configuration table

	MOV	AX,BIOS_SEG
	PUSH	DS
	MOV	DS,AX
	ASSUME	DS:BIOS_SEG			; DS points to bios
	MOV	SI,WORD PTR [BIOS_CTADDR]	; SI points to config table
	XOR	CX,CX
COUNT:
	CMP	WORD PTR [SI],-1
	JZ	COUNT1
	ADD	SI,2
	INC	CX
	JMP	COUNT

;	CX = # of entries in configuration table

COUNT1:
	POP	DS				; Restore DS
	CMP	CX,12				; Must be at least 12
	JNC	CHKOK				; If ok

;	Must be version 1.0? of Z-DOS - bail out

	LEA	DX,BADVER
	MOV	AH,DOSF_OUTSTR
	INT	21H
	INT	20H

BADVER	DB	0AH,0DH,7,'Incorrect version of Z-DOS for this program$'

;	Versions check ok

CHKOK:
	ENDIF

	PUSH	DS

	XOR	AX,AX
	MOV	DS,AX				; Clear DS

	MOV	SI,5*4				; SI points to interrupt

	IF	Z150
	MOV	AX,DS:[SI]
	MOV	CS:OLDOFF,AX
	MOV	AX,DS:[SI+2]
	MOV	CS:OLDSEG,AX

	ENDIF

	CLI

	MOV	WORD PTR [SI],OFFSET INT_5
	MOV	WORD PTR [SI+2],CS		; Set my interrupt vector

	STI
	POP	DS

	MOV	DX,OFFSET INT_END		; LWA of resident portion
	INT	27H

CODE	ENDS
	END	BEGIN
