;
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
PAGE	,132
	TITLE	MDISK - Memory disk driver

;***	MDISK - Memory Disk driver
;
;	MDISK is a memory based disk. Its is configurable to the users
;	system size through the parameters listed below.
;
;	Written by BCB
;
;	Copyright(C) 1983, Zenith Data Systems
;	February 10, 1983
;
;	6/27/84 - RJM Modified to take command line parameters
;		  SIZE=num-Kb and START=start-paragraph 
;

	.xlist
	INCLUDE	PARMS.ASM
	INCLUDE	MACLIB.ASM
	INCLUDE	DEFASCII.ASM
	INCLUDE	DEFMS.ASM
	INCLUDE DEFDEV.ASM
	.list

CODE	SEGMENT	BYTE
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

;	Maximum and minimum size of the mdisk
MD_MINIMUM	=	32		; Minimum size of MDISK
MD_MAXIMUM	=	640		; Maximum size of MDISK
MD_DEFAULT	=	64		; Default size of MDISK


MDISK	LABEL	NEAR			; Begin header information

	ERRNZ	MDISK,DVH_OFF
	DW	-1			; Link to next device
	ERRNZ	MDISK,DVH_SEG
	DW	-1			;  as a dword pointer

	ERRNZ	MDISK,DVH_ATTR
	DW	DVHA_IBM		; Non-IBM format
	ERRNZ	MDISK,DVH_STRAT
	DW	OFFSET MD_STRAT		; Address of strategy routine
	ERRNZ	MDISK,DVH_INTR
	DW	OFFSET MD_INTR		; Address of interrupt routine
	ERRNZ	MDISK,DVH_NAME
	DB	1,'*MDISK*'
	ERRNZ	MDISK,<SIZE DVH_STRUC>

MDISK_BPBVEC	LABEL	NEAR
	DW	OFFSET MDISK_BPB

MDISK_BPB	LABEL	WORD		; BPB table for MDISK
	DW	512			; 512 byte sectors
	DB	1			; Allocation units
	DW	0			; No reserved sectors
	DB	1			; 1 FAT
	DW	?			; Directory entries
	DW	?			; # of sectors
	DB	0FFH			; Media byte
	DW	?			; # of sectors in a FAT

;	There are 2 entry points to a drive, the strategy entry point
;	and the interrupt entry point. When Z-DOS wishes to do an i/o
;	request, it first calls the strategy routine with a dword pointer
;	in the ES:BX registers. The strategy routine simply saves this
;	pointer and returns to the system. The interrupt routine is then
;	called by Z-DOS. The interrupt routine retrieves the dword pointer
;	saved by the strategy routine. This pointer is the address of a
;	"request packet" that contains the information needed to carry
;	out the i/o request, such as transfer address, byte count, etc.

;	The strategy routine

MD_STRAT PROC	FAR
	MOV	WORD PTR CS:PTRSAV,BX
	MOV	WORD PTR CS:PTRSAV+2,ES		; Save ES:BX as dword
	RET
MD_STRAT ENDP

;	Now the interrupt routine.

MD_INTR	PROC	FAR

;	Save everything

	PUSH	AX

	CLI
	MOV	CS:SAVESS,SS
	MOV	CS:SAVESP,SP
	MOV	AX,CS
	MOV	SS,AX
	MOV	SP,OFFSET MYSTACK
	STI

	PUSH	BX
	PUSH	CX
	PUSH	ES
	PUSH	SI
	PUSH	DI

	LES	BX,CS:PTRSAV			; ES:BX = request packet
	MOV	SI,OFFSET MD_CTAB		; Command table
	MOV	CL,ES:SRH_CMD[BX]		; CL = requested command
	XOR	CH,CH
	SHL	CX,1				; Make into word offset
	ADD	SI,CX				; SI = pointer to routine
	JMP	WORD PTR CS:[SI]		; Go to it

;	The routines exit through MD_SUCC if no error, or MD_ERROR if
;	an error has occured

MD_SUCC:
	MOV	AH,SRHS_DON			; Show 'DONE'
	XOR	AL,AL				;  Error code 0
	JMP	SHORT MD_EXIT

MD_ERROR:
	MOV	AH,SRHS_ERR			; Add the error bits
;	JMP	SHORT MD_EXIT			; Error code in AL

;	Now exit from the request

MD_EXIT:
	LES	BX,CS:PTRSAV			; ES:BX = packet
	MOV	ES:SRH_STAT[BX],AX		; Save the status
	POP	DI
	POP	SI
	POP	ES
	POP	CX
	POP	BX
	CLI
	MOV	SS,CS:SAVESS
	MOV	SP,CS:SAVESP
	STI
	POP	AX
	RET

MD_INTR	ENDP

;	This is the dispatch table

MD_CTAB	LABEL	NEAR
	ERRNZ	MD_CTAB,(2*SRHC_INIT)
	DW	MD_INIT			; Initialize
	ERRNZ	MD_CTAB,(2*SRHC_MCHK)
	DW	MD_MCHK			; Media check
	ERRNZ	MD_CTAB,(2*SRHC_BPB)
	DW	MD_BPB			; Build BPB
	ERRNZ	MD_CTAB,(2*SRHC_ICTL)
	DW	MD_RES3			; Reserved?
	ERRNZ	MD_CTAB,(2*SRHC_IN)
	DW	MD_IN			; Input
	ERRNZ	MD_CTAB,(2*SRHC_ICHK)
	DW	MD_ICHK			; Input check (buffer status)
	ERRNZ	MD_CTAB,(2*SRHC_ISTAT)
	DW	MD_ISTAT		; Input status
	ERRNZ	MD_CTAB,(2*SRHC_IFL)
	DW	MD_IFL			; Input flush
	ERRNZ	MD_CTAB,(2*SRHC_OUT)
	DW	MD_OUT			; Output
	ERRNZ	MD_CTAB,(2*SRHC_OUTV)
	DW	MD_OUTV			; Output with verify
	ERRNZ	MD_CTAB,(2*SRHC_OSTAT)
	DW	MD_OSTAT		; Output status
	ERRNZ	MD_CTAB,(2*SRHC_OFL)
	DW	MD_OFL			; Output buffer flush
	ERRNZ	MD_CTAB,(2*SRHC_OCTL)
	DW	MD_RES3			; Output control string
	ERRNZ	MD_CTAB,(2*(1+SRHC_MAX))

;	Now for each of the routines


;	MD_INIT - This is the tail end of the init routine which must
;		  remain resident

;	Now initialize the Directory area

MD_INIT4:
	PUSH	ES
	MOV	AX,MDISK_START		; Do FAT and directory for ease
	MOV	ES,AX
	MOV	CX,32*1024/2
	MOV	AX,0E5E5H
	XOR	DI,DI
	CLD
	REP	STOSW			; Clear all to E5's for 32k

;	Initialize the FAT

	MOV	AX,MDISK_BPB+BPB_FATSECS	; Get the number of sectors
	MOV	CL,8			; Turn into words (secs*512/2)
	SHL	AX,CL
	MOV	CX,AX
	XOR	DI,DI
	XOR	AX,AX
	REP	STOSW			; Clear FAT to zeros
	MOV	BYTE PTR ES:[0],0FFH	; Media byte
	MOV	WORD PTR ES:[1],0FF7H
	POP	ES

;	Return the break address

	LDS	DX,ES:DWORD PTR CIN_KADDR[BX]
	JMP	MD_SUCC			; Successful exit

;*	MD_MCHK - Media check
;
;	This call is used only by the block device drivers
;	so we simply return
;

MD_MCHK	PROC	NEAR
	MOV	ES:CMC_STAT[BX],CMCS_NOC	; Show no change
	CLC
	JMP	MD_SUCC			; Do nothing
MD_MCHK	ENDP

;*	MD_BPB - Build BPB
;
;	This is another one of the block device driver calls.
;	Again, simply return with no error
;

MD_BPB	PROC	NEAR
	MOV	ES:WORD PTR CBPB_BADDR[BX],OFFSET MDISK_BPB
	MOV	ES:WORD PTR CBPB_BADDR[BX+2],CS
	JMP	MD_SUCC
MD_BPB	ENDP

;*	MD_RES3 - Reserved entry point
;
;	This one is reserved, so we exit indicating an
;	error condition.
;

MD_RES3	PROC	NEAR
	MOV	AL,SRHS_EUKC		; Unknown command given
	JMP	MD_ERROR
MD_RES3	ENDP

;*	MD_IN - Character Input
;
;	MD_IN reads the number of characters requested into the
;	address given in the request packet.
;

MD_IN	PROC	NEAR
	MOV	CS:BYTE PTR TFLAG,0	; Flag a read
	JMP	NEAR PTR MD_IO
MD_IN	ENDP

;*	MD_ICHK - Non-destructive input check
;
;	MD_ICHK returns the status of the input queue. A
;	return of BUSY indicates queue empty, otherwise
;	return character at front of queue (without removing
;	it).
;

MD_ICHK	PROC	NEAR
	MOV	ES:CIC_CHAR[BX],01AH	; Show next is EOF
	JMP	MD_SUCC
MD_ICHK	ENDP

;*	MD_ISTAT - Input Status
;
;	MD_ISTAT Sets the busy bit if there is a character
;	ready to be read. If BUSY is set, the I/O will have
;	to go to the physical device. If BUSY is clear, the
;	read will return quickly.
;

MD_ISTAT PROC	NEAR
	JMP	MD_SUCC			; Show always ready
MD_ISTAT ENDP

;*	MD_IFL - Input Queue Flush
;
;	Flush the input queue
;

MD_IFL	PROC	NEAR
	JMP	MD_SUCC			; Consider it done!
MD_IFL	ENDP

;*	MD_OUT - Device Output
;
;	MD_OUT sends the output to the device
;

MD_OUT	PROC	NEAR
	MOV	CS:BYTE PTR TFLAG,1	; Show output
	JMP	NEAR PTR MD_IO
MD_OUT	ENDP

;*	MD_OUTV - Device Output with Verify
;
;	MD_OUTV verifies the output it sent
;

MD_OUTV	PROC	NEAR
	JMP	MD_OUT			; It verifies ok?
MD_OUTV	ENDP

;*	MD_OSTAT - Output Status
;
;	MD_OSTAT returns the status of the device. If BUSY
;	is a 1, output will have to wait for device ready. If
;	BUSY is a 0, output will go directly to device with
;	no waiting.
;

MD_OSTAT PROC	NEAR
	JMP	MD_SUCC			; Output device is ready
MD_OSTAT ENDP

;*	MD_OFL - Output buffer flush
;
;	MD_OFL Flushes the output buffer
;

MD_OFL	PROC	NEAR
	JMP	MD_SUCC			; Consider it done!
MD_OFL	ENDP

;*	MD_IO - Major I/O routine
;
;	This is the I/O routine
;

MD_IO	PROC	NEAR
	PUSH	DS
	PUSH	DX
	LDS	SI,ES:CRW_TADDR[BX]	; DS:SI = trans address
	MOV	DX,ES:CRW_CNT[BX]		; dX = count
	MOV	BX,ES:CRW_START[BX]		; BX = sector number
	MOV	CX,5			; BX << 9 >> 4
	SHL	BX,CL
	XOR	DI,DI			; Compute starting address
	MOV	AX,CS:MDISK_START	; AX = start segment
	ADD	AX,BX
	MOV	ES,AX
	PUSH	SI
	MOV	CX,4
	SHR	SI,CL
	MOV	AX,DS
	ADD	AX,SI			; Compute new base address
	MOV	DS,AX
	POP	SI
	AND	SI,000FH

;	DS:SI = transfer address, ES:DI = MDISK address, DX = count

	MOV	CS:WORD PTR SECCNT,DX	; Set in count

;	Transfer sector between DS:SI and ES:DI

MD_IO3:
	MOV	CX,CS:WORD PTR SECCNT
	JCXZ	MD_IO9			; If count extinguished
	CMP	CX,128
	JL	MD_IO3X
	MOV	CX,127			; Max count / transfer
MD_IO3X:
	PUSH	ES
	PUSH	DS
	PUSH	SI
	PUSH	DI
	TEST	CS:BYTE PTR TFLAG,0FFH
	JZ	MD_IO4

;	Is a write request, from DS:SI to ES:DI

MD_IO3A:
	PUSH	CX
	MOV	BX,CX
	MOV	CX,8
	SHL	BX,CL
	MOV	CX,BX
	REP	MOVSW			; Move it in
	POP	CX
	JMP	MD_IO5

MD_IO4:
	PUSH	ES
	PUSH	DS
	POP	ES
	POP	DS			; Swap DS, ES
	XCHG	SI,DI
	JMP	MD_IO3A			; Reverse and transfer

MD_IO5:
	POP	DI
	POP	SI
	POP	DS
	POP	ES
	PUSH	CX
	MOV	BX,CX
	MOV	CL,5			; Left 9 and right 4
	SHL	BX,CL
	POP	CX
	MOV	AX,DS
	ADD	AX,BX		; Next transfer and sector
	MOV	DS,AX
	MOV	AX,ES
	ADD	AX,BX		;   values
	MOV	ES,AX
	SUB	CS:WORD PTR SECCNT,CX
	JMP	MD_IO3			; Do next

;	End of transfer

MD_IO9:
	POP	DX
	POP	DS
	JMP	MD_SUCC
MD_IO	ENDP

;*	DATA areas

MDISK_START	DW	0		; Start segment of MDISK
PTRSAV	DD	0			; Request packet address
SAVESS	DW	?			; Old stack save
SAVESP	DW	?
TFLAG	DB	0			; 0 = read, 1 = write

SECCNT	DW	?

	DW	128 DUP (?)
MYSTACK	LABEL	NEAR

;	End of resident code/data

MD_END	LABEL	NEAR


MDISK_RESIDENT	DW	?		; Paragraph after resident MDISK
MD_KBYTES	DW	MD_DEFAULT	; Size of MDISK

;	Error messages
SIZE_ERROR	DB	CC_BEL, CC_CR, CC_LF, "Invalid MDISK size requested, "
		DB	"assigning a size of 32 kilobytes.", CC_CR, CC_LF, "$"
START_ERROR	DB	CC_BEL, CC_CR, CC_LF, "Invalid MDISK start address requested, "
		DB	"address will be ignored.", CC_CR, CC_LF, "$"

;	Message for announcing drive letter
DRIVE_MSG	DB	CC_CR, CC_LF, "MDISK installed as drive "
DRIVE		DB	?, ":", CC_CR, CC_LF, "$"

COUNT		DW	?	; Count of characters in command line search string

;	Command line parameter strings
SIZE_STRING	DB	LEN_SIZE, "SIZE"
LEN_SIZE	=	(OFFSET $ - OFFSET SIZE_STRING) - 1

START_STRING	DB	LEN_START, "START"
LEN_START	=	(OFFSET $ - OFFSET START_STRING) - 1

START_FLAG	DB	FALSE		; Flag for start address specified

DELIMS		DB	CC_SP, CC_HT, CC_CR	; Delimiters for parsing
NUM_DELIMS	=	OFFSET $ - OFFSET DELIMS


;	The following tables determine the characteristics of the MDISK
;	The user entered size is compared against the "break" points
;	defined below, and the appropriate entries from the number
;	of directories table and the fat size table are selected.

MD_SIZE	DW	64
	DW	128
	DW	256
	DW	512
MD_SIZE_END	=	OFFSET $ - OFFSET MD_SIZE

MD_DIRS	DW	16		; MD_MINIMUM <= size <64K
	DW	32		; 64K <= size < 128K
	DW	64		; 128K <= size < 256K
	DW	128		; 256K <= size < 512K
	DW	256		; 512K <= size < MD_MAXIMUM

;	This table contains the number of fat sectors needed for a 
;	given size disk. It is calculated by the following formulae:
;
;	BPS = bytes per sector
;	SPAU = Sectors per allocation unit
;	DIRENTS = Number of directory entries
;	SIZE = Size of disk in Kb
;	RES = Number of reserved sectors
;	DIRSECS = Number of directory sectors
;	NAU = Number of allocation units
;	FATBYTES = Number of bytes in the FAT
;	FATSECS = Number of sectors in the FAT
;
;
;	DIRSECS = INT((DIRENTS * 32 + BPS - 1) / BPS)
;	NAU = ((1024 * SIZE / BPS) - RES - DIRSECS) / SPAU
;	FATBYTES = NAU * 3 / 2 + 3
;	FATSECS = INT((FATBYTES + BPS - 1) / BPS)
;
;	Note this formula slightly overestimates the size of a FAT.
;
MD_FATSECS LABEL WORD
	DW	1		; MD_MINIMUM <= size <64K
	DW	1		; 64K <= size < 128K
	DW	2		; 128K <= size < 256K
	DW	3		; 256K <= size < 512K
	DW	4		; 512K <= size < MD_MAXIMUM

;*	MD_INIT - Initialize device
;
;	Return DS:DX = dword pointer to end of driver, after
;	allocating any buffer space. The next drive will be
;	installed starting at this location (Much like the
;	DS:DX usage of a terminate/stay resident system call
;

MD_INIT	LABEL	NEAR

;	Locate starting MDISK paragraph

	MOV	AX,CS
	MOV	DS,AX
	MOV	DX,OFFSET MD_END + 15
	MOV	CX,4
	SHR	DX,CL
	ADD	AX,DX			; AX = our segment
	MOV	MDISK_RESIDENT,AX	; End of resident code
	MOV	MDISK_START,AX		; Default start address of MDISK

;	Parse the command line

	CALL	MD_PARSE

;	Determine the correct set of parameters for the BPB

	MOV	AX,MD_KBYTES
	MOV	SI,0

MD_INIT1:
	CMP	AX,MD_SIZE[SI]		; Check the disk size against the table
	JB	MD_INIT2
	ADD	SI,2
	CMP	SI,MD_SIZE_END
	JNZ	MD_INIT1

;	Set up the MDISK BPB

MD_INIT2:
	SHL	AX,1			; Get size of disk, assume 512 byte sectors
	MOV	MDISK_BPB+BPB_SECS,AX	; Store disk size

	MOV	AX,MD_DIRS[SI]		; Get number of directories and save
	MOV	MDISK_BPB+BPB_DIRENTS,AX

	MOV	AX,MD_FATSECS[SI]	; Get number of FAT sectors and save
	MOV	MDISK_BPB+BPB_FATSECS,AX

;	Reserve the necessary memory for the disk

	MOV	AX,MDISK_RESIDENT	; Get address of end of resident code
	CMP	BYTE PTR START_FLAG,TRUE ; Is start address specified?
	JZ	MD_INIT3		; Yes, don't reserve any space
	MOV	DX,MD_KBYTES		; No, add in space for MDISK
	MOV	CL,6
	SHL	DX,CL			; Convert size from K to paragraphs
	ADD	AX,DX			; Size in 16 byte blocks
MD_INIT3:
	XOR	DX,DX
	MOV	ES:WORD PTR CIN_UNITS[BX],1	; One unit
	MOV	ES:WORD PTR CIN_KADDR[BX],DX	; Break address
	MOV	ES:WORD PTR CIN_KADDR[BX+2],AX	;  dword
	MOV	ES:WORD PTR CIN_BADDR[BX],OFFSET MDISK_BPBVEC
	MOV	ES:WORD PTR CIN_BADDR[BX+2],CS

;	Inform the user which drive the MDISK is

	MOV	AH,DOSF_GETDISK		; Get current disk
	INT	21H
	MOV	DL,AL
	MOV	AH,DOSF_SELDISK		; Select disk, number of drives returned in AL
	INT	21H

	ADD	AL,'A'			; Make into a letter
	MOV	DRIVE,AL		; Save in message and print it
	MOV	DX,OFFSET DRIVE_MSG
	MOV	AH,DOSF_OUTSTR
	INT	21H
	JMP	MD_INIT4		; Finish init. overwrite transient code

;	MD_PARSE - Parse the command line
;
;	ENTRY:	ES:BX - DOS Packet
;
;	EXIT:	None
;
;	USES:	ES:BX unchanged
;
MD_PARSE	PROC	NEAR

	PUSH	ES			; Save packet pointer
	PUSH	BX
	LES	DI,ES:[BX+CIN_BADDR]	; Get pointer to input string
	CALL	SKIP_WHITE		; Skip over white space
	MOV	SI,OFFSET SIZE_STRING	; Pass string to match
	CALL	MATCH			; Try to match string
	JNZ	MD_1			; No, try next one
	CALL	DO_SIZE			; Yes, get size of MDISK
MD_1:
	MOV	SI,OFFSET START_STRING	; Pass string to match
	CALL	MATCH			; Try to match string
	JNZ	MD_2			; No, try next one
	CALL	DO_START		; Yes, get size of MDISK
MD_2:
	POP	BX
	POP	ES
	RET

MD_PARSE	ENDP


;	SKIP_WHITE - Skip white space (tabs and spaces)
;
;	ENTRY:	ES:DI string (terminated by CC_CR)
;
;	EXIT:	ES:DI - pointer to first non-white char in string
;
SKIP_WHITE	PROC	NEAR

	CMP	BYTE PTR ES:[DI],CC_SP		; Skip over spaces and
	JZ	SW1
	CMP	BYTE PTR ES:[DI],CC_HT		; skip over tabs
	JZ	SW1
	RET
SW1:
	INC	DI
	JMP	SHORT	SKIP_WHITE

SKIP_WHITE	ENDP

;	MATCH - 
;
;	ENTRY:	DS:SI - Pointer to string to match
;		ES:DI - Pointer to command line
;
;	EXIT:	'Z' Set - string found
;		    ES:DI - Points to cahr. after matched string
;
;		'Z' Clear - string not found
;		    ES:DI - Unchanged
;
;		All other registers unchanged
;
MATCH	PROC	NEAR

	PUSH	AX
	PUSH	ES
	PUSH	DI

;	Prepare for search

	LODSB			; Get count and save it
	SUB	AH,AH
	MOV	COUNT,AX
	MOV	AL,DS:[SI]	; Try to match first character

;	Try to match the first character in the search string

MATCH1:
	CMP	BYTE PTR ES:[DI],CC_CR	; At end of string?
	JZ	MATCH4			; Yes exit
	CMP	AL,ES:[DI]		; No, does first char match?
	JZ	MATCH2			; Yes, try to match string
	INC	DI			; No, try next character
	JMP	MATCH1

;	First character matches, try to match string

MATCH2:	
	PUSH	SI			; Save old pointers in case no match
	PUSH	DI
	MOV	CX,COUNT
	REPZ	CMPSB			; Check if strings match
	JZ	MATCH3			; yes, exit
	POP	DI			; No, restore pointers
	POP	SI
	INC	DI			; Bump past matching character
	JMP	MATCH1			; Try to match first character again

;	String was matched, clean up and set 'Z' flag

MATCH3:
	ADD	SP,8		; Get rid of garbage on the stack
	SUB	AX,AX		; Ensure Zero flag set
	POP	AX
	RET

;	String was not matched, restore registers and clear 'Z' flag

MATCH4:
	SUB	AL,AL
	INC	AL
	POP	DI
	POP	ES
	POP	AX
	RET

MATCH	ENDP

;	DO_SIZE - Process the SIZE= command 
;
;	ENTRY:	ES:DI - Points to first char after string "SIZE"
;
;	EXIT:	MD_KBYTES - Size of MDISK in Kilobytes
;
DO_SIZE	PROC	NEAR

	CALL	SKIP_WHITE		; Skip white space
	CMP	BYTE PTR ES:[DI],'='	; Make sure an equals sign is there
	JNZ	DS2			; No, error do no size
	INC	DI			; Skip over =
	CALL	SKIP_WHITE		; Skip white
	CALL	GET_DECIMAL		; Get a decimal number

;	Ensure correct MDISK size

	CMP	AX,MD_MINIMUM		; Is disk less than minimum
	JB	DS2			; Yes, Notify user
DS1:
	CMP	AX,MD_MAXIMUM		; No, is disk greater than max. 
	JBE	DS3			; No, skip

;	Invalid MDISK size, notify user and make MDISK the minimum

DS2:
	MOV	DX,OFFSET SIZE_ERROR
	MOV	AH,DOSF_OUTSTR
	INT	21H
	MOV	AX,MD_MINIMUM

;	Return size in Kbytes

DS3:
	MOV	MD_KBYTES,AX
	RET

DO_SIZE	ENDP

;	DO_START - Process the START= command
;
;	ENTRY:	ES:DI pointer to char after string "START"
;
;	EXIT:	MDISK_START - Start paragraph of MDISK
;		START_FLAG - Flag for start address specified
;
DO_START	PROC	NEAR

	CALL	SKIP_WHITE		; Skip white space
	CMP	BYTE PTR ES:[DI],'='	; Make sure an equals sign is there
	JNZ	DST1			; No, error don't do start
	INC	DI			; Skip over =
	CALL	SKIP_WHITE		; Skip white
	CALL	GET_HEX			; Get a hexadecimal number
	OR	AX,AX
	JZ	DST1
	MOV	MDISK_START,AX		; Set MDISK address
	MOV	START_FLAG,TRUE		; Flag as specified start address
	RET
DST1:
	MOV	DX,OFFSET START_ERROR	; Tell user error in start address
	MOV	AH,DOSF_OUTSTR
	INT	21H
	RET

DO_START	ENDP

;	GET_HEX - Get a hexadecimal number
;
;	ENTRY:	ES:DI pointer to string
;
;	EXIT:	AX - Number (errors return as 0)
;
GET_HEX	PROC	NEAR

	PUSH	CX
	MOV	CX,16
	JMP	SHORT	GD0

GET_HEX	ENDP

;	GET_DECIMAL - Get a decimal number
;
;	ENTRY:	ES:DI pointer to string
;
;	EXIT:	AX - Number (errors return as 0)
;
GET_DECIMAL	PROC	NEAR

	PUSH	CX
	MOV	CX,10
GD0:
	PUSH	BX
	PUSH	DX

	SUB	BX,BX		; BX will hold number

;	Get character and turn it into a digit

GD1:
	MOV	AL,ES:[DI]	; Get a character
	CALL	DELIM		; Check if delimiter
	JZ	GD3		; Yes, exit
	CMP	AL,'A'		; Prepare for hex number
	JB	GD1A
	CMP	AL,'F'
	JA	GD1A
	SUB	AL,'A'-(10+'0')	; Make hex digit
GD1A:
	SUB	AL,'0'		; Make it a number
	JS	GD2		; Error if below 0
	CMP	AL,CL		; Check if it is above the maximum digit
	JAE	GD2		; Error, invalid character
	INC	DI		; Character good, advance pointer

;	Update number

	XCHG	AX,BX		; Prepare for shifting number
	SUB	DX,DX
	MUL	CX
	SUB	BH,BH		; Add new digit to old number
	ADD	BX,AX
	ADC	DX,0		; Check for overflow
	JZ	GD1		; No, return for more digits

;	Error, not a valid number. Return 0

GD2:
	SUB	BX,BX		; Yes, return 0

GD3:
	MOV	AX,BX		; Return value in AX
	POP	DX
	POP	BX
	POP	CX
	RET

GET_DECIMAL	ENDP

;	DELIM - Check for delimiter character
;
;	ENTRY:	ES:DI points to character to check
;
;	EXIT:	'Z' set, char was delimiter
;		'Z' clear, char was not a delimiter
;
DELIM	PROC	NEAR

	PUSH	CX
	PUSH	DI
	PUSH	ES
	PUSH	CS
	POP	ES

	MOV	DI,OFFSET DELIMS
	MOV	CX,NUM_DELIMS
	REPNZ	SCASB

	POP	ES
	POP	DI
	POP	CX
	RET

DELIM	ENDP	

CODE	ENDS
	END	MDISK			; End of program
