NMI_FUNCTIONS	LABEL	WORD
	DW	OFFSET LOW_BATTERY_2
	DW	OFFSET CURSOR_UPDATED
	DW	OFFSET EL_PANEL
	DW	OFFSET CLOCK_ICON
	DW	OFFSET PHONE_ICON
	DW	OFFSET DISK_ICON
	DW	OFFSET CALCULATIR_ICON

NMI_STATUS_MAX	EQU	($-NMI_FUNCTIONS)



NMI_INTERRUPT	PROC	FAR

	PUSHREG	<AX,BX,DX>

	MOV	AL,NMI_STATUS_REGISTER	;Find out what caused the interrupt
	MOV	DX,COLOR_CARD		;Address the NMI status register
	OUT	DX,AL
	INC	DX
	IN	AL,DX			;Get the status (index to a routine)
	SUB	AL,2			;Make it 0 based.
	CMP	AL,NMI_STATUS_MAX	;Is it in range?
	JA	NMI1			;No, exit
	MOV	BL,AL			;Use it as an index the the appropriate routine
	SUB	BH,BH
	CALL	NMI_FUNCTIONS[BX]

NMI1:
	MOV	DX,COLOR_CARD+1		;Acknowlege the interrupt
	MOV	AL,0			;Send a 0 to the status port
	OUT	DX,AL
	POPREG	<DX,BX,AX>
	IRET

NMI_INTERRUPT	ENDP

LOW_BATTERY_2	PROC	NEAR
	RET
LOW_BATTERY_2	ENDP


CURSOR_UPDATED	PROC	NEAR
	RET
CURSOR_UPDATED	ENDP


EL_PANEL	PROC	NEAR
	RET
EL_PANEL	ENDP

CLOCK_ICON	PROC	NEAR
	RET
CLOCK_ICON	ENDP


PHONE_ICON	PROC	NEAR
	RET
PHONE_ICON	ENDP


DISK_ICON	PROC	NEAR
	RET
DISK_ICON	ENDP


CALCULATOR_ICON	PROC	NEAR
	RET
CALCULATOR_ICON	ENDP

