/*
                RESTRICTED RIGHTS LEGEND
		------------------------
	
	    "Use, duplication, or disclosure by the
	Government is subject to restrictions as set forth
	in paragraph (b) (3) (B) of the Rights in Technical
	Data and Computer Software clause in DAR
	7-104.9(a).  Contractor/manufacturer is Zenith
	Data Systems Corporation of Hilltop Road, St.
	Joseph, Michigan 49085.

*/
/*
	This program is the backup/restore facility for Z-DOS.
	This code is contained in the source file BR1.C
	The remainder of the code and definitions needed for 
	compilation and linkage of these programs are:
	    CTYPE.H
	    STDIO.H
	    CONIO.H
	    BRSTRUCT.H
	    BR2.C
	    BR3.ASM
	    BR4.ASM
	    BR5.ASM
	and of course C.OBJ and LC.LIB from the "C" package.
	The batch files used to compile and link BACKUP/RESTORE
	are CBACKUP.BAT and CRESTORE.BAT
	
	Note: this program MUST be compiled with the -b switch
	      on pass 1 of the Lattice compiler.

    Written by: Bob Meinschein - Zenith Data Systems
    Date:	11-5-82

    Copyright (C) Zenith Data Systems 1983

    Modified 3-11-83 by: Brian Barnes - Zenith Data Systems
	include Z-DOS 2.00 Directory path traversal. Note this
	requires linkage of the ZC.LIB library as well as LC.LIB.
	ZC.LIB contains the new 2.00 system calls.

    9/27/83 - RJM: Used for the Z150 computer, file BR5.ASM used
    	      in the Z100 version no longer needed. Dynamic drive
	      prompting added.

*/

    
/*
    This routine passes the input line to BACKUP/RESTORE
*/
_MAIN(line)
char *line;
{
    main(line);
    exit(0);
}

/*
    This is the main loop for BACKUP/RESTORE
*/
#define main_debug FALSE
main(line)
char *line;
{
extern char *in_buf, *out_buf;
extern char dr_default, num_drive;
extern char msg_gen;
extern char *parms[], sw_list[];
#if !BACKUP
extern int drive_map[];
#endif
extern unsigned today;
#if BACKUP
extern char stamp_flag[];
#endif
char error, com_flag = FALSE;     /* flag for command line */
int num;
struct buffer com_line;		/* command buffer */
unsigned tdate();


/* initialize some things */
signon();			/* print signon message */
today = tdate();		/* get todays date */
msg_gen = TRUE;			/* set up for generation of messages */

dr_default = (char) bdos(CUR_DISK) + 1;	/* get default drive */
num_drive = bdos(SEL_DISK, dr_default-1);	/* Get the number of block devices */
com_line.buf_len = COMLEN;		/* set input line length */


/*
*
*   If the number of files backup can operate upon is desired,
*   then set the following conditional compilation to TRUE.
*   Note: To test this, BACKUP should be run on a 128K machine.
*	  Also this figure is a ball park figure, the real number
*	  of files is slightly less.
*
*/
#define MAX_BACK FALSE
#if MAX_BACK
    allmem();
    printf("The maximum number of files that BACKUP can operate on\r\n");
    printf(" is %d\r\n", (sizmem()/sizeof(struct link_file)) * 2);
#endif


#if BACKUP
/* all stamp flags to FALSE */
for (num = 0; num < num_drive; ++num) stamp_flag[num] = FALSE;
#endif

/* Find out if a command line was typed and set flag if so */

while (*(++line) == ' ');	/* skip blanks */
if (*line != '\0') com_flag = TRUE;

#if main_debug
printf("MAIN: com_flag %d , line:%s\n\r", com_flag, line);
#endif

/* Get a command line */

do
{
    if (com_flag) strcpy((char *) &com_line.buf, line);	/* copy command */
    else get_inp(&com_line);		/* get a line from the user */

#if main_debug
printf("MAIN: com_line %s \r\n", &com_line.buf);
#endif

/* delimit the command line into 1, 2 or 3 parameters */

    num = delim(parms, (char *)&com_line.buf);

#if main_debug
printf("MAIN: num delim %d \r\n", num);
#endif

    if (num != -1)
    {
	error = switches();  		/* set switches */
	if (!error) /* skip to end if error */
	{
	    if (num != 0)		/* skip to end if no parameters */
	    {
		if(((num == 1) && strlen(parms[0]) == 1 && *parms[0] == '?'))
			help();
		else if (sw_list[D]) bsd();
		else if(sw_list[L]) 
		    list();

	/*   backup/restore files  */

		else br();
	    }
	}
    }
    if (parms[NUM_PAR-1] != NULL) rls_mem(parms[NUM_PAR-1],
		    (unsigned) strlen(parms[NUM_PAR-1]) + 1);
    if (num == 0) break;	/* exit on NULL input (carraige return) */
}
    while (!com_flag);
}
/*
    This routine will print out a help screen
*/
help()
{

#if BACKUP

printf("\r\n");
printf("The BACKUP  utility is  designed to take  any number of source\r\n");
printf("files and put  them into  a single,  long file that may extend\r\n");
printf("across several volumes.  The source file can  originate on any\r\n");
printf("readable device. The backup destination is any device that can\r\n");
printf("be written to except CON and PRN.\r\n");
printf("\r\n");
printf("Syntax: A:BACKUP [<filespec>[+<filespec>...] [<d:>]<filename>][</x>...]\r\n");
printf("\r\n");
printf("      Switches: Default state: /F off, /Q off, and /V off.\r\n");
printf("\r\n");
printf("/A AFTER date.  /A:<mm-dd-yy>         /N NO formatting.\r\n");
printf("/B BEFORE date. /B:<mm-dd-yy>         /Q QUERY each.\r\n");
printf("/D DIRECTORY master.                  /R REVIEW selected files.\r\n");
printf("/E EXCEPTION files.                   /T TODAY's date.\r\n");
printf("/F FORMAT silent.                     /V VERIFY files.\r\n");
printf("/G GLOBAL subdirectories.             /W WRITTEN files only.\r\n");
printf("/L LIST directory. <filespec>/l\r\n");
#else

printf("\r\n");
printf("The RESTORE utility  is designed to complement  the BACKUP\r\n");
printf("utility. RESTORE extracts specified  files from the single\r\n");
printf("long file that BACKUP creates; then it returns those files\r\n");
printf("to their original drives.\r\n");
printf("\r\n");
printf("Syntax: A:RESTORE [[<d:>]<filename> [<filespec>[+<filespec>...]]][</x>...]\r\n");
printf("\r\n");
printf("      Switches: Default state: /O off, /Q off and /V off.\r\n");
printf("\r\n");
printf("/A AFTER date.  /A:<mm-dd-yy>         /M MAP output drive. /M:lp\r\n");
printf("/B BEFORE date. /B:<mm-dd-yy>         /O OVERWRITE files.\r\n");
printf("/D DIRECTORY master.                  /Q QUERY each.\r\n");
printf("/E EXCEPTION file.                    /R REVIEW selected files.\r\n");
printf("/F FLAT restoration.                  /T TODAY's date.\r\n");
printf("/L LIST directory. <filespec>/L       /V VERIFY files.\r\n");
#endif

return;
}
/* 
    This routine will print the Zenith signon message and version
    number.
*/
signon()
{
#if ZENITH
    puts("\r\n              ");
#endif
#if NBI
    puts("\r\n     ");
#endif

#if SYNTREX
    puts("\r\n       ");
#endif

#if BACKUP
    printf("BACKUP version %.2f\r\n",RELEASE);
#else
    printf("RESTORE version %.2f\r\n",RELEASE);
#endif

#if ZENITH
    printf("Copyright(C) 1983 Zenith Data Systems Corporation\r\n");
#endif

#if NBI
    printf("(C)Copyright NBI, Inc. 1984\r\n");
#endif

#if SYNTREX
    printf("(C)Copyright SYNTREX, Inc. 1986\r\n");
#endif

    in_buf = (char *) malloc(BUF_SIZ);
    out_buf = (char *) malloc(BUF_SIZ);

    return;
}

/*  routine to get a line of input from the user */
get_inp(in_buf)
struct buffer *in_buf;
{
    static int prompt = '>';	/* prompt character	*/
    char *p, *cgets();
    putch(prompt);		/* output prompt	*/
    p = cgets((char *) in_buf);		/* get response		*/
    putch('\r');
    putch('\n');
}

/*  This routine will parse the switches and set flags for the
    ones it finds. It will also get necessary parameters when
    one is required with the switch.
*/
#define sw_debug FALSE
switches()
{
    extern unsigned before, after;
    extern char sw_list[], *parms[], *xcpt_ptr;
    char *p1, *p2, badsw[3], c, d;
    int i, ret, error = FALSE;
    
    /* set all switches to off */
    for (i = 0; i < NUM_SW; ++i) sw_list[i] = FALSE;

    /* if no switches return */
    if ((p1 = parms[NUM_PAR - 1]) == NULL) return(FALSE);
	
    while (*p1 != '\0')
    {
	c = '\0';
	p2 = p1 + 1;
	if (isalpha(*p2))	/* get switch letter */
	{
	    if (islower(*p2)) *p2 = toupper(*p2);
	    c = *p2;
	    switch (c)
	    {
		case 'A':	/*  get date  */
		    error = scan_date(p2, &after);
		    break;
		case 'B':	/*  get date  */
		    error = scan_date(p2, &before);
		    break;
#if !BACKUP
		case 'M':	/*  Do output drive mapping */
		    if (*(p2 + 1) != ':')
		    {
			printf("Invalid output mapping specifications.\r\n");
			error = TRUE;
		    }
		    else
		    {
			error = mapdrv((char) *(p2+2),(char) *(p2+3));
		    }
		    break;
#endif
		case 'E':	/*  exception processing */
		    if (*(p2 + 1) != ':')
		    {
			printf("Invalid exception file specifications.\r\n");
			error = TRUE;
		    }
		    else
		    {
			xcpt_ptr = p2 + 2;  /* point to begining of string */
			while (*xcpt_ptr != zchrop(0,0) && *xcpt_ptr != '\0') ++xcpt_ptr;
			d = *xcpt_ptr;		/* make into "C" string */
			*xcpt_ptr = '\0';
			ret = pre_scan(p2+2);  /* validate afn's */
			*xcpt_ptr = d;
			if (ret) xcpt_ptr = p2 + 2;
		    	else
			{
			    printf("Invalid exception file specifications.\r\n");
			    error = TRUE;
			}
		    }
		    break;

/*	Unused switches	*/

#if !BACKUP
		case 'G':	/* Only allowed for backup */
		case 'W':	/* Only allowed for backup */
#endif
#if BACKUP
		case 'M':	/* Only allowed for restore */
#endif
		case 'C':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'P':
		case 'S':
		case 'U':
		case 'X':
		case 'Y':
		case 'Z':
		    badsw[0] = zchrop(0,0);
		    badsw[1] = c;
		    badsw[2] = '\0';
		    error = TRUE;
		    printf("Invalid switch %s specified.\r\n", badsw);
		    break;
	    }
	    if (!error) sw_list[c - 'A'] = TRUE;
	}
	else
	{
	    badsw[0] = zchrop(0,0);
	    badsw[1] = c;
	    badsw[2] = '\0';
	    error = TRUE;
	    printf("Invalid switch %s specified.\r\n", badsw);
	}
	p1 = p2;
	while (*p1 != zchrop(0,0) && *p1 != '\0') ++p1;
    }

#if sw_debug
for (i = 0; i < NUM_SW; ++i)
    printf("SWITCHES: %c %d %s",(char) (i+'A'), sw_list[i], 
	(i%5==4 ||i == NUM_SW - 1) ? "\r\n": " ");
#endif
    
    return(error);
}
#if !BACKUP
/*
    This routine maps the drive in dr1 to the output of dr2
*/

mapdrv(dr1,dr2)
char dr1, dr2;
{
    int d1, d2;

    if ((dr1 == '\0') || (dr2 == '\0'))
	return(TRUE);
    if (islower(dr1))
        d1 =  toupper(dr1) - 'A' + 1;
    else
	d1 = dr1 - 'A' + 1;
    if (islower(dr2))
        d2 =  toupper(dr2) - 'A' + 1;
    else
	d2 = dr2 - 'A' + 1;
    if ((d1 < 0) || (d1 > 16) || (d2 < 0) || (d2 > 16))
	return(TRUE);
    drive_map[d1]=d2;
    return(FALSE);
}
#endif
/*
    This routine will scan an ambiguous file specification and
    return TRUE if it is a valid specification else FALSE is 
    returned.
*/
pre_scan(ptr)
char *ptr;
{
    extern char msg_gen;
    struct ext_fcb e_fcb;
    int ret;
    char *p1, c;
    
    msg_gen = FALSE;	/* keep scan_afn from putting out messages */
    while (*ptr != '\0')
    {
	p1 = ptr;
	while (*p1 != '+' && *p1 != '\0') ++p1; /* scan for single afn */
	c = *p1;	/* make into "C" string */
	*p1 = '\0';
	ret = scan_afn(ptr, &e_fcb);	/* validate afn */
	*p1 = c;
	if (ret == ERROR) 
	{
	    msg_gen = TRUE;
	    return(FALSE);
	}
	ptr = p1;	/* get next afn */
	if (*ptr == '+') ++ptr;
    }
    msg_gen = TRUE;	/* allow scan_afn to put out error messages */
    return(TRUE);
}

/* 
    This routine will scan the date on an input switch and return 
    TRUE is the date is invalid else FALSE and the date will be set 
    appropriately.
*/
scan_date(ptr, date)
char *ptr;
unsigned *date;
{
    extern unsigned today;
    unsigned put_date();
    char *p, c;
    
    ++ptr;	/* get to and check for a ':' */
    if (*ptr != ':') 
    {
	if (*ptr != '/' && *ptr != '\0')
	{
	    printf("Invalid date in switch.\r\n");
	    return(TRUE);
	}
	*date = today;
	return(FALSE);
    }
    ++ptr;	/* skip ':' */
    p = ptr;
    while (*p != '/' && *p != '\0' && *p != ' ') ++p; /* scan for end of date */
    c = *p;
    *p = '\0';		/* make into "C" string */
    *date = put_date(ptr);
    *p = c;
    if (*date != 0) return(FALSE);
    printf("Invalid date in switch.\r\n");
    return(TRUE);
}

/*  
    This routine will delimit NUM_PAR parameters in an input line.
    It will set up pointers in a pointer array, the last entry will
    be the pointer for switches (if they exist).
*/
#define del_debug FALSE
delim(parms, line)
char *parms[], *line;
{
    char *p, *get_mem(), *p1;
    int i, len, count = 0;

#if del_debug
printf("DELIM: got here, line:%s\r\n", line);
#endif
    /* null out the parameter array */
    
    for (i = 0; i < NUM_PAR; ++i) parms[i] = NULL;
    
    /* get text pointer and process input line */
    
    p = line;
#if del_debug
 printf("DELIM: p points to:%s\r\n", p);
#endif

    while (*p == ' ') ++p;
    while (*p != '\0')
    {
#if del_debug
 printf("DELIM: char is :%c\r\n", *p);
#endif
	    /*
		If a '/' then the rest is switches so get
		some memory and save them
	    */
	if (*p == zchrop(0,0))
	{
	    len = strlen(p);
	    parms[NUM_PAR - 1] = get_mem((unsigned) (len+1));
	    strcpy(parms[NUM_PAR - 1], p);
	    *p = '\0';			/* for previous parameter */
#if del_debug
for (i = 0; i < NUM_PAR; ++i)
    if(parms[i] != NULL) printf("DELIM:parm %d = %s \r\n", i, parms[i]);
#endif
	    return(count + 1);
	}
    
	    /*  have an actual parameter, delimit it  */
#if del_debug
 printf("DELIM: found actual:%s\r\n", p);
#endif
    
	parms[count++] = p;
	while (*p != ' ' && *p != '\0' && *p != zchrop(0,0)) ++p;
	if (*p == ' ')
	{
	    p1 = p;
	    while (*p1 == ' ') ++p1;
	    if (count == (NUM_PAR - 1) && *p1 !=zchrop(0,0) && *p1 != '\0')
	    {
		printf("Too many parameters specified.\r\n");
		return(-1);
	    }
	    *p = '\0';
	    ++p;
	}
    }

#if del_debug
for (i = 0; i < NUM_PAR; ++i)
    if(parms[i] != NULL) printf("DELIM:parm %d = %s \r\n", i, parms[i]);
#endif
    
    return(count);
}

/*
    This routine will list what files are contained in a specified
    backup file as well as the date and size of the files
*/
list()
{
    extern struct br_entry br_id;
    extern char *parms[], *in_buf, *in_ptr, *last_in;
    extern char cur_vol;
    char *fname, *get_fname(), *date, *get_date();
    struct file_entry f_ent;
    struct br_entry br_ent;
    char line[80];	/* output line for ^S and ^Q */
    unsigned files, vols;	/* number of files and volumes */
    int i;

    if (parms[0] == NULL)
    {
	printf("Not enough parameters specified.\r\n");
	return;
    }
    if (scan_ufn(parms[0]) == ERROR) return;
    if (!file_open(&br_id.fcb))
    {
	fname = get_fname(&br_id.fcb);
	printf("Can not find master backup file %s.\r\n", fname);
	rls_mem(fname, (unsigned) FNAME_SIZE);
    }
    else
    {
	cur_vol = 0;	/* start at master volume */
	clear_inp();	/* empty input buffer */
	if (get_buf(&br_id.fcb, (char *) &br_ent, 
			sizeof(struct br_entry)) != 0) 
	{
	    if(!br_verify(&br_ent))
		printf("Invalid backup file.\r\n");
	    else
	    {
		files = br_ent.num_files;
		vols = 0;
		for (i = 0; i < 3; ++i) vols = 10*vols+br_ent.fcb.ext[i]-'0';
		printf("Drive     Filename          Date       Start ");
		printf("      End           Size in\r\n");
		printf("                                       Volume");
		printf("     Volume          bytes\r\n");
		if (get_all(&br_id.fcb, (char *) &f_ent,
			 sizeof(struct file_entry)) != 0)
		do
		{
		    fname = get_fname(&f_ent.fcb);
		    date = get_date(f_ent.fcb.date);
		    putch(' ');
		    putch(*fname);
		    putch(*(fname+1));
		    if ((f_ent.fcb.attr & attr_dir) != 0) {
			sprintf(line, "       %-12s    %s     <DIR>\r\n",
				fname+2,date);
			cputstr(line);
			}
		    else {
			sprintf(line, "       %-12s    %s      %3d", fname+2,
						date, f_ent.s_vol);
 			cputstr(line);
			sprintf(line, "        %3d          %7ld\r\n", 
					    f_ent.e_vol, f_ent.length);
			cputstr(line);
			}
		    rls_mem(fname, (unsigned) FNAME_SIZE);
		    rls_mem(date, (unsigned) DATE_SIZE);
		    if (get_all(&br_id.fcb, (char *) &f_ent,
			    sizeof(struct file_entry)) == 0) break;
		}
		while(f_ent.id != last_ent);
		printf("%d file(s) on %d volume(s)\r\n", files, vols+1);
	    }
	}
	else printf("Invalid backup file.\r\n");
    }
    file_close(&br_id.fcb);
    return;
}

/*
    This routine will take a string and print it to the console
    character by character so that a "$" will not terminate string
    output.
*/
cputstr(s)
char *s;
{
    while (*s != '\0')
    {
	bdos(PUT_CHAR, *s++);
    }
}

/*
    This routine will locate all backup files on the specified
    drive and list information about them.
*/
bsd()
{
    extern char *parms[], cur_vol, num_drive;	/* parameter list */
    extern unsigned today;
    struct ext_fcb master, e_fcb;	/* for searching the directory */
    struct search_fcb s_fcb;	/* return from directory searches */
    struct br_entry br_ent;	/* information on backup file */
    int i, num_vol;
    char *date, *get_date();
    
    init_fcb(&master);

/*
    find drive letter if it exists
*/

    if (parms[0] != NULL)
    {
	if (islower(*parms[0])) *parms[0] = toupper(*parms[0]);
	if (*(parms[0] + 1) != ':' || *parms[0] < 'A' ||
			*parms[0] > ('A' + num_drive - 1))
	{
	    printf("Invalid drive designation.\r\n");
	    return;
	}
	else master.drive = *parms[0] - ('A' - 1);
    }

    for (i = 0; i < 8; ++i) master.name[i] = '?';	/* get afn */
    for (i = 0; i < 3; ++i) master.ext[i] = '0';	/* get extention */

    bdos(SET_DMA, &s_fcb);	/* set destination for searches */
    if (bdos(SRCH_FIRST, &master) != 0xff) /* found match */
    {
	date = get_date(today);
	printf(" Name                Volumes              Files      ");
	printf("        Date      %s\r\n", date);
	rls_mem(date, DATE_SIZE);
	do
	{
	    copy_fcb(&e_fcb, &s_fcb);	/* make into extended fcb */
	    file_open(&e_fcb);		/* open file */
	    cur_vol = 0;		/* start at master volume */
	    clear_inp();		/* empty input buffer */
	    if (get_buf(&e_fcb, (char *)&br_ent, sizeof(struct br_entry))
			== sizeof(struct br_entry)) /* get file info. */
	    {
		if (br_verify(&br_ent))	/* verify correct backup file */
		{
		    date = get_date(br_ent.fcb.date);
		    num_vol = 0;
		    for (i = 0; i < 3; ++i)
			num_vol = 10 * num_vol + br_ent.fcb.ext[i] - '0';
		    num_vol += 1;
		    printf(" %c:%-.8s           %3d",
		       br_ent.fcb.drive+('A'-1), &br_ent.fcb.name, num_vol);
		    printf("                 %4d             %s\r\n", 
					br_ent.num_files, date);
		    rls_mem(date, (unsigned) DATE_SIZE);
		    file_close(&e_fcb);
		}
	    }
	    bdos(SET_DMA, &s_fcb);
	}
	while(bdos(SRCH_NEXT, &master) != 0xff);
    }
    return;
}
/*
    This routine will recover memory that has been allocated
*/
rls_mem(ptr, size)
char *ptr;
unsigned size;
{
    if(rlsmem(ptr, size) != 0)
    {
	printf("Internal error in returning memory\r\n");
	exit(0);
    }
    return;
}

/*
    This routine will allocate memory from the memory pool.
*/
char *get_mem(size)
unsigned size;
{
    char *ret, *getmem();

    ret = getmem(size);
    if (ret == NULL)
    {
	cputs("         ");
	printf("You have specified too many files for BACKUP sources.\r\n\n");
	cputs("      ");
	printf("Enter more than one BACKUP command to specify these files,\r\n");
	printf("or enter a single BACKUP command specifying fewer files as BACKUP sources.\r\n");
	exit(0);
    }
    return(ret);
}

#if BACKUP

/*
    This routine is the main backup restore routine that
    calls the necessary routines to accomplish the operation.
*/
#define br_debug FALSE
br()
{
    extern struct br_entry br_id;
    extern char *parms[], cur_vol, max_vol, open_flag;
    extern int file_count, dir_count;
    extern unsigned today;
    struct link_file *head, *bld_bdir();
    char *get_fname(), *fname;
    int ret;
 
#if br_debug
printf("BR:Got here");
#endif

    /* verify correct switches for backup */
    if(!sw_ver()) return;
    
    /* if not enough paramters, exit */
    if (parms[0] == NULL || parms[1] == NULL)
    {
	printf("Not enough parameters specified.\r\n");
	return;
    }

    /* check for valid selection afn's */
    if (!pre_scan(parms[0]))
    {
	printf("Invalid selection file specifications.\r\n");
	return;
    }
    
    /* check if valid "ufn" for destination file */
    if (scan_ufn(parms[1]) == ERROR) return;

    /* try to build a directory of files to backup/restore */
    if ((head = bld_bdir(parms[0])) == NULL)
    {
	printf("No files selected.\r\n");
	return;
    }

    if (!display(head))
    {
	free_mem(head);
	return;
    }

    /* set up the backup/restore header record */
    br_id.id = bf_npp;		/* id code */
    br_id.release = RELEASE;	/* Release # */
    br_id.version = VERSION;	/* Version # */
    br_id.num_files = file_count;	/* number of files in b-file */
    br_id.num_dirs = dir_count;		/* number of directories in b-file */
    br_id.fcb.date = today;		/* today's date */

    /* dump the directory to disk, dump the files,
	fix up the directory and return			*/

    cur_vol = 0;
    max_vol = 0;
    if ((ret = form_disk()))
    {
	while (TRUE)
	{
	    if (file_create(&br_id.fcb))
	    {
		if (avail_space(&br_id.fcb)) break;
		else
		{
		    file_close(&br_id.fcb);
		    file_delete(&br_id.fcb);
		    fname = get_fname(&br_id.fcb);
		    printf("\nCan not open master backup file %s,\r\n", fname);
		    printf("not enough space on the disk.\r\n");
		    rls_mem(fname, (unsigned) FNAME_SIZE);
		    if (!(ret = get_disk())) break;
		}
	    }
	    else
	    {
		    fname = get_fname(&br_id.fcb);
		    printf("\nCan not open master backup file %s,\r\n", fname);
		    printf("not enough space on the disk.\r\n");
		    rls_mem(fname, (unsigned) FNAME_SIZE);
		    if (!(ret = get_disk())) break;
	    }
	}
    }
    if (ret)
    {
	open_flag = FALSE;	/* create all backup files */
	if (dmp_dir(head)) /* dump the directory and create all files */
	{
	    if (dmp_files(head))	/* dump the files */
	    {
		if (get_vol((char) 0)) /* get the master volume */
		{
		    br_id.fcb.ranrec = 0L;	/* position to the beginning */
		    open_flag = TRUE;	/* open all backup files*/
		    dmp_dir(head);	/* fix up the directory */
		}
		file_close(&br_id.fcb);
		stamp_disks();		/* stamp dates on disks */
	    }
	}
    }
    free_mem(head);
    return;
}
/*
    This routine will make sure that at least the master directory record
    will be put out to the first disk, to allow /D to work properly.
*/
avail_space(e_fcb)
struct ext_fcb *e_fcb;
{
    char c = 'A';	/* dummy to write to disk */
    int ret;
    
    ret = rwrite(e_fcb, &c, 1);	/* try to write 1 byte */
    e_fcb->ranrec = 0L;		/* reset to beginning of file */
    if (ret == 0) return(FALSE);
    return(TRUE);
}

#else

/*
    This routine is the main backup restore routine that
    calls the necessary routines to accomplish the operation.
*/
br()
{
    extern struct br_entry br_id;
    extern char *parms[], cur_vol, max_vol;
    struct link_file *head, *bld_rdir();
    char *get_fname(), *fname;
 
    /* verify correct switches for backup */
    if(!sw_ver()) return;
    
    /* if not enough paramters, exit */
    if (parms[0] == NULL || parms[1] == NULL)
    {
	printf("Not enough parameters specified.\r\n");
	return;
    }
    
    /* check if valid "ufn" for source file */
    if (scan_ufn(parms[0]) == ERROR) return;
    
    /* check for valid selection afn's */
    if (!pre_scan(parms[1]))
    {
	printf("Invalid selection file specifications.\r\n");
	return;
    }

    cur_vol = 0;
    while (!file_open(&br_id.fcb))
    {
	fname = get_fname(&br_id.fcb);
	printf("\nCan not open master backup file %s, \r\n", fname);
	printf("insert another disk and press RETURN,\r\n");
	printf("or press any other key to abort.\r\n");
	if (chkabrt() == FALSE) return(FALSE);
    }

    /* try to build a directory of files to restore */
    if ((head = bld_rdir(parms[1])) == NULL)
    {
	printf("No files selected.\r\n");
	return;
    }
    
    /* display names being operated on and make sure OK */
    if (display(head))
    {
	/* dump the files, and return */
	dmp_files(head);	/* dump the files */

	file_close(&br_id.fcb);
    }
    free_mem(head);
    return;
}

#endif

/*
    This routine will verify that the correct switches are
    specified for backup or restore. TRUE is returned if the
    switches are valid, else FALSE is returned.
*/
sw_ver()
{
    extern char sw_list[];
    int i;
    char sw_msg[3];
#if BACKUP
    static char bad_sw[] = { O };
#else
    static char bad_sw[] = { N, S };
#endif
#if BACKUP
    if (sw_list[N] && sw_list [F])
    {
	printf("Conflicting switches /F and /N specified.\r\n");
	return(FALSE);
    }
#endif
    for (i = 0; i < sizeof(bad_sw); ++i)
    {
	if (sw_list[bad_sw[i]])
	{
	    sw_msg[0] = zchrop(0,0);
	    sw_msg[1] = 'A' + bad_sw[i];
	    sw_msg[2] = '\0';
	    printf("Invalid switch %s specified.\r\n", sw_msg);
	    return(FALSE);
	}
    }
    return(TRUE);
}
/*
    This routine will take a date in the format of an unsigned Z-DOS
    date entry and return a pointer to a character string that is
    the date. No error checking is done, the entry values are assumed correct
*/
char *get_date(date1)
unsigned date1;
{
    char *date, *get_mem();
    unsigned date2;
    
    date = get_mem((unsigned) DATE_SIZE);	/* get storage */
    date += 8;					/* fill in from the end */
    *date-- = '\0';
    date2 = ((date1 & 0xfe00) >> 9) + 80;	/* get year based at 1980 */
    *date-- = date2 % 10 + '0';			/* fill in year */
    date2 /= 10;
    *date-- = date2 % 10 + '0';
    *date-- = '-';

    date2 = date1 & 0x001f;		/* get day */
    *date-- = date2 % 10 + '0';		/* fill in day */
    date2 /= 10;
    *date-- = date2 + '0';
    *date-- = '-';

    date2 = (date1 & 0x01e0) >> 5;	/* get month */
    *date-- = date2 % 10 + '0';		/* fill in month */
    date2 /= 10;
    if (date2 != 0) *date = date2 + '0';
    else *date = ' ';
return(date);
}
/* 
    This routine will take a character string (i.e. 10-22-82) and change
    it into an unsigned date like used in Z-DOS fcb's. If the date 
    contains an error, a 0 will be returned.
*/
unsigned put_date(date)
char *date;
{
    unsigned date1, date2;
    int i;

    date2 = 0;
    if (*date == ' ') ++date;
    
    /* get month */
    
    while(*date != '\0' && *date != '-')
    {
	if (!isdigit(*date)) return(0);
	date2 = 10 * date2 + (*date++ - '0');
    }
    if (date2 > 12 || date2 < 1) return(0);	/* check for valid month */
    if (*date == '\0') return(0);		/* check for valid string */
    date1 = date2 << 5;			/* position month and save it */
    ++date;		/* skip over delimiter */
    
    /* get day */
    
    date2 = 0;
    while(*date != '\0' && *date != '-')
    {
	if (!isdigit(*date)) return(0);
	date2 = 10 * date2 + (*date++ - '0');
    }
    if (date2 > 31 || date2 < 1) return(0);	/* check valid day */
    if (*date == '\0') return(0);		/* check valid string */
    date1 += date2;			/* save day */
    ++date;		/* skip over delimiter */
    
    /* get year */
    
    date2 = 0;
    while(*date != '\0') 
    {
	if (!isdigit(*date)) return(0);
	date2 = 10 * date2 + (*date++ - '0');
    }
    if (date2 > 1980) date2 -= 1900;
    date1 += (date2 - 80) << 9;			/* save year */
    return(date1);
}
/* 
    This routine will attempt to verify that a valid backup file
    has been opened. If the file is valid a TRUE is returned. If
    not then a FALSE is returned.
*/
br_verify(br_ent)
struct br_entry *br_ent;
{
    extern char num_drive;
    int i;
    char *fname, *get_fname();

    if (br_ent->version > (char)VERSION)
    {
	fname = get_fname(&br_ent->fcb);
#if BACKUP
	printf("Invalid version of BACKUP for file %s\r\n", fname);
#else
	printf("Invalid version of RESTORE for file %s\r\n", fname);
#endif
	rls_mem(fname, FNAME_SIZE);
	return(FALSE);
    }
	
    if (br_ent->id != bf_pp && br_ent->id != bf_npp) return(FALSE);
    if (br_ent->fcb.extend != 0xff) return(FALSE);
    if(br_ent->fcb.drive < 1 || br_ent->fcb.drive > num_drive) return(FALSE);
    
    /* check valid filename */
    for (i = 0; i < 8; ++i)
	if (br_ent->fcb.name[i] == ' ') break;
	else
	    if (!file_char(br_ent->fcb.name[i])) return(FALSE);
    for (i = 0; i < 3; ++i)
	if (br_ent->fcb.ext[i] == ' ') break;
	else
	    if (!file_char(br_ent->fcb.ext[i])) return(FALSE);
    /* all OK */
    return(TRUE);
}

/*
    This routine will attempt to open a disk file. It accepts an FCB
    and returns TRUE if it is opened else FALSE.
*/
file_open(e_fcb)
struct ext_fcb *e_fcb;
{
    return(file_func(e_fcb, FILE_OPEN));
}
/*
    This routine will attempt to create a disk file. It accepts an FCB
    and returns TRUE if it is created else FALSE.
*/
file_create(e_fcb)
struct ext_fcb *e_fcb;
{
    return(file_func(e_fcb, FILE_CREATE));
}
/*
    This function will close a file. It returns TRUE if sucessful
    else FALSE.
*/
file_close(e_fcb)
struct ext_fcb *e_fcb;
{
    if (bdos(FILE_CLOSE, e_fcb) == 0xff) return(FALSE);
    return(TRUE);
}
/*
    This routine will delete a file. It returns TRUE if sucessful
    else FALSE.
*/
file_delete(e_fcb)
struct ext_fcb *e_fcb;
{
    if (bdos(FILE_DELETE, e_fcb) == 0xff) return(FALSE);
    return(TRUE);
}
/*
    This routine will do the actual BDOS call for open and create.
    It returns TRUE is sucessful else FALSE. It also sets the
    random record field to the beginning of the file and the
    record length to 1
*/
file_func(e_fcb, val)
struct ext_fcb *e_fcb;
int val;
{
    if (bdos(val, e_fcb) == 0xff) return(FALSE);
    e_fcb->ranrec = 0L;		/* set beginning of file */
    e_fcb->rec_size = 1;	/* set record size to 1 */
    return(TRUE);
}
/*
    This routine will take an fcb and put the filename into
    a "C" string. It returns a pointer to this string.
*/
char *get_fname(p)
struct ext_fcb *p;
{
    int i;
    char *fname, *get_mem(), *ptr;
    
    fname = get_mem((unsigned) FNAME_SIZE);  /* get some memory for name */
    ptr = fname;
    *ptr++ = p->drive + 'A' - 1;	/* put in drive letter */
    *ptr++ = ':';
    for (i = 0; i < 8; ++i)	/* put in filename */
    {
	if (p->name[i] == ' ') break;
	*ptr++ = p->name[i];
    }
    if (p->ext[0] != ' ')	/* check for extension */
    {
	*ptr++ = '.';		/* put in '.' */
	for (i = 0; i < 3; ++i)		/* put in extension */
	{
	    if (p->ext[i] == ' ') break;
	    *ptr++ = p->ext[i];
	}
    }
    *ptr = '\0';	/* terminate string */
    return(fname);
}

#if BACKUP
/* 
    This routine will return the date that has been stamped on
    a given drive. If no date is stamped a 0 is returned.
*/
unsigned stamp_date(drv)
char drv;
{
    extern char stamp_flag[];
    extern unsigned stamps[];
    unsigned get_stamp();
    
    if (stamp_flag[drv-1]) return(stamps[drv-1]); /* already have date */
    stamps[drv - 1] = get_stamp(drv);	/* get stamp and save it */
    stamp_flag[drv - 1] = TRUE;		/* flag as have stamp */
    return(stamps[drv-1]);		/* return stamp */
}
/*
    This routine will stamp todays date on all disks that were
    referenced in the last backup.
*/
stamp_disks()
{
    return;
}
    
/*
    This routine will stamp the given drive with todays date.
    If the write is unsucessful then the stamp file is deleted.
*/
put_stamp(drv)
char drv;
{
    return;
}
/*
    This routine will get the stamped date off the given drive and
    return it. If no stamp exists then 0 is returned.
*/
unsigned get_stamp(drv)
char drv;
{
    return;
}
/*
    This routine will put the name of the stamp file into an fcb.
*/
stamp_name(p)
char *p;
{
    return;
}
#endif
/*
    This routine will copy a memory image of an entry to a full
    expanded image of an entry.
*/
lnk_ent(lnk, f_ent)
struct link_file *lnk;
struct file_entry *f_ent;
{
    int i;
    
    init_fcb(&f_ent->fcb);
    f_ent->id = lnk->id;
    f_ent->fcb.attr = lnk->attr;
    f_ent->fcb.drive = lnk->drive;
    for (i = 0; i < 8; ++i) f_ent->fcb.name[i] = lnk->name[i];
    for (i = 0; i < 3; ++i) f_ent->fcb.ext[i] = lnk->ext[i];
    f_ent->fcb.date = lnk->date;
    f_ent->s_vol = lnk->s_vol;
    f_ent->e_vol = lnk->e_vol;
    f_ent->s_pos = lnk->s_pos;
    f_ent->length = lnk->length;
    f_ent->level = lnk->level;
    for (i = 0; i < 8; ++i) f_ent->res2[i] = lnk->res[i];
    return;
}
/*
    This routine will copy a full image of an entry to a shortened
    memory image.
*/
ent_lnk(f_ent, lnk)
struct link_file *lnk;
struct file_entry *f_ent;
{
    int i;
    
    lnk->id = f_ent->id;
    lnk->attr = f_ent->fcb.attr;
    lnk->drive = f_ent->fcb.drive;
    for (i = 0; i < 8; ++i) lnk->name[i] = f_ent->fcb.name[i]; 
    for (i = 0; i < 3; ++i) lnk->ext[i] = f_ent->fcb.ext[i];
    lnk->date = f_ent->fcb.date;
    lnk->s_vol = f_ent->s_vol;
    lnk->e_vol = f_ent->e_vol;
    lnk->s_pos = f_ent->s_pos;
    lnk->length = f_ent->length;
    lnk->level = f_ent->level;
    for (i = 0; i < 8; ++i) lnk->res[i] = f_ent->res2[i];
    return;
}
/*
    This routine will copy some fcb info. to a link entry.
*/
fcb_lnk(s_fcb, lnk)
struct search_fcb *s_fcb;
struct link_file *lnk;
{
    int i;
    
    lnk->attr = s_fcb->attr2;
    lnk->drive = s_fcb->drive;
    for (i = 0; i < 8; ++i) lnk->name[i] = s_fcb->name[i];
    for (i = 0; i < 3; ++i) lnk->ext[i] = s_fcb->ext[i];
    lnk->date = s_fcb->date;
    return;
}

/*
    This routine will scan an unambiguous file name (a backup file 
    name) and return TRUE if it is valid, or FALSE if not.
*/
#define ufn_debug FALSE
scan_ufn(p)
char *p;
{
    extern struct br_entry br_id;	/* backup/restore file id */
    char d;		/* drive letter */
    int ret, i;
    static char con[] = {"CON       "}, prn[] = {"PRN     "};
    
#if ufn_debug
printf("UFN:Got here, parameter:%s\r\n", p);
#endif

    /* ensure that backup file is not ambiguous  */
    
    if (stpchr(p, '?') != NULL || stpchr(p, '*') != NULL)
    {
	printf("Backup file name can not be ambiguous.\r\n");
	return (ERROR);
    }
    if (scan_afn(p, &br_id.fcb) == ERROR)
	return(ERROR);
    
    if (stccmp(&br_id.fcb.name, con, 8) == 0 || 
			    stccmp(&br_id.fcb.name, prn, 8) == 0)
    {
	printf("Invalid filename.\r\n");
	return;
    }
    
    if (stpchr(p, '.') != NULL)
    {
	printf("Extension on backup file specified.\r\n");
	printf("Extention 000 will be assumed.\r\n");
    }

/*
	blank out remainder of filename, insert extention of 000
	and return
*/

    for (i = 0; i < 3; ++i) br_id.fcb.ext[i] = '0';

#if ufn_debug
p = &br_id.fcb.drive;
putch(*p+('A'-1));
putch(':');
for (i = 0; i < 12; ++i)
    printf("%c", *p++);
#endif
    
    return(OK);
}


/*
    This routine will initialize an FCB to show that it
    is extended, no attributes, and the default drive.
*/

init_fcb(fcb)
struct ext_fcb *fcb;
{
    extern char dr_default;
    int i;
    
    fcb->extend = 0xff;
    for (i = 0; i < 5; ++i) fcb->zero[i] = 0;
    fcb->attr = 0;
    fcb -> drive = dr_default;
    return;
}



/*
    This routine returns TRUE if the character passed is a valid 
    Z-DOS file name character else FALSE.
*/

file_char(c)
char c;
{
    if (c == '_') return(TRUE);	 /* needed because isprint() returns FALSE */
    if (!isprint(c)) return(FALSE);
    switch(c)
    {

/* bad characters */

	case ' ':
	case '?':
	case '.':
	case ',':
	case ';':
	case ':':
	case '=':
	case '*':
	case '{':
	case '}':
	case '/':
	case '+':
	case '"':
	    return(FALSE);

/* everything else is good */

	default:
	    return(TRUE);
    }
}


/*
    This routine will scan an ambiguous file name and format an
    FCB appropriately.  If an error is encountered then TRUE is 
    returned. If not then FALSE is returned.
*/
#define afn_debug FALSE
scan_afn(p1, fcb)
char *p1;
struct ext_fcb *fcb;
{
    extern char msg_gen;
    extern char dr_default, num_drive;
    int error = FALSE, i;
    char d;

#if afn_debug
char *p;
printf("AFN:Got here, parameter %s\r\n", p1);
#endif

    for (i = 0; i < 8; ++i) fcb->name[i] = ' ';		/* blank file name */
    for (i = 0; i < 3; ++i) fcb->ext[i] = ' ';		/* blank ext */
    init_fcb(fcb);
    
    /*  check for drive designation  */
    if (*(p1+1) == ':')
    {
	if (islower(*p1)) *p1 = toupper(*p1);
	d = *p1 - ('A' - 1);
	if (d < 1 || d > num_drive)
	{
	    if (msg_gen)
		printf("Invalid drive designation on backup file.\r\n");
	    return(ERROR);
	}
	fcb->drive = d;
	p1 += 2;
    }
    
    if (*p1 == '\0')	/* need at least 1 char. in filename */
    {
	if (msg_gen) printf("Invalid filename.\r\n");
	return(ERROR);
    }
    
    i = 0;
    while (*p1 != '\0' && *p1 != '.')
    {
	if (islower(*p1)) *p1 = toupper(*p1);
	if (file_char(*p1) || *p1 == '?')
	{
	    fcb->name[i] = *p1;		/* put character in fcb  */
	    ++i;
	    ++p1;
	    if (i >= 8 && *p1 != '.' && *p1 != '\0')
	    {
		if (msg_gen)
		    printf("Invalid filename.\r\n");
		error = TRUE;
		break;
	    }
	}
	else if (*p1 == '*')		/* fill remainder with '?' */
	{
	    for (; i < 8; ++i)
		fcb->name[i] = '?';
	    while(*p1 != '\0' && *p1 != '.') ++p1;
	    break;
	}
	else  /*  Invalid character  */
	{
	    if (msg_gen)
		printf("Invalid filename.\r\n");
	    error = TRUE;
	    break;
	}
    }
    if (!error) 
    {
	if (*p1 != '\0')
	{
	    ++p1;
	    i = 0;
	    while(*p1 != '\0')
	    {
		if (islower(*p1)) *p1 = toupper(*p1);
		if (file_char(*p1) || *p1 == '?')
		{
		    fcb->ext[i] = *p1;	/* put char in extention */
		    ++i;			/* get next locations */
		    ++p1;
		    if (i >= 3 && *p1 != '\0')
		    {
			if (msg_gen)
			    printf("Invalid filename.\r\n");
			error = TRUE;
			break;
		    }
		}
		else if (*p1 == '*')		/* fill with '?' */
		{
		    for (; i < 3; ++i)
			fcb->ext[i] = '?';
		    break;
		}
		else  /*  Invalid character  */
		{
		    if (msg_gen)
			printf("Invalid filename.\r\n");
		    error = TRUE;
		    break;
		}
	    }
	}
    }
    
#if afn_debug
p = (char *) &fcb->drive;
putch(*p+('A'-1));
putch(':');
for (i = 0; i < 12; ++i)
    printf("%c", *p++);
printf("\r\nAFN: return is:%d\r\n", error);
#endif
    if(error) return (ERROR);
    return(OK);
}
/*
    This routine will return TRUE if the fcb passed matches one of
    the selection specs. passed else it returns FALSE.
*/
file_match(fcb1, p1)
struct ext_fcb *fcb1;
char *p1;
{
    extern char *parms[];
    struct ext_fcb fcb2;
    char *p2, c;
    
    while (*p1 !='\0')
    {
	p2 = p1;
	while (*p2 != '+' && *p2 != '\0') ++p2;
	c = *p2;	/* save character */
	*p2 = '\0';	/* make into "C" string for scan_afn */
	if (scan_afn(p1, &fcb2) == ERROR) return(-1);
	*p2 = c;	/* restore character */
	if (amb_match((char *) &fcb1->drive, (char *) &fcb2.drive))
		return(TRUE);
	p1 = p2;	/* set up for next selection afn */
	if (*p1 == '+') ++p1;
    }
    return(FALSE);
}
/*
    This routine will see if two ambiguous file names match. TRUE is 
    returned if there is a match else FALSE.
*/
amb_match(p1, p2)
char *p1, *p2;
{
    int i;
    
    for (i = 0; i < 12; ++i) /* check 12 characters (drive + 11 filename) */
    {
	if (*p1 != '?' && *p2 != '?')	  /* if '?' skip this character */
	    if (*p1 != *p2) return(FALSE);
	++p1;
	++p2;
    }
    return(TRUE);
}

/*
    This routine will get a particular volume from the user.
    The volume number is passed to this routine and TRUE is
    returned if the volume is correctly entered else FALSE 
    is returned and the file is not opened.
*/
get_vol(vol)
char vol;
{
    extern struct br_entry br_id;
    extern char cur_vol;
    char *fname, *get_fname(), c;
    
    if (cur_vol == vol) return(TRUE);	/* check if volume is here */
    file_close(&br_id.fcb);	/* close previous volume */
    cur_vol = vol;	/* set the current volume */
    set_vol();		/* set the volume in the fcb */
    fname = get_fname(&br_id.fcb);
    if (cur_vol == 0)
    {
	printf("\nInsert backup master volume 1, %s,in drive %c\r\n",
				fname, br_id.fcb.drive + ('A' - 1));
	printf("and press RETURN when ready.\r\n");
    }
    else
    {
    	printf("\nInsert backup volume %d, %s, in drive %c\r\n", cur_vol+1,
				fname, br_id.fcb.drive + ('A' - 1));
	printf("and press RETURN when ready.\r\n");
    }
    while(getch() != '\r');
    while(TRUE)
    {
	if (file_open(&br_id.fcb))
	{
	    rls_mem(fname, (unsigned) FNAME_SIZE);
	    return(TRUE);
	}
	if (cur_vol == 0)
	{
	    printf("\nCan not open master backup file %s, insert another disk in drive %c\r\n",
				fname, br_id.fcb.drive + ('A' - 1));
	    printf("and press RETURN when ready,\r\n");
	    printf("or press any other key to abort.\r\n");
	}
	else
	{
	    printf("\nCan not open backup file %s, insert another disk in drive %c\r\n",
				fname, br_id.fcb.drive + ('A' - 1));
	    printf("and press RETURN when ready,\r\n");
	    printf("or press any other key to abort.\r\n");
	}
	if(chkabrt() == FALSE)
	{
	    rls_mem(fname, (unsigned) FNAME_SIZE);
	    return(FALSE);
	}
    }
}
