Page	60,132
Title	-Initialization and Power-Up Diagnostics
;
;
;	Copyright (c) 1983
;	Zenith Data Systems
;	St. Joseph, Michigan
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;
;	Last Update 28_Jan_86
;
%Out	Rom.asm
page
;----------------------------------------------------------------------
; Equates (7_Aug_85)
;-------------------
;
KeyBd_Rom_Rev	equ	3		;Keyboard Rom Compatibility Revision
Win_Size	equ	24		;Task Handler Screen Area (in K_Bytes)



Read_Flag	equ	40h		;Memory Test Flag -- Read/Check Memory
Write_Flag	equ	80h		;Memory Test Flag -- Write Memory

; Include Files
;--------------
;	Rom.lit
;	Intr.lit
;	Sys.lit
;	IO.lit
;	Disk.lit
;	Video.lit
;
	.xlist
	Include ..\Rom\Rom.lit
	Include ..\Rom\Intr.lit
	Include ..\Rom\Sys.lit
	Include ..\Disk\Disk.lit
	Include ..\IO\IO.lit
	Include ..\Video\Video.lit
	.list


;======================================================================
Rom_Data Segment
;===============
;
	extrn	Ext_Rom_Init:Far

Rom_Data	EndS

;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

; Include Files
;--------------
;
;	Rom.ext
;	Sys.ext
;	Disk.ext
;	Video.ext

	.xlist
	Include ..\Rom\Rom.ext
	Include ..\Rom\Sys.ext
	Include ..\Disk\Disk.ext
	Include ..\Video\Video.ext
	.list

	extrn	Zero_Divide_Interrupt:Far
	extrn	Nmi_Interrupt:Far
	extrn	Overflow_Interrupt:Far
	extrn	Print_Screen_Interrupt:Far 
	extrn	Timer_Interrupt:Far
	extrn	Keyboard_Interrupt:Far
	extrn	Reserved_Hardware_Interrupt:Far
	extrn	Disk_Interrupt:Far 
	extrn	Video_IO_Interrupt:Far
	extrn	Get_IO_Config_Interrupt:Far 
	extrn	Get_Memory_Size_Interrupt:Far
	extrn	Disk_IO_Interrupt:Far 
	extrn	Serial_IO_Interrupt:Far
	extrn	Keyboard_IO_Interrupt:Far 
	extrn	Printer_IO_Interrupt:Far
	extrn	Boot_Interrupt:Far
	extrn	Time_of_Day_Interrupt:Far
	extrn	Do_Nothing:Far
	extrn	Get_Intr_Ptr:Near
	extrn	Rom_Start:Near
	extrn	Init_Key_Buff:Near
	extrn	Set_IO_Configuration:Near
	extrn	Set_Default_Video_Mode:Near
	extrn	Read_Dip_Switches:Near
	extrn	Set_Intr_Ptr:Near
	extrn	Display_Error_Msg:Near
	extrn	Bad_Ram:Near
	extrn	Disk_Boot:Near
	extrn	Delay:Near
	extrn	Init_IO_Timers:Near
	extrn	Check_Rtc:Near
	extrn	Set_Vid_Parms:Near
	extrn	Enable_Cursor_Ram:Near
	extrn	Disable_Cursor_Ram:Near
	extrn	Poll_Memory_Size:Near
	extrn	In_Morrow_6845:Near
	extrn	Out_Morrow_6845:Near
	extrn	Diag_Disp_String:Near
	extrn	Exec_Init:Near
	extrn	Calc_Init:Near
	extrn	Data_Segment:Word
	extrn	DS_to_Rom_Data:Near

	extrn	No_Boot_Flag:Byte
	extrn	Crt_Mode:Byte
	extrn	Rom_Vars:Byte
	extrn	Default_IO_Config:Byte
	extrn	Stack_Level:Byte
	extrn	Dcr_Save:Byte		;Display Control Register Value Save
	extrn	Bad_Rom_Msg:Byte
	extrn	Bad_Tintr_Msg:Byte
	extrn	Mem_Test_Msg:Byte	;Testing Memory Message
	extrn	Keybd_Rev_Msg:Byte
	extrn	Boot_Msg:Byte
	extrn	Put_String:Near

	extrn	Scr_Save_Base:Word	;Base of Task Handler Screen Area
	extrn	System_Stack:Word
	extrn	Stack_Top:Word

;hf	extrn	Battery_Low:Word
;hf	extrn	Battery_Dead:Word

page
;----------------------------------------------------------------------
; Code Section Fixed Data Section (1_Jul_85)
;-------------------------------------------
;
Pattern_Table Label Byte
;-----------------------
;
Public	Pattern_Table

	db	Write_Flag + 2,	0AAh
	db	Read_Flag  + 2,	0AAh

	db	Write_Flag + 2,	55h
	db	Read_Flag  + 2,	55h
	db	0, 0			;End of Table 


;----------------------------------------------------------------------
Start_Up Proc Far; (1_Jul_85)
;----------------------------
;	1) Start_Up is the code executed on power up and reset.
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing
Public	Start_Up

	mov	ax,Rom_Data
	mov	ds,ax			;DS:= Rom Data Segment
	mov	Reset_Flag,0		;Reset_Flag:= 0

Start_Up	EndP

page
;----------------------------------------------------------------------
Start_Up_Warm Proc Far; (6_Aug_85)
;---------------------------------
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing
Public	Start_Up_Warm

	cli				;Prevent spurious interrupts
	cld				;Set forward byte moves
	mov	al,Parallel_Mode
	out	Par_Ctrl_Port,al	;Initialize the parallel I/O chip
	mov	al,Sys_Port_Init
	out	Sys_Ctrl_Port,al	;Disable Speaker
	mov	dx,Expansion_Port
	mov	al,Expansion_Init
	out	dx,al			;Enable Expansion Interface (if there)

	mov	ax,Rom_Data
	mov	ds,ax			;DS:= Initial Data Segment
	cmp	Reset_Flag,1234h	;If (This is a Cold Boot)
	jz	SuwSk1

	mov	ax,Monitor_Segment
	mov	ds,ax			;	DS:= Monitor Segment

;hf	mov	dx,Battery_Low
;hf	mov	bp,Battery_Dead

	mov	di,0			;	DI:= Offset to Base of SRam
	mov	es,ax			;	ES:= Monitor Segment
	mov	cx,1000h		;	CX:= Byte Count (4k)
	mov	al,0FFh			;	AL:= Fill Byte (0)
	rep	stosB			;	Fill SRam Memory with FF's

	mov	bx,0			;	BX:= Index (zero)
	mov	cx,1000h		;	CX:= Byte Count (4k)
SuwLp1:	xor	Byte Ptr [bx],al	;	Repeat	If (there was an error)
SuwLp2:	jnz	SuwLp2			;			Loop Forever

	inc	bx			;		Index:= Index + 1
	loop	SuwLp1			;	Until (All of SRam checked)

;hf	mov	Battery_Dead,bp
;hf	mov	Battery_Low,dx

	mov	ax,Rom_Data
	mov	ds,ax			;	DS:= Ibm Rom Data Area

SuwSk1:	mov	ax,cs
	mov	ss,ax			;SS:= Monitor Segment
	mov	sp,Offset Stack_Top	;SP:= Offset to System Stack
	mov	Stack_Level,0		;Flag that stack is available for use

	call	System_Init		;Initialize the System
	jmp	Start_Executing

Start_Up_Warm	EndP

page
;----------------------------------------------------------------------
System_Init Proc Near; (7_Aug_85)
;--------------------------------
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

	call	Init_Video		;Load Video Constants & Clear Video Mem
	call	Init_Refresh		;Startup Refresh Cycles
	cmp	Reset_Flag,1234h	;If (This is a Cold Boot)
	jz	MnSk2

	call	Rom_Test		;	Validate Rom Checksum
	jz	MnSk0			;	If (Rom Memory Test Failed)

	mov	si,Offset Bad_Rom_Msg	;		SI:= Pointer (BAD-ROM)
	jmp	Display_Error_Msg	;		Print the Message

MnSk0:	call	Main_Mem_Test		;	Test Remaining System Memory
	jz	MnSk1			;	If (Memory Test Failed)

	mov	di,si			;		ES:DI:= Error address
	jmp	Bad_Ram			;		Display Bad_Ram Message

MnSk1:	mov	dx,Color_Card
	in	al,dx			;	Enable Nmi's
	cmp	al,KeyBd_Rom_Rev	;	If (Invalid KeyBoard Rom Rev)
	jz	MnSk2

	mov	si,Offset Keybd_Rev_Msg	;		SI:= Message Pointer
	jmp	Display_Error_Msg	;		Print the Message

MnSk2:	mov	ax,0			; clear lowest 64K of Ram
	mov	es,ax
	mov	di,ax
	mov	cx,8000h
	rep	stosw

	mov	ax,ds
	mov	es,ax			;ES:= dummy seg in ES in case of error
	mov	Data_Segment,ax

	call	Init_Interrupts		;Initialize 8259 and intr vectors
	call	Set_Memory_Parm		;Determine amount of system RAM
	call	Exec_Init		;Initialize the Task Handler
	call	Calc_Init		;Initialize the Calculator

	mov	Crt_Control,Video_On	;Set default value for CRT ctrl port
	call	Set_Default_Video_Mode	;Determine power-up video mode

	call	Init_Key_Buff		;Initialize keyboard variables
	call	Init_IO_Timers		;Set default device timeouts

	mov	al,Tone_Control		;Get the init code for the timer
	out	Timer_Ctrl,al		;Init the timer for use as tone gen
	call	Timer_Interrupt_Test	;Test out the 8253 timer and intr
	jnc	M2			;If (Timer Test eq Failed)

	mov	si,Offset Bad_Tintr_Msg	;	SI:= Pointer to Failed Message
	jmp	Display_Error_Msg	;	Exit

M2:	call	Set_IO_Configuration	;Determine global I/O configuration
	call	Check_Rtc		;Init Real Time Clock & System Setup
	call	Install_External_Roms	;Install Z100/Z150 Expansion Roms
	ret

System_Init	EndP

page
;----------------------------------------------------------------------
Start_Executing Proc Near; (2_Aug_85)
;------------------------------------
;	1) This routine initializes the Disk Drivers and then either
;	   starts up the World Map or Boots the Disk System depending
;	   on the state of the No_Boot_Flag.
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

	mov	Disk0_Turn_Off_Limit,0
	mov	Disk1_Turn_Off_Limit,0
	mov	FDC_Power_Flag,0
	mov	Disk_Reset_Count,0
	mov	Disk_Use_Status,0
	mov	Drive_Status,NOT Disk_Motor_Masks
	mov	Disk_Retries,Default_Retries
	mov	Current_Drive,0		;Set default drive to drive A
	mov	Drive_Count,2		;Set drive count to 2
	mov	Boot_Drive,0		;Boot_Drive:= A:

	mov	dx,Disk_Control_Port
	mov	al,Disk_IO_Enable
	out	dx,al			;Turn Off Power to Disk Drive Motors

	mov	ah,NOT Enable_Floppy_Power
	mov	al,System_Status_Register
	call	Out_Morrow_6845		;Turn Off Power to Disk Controller

	cmp	No_Boot_Flag,True	;Is auto-booting enabled?
	mov	No_Boot_Flag,False	;[Clear the auto-boot flag value]
	jne	M32			;If (Auto_Boot eq False)

M31:	mov	ax,Icon_Clock Shl 8 + Nmi_Regenerate
	call	Out_Morrow_6845		;	Switch to the Clock Icon
	mov	cx,500h			;	CX:= Time Delay for Nmi
ML1:	loop	ML1			;	Wait for Nmi to enter world map

M32:	mov	bl,7			;BL:= Normal Character Attribute
	mov	dx,0			;DX:= Cursor Position (Home)
	mov	si,Offset Boot_Msg	;SI:= Pointer to Start of String
	call	Put_String		;Print the Booting... Message


	call	Disk_Boot		;If (Unable to Read floppy Boot sector)
	jc	M33			;	Try for winchester
	jmp	M5			;else   Boot from the floppy

M33:	push	ds
	push	si
	mov	al,Boot_Intr		;Get Segment of Boot Interrupt Vector
	call	Get_Intr_Ptr
	mov	ax,ds
	pop	si
	pop	ds
	cmp	ax,Monitor_Segment	;If (Boot Segment Monitor_Segment)
	jz	M31			;	then no winchester available

	or	Boot_Drive,80h
M5:	mov	dl,Boot_Drive		;Get the boot device as a parameter
	mov	al,Boot_String		;...and the boot partition, too
	int	Boot_Intr		;Boot and execute operating system

Start_Executing	EndP

page
;----------------------------------------------------------------------
Init_Video Proc Near; (2_Jul_85)
;-------------------------------
;	1) This routine initializes the Color and MonoChrome control registers,
;	   Clears their memories and Clears cursor ram.
;	2) Notice that only the DS register is saved.
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

	push	ds
	mov	ax,Monitor_Segment
	mov	ds,ax			;DS:= Monitor_Segment
	mov	es,ax			;ES:= Monitor_Segment

	mov	Dcr_Save,0		;Initialize Display_Control_Register
	mov	Cursor_Flag,Alpha_Cursor_On ;Flag alpha cursor on graphics off

	mov	dx,Color_Card + Crt_Color_Select
	mov	al,Rom_Vars[Size Vid_Vars].Default_Colors ;Set colors
	out	dx,al			;Set the color register properly

	mov	dx,Color_Card + Crt_Mode_Select
	mov	al,Crt_Mode[3]		;Get the 80x25 mode byte
	out	dx,al			;Init the color video hardware mode

	mov	si,Offset Rom_Parms_60[Size Vid_Parms] ;Point to 80x25 CRT parms
	mov	dx,Color_Card + Crt_Base_Register
	call	Set_Vid_Parms

	mov	dx,Mono_Card + Crt_Mode_Select
	mov	al,1			;Get code to init monochrome board
	out	dx,al			;Initialize the monochrome card
	mov	al,Crt_Mode[7]		;Get the monochrome mode byte
	out	dx,al			;Init the mono video hardware mode

	mov	dx,Mono_Card + Crt_Base_Register
	mov	si,Offset Rom_Parms_60[Size Vid_Parms * 3] ;Point to mono parms
	call	Set_Vid_Parms

	mov	ax,Mono_Segment		;Point to the screen RAM segment
	mov	es,ax
	mov	di,Offset Screen	;Point to the start of screen RAM
	mov	ax,(Default_Attribute Shl 8) or ' ' ;Set clear-screen data
	mov	cx,8000h		;Get length of both mono + color cards
	rep	stosW			;Clear mono and color screens to spaces

	call	Enable_Cursor_Ram	;Enable writes to the cursor RAM
	sub	ax,ax			;Prepare to store zeros
	mov	di,8000h
	mov	cx,Screen_Words/2	;Cursor RAM is half of color RAM
	rep	stosW			;Clear the RAM
	call	Disable_Cursor_Ram	;Disable the RAM
	pop	ds
	ret				;Return

Init_Video	EndP

page
;----------------------------------------------------------------------
Init_Refresh Proc Near
;---------------------
;	1) Init_Refresh sets up the timer/counter and the DMA controller
;	   so that the on-board RAM will be refreshed.  
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

	out	Dma_Clear,al		;Perform a DMA master clear
	mov	al,Refresh_Timer_Mode	;Get the timer mode for mem refresh
	out	Timer_Ctrl,al		;Set the correct mode
	mov	al,Refresh_Dma_Mode	;Get the DMA mode for memory refresh
	out	Dma_Control,al		;Set channel 0's mode
	mov	al,Refresh_Timer_Count	;Set the time counter for refresh
	out	Timer_1,al
	mov	ax,Refresh_Dma_Count	;Get the DMA count
	out	Dma_Count_0,al		;Output the low DMA count byte
	mov	al,ah			;Get the high DMA count byte

	push	ax			;Delay for a little while
	out	Dma_Count_0,al		;Output high byte of the DMA count
	pop	ax			;Delay in-between DMA chip accesses

	mov	al,0			;Set DMA command register up
	out	Dma_Command,al

	push	ax			;Delay for a little while
	out	Dma_Enable,al		;Enable DMA channel 0
	out	Dma_Segment_0,al	;Set up page 0 as refresh page
	out	Dma_Segment_3,al	
	mov	al,Dma_Mode_1		;Disable DMA channel 1
	out	Dma_Control,al
	pop	ax			;Delay in-between DMA chip accesses

	mov	al,Dma_Mode_2		;Disable DMA channel 2
	out	Dma_Control,al

	push	ax			;Delay for a little while
	mov	al,Dma_Mode_3		;Disable DMA channel 3
	out	Dma_Control,al
	pop	ax			;Clean up the stack
	ret				;Return

Init_Refresh	EndP

page
;----------------------------------------------------------------------
Rom_Test Proc Near; (22_Jun_85)
;------------------------------
;	1) ROM_Test adds every byte in the ROM together, and compares the
;	   result with 1 (a checksum placed at the last two bytes of the 
;	   ROM should force the generated checksum to be 1).
;	2) The Zero_Flag is returned set the Rom's Checksum was Ok.
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

	mov	ax,0			;Clear checksum
	mov	bx,Offset Rom_Start	;Point to start of the code in ROM
	mov	cx,Rom_Length Shr 1	;Number of words in ROM to CX

RtLp1:	add	ax,Word Ptr cs:[bx]	;Repeat	Add a word into the checksum
	adc	ax,0			;	Add carries back into checksum
	add	bx,2			;	Point to the next word
	loop	RtLp1			;Until (All of Rom Checksummed)

	cmp	ax,1			;Clear Z_Flag if Rom Checksum Test Failed
	ret				;Return

Rom_Test	EndP

page
;----------------------------------------------------------------------
Main_Mem_Test Proc Near; (26_Jun_85)
;-----------------------------------
;	1) This routine tests the entire main system memory space.
;	2) Exit Register Values:
;		Zero_Flag -> Set if No Errors Occured
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing, ss:Nothing

	mov	dx,0			;DX:= Starting Cursor Position
	mov	si,Offset Mem_Test_Msg	;SI:= Pointer to Start of String
	mov	ax,Screen_Segment
	mov	es,ax			;ES:= Start of Video Memory
	call	Diag_Disp_String	;Print the Memory Test Message

	call	Poll_Memory_Size	;AX:= Size of Memory in KiloBytes
	mov	cl,64
	div	cl
	cbw
	mov	cx,ax			;CX:= Number of 64k Segments to Test

	mov	ax,0
	mov	si,ax			;SI:= 0 (Initial offset within segment)
	mov	es,ax			;ES:= 0 (Base of Ram under test)
	mov	bx,Offset Pattern_Table	;BX:= Pointer to Pattern Table

MmLp1:	push	cx			;Repeat
	mov	cx,0FFFFh		;	CX:= Number of Bytes to Test
	call	Memory_Test		;	If (Memory Test ne Ok)
	pop	cx
	jnz	MmSk1			;		Break

	mov	ax,es
	add	ax,0FFFh
	mov	es,ax			;	ES:= Base of Next 64k Segment
	xor	al,al			;	(Set the Zero_Flag)

	loop	MmLp1			;Until (all full 64k Segments Tested)
MmSk1:	ret				;Return

Main_Mem_Test	EndP

page
;----------------------------------------------------------------------
Memory_Test Proc Near; (24_Jun_85)
;---------------------------------
;	1) Run Set of Memory Reads/Writes
;	2) Entry Register Values
;		BX    -> Pointer to the Base of the Pattern Table
;		CX    -> Number of Bytes to Test (divided by 3)
;		ES:SI -> Pointer to Base of Memory to Test
;	3) Exit Register Values:
;		Zero_Flag -> Set if No Errors Occured.
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing, ss:Nothing
Public	Memory_Test

	push	bx
	push	cx

	push	dx
	mov	dx,0			;DX:= 0
	mov	ax,cx			;AX:= Entry Value of Byte Count
	mov	cx,3			;CX:= Divisor
	div	cx
	pop	dx

	mov	cx,ax			;CX:= Number of Bytes/3
DpLp1:	mov	al,cs:[bx]		;Loop	AL:= Control Data
	inc	bx
	mov	ah,cs:[bx]		;	AH:= Test Data
	inc	bx

	test	al,Write_Flag		;	If (Operation eq Write)
	jz	DpSk1

	call	Write_Memory		;		Fill Mem. with Pattern
	jmp	DpLp1

DpSk1:	test	al,Read_Flag		;	If (Operation eq Stop)
	jz	DpSk2			;		Break

	call	Read_Memory		;	Else If (Memory Failed)
	jz	DpLp1			;		Break

DpSk2:	pop	cx
	pop	bx
	ret				;Return

Memory_Test	EndP

page
;----------------------------------------------------------------------
Write_Memory Proc Near; (26_Jun_85)
;----------------------------------
;	1) Write a Pattern into Memory
;	2) Entry Register Values:
;		AH -> Test Pattern
;		AL -> Msb=Write_Flag, low order bits = initial memory offset
;		CX -> Number of Byte to test (divided by three)
;		ES -> Segment Address of Memory Under Test
;		SI -> Offset to Memory Under Test
;	3) Exit Register Values:
;		Zero_Flag -> Returned Set
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing, ss:Nothing

	push	cx
	push	si
	push	es

	push	ax
	and	al,Not Write_Flag
	mov	ah,0			;AX:= Initial Offset
	add	si,ax			;SI:= Initial Offset
	pop	ax

WmLp1:	mov	Byte Ptr es:[si],ah	;Repeat	Write to Memory
	add	si,3			;	Increment Index
	loop	WmLp1			;Until (Counter eq 0)

	xor	cl,cl			;Zero_Flag:= Set
	pop	es
	pop	si
	pop	cx
	ret				;Return

Write_Memory	EndP

page
;----------------------------------------------------------------------
Read_Memory Proc Near; (26_Jun_85)
;---------------------------------
;	1) Read a Pattern from Memory
;	2) Entry Register Values:
;		AH -> Test Pattern
;		AL -> Msb=Read_Flag, low order bits = initial memory offset
;		CX -> Number of Byte to test (divided by three)
;		ES -> Segment Address of Memory Under Test
;		SI -> Offset to Memory Under Test
;	3) Exit Register Values:
;		AL -> 0 If memory passed, otherwise it has the bits that failed
;		Zero_Flag -> set if passed, clear if failed
;
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing, ss:Nothing

	push	cx
	push	si
	push	es

	push	ax
	and	al,Not Read_Flag
	mov	ah,0			;AX:= Initial Offset
	add	si,ax			;SI:= Initial Offset
	pop	ax
	mov	al,0			;AL:= Pass

RmLp1:	mov	al,Byte Ptr es:[si]	;Repeat	If (Byte from Memory ne AH)
	cmp	ah,al
	jz	RmSk1

	xor	al,ah			;		AL:= bits that failed
	jmp	RmSk3			;		Break

RmSk1:	add	si,3			;	Increment Index
	loop	RmLp1			;Until (Counter eq 0)
	xor	cl,cl			;Zero_Flag:= Set

RmSk2:	pop	es
	pop	si
	pop	cx
	ret				;Return

RmSk3:  pop	cx			; fix stack, but preserve ES:SI
	pop	cx
	pop	cx
	ret

Read_Memory	EndP

page
;----------------------------------------------------------------------
Set_Memory_Parm Proc Near; (8_Jul_85)
;------------------------------------
;	1) Set_Memory_Size determines how much memory is in the system by
;	   calling Poll_Memory_Size. This figure is then used to initialize
;	   Memory_Size, Scr_Save_Base (for the task Handler) and
;	   Bus_Memory_Size.
;	2) Input Register Values:
;		DS -> Base of Rom_Data
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

	call	Poll_Memory_Size	;Poll to get system memory size

	sub	ax,Win_Size		;Memory_Size:= Memory_Size-Window Area
	mov	Memory_Size,ax		;Record it in memory

	mov	bx,ax			;BX:= Memory_Size
	mov	cl,6			;Memory_Size:= Memory_Size (paragraphs)
	shl	ax,cl
	mov	cs:Scr_Save_Base,ax	;Save address of screen save area

	sub	bx,64			;Subtract size of system memory
	mov	Bus_Memory_Size,bx	;Update bus memory size variable

	ret				;Return

Set_Memory_Parm	EndP

page
;----------------------------------------------------------------------
Init_Interrupts Proc Near; (20_Jun_85)
;-------------------------------------
;	Init_Interrupts initializes the interrupt vectors in low
; memory which point to I/O and interrupt service routines within
; the Z-150 monitor.  This routine also sets up the 8259A interrupt
; controller appropriately.
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

	PushReg	<ax,bx,cx,si,ds>
	mov	ax,0			;Get the number of the first vector
	mov	bx,Offset Z150_Intr_Tbl	;Point to the default intr table
	mov	cx,Z150_Interrupts	;Number of Z-150 intr vectors to be set
IIV1:	push	cs			;Point to the ROM code segment
	pop	ds
	mov	si,Word Ptr cs:[bx]	;Get the intr vector
	test	si,si			;Is this a valid vector?
	jnz	IIV2			;Yes - write it in memory

	mov	ds,si			;No, set segment to 0, too
IIV2:	call	Set_Intr_Ptr		;Write the interrupt vector
	add	bx,2			;Point to the next interrupt vector
	inc	ax			;Increment the interrupt number
	loop	IIV1			;Continue till all initialized

	mov	si,0			;Set clear-intr-vector to 0000:0000
	mov	ds,si
IIV3:	call	Set_Intr_Ptr		;Clear an interrupt vector to 0
	inc	ax			;Go on to the next interrupt
	cmp	ax,100H			;Finished initializing interrupts?
	jb	IIV3			;No, loop until rest of vectors cleared

	mov	cx,cs			;Point DS to the code segment
	mov	ds,cx
	call	Read_Dip_Switches	;Read the configuration switches
	and	al,Refresh_Rate		;Isolate the refresh rate select bit

IIV4:	mov	al,Intr_Mode_1		;Init the first intr ctrlr mode byte
	out	Interrupt_Ctrl,al
	mov	al,Hardware_Intr_Base	;Set the starting interrupt number
	out	Interrupt_Parms,al
	mov	al,Intr_Mode_2		;Init the second mode byte
	out	Interrupt_Parms,al
	mov	al,Default_Intr_Mask	;Get the default I/O interrupt config
	out	Interrupt_Mask,al	;Enable keyboard & timer interrupts

	PopReg	<ds,si,cx,bx,ax>
	ret

Init_Interrupts	EndP

page
;----------------------------------------------------------------------
Timer_Interrupt_Test Proc Near; (20_Jun_85)
;------------------------------------------
;	1) Timer_Interrupt_Test initializes the system real-time clock
;	   counter, and it then verifies its accuracy to within +/- 10%.
;	2) If the actual timed value is off by more than approximately 10%,
;	   or if no timer interrupts occur, then a failure will be declared.
;	3) Output:
;		CY -> Reset if the timer ok; Set if an error occurred.
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing
Public	Timer_Interrupt_Test

	PushReg	<ax,bx,cx>
	sti				;Permit timer interrupts to occur
	mov	al,Clock_Timer_Mode	;Get the system clock channel's mode
	out	Timer_Ctrl,al		;Initialize the clock timer
	mov	Tod.LsCount,0		;Set the initial time to 0 (LS WORD)
	mov	al,0			;Set clock period to 0 (/65536)
	out	Timer_0,al
	mov	Tod.MsCount,0		;Initialize M.S. word of system time
	out	Timer_0,al		;Timer 0 now dividing by 65536
	mov	Tod.Days,0		;Clear timer overflow to 0
	in	al,Interrupt_Mask	;Read the interrupt mask register
	and	al,Timer_Intr_Mask	;Enable timer interrupts
	out	Interrupt_Mask,al
	mov	bx,100			;Set maximum delay to .1 second
Tint1:	mov	cx,1			;Set single delay to 1 millisecond
	call	Delay			;Wait for a short while
	cmp	Tod.LsCount,1		;Gotten an interrupt from the clock?
	je	Tint2			;Yes - now check its accuracy

	dec	bx			;Waited too long yet?
	jnz	Tint1			;No, continue to wait
	jmp	Tint5			;ERROR - timer not running

Tint2:	mov	bx,100			;Set delay to .1 second again
Tint3:	mov	cx,1			;Delay for a millisecond...
	call	Delay			;...while waiting for the clock intr
	cmp	Tod.LsCount,2		;Gotten another interrupt yet?
	je	Tint4			;Yes - See how accurate the timer is

	dec	bx			;Waited too long yet?
	jnz	Tint3			;No, continue to wait
	jmp	Tint5			;ERROR - timer not running

Tint4:	cmp	bx,Clock_Min_Time	;Is the timer running > 10% too fast?
	ja	Tint5			;ERROR - timer running too fast
	cmp	bx,Clock_Max_Time	;Is the timer rate > 10% too slow?
	jae	Tint6			;No, running just fine

Tint5:	stc				;Set carry flag to indicate error
	jmp	Tint7			;Return

Tint6:	clc				;Clear carry - no error occurred
Tint7:	PopReg	<cx,bx,ax>
	ret

Timer_Interrupt_Test EndP

page
;----------------------------------------------------------------------
Install_External_Roms Proc Near; (2_Aug_85)
;------------------------------------------
;	1) This routine installs Z-150 expansion roms and then
;	   restores timer interrupts before returning.
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

	mov	bx,Z150_Ext_Rom_Segment	;Point to the Z150 external ROM segment
	mov	cx,Z150_Ext_Roms	;Set the number of ROM slots
	call	Poll_External_Roms	;Check for extra interface ROMs

	in	al,Interrupt_Mask	;Read the interrupt mask register
	and	al,Timer_Intr_Mask	;Make sure that the timer is on...
	out	Interrupt_Mask,al	;...in case external ROMs disabled it
	ret				;Return

Install_External_Roms EndP

;----------------------------------------------------------------------
Poll_External_Roms Proc Near
;---------------------------
;	1) Poll_External_ROMs is called to determine if additional peripheral
;	   interface ROMs are available.
;	2) The ROMs are identified by the first two bytes being 055H,
;	   then 0AAH.  The next byte (byte 3) contains the length of the
;	   ROM in 512 byte blocks.
;	3) To ensure that a valid ROM is installed, each ROM must pass a
;	   sumcheck test.
;	4) Once a valid ROM is found, the monitor will perform a long call
;	   to the initialization code in the ROM, starting with the
;	   fourth byte.
;	5) Register Input Values
;		BX -> Base segment address of expansion ROM area
;		CX -> Maximum number of 2K blocks to be polled
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

	PushReg	<bx,cx,si,es>
Per1:	mov	si,0			;Repeat	Point to the start of a ROM
	mov	es,bx			;	Set segment for current ROM
	cmp	es:[si].Flag,0AA55h	;	If (there is a rom present)
	jnz	Per2

	call	Install_Rom		;		install if checksum OK
Per2:	add	bx,8*K Shr 4		;	Point to next 2K byte block
	loop	Per1			;Until (all external ROMs polled)

	PopReg	<es,si,cx,bx>
	ret				;Return

Poll_External_Roms EndP

page
;----------------------------------------------------------------------
Install_Rom Proc Near; (20_Jun_85)
;---------------------------------
;	1) Install_ROM is called when an external ROM has been detected in
;	   the system.  It will perform a sumcheck on the contents of the ROM.
;	   If the sumcheck is valid, the initialization code in the ROM will
;	   be executed.
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing

	PushReg	<ax,bx,cx,dx,si,si,bp,ds,es>
	mov	ch,Byte Ptr es:[si].Len
	mov	cl,0			;CX:= ROM length in words
	shl	cx,1			;CX:= ROM length in bytes
	mov	al,0			;AL:= 0 (used to accumulate checksum)

Ir1:	add	al,Byte Ptr es:[si]	;Repeat	Add a byte into the sumcheck
	inc	si			;	Point to the next byte to check
	loop	Ir1			;Unitl (whole rom checked)

	test	al,al			;If (CheckSum Ok)
	jnz	Ir2

	mov	Word Ptr Ext_Rom_Init[0],Init	;Write the ROM's init offset
	mov	Word Ptr Ext_Rom_Init[2],es	;Write the ROM's init segment

	call	DWord Ptr [Ext_Rom_Init]	;Execute ROM's init code

Ir2:	PopReg	<es,ds,bp,di,si,dx,cx,bx,ax>
	ret				;Return

Install_Rom	EndP

page
;----------------------------------------------------------------------
; Interrupt Vector Table
;-----------------------
;
public	Z150_Intr_Tbl
Z150_Intr_Tbl	dw	Offset Zero_Divide_Interrupt
		dw	Offset Do_Nothing
		dw	Offset Nmi_Interrupt
		dw	Offset Do_Nothing
		dw	Offset Overflow_Interrupt
		dw	Offset Print_Screen_Interrupt
		dw	Offset Do_Nothing
		dw	0
		dw	Offset Timer_Interrupt
		dw	Offset Keyboard_Interrupt
		dw	Offset Reserved_Hardware_Interrupt
		dw	Offset Reserved_Hardware_Interrupt
		dw	Offset Reserved_Hardware_Interrupt
		dw	Offset Reserved_Hardware_Interrupt
		dw	Offset Disk_Interrupt
		dw	Offset Reserved_Hardware_Interrupt
		dw	Offset Video_IO_Interrupt
		dw	Offset Get_IO_Config_Interrupt
		dw	Offset Get_Memory_Size_Interrupt
		dw	Offset Disk_IO_Interrupt
		dw	Offset Serial_IO_Interrupt
		dw	Offset Do_Nothing		;Dummy cassette I/O intr
		dw	Offset Keyboard_IO_Interrupt
		dw	Offset Printer_IO_Interrupt
		dw	Offset Default_IO_Config	;I/O configuration tables
		dw	Offset Boot_Interrupt
		dw	Offset Time_of_Day_Interrupt
		dw	Offset Do_Nothing
		dw	Offset Do_Nothing
		dw	Offset Rom_Parms_60		;Video parms (60 Hz)
		dw	Offset Disk_Parms		;Disk parameters
		dw	0				;User-font pointer

Z150_INTERRUPTS	EQU	($ - Z150_INTR_TBL) / 2


Monitor_Segment	EndS
		End
