Page	60,132
Title	-Icon Related Initialization
;
;
;	Copyright (c) 1983
;	Zenith Data Systems
;	St. Joseph, Michigan
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;
;	Last Update 29_Jul_85
;
%Out	MorInit.asm
page
;----------------------------------------------------------------------
; Equates (19_June_85)
;--------------------
;
; Include Files
;--------------
;	Rom.lit
;	Intr.lit
;	Sys.lit
;	Io.lit
;	Icon.lit

	.xlist
	Include	..\Rom\Rom.lit
	Include	..\Rom\Intr.lit
	Include	..\Rom\Sys.lit
	Include	..\IO\Io.lit
	Include ..\Icon\Icon.lit
	.list

; Other Equates
;--------------
;
		;RTC definitions for National MM58167A chip
RTC_Base	equ	0C0h		; base port for real time clock
RTC_Hundreds	equ	RTC_Base+1	; 	hundredths and tenths 
RTC_Seconds	equ	RTC_Base+2	; 	seconds count (0-59)
RTC_Minutes	equ	RTC_Base+3	; 	minutes count (0-59)
RTC_Hours	equ	RTC_Base+4	;	hours count (0-23)
RTC_Day		equ	RTC_Base+6	;	Day of month (1-31)
RTC_Month	equ	RTC_Base+7	;	Month	(1-12)
RTC_Ram_Base	equ	RTC_Base+8	; Base of Ram in RTC chip (8 Bytes)
RTC_Int_Satus	equ	RTC_Base+10h	; RTC interrupt status reg (Read only)
RTC_Int_Control	equ	RTC_Base+11h	; RTC interrupt control reg (Write " )
RTC_Status	equ	RTC_Base+14h	; roll-over status flag
RTC_Check	equ	0AA55h		; compare values for validity check

		; 'System_Setup' definitions:
Sys_Use_Ser	equ	4		; true if serial printer

		; parallel SPIOT entry format
Par_Flgs	equ	Byte Ptr 0	; map, parity, case
Par_Pad		equ	Byte Ptr 1	; CR pad char
Par_Npad	equ	Byte Ptr 2	; number of pad chars
Par_Tout	equ	Byte Ptr 3	; time-out value

		; 'Par_Flgs' definitions:
Par_F_Map	equ	0fh		; map field
Par_F_Serp	equ	1		; map to serial (COM1)

		; serial SPIOT entry format
Ser_Hshk	equ	Byte Ptr 0	; handshake type
Ser_Attr	equ	Byte Ptr 1	; transmission attributes
Ser_Pad		equ	Byte Ptr 2	; CR pad char
Ser_Npad	equ	Byte Ptr 3	; number of pad chars
Ser_EA_flg	equ	Byte Ptr 4	; ETX/ACK burst count flag
Ser_EA_cnt	equ	Byte Ptr 5	; counter for ETX/ACK
Ser_Ini		equ	Byte Ptr 6	; serial parameters
Ser_Rsvd	equ	Byte Ptr 7	; reserved byte

page
;======================================================================
Rom_Data Segment At (40h)
;========================
;
	extrn	IO_Config:Word
	extrn	Bus_Memory_Size:Word
	extrn	Tod:Word

Rom_Data	EndS

;======================================================================
Mono_Segment Segment At (0B000h)
;===============================
;
	;segment for mono screen

Mono_Segment	EndS

;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment

	extrn	Exec_Init:Near		;Icon\Task.asm
	extrn	Calc_Init:Near		;Calcmain.asm
	extrn	R_W_Rtc_Ram:Near	;Icon\IconIo.asm
	extrn	Get_RTC_Time:Near	;ClkInt.asm
	extrn	Set_TOD_Count:Near	;ClkInt.asm
	extrn	Set_Intr_Ptr:Near	;Misc.asm
	extrn	Get_Intr_Ptr:Near	;Misc.asm
	extrn	RSize:Near		;PUtil.asm
	extrn	AlmNxt:Near		;Appt.asm

	extrn	System_Setup:Word
	extrn	Serial_Setup:Word
	extrn	Modem_Setup:Word

	extrn	NovRam_Stat:Byte
	extrn	No_Boot_Flag:byte
	extrn	Mono_Exist:Byte		; True if Memory exists at B000:0
	extrn	Modem_Exist:Byte	; true if serial device at Com2
	extrn	Spiot:Byte		; copy of serial/parallel i/o table

	;Extrnal Data in NovRam
	extrn	RTC_Compare:Word	;reserved area for checking RAM & RTC
	extrn	NovRam_Setup:Abs	;Start of Setup Save Area
	extrn	N_System_Setup:Word	;Saved system setup
	extrn	N_Serial_Setup:Word	;Serial port setup
	extrn	N_Modem_Setup:Word	;Saved modem setup
	extrn	N_Year:Word		;Current year from setup
	extrn	N_Month:Byte		;Month machine turned on

page
;----------------------------------------------------------------------
; Default data for RTC and System initialization; (8_Jul_85)
;-----------------------------------------------------------
;	1) This table is used to initalize the system on power-up when it is
;	   determined that the RTC or NovRam have bad data (i.e. Very first
;	   time turned on)
;	2) Defaults
;		date is 1 May, 1985
;		(NOTE: RTC default data must be in BCD)
;		Time is 12:00:00
;		Zone is 16, El timeout ON
;		System_Setup is:
;			graphics card
;			graphics cursor OFF---- eliminated option
;			LPT:= Parallel
;			internal modem
;			12 hour time display
;			Auto-Boot OFF
;		COM1 setup is No Handshake,9600,n,8,2
;		COM2 setup is No Handshake,1200,n,8,2
;
Def_Setup	dw	1092h	; System_Setup
		dw	00E7h	; Serial_Setup
		dw	0087h	; Modem_Setup
		dw	1985	; Year
		db	5	; Month	= May (Must set month in Def_Time also)

Def_Time:	db	 00h	; Seconds   == Data From here down for RTC ==
		db	 00h	; Minutes
		db	 012h	; Hour in BCD
		db	 00	; Day of week -- ignored
		db	 01h	; day of month
		db	 05h	; Month

page
;----------------------------------------------------------------------
Check_RTC Proc Near; (8_Jul_85)
;------------------------------
;	1) Compares the reserved area in NovRam with the 8 bytes of
;	   Rtc Ram. If the two are not the same, then this routine 
;	   will initialize The NovRam, and the RTC to default values
;	   stored in ROM.
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing
Public	Check_RTC

	push	ds
	push	es

	push	cs
	pop	ds			;DS:= Base of the Monitor Segment

	mov	al,0			;set initial NovRam status
	mov	NovRam_Stat,al

	mov	al,1			;Select RTC_RAM enable
	call	R_W_RTC_Ram		;Enable RTC and NovRam

	mov	dx,RTC_Int_Control	;Disable interrupts from RTC
	mov	al,0
	out	dx,al

	mov	dx,RTC_Ram_Base		;DX:= RTC Ram for comparison
	mov	cx,4			;CX:= Number of Bytes to check
	mov	si,Offset RTC_Compare	;SI:= Start of the Check Area
CrLp1:	inc	si			;Repeat	Adjust NovRam Pointer
	inc	dx			;	Adjust Rtc_Ram Pointer
	in	al,dx			;	If (NovRam ne Rtc_Ram)
	cmp	al,[si]			;		Break

	loopE	CrLp1			;Until ((4 bytes checked) or (bad Cmp))
	jz	CrSk1			;If (NovRam ne Rtc_Ram)
	call	Bad_RTC_Ram		;	Reset system data

CrSk1:	xor	al,al			;Select RTC_RAM disable
	call	R_W_RTC_Ram		;Disable Reads of RTC and RAM writes

; At this point, it is assumed that the NovRam and RTC contain valid data
; Now, we must move data from NovRam to the DATA area, and also, set up
; the various time values.

	mov	ax,N_System_Setup	; get system setup from NovRam
	mov	System_Setup,ax		; save it in Ram data area
	mov	ax,N_Serial_Setup	; get serial port setup from NovRam
	mov	Serial_Setup,ax		; move it to ram data area
	mov	ax,N_Modem_Setup	; lastly, move the modem setup
	mov	Modem_Setup,ax

	call	Get_RTC_Time		; initialize time variables from RTC
	call	Set_TOD_Count		; set the 18.2 Hz timer values
	call	Move_IO_Tab		; move Serial & Parallel Config tables
	call	Test_For_Mono		; check for Mono Card and set Mono_Exist
	call	Test_For_Modem		; check if internal modem present

	; Now, we should init the serial port, and (if present) the Modem port
	sub	dx,dx			; select COM1
	mov	al,byte ptr Serial_Setup ;get serial port setup
	mov	ah,0			; select init serial port function
	int	Serial_IO_Intr		; initialize COM1
	push	dx
	mov	dx,3fcH			; turn on DTR & RTS on Serial port (saves power)
	mov	al,3
	out	dx,al
	pop	dx

	cmp	Modem_Exist,true	; if (Modem at Com2)
	jnz	No_Modem		; then
	inc	dx			;    select COM2
	mov	al,byte ptr Modem_Setup	;    get Modem Configuration
	mov	ah,0			; select init serial port function
	int	Serial_IO_Intr		; initialize COM2
	jmp	short Init_LPT		; init LPT devices
No_Modem:
	or	byte ptr System_Setup,8	; turn of internal modem bit

;	Initialize LPT# devices
Init_LPT:
	mov	cx,Printer_Ports	; maximum number of lpt devices
init2:	mov	dx,Printer_Ports	; repeat
	sub	dx,cx			;    get device number
	mov	ah,PIO_INIT		;    and init command
	int	Printer_IO_Intr		;    and do the interrupt
	loop	init2			; until (All LPT's Initialized)


	If	Enable_Appt
	sub	sp,256			; give lots of stack to phone stuff
	mov	bp,sp
	call	Rsize			; check Rest of Novram and fix if bad
	jnz	Bad_Appt_Ram		; 
	call	Almnxt			; If Ram was valid, set next appt time

Bad_Appt_Ram:
	add	sp,256			; restore stack
	Endif

	call	Re_Init			; initialize system from SETUP variables
	pop	es
	pop	ds
	ret
Check_RTC	EndP

page
;----------------------------------------------------------------------
Bad_RTC_Ram Proc Near; (20_Apr_85)
;---------------------------------
;	1) This routine initializes 1) the timekeeping data areas of NovRam
;	   and Rtc_Ram 2) the Check Areas of the NovRam and the Rtc_Ram 3) the
;	   default setup for System_Setup, Serial_Setup, Modem_Setup and Year
;	   and 4) The Default Time and Date.
;	2) NovRam and the Rtc are Enabled/DisAbled by the Calling Routine
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Monitor_Segment

	push	es			;(Save entry value of ES)
	push	ds
	mov	ax,Monitor_Segment
	mov	ds,ax			;DS:= Base of Monitor_Segment
	mov	es,ax			;ES:= Base of Monitor_Segment

	;Fill the NovRam Check area with the Default Value
	mov	ax,0AA55h		;AX:= Default Fill Value
	mov	di,Offset RTC_Compare+1	;DI:= Start of Check Area in NovRam
	cld				;Direction:= left to right
	mov	cx,2			;CX:= Number of words to Store
	rep	stosw			;Write them to NovRam

	;Fill the Rtc_Ram Check area with the Default Value
	mov	dx,RTC_Ram_Base+1	;DX:= Start of the RTC Ram
	mov	cx,2			;CX:= Number of words to Store
W_RTC:	out	dx,ax			;Repeat	Write a word to Rtc_Ram
	inc	dx
	inc	dx			;	Increment the Pointer
	loop	W_RTC			;Until (4 Words written into Rtc_Ram)

	;Move the Default Setup Words and Year from Rom into NovRam
	mov	si,Offset Def_Setup	;DS:SI:= Default Setup in Rom
	mov	cx,9			;CX:= Counter (9 bytes of config. data)
	mov	di,Offset NovRam_Setup	;ES:DI:= Start of NovRam data area

S_SLp1:	lodsb				;Repeat	Get Byte from Rom Default Setup
	stosb				;	Write it to NovRam
	loop	S_SLp1			;Until (9 Bytes initial data written)

	;Move the Default Time and Date Setup from Rom into the Rtc's Memory
	mov	dx,RTC_Seconds		;DX:= Base of Time and Date area of RTC
	mov	cx,6			;CX:= number of bytes transfered to RTC
S_Time:	lodsb				;Repeat	get a byte from setup for RTC
	out	dx,al			;	output it to the RTC
	inc	dx			;	Next RTC_Port
	loop	S_Time			;Until (RTC_Second -> RTC_Month set)

	pop	ds
	pop	es
	ret				;Return

Bad_RTC_Ram	EndP

page
;-------------------------------------------------------------------------
Move_IO_Tab Proc Near; (6_May_85)
;--------------------------------
; 	Moves the ROM default data for serial and parallel
;		protocols from ROM to RAM, and updates the Int 18h vector
;		to point to the new table.
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing

	pushreg	<ds,es,si,di>
	mov	al,18h			; get pointer to ROM table
	call	Get_Intr_Ptr		;  DS:SI --> ROM TABLE
	mov	ax,offset Spiot		; set up es:di to point to RAM image
	mov	di,ax			; di = offset in Monitor Segment
	push	cs
	pop	es			; es:di --> RAM image of table
	push	es			
	push	di			; save image pointer for later
	mov	cx,3*4+2*8		; 3 parallel tabs and 2 serial tabs
	cld
	rep	movsb			; copy old SPIOT
	pop	si
	pop	ds
	mov	al,18h			; int 18 to point to DS:SI
	call	Set_Intr_Ptr		; set pointer to RAM Table
	popreg	<di,si,es,ds>
	ret

Move_IO_Tab	EndP

page
;----------------------------------------------------------------------
Re_Init	Proc Near; (3_Jun_85)
;----------------------------
; Set up system according to the configuration in System_Setup, and set up
; for the type of handshaking selected for the serial port.
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing
Public	Re_Init

	push	ds
	push	cs
	pop	ds			;DS:= Start of Sram

	mov	bx,System_Setup		; get saved setup
	push	bx

	;Enable/Disable Auto-Boot
	test	bl,80h			; set flags based on Auto-Boot selection
	mov	ah,0FFh			; assume Auto-Boot disabled
	jnz	Nbskp

	inc	ah
Nbskp:	mov	No_Boot_Flag,ah		; set Boot flag as selected

	;Enable/Disable Monochrome card access
	cmp	Mono_Exist,True		; If ( (Mono card in system) And
	jnz	NoMono
	test	bl,1			;      (External Mono Selected) )
	jz	NoMono

	Assume	ds:Rom_Data
	push	ds
	mov	ax,Rom_Data
	mov	ds,ax			;	DS:= Rom_Data
	or	IO_Config,30h		;	set Equipment flag to say both
	pop	ds			;	(restore Data Segment)
	Assume	ds:Monitor_Segment

	mov	ax,7			;	select Mono adapter
	int	Video_IO_Intr

	; update SPIOT RAM image from Ram variables setup by 'Setup'
NoMono:	push	ds
	push	si
	mov	ax,18h			; get vector to IOCONFIG table
	call	Get_Intr_Ptr		; DS:SI => IOCONFIG table base
	and	ds:[si.Par_Flgs],Not Par_F_Map ;remove mapping
	test	cs:System_Setup,Sys_Use_Ser
	jz	noser			;skip if parallel is printer

	or	ds:[si.Par_Flgs],Par_F_Serp ;set for serial printer
noser:	mov	bx,0			; select com1 for initialization
	mov	dx,cs:Serial_Setup	; COM1 setup parms
	push	si			; preserve si for com2 setup
	call	Set_Ser			; do setup for com1
	pop	si
	mov	bx,1			; select com2 for initialization
	mov	dx,cs:Modem_Setup		; COM2 setup parms
	call	Set_Ser			; do setup for com2
	pop	si
	pop	ds
	pop	bx			; restore system setup

	;Enable/Disable Screensaver (EL panel timeout)
	mov	dx,Color_Card
	mov	al,Display_Control_Register+3	; el timeout register
	out	dx,al			;Select the Display Control Register

	inc	dx
	mov	al,bh			;(BH:= High byte of System_Setup)
	mov	ah,0			; assume Timeout enabled
	test	al,20h			; IF EL PANEL TIMEOUT disabled
	jz	EL_On

	mov	ah,6			;    then set to leave it on
EL_On:	mov	al,ah
	out	dx,al			;Set the TimeOut Control

	pop	ds
	ret				;Return

Re_Init	EndP

page
;----------------------------------------------------------------------------
Set_Ser Proc Near; (20_June_85)
;------------------------------
;	1) Set_ser - setup a serial SPIOT entry from dx
;		bx = com port 0/1
;
Assume	cs:Monitor_Segment, ds:Monitor_Segment, es:Nothing
	mov	ax,3*4			; ax = offset to base of serial tables
	cmp	bx,0			; if ( port ne COM1)
	jz	SS_Com1			; then
	add	ax,8			;   ax := offset to base of COM2 table
SS_Com1:
	add	si,ax			; si => base of table for selected com port
	mov	ds:[si.Ser_Ini],dl	; set serial protocol
	and	dh,3			; isolate handshaking bits
	jz	dh0			; skip if no handshaking
	dec	dh
	jz	dh1			; skip if XON/XOFF
	dec	dh
	jz	dh2			; skip if Hardware handshaking
	dec	dh
	jz	dh3			; skip if both handshaking
	ret

dh0:	mov	ds:[si.Ser_Hshk],0	; no handshaking
	ret				; clear handshaking

dh1:	mov	ds:[si.Ser_Hshk],6	; XON/XOFF handshaking
	ret				; set for DC1/DC3

dh2:	mov	ds:[si.Ser_Hshk],3dh	; hardware handshaking
	ret				; IBM compatible shake

dh3:	mov	ds:[si.Ser_Hshk],3dh	; both hardware/software shake
	ret				; force IBM compatible only

Set_Ser		EndP

page
;----------------------------------------------------------------------------
Test_For_Mono Proc Near; (8_May_85)
;----------------------------------
; Test if Mono card is connected, and Set Mono_Exist TRUE if a Mono card 
; is in system, otherwise set Mono_Exist to False.
;	IF Memory exists at B000:0, then It is assumed that there is a Mono
;	card in the system, otherwise, no mono card is in system.
;
Assume	cs:Monitor_Segment, ds:Mono_Segment, es:Nothing

	push	ds			; point to mono screen memory
	mov	ax,Mono_Segment
	mov	ds,ax

	mov	ax,ds:[0]		; get a word from mono screen
	mov	bx,ax			; save it
	not	ax			; invert it
	mov	ds:[0],ax			; write it back
	mov	al,True			; assume that a mono card exists
	cmp	bx,ds:[0]		; see if what we had has changed

	pushf				; save result of test
	mov	ds:[0],bx		; restore previous data to screen
	popf

	Assume	ds:Monitor_Segment
	pop	ds			; restore segment
	jnz	TmSk1
	not	al			; set it false

TmSk1:	mov	Mono_Exist,al		; set state of Mono_Exist
	ret

Test_For_Mono	EndP


page
;----------------------------------------------------------------------------
Test_For_Modem Proc Near; (27_June_85)
;----------------------------------
; Test if system has internal Modem, and set Modem_Exist to True or False.
;
Assume	cs:Monitor_Segment, ds:Mono_Segment, es:Nothing

	int	Equipment_Intr		; Get Equipment Flag
	and	ah,0eh			; isolate # of serial ports
	shr	ah,1			; ah:= number of serial ports attached
	dec	ah
	jz	No_Com2			; if (ah = 0) then no Modem attached
	mov	ah,TRUE			; else, Modem attached
No_Com2:
	mov	Modem_Exist,ah		; set Modem exist status
	ret

Test_For_Modem	EndP
 
Monitor_Segment	EndS
		End
