Page	60,132
Title	-Compatibility File
;
;
;	Copyright (c) 1983
;	Zenith Data Systems
;	St. Joseph, Michigan
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 03_Jan_86
;
%Out	Compatbl.asm
page
;----------------------------------------------------------------------
; Equates
;--------
;
; Include Files
;--------------
;
;	Rom.lit
;	Intr.lit
;	Disk.lit
;	Video.lit
;	Io.lit
;	Keyboard.lit
;	Icon.lit
;	Pequ.lit

	.xlist
	Include	..\Rom\Rom.lit
	Include ..\Rom\Intr.lit
	Include	..\Disk\Disk.lit
	Include ..\Video\Video.lit
	Include ..\io\Io.lit
	Include ..\io\Keyboard.lit
	Include ..\Icon\Icon.lit
	Include ..\Icon\Pequ.lit
	.list

;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment

; Include Files
;--------------
;	Keyboard.ext
;
	.xlist
	Include ..\io\Keyboard.ext
	.list

	extrn	START_UP:FAR
	extrn	BOOT_INTERRUPT:NEAR
	extrn	SERIAL_IO_INTERRUPT:NEAR
	extrn	KEYBOARD_IO_INTERRUPT:NEAR
	extrn	KEYBOARD_INTERRUPT:NEAR
	extrn	DISK_IO_INTERRUPT:NEAR
	extrn	DISK_INTERRUPT:NEAR
	extrn	PRINTER_IO_INTERRUPT:NEAR
	extrn	VIDEO_IO_INTERRUPT:NEAR
	extrn	GET_MEMORY_SIZE_INTERRUPT:NEAR
	extrn	GET_IO_CONFIG_INTERRUPT:NEAR
	extrn	TIME_OF_DAY_INTERRUPT:NEAR
	extrn	TIMER_INTERRUPT:NEAR
	extrn	PRINT_SCREEN_INTERRUPT:NEAR
	extrn	Out_Morrow_6845:Near
	page

Compatbl equ this Byte			
;---------------------
;	1) Label for use in padding ROM
;	2) Should reside at 0E000H
;
Public	Compatbl

	org	0E008h - 0E000h		;Place at copyright location
	db	'MF',19H		;Copyright message sumcheck
	page

; Jump to Initialization Routine
;-------------------------------
;
	org	0E05Bh - 0E000h
	db	Far_Jump		;Far jump
	dw	Offset Start_Up		;Offset of start-up routine
	dw	Seg Monitor_Segment	;Segment of start-up routine


CopyRight equ this Byte
;----------------------
;
Public	Copyright

	db	'Copyright (c) 1985 Morrow/Zenith', 0


page
;----------------------------------------------------------------------
; Inlcude Data Area for Clock Icon
;---------------------------------
;
	Include	..\Icon\Clkdata.inc
	page

	Include	..\video\pagemap.asm
	page

; Bootstrap Loader
;-----------------
	org	0E6F2h - 0E000h
	jmp	Boot_Interrupt		;Boot operating system



; Serial I/O Interrupt
;---------------------
;
	org	0E739h - 0E000h
	jmp	Serial_IO_Interrupt	;RS-232 I/O call interrupt

;*********
;------------------------------------------------------------------
; Setup screen data-- part 1 (6_Dec_85)
;--------------------------------------
	Include ..\Icon\Setup2.inc
;*********
; Keyboard I/O Interrupt
;-----------------------
;
	org	0E82Eh - 0E000h
	jmp	Keyboard_IO_Interrupt	;Keyboard char/status routine


;----------------------------------------------------------------------
; Phone Icon Data -- Area 2
;--------------------------
;
	Include	..\Icon\Phone2.inc

page

; Keyboard Interrupt Service Routine
;-----------------------------------
;
	org	0E987h - 0E000h
	jmp	Keyboard_Interrupt	;Actual keyboard interrupt



; Special 'Kludge' Entry point into keyboard interrupt routine.
;--------------------------------------------------------------
;	Expects character in (AL), handled in interrupt routine.
;
	org	0E996h - 0E000h
	add	SP,8 * 2		;Throw away garbage registers
	jmp	Keyboard_Interrupt	;Re-enter the keyboard interrupt

page
;----------------------------------------------------------------------
; Keyboard Key Encoding Tables
;-----------------------------
;
	Include ../Io/KeyTbl.inc

page
;----------------------------------------------------------------------
; Phone Icon Data -- Area 1
;--------------------------
;
	Include	..\Icon\Phone1.inc


;----------------------------------------------------------------------
; Phone Icon Data -- Area 3
;--------------------------
;
	Include	..\Icon\Phone3.inc

page
;-----------------------------------------------------------------------
; Disk I/O Interrupt
;-------------------
;
	org	0EC59h - 0E000h
	jmp	Disk_IO_Interrupt	;Disk I/O call handler



; Debugger Pause/Continue Message
;--------------------------------
;		PUBLIC	CONTINUE_MSG
;CONTINUE_MSG	DB	'			    - Press any key to continue -',CR,LF,0
;
;

page

; Video Start-of-Line Offsets
;----------------------------
	dw	4000H,4000H,4000H,4000H	;Negative offsets for progs...
	dw	4000H,4000H,4000H,4000H ;which wrap around...


Graphics_Line_Offset equ this Word
;---------------------------------
;
Public	Graphics_Line_Offset

	dw	0000H,0140H,0280H,03C0H ;Offsets of text...
	dw	0500H,0640H,0780H,08C0H ;...lines while in...
	dw	0A00H,0B40H,0C80H,0DC0H ;...graphics mode
	dw	0F00H,1040H,1180H,12C0H
	dw	1400H,1540H,1680H,17C0H
	dw	1900H,1A40H,1B80H,1CC0H
	dw	1E00H

	dw	4000H,4000H,4000H,4000H	;Negative line numbers will
	dw	4000H,4000H,4000H,4000H	;...yield off-screen display

Text_Line_Offset equ this Word
;-----------------------------
;
Public	Text_Line_Offset

	dw	0000H,00A0H,0140H,01E0H	;Offsets of text...
	dw	0280H,0320H,03C0H,0460H	;...lines while in...
	dw	0500H,05A0H,0640H,06E0H	;...80x25 text mode
	dw	0780H,0820H,08C0H,0960H
	dw	0A00H,0AA0H,0B40H,0BE0H
	dw	0C80H,0D20H,0DC0H,0E60H
	dw	0F00H,0FA0H,1040H,10E0H ;Note that displays
	dw	1180H,1220H,12C0H,1360H ;of up to 50 lines
	dw	1400H,14A0H,1540H,15E0H ;are supported in
	dw	1680H,1720H,17C0H,1860H ;text modes, via the
	dw	1900H,19A0H,1A40H,1AE0H ;use of interlaced
	dw	1B80H,1C20H,1CC0H,1D60H ;sync and video mode
	dw	1E00H,1EA0H,1F40H,1FE0H ;within the CRTC chip.

page
;----------------------------------------------------------------------
; Icon I/O Routines
;------------------
;
	Include ..\Icon\IconIO.inc


page
; Disk Interrupt Service Routine
;-------------------------------
;
	org	0EF57h - 0E000h
	jmp	Disk_Interrupt		;Actual disk interrupt


; Default Disk Parameter Table
;-----------------------------
;
	org	0EFC7h - 0E000h
	Public	Disk_Parms		;Disk parameter table

Disk_Parms	Disk_P	<0DFH,02H,25H,02H,08H,2AH,0FFH,50H,0F6H,19H,04H>


page
; Printer I/O Interrupt
;----------------------
;
	org	0EFD2h - 0E000h
	jmp	Printer_IO_Interrupt	;Printer I/O call handler


;----------------------------------------------------------------------
; Phone Icon Data -- Area 4
;--------------------------
;
	Include	..\Icon\Phone4.inc

page
; Video I/O Interrupt
;--------------------
;
	org	0F065h - 0E000h
	jmp	Video_IO_Interrupt	;Video I/O call handler


; CRT Controller Parameters (60 Hz and 50 Hz Refresh Rates)
;----------------------------------------------------------
;
	org	0F0A4h - 0E000h

	Public	Rom_Parms_60		;CRT controller parms (60 Hz)

Rom_Parms_60 	VID_PARMS <38H,28H,2DH,0AH,1FH,06H,19H,1CH,2,7,6,7,0,0,0,0>;40
	 	VID_PARMS <71H,50H,5AH,0AH,1FH,06H,19H,1CH,2,7,6,7,0,0,0,0>;80
	  	VID_PARMS <38H,28H,2DH,0AH,7FH,06H,64H,70H,2,1,6,7,0,0,0,0>;GRFX
	  	VID_PARMS <61H,50H,52H,0FH,19H,06H,19H,19H,2,13,11,12,0,0,0,0>;Mono

	Public	Rom_Parms_50		;CRT controller parms (50 Hz)

Rom_Parms_50 	VID_PARMS <38H,28H,2DH,0AH,26H,02H,19H,20H,2,7,6,7,0,0,0,0>;40
	 	VID_PARMS <71H,50H,5AH,0AH,26H,02H,19H,20H,2,7,6,7,0,0,0,0>;80
	  	VID_PARMS <38H,28H,2DH,0AH,7FH,06H,64H,70H,2,1,6,7,0,0,0,0>;GRFX
	  	VID_PARMS <61H,50H,52H,0FH,19H,06H,19H,19H,2,13,11,12,0,0,0,0>;Mono

page
;----------------------------------------------------------------------
; Include the Clock Icon Code and Misc. Print Strings
;----------------------------------------------------
;
	Include	..\Icon\Clock.inc
	Include ..\Icon\IcData.inc

page
; Get Memory Size Interrupt
;--------------------------
	org	0F841H - 0E000H
	jmp	Get_Memory_Size_Interrupt ;Return memory size



; Get I/O Configuration Interrupt
;--------------------------------
;
	org	0F84Dh - 0E000h
	jmp	Get_IO_Config_Interrupt	;Return I/O configuration



; Dummy Cassette I/O Interrupt
;-----------------------------
;
	org	0F859h - 0E000h
	iret				;Dummy cassette I/O call

page
;----------------------------------------------------------------------
; Disk Error Message Tables (20_May_85)
;--------------------------------------
;
Public	DISK_MSG_TABLE
Public	DISK_ERROR_MSG

DISK_MSG_TABLE	DB	TIMEOUT_ERROR	;Time out error occurred
		DW	DISK_TO_MSG

		DB	SEEK_ERROR	;Seek (to track) failed
		DW	DISK_SEEK_MSG

		DB	BAD_CTRL_ERROR	;Bad disk controller
		DW	DISK_CTRL_MSG

		DB	CRC_ERROR	;CRC (Cyclic Redundancy Check) error
		DW	DISK_CRC_MSG

		DB	OVERRUN_ERROR	;DMA overrun failure
		DW	DISK_ORUN_MSG

		DB	RECORD_ERROR	;Record not found
		DW	DISK_RECORD_MSG

		DB	ADDRESS_ERROR	;Address mark invalid
		DW	DISK_ADDR_MSG

		DB	nil		;End of table
		DW	DISK_CTRL_MSG	;Must be bad controller here...

DISK_ERROR_MSG	DB	'Disk Error:  ',0
DISK_TO_MSG	DB	'Drive Not Ready ',0
DISK_SEEK_MSG	DB	'Seek Failure ',0
DISK_CTRL_MSG	DB	'Bad Disk Controller ',0
DISK_CRC_MSG	DB	'CRC Error ',0
DISK_ORUN_MSG	DB	'DMA Overrun Error ',0
DISK_RECORD_MSG	DB	'Sector Not Found ',0
DISK_ADDR_MSG	DB	'Invalid Address Mark Detected ',0

page
;----------------------------------------------------------------------
; System Error Messages
;----------------------
;
Public	ERROR_MSG
Public	BAD_RAM_MSG1
Public	BAD_RAM_MSG2
Public	BAD_RAM_MSG3
Public	BAD_RAM_MSG4

ERROR_MSG	DB	'Error:  ',0
BAD_RAM_MSG1	DB	'RAM Failure at Address: ',0
BAD_RAM_MSG2	DB	', Bit: ',0

BAD_RAM_MSG3	DB	', Chip: ',0		;No "U" chips in Morrow machine

BAD_RAM_MSG4	DB	0

page
;----------------------------------------------------------------------
; System Messages (26_Jun_85)
;----------------------------
;
Public	Div_Err_Msg
Public	Overflow_Msg
Public	Wild_Intr_Msg
Public	Wild_Hw_Msg

Public	Mem_Test_Msg
Public	Keybd_Rev_Msg
Public	Bad_Rom_Msg
Public	Bad_TIntr_Msg
Public	Boot_Msg

Div_Err_Msg	db	Cr,Lf,' Divide by Zero',Cr,Lf,0
Overflow_Msg	db	Cr,Lf,' Overflow',Cr,Lf,0
Wild_Intr_Msg	db	Cr,Lf,' Invalid Interrupt',Cr,Lf,0
Wild_Hw_Msg	db	Cr,Lf,' Invalid Hardware Interrupt',Cr,Lf,0

Mem_Test_Msg	db	'Testing Memory',0
Keybd_Rev_Msg	db	'Wrong Keyboard Rom ',0
Bad_Rom_Msg	db	'Rom checksum failure ',0
Bad_TIntr_Msg	db	'Timer Interrupt failure ',0
Boot_Msg	db	30,0,0		;Set Cursor to Column 0, Row 0
		db	'Booting ... '	;Print 'Booting ... '
		db	30,0,1		;Set Cursor to Column 0, Row 1
		db	0		;End of String

page
;----------------------------------------------------------------------
; Graphics Character Font
;------------------------
;
	org	0FA6Eh - 0E000h		;Character font table
	Include	../Video/Font.inc	;(Font is 8x8)


page
; Get/Set Time-of-day
;--------------------
	org	0FE6Eh - 0E000h
	jmp	Time_of_Day_Interrupt	;Get/set time of day


; Timer Interrupt
;----------------
;
	org	0FEA5h - 0E000h
	jmp	Timer_Interrupt		;Timer tick service routine

;******
;---------------------------------------------------------------------
; Setup Screen Data Part 2 (6_Dec_85)
;------------------------------------
;
	Include ..\Icon\Setup3.inc
;******
page
;----------------------------------------------------------------------
; FEED_KEYBOARD: (SCAN_CODE)
;---------------------------
;	Feed_Keyboard is a special entry point which allows a program
; to pass a key to the ROM as though it were typed at the keyboard.
; This entry point expects a scan code in AL.  When using this entry
; point, don't forget to send both Make and Break key codes for each
; key!  Also, it is quite easy to get the keyboard LEDs out of sync
; when using this technique - be careful!
;
; Input:
;	AL: Scan code for character
;
; NOTE: THIS PROGRAM REQUIRES THAT THE CALLER SAVE FLAGS ON THE STACK
;	BEFORE BEING CALLED - ie, EXECUTE A PUSHF INSTRUCTION FIRST!!
;
	Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing, ss:Nothing

	org	0FF40h - 0E000h		;Feed key entry point
	mov	Feed_Key,True		;Flag that this is a 'feed-key' operation
	mov	ah,al			;Copy the key code into AH
	jmp	Keyboard_Interrupt	;Execute the keyboard interrupt code


; Another Dummy Return Instruction...
;------------------------------------
;
	iret


; Dummy Return Instruction
;-------------------------
;
	org	0FF53h - 0E000h
	iret				;Compatible dummy routine



; Print Screen Interrupt
;-----------------------
;
	org	0FF54h - 0E000h
	jmp	Print_Screen_Interrupt	;Print screen contents (text)



; Power-Up / Reset Vector
;------------------------
;
	Public	Reset

	org	0FFF0h - 0E000h
Reset:	jmp	Start_Up		;Initialization / Startup code


Monitor_Segment	EndS

page
;======================================================================
Checksum_Segment Segment Byte Public
;===================================
;	1) ROM Checksum location and Machine I.D.
;
Public	Rom_Checksum

		db	7 DUP (00H)		;Pad out to checksum
Rom_Checksum	dw	0			;Set initial checksum to 0
		db	0FEh			;Machine-ID (XT compatible)
		db	0			;Last byte of ROM

Checksum_Segment EndS
		 End
