h61197
s 00570/00000/00000
d D 1.1 82/08/02 15:17:18 cecily 1 0
e
u
U
t
T
I 1
/*
 *		Assembler pseudo-op processing
 *
 *
 *	Copyright (C) 1978, Richard Miller
 */

#define EXTERN	extern
#include "as.h"

/*
 * Ignored opcode
 */
donull()
{
	nexttoken = EOL;
}

/*
 * Illegal opcode
 */
dobad()
{
	xerror(errc);
}

/*
 * Data definition pseudo-ops
 */

#define DB	0
#define DC	1
#define DAC	2
#define DCF	3
#define DCX	4
#define DCY	5
#define DCZ	6

dodata(op)
{
	register t;

	dcflag = 1;		/* a()-type constants are legal */
	switch (op) {

	case DC:
	case DCX:
	case DCZ:
		align(2);
		break;

	case DAC:
	case DCF:
	case DCY:
		align(4);
		break;

	case DB:
		/*
		 * Stupid special case:
		 *	"DB *" is equivalent to "ALIGN 2"
		 */
		if ((t = token()) == STAR && eol()) {
			label();
			align(2);
			return;
		}
		nexttoken = t;
	}
	label();

	do switch (op) {

		/*
		 * fullword or halfword constant
		 */
		case DC:
		case DAC:
		case DCF:
		case DCZ:
			if ((t = token()) == STRING)
				puts((strlen+01)&~01);
			else {
				nexttoken = t;
				expr();
				/*
				 * relocate
				 */
				switch (exp.rel) {

				case RBSS:
					exp.val += hdr.dsize;
				case RDATA:
					exp.val += hdr.tsize;
				}
				if (exp.half || op == DCZ) {
					if (passg && (exp.val < 0xffff8000
					    || exp.val > 0xffff))
						error(errh);
					puth(exp.val, exp.rel);
				} else
					putw(exp.val, exp.rel);
			}
			continue;

		/*
		 * Hex constant
		 */
		case DCX:
			t = getnum(16);
			if (t < 0xffff8000 || t > 0xffff)
				error(errh);
			puth(t, RABS);
			continue;

		case DCY:
			t = getnum(16);
			putw(t, RABS);
			continue;

		/*
		 * Byte constant
		 */
		case DB:
			if ((t = token()) == STRING && strlen > 1) {
				puts(strlen);
				continue;
			}
			nexttoken = t;
			t = expr();
			if (passg)
				if (t != RABS
				    || exp.val < -127 || exp.val > 255)
					error(errv);
			putb(exp.val);
			if (listing)
				lstb(exp.val);
			continue;

		}
	while ((t = token()) == COMMA);

	nexttoken = t;
}

/*
 * Location counter pseudo-ops
 */

#define IMPURE	0
#define PURE	1
#define ALIGN	2
#define DS	3
#define DSF	4
#define ORG	5
#define COMN	6
#define STRUC	7
#define ENDS	8
#define BSS	9
#define BDATA	10
#define BORG	11
#define DSH	12
#define DLIST	13
#define CNOP	14

#define NOPR	0x0200		/* NO-OP instruction */

doloc(op)
{
	static struct segment *saveseg;		/* previous segment (while in
						   a STRUC or COMN */
	static int saverel;			/* previous relocatability */

	register t;
	register struct symbol *blk;

	switch (op) {

	case IMPURE:
		label();
		curseg = &impure;
		currel = RDATA;
		align(2);
		nexttoken = EOL;
		break;

	case PURE:
		label();
		curseg = &pure;
		currel = RTEXT;
		align(2);
		nexttoken = EOL;
		break;

	case BSS:
		label();
		curseg = &bss;
		currel = RBSS;
		align(2);
		nexttoken = EOL;
		break;

	case ALIGN:
	case CNOP:
		if (expr() != RABS)
			xerror(erra);
		if ((t = exp.val) != 2 && t != 4 && t != 8)
			t = 4;
		if (op == ALIGN) {
			align(t);
			label();
			break;
		}
		align(2);
		label();
		while (curseg->loc & (t-1))
			puth(NOPR, RABS);
		break;

	case DSF:
		align(4);
	case DSH:
		align(2);
	case DS:
		label();
		if (expr() != RABS)
			xerror(erra);
		if ((t = exp.val) < 0) {
			t = 0;
			error(errv);
		}
		if (op == DSF)
			t *= 4;
		else if (op == DSH)
			t *= 2;
		org(curseg->loc + t);
		break;

	case DLIST:
		if (expr() != RABS)
			error(erra);
		if ((t = exp.val) < 0) {
			t = 0;
			error(errv);
		}
		align(4);
		label();
		puth(t, RABS);
		puth(0, RABS);
		putw(0, RABS);
		org(curseg->loc + t*4);
		break;

	case ORG:
		label();
		switch (t = expr()) {
			case RTEXT:
				curseg = &pure;
				break;
			default:
				if (t == currel)
					break;
				error(errr);
				t = RDATA;
			case RDATA:
				curseg = &impure;
				break;
		}
		currel = t;
		org(exp.val);
		break;

	case COMN:
		if (curcomm)
			xerror(erri);
		if (!curlab)
			xerror(errl);
		curcomm = curlab;
		if ((t = curlab->type&SSEG) != SUNDEF &&
		    (t != SDATA || (bdata && pass == 0)))
			error(errm);
		curlab->type = SEXT | (bdata? SUNDEF : t);

		saverel = currel;
		saveseg = curseg;
		currel = REXT | ((curlab-usymtab)<<4);
		curseg = &comm;
		nexttoken = EOL;
		break;

	case STRUC:
		if (curcomm)
			error(erri);
		if (curlab) {
			curcomm = curlab;
			deflab(SABS, 0, 0);
		}
		else
			curcomm = -1;

		saverel = currel;
		saveseg = curseg;
		currel = RABS;
		curseg = &comm;
		nexttoken = EOL;
		break;

	case ENDS:
		if (!curcomm)
			xerror(erri);
		if (comm.loc > comm.maxloc)
			comm.maxloc = comm.loc;
		if ((currel != RABS && curcomm->type == (SEXT|Symbuf[sizeof symbuf]) {
			if (ucase && (ctype&C_UPPER))
				c += 'a'-'A';
			*s++ = c;
		}
	} while ((ctype = ctab[c = *++p])&(C_ALPHA|C_HEXDIGIT));

	scanp = p;
	return(1);
}

/*
 * Determine whether scan pointer is at end of line
 */
eol()
{
	register c;

	return((c = ctab[*scanp]) == EOL || c== SPACE);
}

/*
 * Save / restore scan pointer (for backtracking)
 */

static char	*scansave;

sscan()
{
	scansave = scanp;
}

rscan()
{
	scanp = scansave;
}
E 1
int *)s)[0] = ((int *)s)[1] = 0;
	do {
		if (s < &ssrc/cmd/as/s.as5.c                                                                                     444       3       3        11214  2752674177   7103                                                                                                                                                                                                                                                                                                                                                                      h31992
s 00225/00000/00000
d D 1.1 82/08/02 15:17:48 cecily 1 0
e
u
U
t
T
I 1
/*
 *		Assembler symbol table management
 *
 *
 *	Copyright (C) 1978, Richard Miller
 */

#define EXTERN	extern
#include "as.h"

#define NSYM	100		/* initial no. of symbols */
#define SYMINC	100		/* increment for symtab expansion */
#define HASHSIZE 199		/* size of hashed index to symtab
				   should be prime for best distribution */

/*
 * Hashing function for symbol table index:
 *	defined as a macro for speed
 */
#define hash(name)	((((unsigned *)name)[0]+((unsigned *)name)[1])%HASHSIZE)

struct symbol *hashtab[HASHSIZE];	/* index to symbol table */

struct symbol undefsym;			/* dummy symbol for undefined labels */
struct symbol tildechain;		/* 'anchor' for list of ~-symbols */
struct symbol *ptilde = &tildechain;	/* ptr to last ~-symbol defined(pass 0)
					   or referenced (pass >0) */

extern struct optab	opcodes[];		/* built-in opcodes */
extern struct symbol	predefs[];		/* pre-defined symbols */

/*
 * Initialize symbol table:
 *	- enter opcodes into hashed index
 *	- allocate initial space for user-defined symbols
 *	- initialize predefined symbols
 */
syminit()
{
	register struct symbol *sp, **hp;
	register struct optab *op;

	for (op = opcodes; op->name[0]; op++) {
		hp = &hashtab[hash(op->name)];
		op->next = *hp;
		*hp = op;
	}

	nextsym = usymtab = sbrk(0);
	brk(symtop = nextsym + NSYM);

	for (sp = predefs; sp->name[0]; sp++) {
		enter(sp->name);
		cursym->type = sp->type;
		cursym->value = sp->value;
	}
}

/*
 * Append symbol table to object file
 *	- returns number of undefined symbols
 */
symout()
{
	register struct symbol *sp;
	register char c, *p;
	register undefs;

	lseek(ofile, symseek, 0);
	undefs = 0;
	for (sp = usymtab; sp < nextsym; sp++) {
		/*
		 * relocate
		 */
		switch (sp->type&SSEG) {

		case SCOMN:
			/* change common block members to absolute */
			sp->type = SABS;
			break;

		case SBSS:
			sp->value += hdr.dsize;
		case SDATA:
			sp->value += hdr.tsize;
			break;

		case SUNDEF:
			undefs++;
			break;

		}
		write(ofile, sp->name, 16);
	}
	return (undefs);
}

/*
 * Reset pointer to list of ~-symbols at beginning of each assembly pass
 */
symset()
{
	ptilde = &tildechain;
}

/*
 * Look up symbol name in symbuf in hash-indexed symbol table
 *	flag =	0:	opcode expected
 *		1:	user symbol expected
 *		2:	user symbol expected; enter into index if not found
 *
 *	returns	0:	symbol was not previously defined
 *		1:	symbol was previously defined
 *		cursym:	points to symbol table entry
 *
 * A symbol preceded by '~' is entered into the symbol table but NOT into
 *	the hashed index, so that it will not match any other occurrence of
 *	the same symbol.  This trick is used by UNIX debuggers.
 */
symlook(flag)
{
	register struct symbol *sym, *sp, *lp, **hp;

	/*
	 * Look for already defined symbol
	 */
	if (symtilde) {
		/*
		 * Symbol preceded by '~'
		 */
		if (pass !=