#include "../h/local.h"

#ifdef  SCCS_ID
static char SCCS_ID [] = "@(#)main.c    	3.3	 03:06:51 - 82/01/15 ";
#endif  SCCS_ID

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/filsys.h"
#include "../h/mount.h"
#include "../h/map.h"
#include "../h/proc.h"
#include "../h/inode.h"
#include "../h/seg.h"
#include "../h/conf.h"
#include "../h/buf.h"
#include "../h/sysmon.h"

#ifdef  UCB_FRCSWAP
int     swpdebug        0;
int     idleflg         0;      /* If set, allow incore forks and expands */
				/* Set before idle(), cleared in clock.c */
#endif  UCB_FRCSWAP
/*
 * Initialization code.
 * Called from cold start routine as
 * soon as a stack and segmentation
 * have been established.
 * Functions:
 *      clear and free user core
 *      turn on clock
 *      hand craft 0th process
 *      call all initialization routines
 *      fork - process 0 to schedule
 *           - process 1 execute bootstrap
 *
 * loop at low address in user mode -- /etc/init
 *      cannot be executed.
 */
main()
{

	startup();
	/*
	 * set up system process
	 */

#ifdef DEC
	proc[0].p_addr = ka6->r[0];
#else  DEC
	{       int a;

		a = &u;
		lraddr(&a, kisa);
		proc[0].p_addr = btoc(a);
		trace(1<<24, "p0adr", proc[0].p_addr);
	}
#endif DEC
	proc[0].p_size = USIZE;
	proc[0].p_stat = SRUN;
	proc[0].p_flag |= SLOAD|SSYS;
	proc[0].p_nice = NZERO;
	u.u_procp = &proc[0];
	u.u_cmask = CMASK;

	/*
	 * Initialize devices and
	 * set up 'known' i-nodes
	 */

	clkstart();
#ifdef  UCB_IHASH
	ihinit();
#endif  UCB_IHASH
#ifdef  UCB_BHASH
	bhinit();
#endif  UCB_BHASH
	cinit();
	binit();
	iinit();
	rootdir = iget(rootdev, (ino_t)ROOTINO);
	rootdir->i_flag &= ~ILOCK;
	u.u_cdir = iget(rootdev, (ino_t)ROOTINO);
	u.u_cdir->i_flag &= ~ILOCK;
	u.u_rdir = NULL;

	/*
	 * make init process
	 * enter scheduling loop
	 * with system process
	 */

#ifdef  UCB_FRCSWAP
	idleflg++;      /* init creation must not cause swap */
#endif  UCB_FRCSWAP
	if(newproc()) {
		expand(USIZE + (int)btoc(szicode));
		trace(1<<24, "p1estab", 0);
		estabur((unsigned)0, btoc(szicode), (unsigned)0, 0, RO);
		copyout((caddr_t)icode, (caddr_t)0, szicode);
		/*
		 * Return goes to loc. 0 of user init
		 * code just copied out.
		 */
		trace(1<<24, "init", 0);
		return;
	}
	sched();
}

/*
 * iinit is called once (from main)
 * very early in initialization.
 * It reads the root's super block
 * and initializes the current date
 * from the last modified date.
 *
 * panic: iinit -- cannot read the super
 * block. Usually because of an IO error.
 */
iinit()
{
	register struct buf *cp, *bp;
	register struct filsys *fp;

	(*bdevsw[major(rootdev)].d_open)(rootdev, 1);
	bp = bread(rootdev, SUPERB);
	cp = geteblk();
	if(u.u_error)
		panic("iinit");
	bcopy(bp->b_un.b_addr, cp->b_un.b_addr, sizeof(struct filsys));
	brelse(bp);
	mount[0].m_bufp = cp;
	mount[0].m_dev = rootdev;
#ifdef  UCB_MOUNT
	mount1(&mount[0]);
	fp = mount[0].m_caddr;
#else   UCB_MOUNT
	fp = cp->b_un.b_filsys;
#endif  UCB_MOUNT
	fp->s_flock = 0;
	fp->s_ilock = 0;
	fp->s_ronly = 0;
#ifdef  CGL_ISRCH
	fp->s_lasti = 1;
	fp->s_nbehind = 0;
#endif  CGL_ISRCH
#ifdef  UCB_FSNAM
	{ int i;
	  fp->s_fsmnt[0] = '/';
	  for (i = 1; i < sizeof(fp->s_fsmnt); i++)
		fp->s_fsmnt[i] = 0;
	}
#endif  UCB_FSNAM
	time = fp->s_time;
#ifdef  UCB_LOAD
	bootime = time;
#endif  UCB_LOAD
}

/*
 * Initialize the buffer I/O system by freeing
 * all buffers and setting all device buffer lists to empty.
 */
binit()
{
	register struct buf *bp;
	register struct buf *dp;
	register int i;
	struct bdevsw *bdp;

	bfreelist.b_forw = bfreelist.b_back =
	    bfreelist.av_forw = bfreelist.av_back = &bfreelist;
	for (i=0; i<nbuf; i++) {
		bp = &buf[i];
		bp->b_dev = NODEV;
		bp->b_un.b_addr = &buffers[i * (BSIZE + BSLOP)];
		bp->b_back = &bfreelist;
		bp->b_forw = bfreelist.b_forw;
		bfreelist.b_forw->b_back = bp;
		bfreelist.b_forw = bp;
		bp->b_flags = B_BUSY;
		brelse(bp);
	}
	for (bdp = bdevsw; bdp->d_open; bdp++) {
		dp = bdp->d_tab;
		if(dp) {
			dp->b_forw = dp;
			dp->b_back = dp;
		}
		nblkdev++;
#ifdef  MONITORING

		sysmon.bthres = BUFTHRES;

#endif  MONITORING
	}
}
