/* SCCS_ID @(#)file.h    	5.1	 11:40:16 - 82/05/21 */

#ifndef LOCALS_INCLUDED
# include <sys/local.h>
#endif

/*
 * One file structure is allocated
 * for each open/creat/pipe call.
 * Main use is to hold the read/write
 * pointer associated with each open
 * file.
 */
struct	file
{
	short   f_flag;
	short   f_count;        /* reference count */
	struct inode *f_inode;	/* pointer to inode structure */
	union {
		off_t	f_offset;	/* read/write character pointer */
		struct chan *f_chan;	/* mpx channel pointer */
	} f_un;
};

extern struct file *file;       /* The file table itself */
extern struct file *fileNFILE;  /* &file[nfile] */

/* flags */
#define	FREAD	01
#define	FWRITE	02
#define	FPIPE	04
#define FMPX	010
#define	FMPY	020
#define	FMP	030
#define	FKERNEL	040
