static char SCCS_ID [] = "@(#)para.c	1.3";
#include "../h/local.h"
#include "../h/param.h"
#include "../h/buf.h"
#include "../h/proc.h"
#include "../h/text.h"
#include "../h/file.h"
#include "../h/inode.h"
#include "../h/callo.h"
#include "../h/map.h"
#include "../h/mount.h"
#include "../h/clist.h"
#include "../h/systm.h"

/*
 * tunable variables
 */

#define MAXUSERS 16             /* max number of users */
#define NPROC   (20+8*MAXUSERS) /* max number of processes */
#define NBUF     75             /* size of buffer cache */
#define NINODE  ((NPROC+16+MAXUSERS)+32)        /* number of in core inodes */
#define NFILE   (8*(NPROC+16+MAXUSERS)/10+32)   /* number of in core file structures */
#define NMOUNT  15              /* number of mountable file systems */
#define MAXUPRC 25              /* max processes per user */
#define CMAPSIZ ((NPROC+NTEXT)/2)       /* size of core allocation area */
#define SMAPSIZ ((NPROC+NTEXT)/2)       /* size of swap allocation area */
#define NCALL   (16+MAXUSERS)           /* max simultaneous time callouts */
#define NTEXT   (24+MAXUSERS)     /* max number of pure texts */
#define NCLIST  (((150+16*MAXUSERS)*28)/CBSIZE) /* max total clist size */
#define MSGBUFS 128             /* Characters saved from error messages */

int nproc   = NPROC;            /* max number of processes */
int nbuf    = NBUF;             /* size of buffer cache */
int ninode  = NINODE;           /* number of in core inodes */
int nfile   = NFILE;            /* number of in core file structures */
int nmount  = NMOUNT;           /* number of mountable file systems */
int maxuprc = MAXUPRC;          /* max processes per user */
int cmapsiz = CMAPSIZ;          /* size of core allocation area */
int smapsiz = SMAPSIZ;          /* size of swap allocation area */
int ncall   = NCALL;            /* max simultaneous time callouts */
int ntext   = NTEXT;            /* max number of pure texts */
int nclist  = NCLIST;           /* max total clist size */
int msgbufs = MSGBUFS;          /* Characters saved from error messages */

struct buf      xbuf[NBUF];
struct buf      *buf = xbuf;
/* struct buf      *bufNBUF = &xbuf[NBUF]; /**/

struct file     xfile[NFILE];
struct file     *file = xfile;
struct file     *fileNFILE = &xfile[NFILE];

struct inode    xinode[NINODE];
struct inode    *inode = xinode;
struct inode    *inodeNINODE = &xinode[NINODE];

struct proc     xproc[NPROC];
struct proc     *proc = xproc;
struct proc     *procNPROC = &xproc[NPROC];

struct text     xtext[NTEXT];
struct text     *text = xtext;
struct text     *textNTEXT = &xtext[NTEXT];

struct callo    xcallout[NCALL];
struct callo    *callout = xcallout;
struct callo    *calloutNCALL = &xcallout[NCALL];

struct map      xcoremap[CMAPSIZ];
struct map      *coremap = xcoremap;
/* struct map      *coremapCMAPSIZ = &xcoremap[CMAPSIZ]; /**/

struct map      xswapmap[SMAPSIZ];
struct map      *swapmap = xswapmap;
/* struct map      *swapmapSMAPSIZ = &xswapmap[SMAPSIZ]; /**/

struct mount    xmount[NMOUNT];
struct mount    *mount = xmount;
struct mount    *mountNMOUNT = &xmount[NMOUNT];

struct cblock   xcfree[NCLIST];
struct cblock   *cfree = xcfree;
struct cblock   *cfreeNCLIST = &xcfree[NCLIST];

char            xmsgbuf[MSGBUFS];
char            *msgbuf = xmsgbuf;
char            *msgbufMSGBUFS = &xmsgbuf[MSGBUFS];
char            *msgbufp = xmsgbuf;

char            xbuffers[NBUF][BSIZE+BSLOP];
char            *buffers = xbuffers;
#ifdef  DISKMON
long            io_infbufcount[NBUF];
struct io_info io_info = { NBUF, 0, 0, 0, 0, io_infbufcount };
#endif  DISKMON
