#include "../h/local.h"

#ifdef  SCCS_ID
static char SCCS_ID [] = "@(#)machdep.c    	3.3	 15:12:53 - 81/12/09 ";
#endif  SCCS_ID

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/acct.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/inode.h"
#include "../h/proc.h"
#include "../h/seg.h"
#include "../h/map.h"
#include "../h/reg.h"
#include "../h/buf.h"

extern char serialnum[];
extern char license[];

/*
 * Machine-dependent startup code
 */
startup()
{
	register i;
	char *a;

	/*
	 * zero and free all of core
	 */

	a = &u;			/* Virtual address of process 0 u area */
	lraddr(&a, kisa);		/* Physical address */
	i = btoc(a) + USIZE;		/* Start of user memory */
	trace(2<<24, "umem", i);
	trace(2<<24, "memtop", memtop);
	for ( ; ctob(i) < memtop; i++) {
		clearseg(i);
		maxmem++;
		freemem++;
		mfree(coremap, 1, i);
	}
	printf("CPU Serial Number %s, UNIX License Number %s\n",
		serialnum, license);
/**
	printf("Memory = %d.%d K\n", maxmem/4, (maxmem%4)*25);
**/
	printf("Memory = %d.%d K\n", (maxmem<<CSHIFT)/1024,
		(((maxmem<<CSHIFT)/256)%4)*25);
	if(MAXMEM < maxmem)
		maxmem = MAXMEM;
#ifdef UCB_NKB
	/* We would like to do this:
	 *     mfree(swapmap, nswap, 0);
	 * but you have to call mfree with a non-zero addr
	 * to initialize a map, so the 'swplo -= CLSIZE' is
	 * a kludge to adjust for this.
	 */
	mfree(swapmap, nswap, CLSIZE);
	swplo -= CLSIZE;
#else  UCB_NKB
	mfree(swapmap, nswap, 1);
	swplo--;
#endif UCB_NKB
}

/*
 * set up a physical address
 * into users virtual address space.
 */
sysphys()
{
	register i, s, d;
	register struct a {
		int	segno;
		int	size;
		int	phys;
	} *uap;

#ifdef  M3240
	/* I tried to parameterize this code so it would work on the 40, */
	/* but it doesn't work yet.  Don't know why.  -d yost */
	goto bad;
#endif  M3240
	if(!suser())
		return;
	uap = (struct a *)u.u_ap;
	i = uap->segno;
	if(i < 0 || i >= NUSEGS)
		goto bad;
	s = uap->size;
	if(s < 0 || s > SEGFULL)
		goto bad;
	d = u.u_uisa[i];
	if(d != 0 && (d&ABS) == 0)
		goto bad;
	if(s)
		u.u_uisa[i] = ((s - 1) << SEGLSL) | RW | ABS
			    | ((uap->phys >> (CSHIFT - SEGASL)) & SEGMASK);

	sureg();
	return;

bad:
	u.u_error = EINVAL;
}

/*
 * Let a process handle a signal by simulating an interrupt
 */
sendsig(p, signo)
caddr_t p;
{
	register unsigned n;
	register aps;

	aps = u.u_ar0[RPS];
	if (u.u_nostack) {
		/* No user stack -- set up stack for signal routine */
		u.u_nostack = 0;
		aps =| (1<<31);
		n = ctob(stoc(u.u_sseg) + u.u_ssize-2) - 4*NBPW;
	} else
		n = u.u_ar0[RSP] - 3*NBPW;

	grow(n);
	suword((caddr_t)n, aps);
	suword((caddr_t)n+NBPW, u.u_ar0[PC]);
	suword((caddr_t)n+2*NBPW, u.u_ar0[RSP]);
	u.u_ar0[RSP] = n;
	u.u_ar0[PC] = (int)p;
}

mapalloc()
{}

mapfree()
{}
