/*
 *	Polynet Ring Driver
 */


/*
 *   Register definitions
 *	(Are really oc command bits)
 */
#define		R0		0x00		/* Source select register */
#define		R1		0x01		/* RX source / TX destination */
#define		R2		0x02		/* Node address */
#define		R3		0x03		/* TX status */
#define		R4		0x04		/* RX status / Node status */
#define		R5		0x05		/* RX / TX byte */
#define		R6		0x06		/* RX / TX byte and go */
#define		R7		0x07		/* RX / TX go */
#define		R8		0x08		/* Extended control */

/*
 *   Further oc command bits
 */
#define		DMAOUT		0x10		/* DMA start output (write) */
#define		DMAIN		0x20		/* DMA start input (read) */


/*
 *   Status bits.
 */
#define		SS_RTYP		0xc0		/* type of m-p */
#define		SS_RDN		0x20		/* RX done */
#define		SS_TDN		0x10		/* TX done */
#define		SS_BUSY		0x08		/* busy */
#define		SS_EX		0x04		/* examine */
#define		SS_TER		0x01		/* TX error */
#define		SS_RSHFT	6		/* shift RTYP down */

/*
 *   Register control and status bits.
 */
#define		R3_TDN		0x80		/* TX done */
#define		R3_TER		0x40		/* TX error */
#define		R3_BCE		0x20		/* Broadcast enabled */
#define		R3_TCE		0x10		/* TX compare error */
#define		R3_TIG		0x08		/* TX ignored */
#define		R3_TAC		0x04		/* TX accepted */
#define		R3_TUS		0x02		/* TX not selected */
#define		R3_TBY		0x01		/* TX busy */

#define		R4_RDN		0x80		/* RX done */
#define		R4_BPR		0x40		/* RX broadcast m-p */
#define		R4_RRJ		0x20		/* RX reject */
#define		R4_RTRY		0x02		/* Auto retry */
#define		R4_NEN		0x01		/* Node enabled */

#define		W4_TRST		0x08		/* TX reset */
#define		W4_RRST		0x04		/* RX reset */
#define		W4_RTRY		R4_RTRY		/* Enable auto retry */
#define		W4_NEN		R4_NEN		/* Enable node */

#define		R8_LMASK	0xe0		/* bytes / m-p */
#define		R8_LSHFT	5		/* shift for LMASK */
#define		R8_AOK		0x10		/* All ok */
#define		R8_RON		0x08		/* Ring on */
#define		R8_40B		0x04		/* 40 bit mode */
#define		R8_RTYP		0x03		/* RX type mask */

#define		W8_TTYP		R8_RTYP		/* TX type field */

/*
 *   Misc flags
 */
#define		TRC		0x2000		/* trace mask */
#define		PAD		0x00		/* NUL */


/*
 *   Message storage system
 */
struct	rmsg	{
	struct	rmsg	*rm_next;		/* next I/O waiting */
	int		rm_size;		/* size of message */
	int		rm_state;		/* internal state */
	int		rm_port;		/* output port addr */
	int		rm_op;			/* type of message */
	};


/*
 *   Pseudo station interface
 */
struct	ring	{
	struct	rmsg	*rg_inq;		/* input waiting queue */
	int		rg_station;		/* station address */
	int		rg_state;		/* internal state */
	};


/*
 *   States
 */
#define		RINGOPEN	0x0001		/* station open */
#define		CHECKSUM	0x0002		/* compare checksums */
#define		DISABLED	0x0004		/* can't do I/O */
#define		ACKWAIT		0x0010		/* waiting for ack/nak */
#define		COMPLETE	0x0020		/* requested op complete */
#define		SLEEPING	0x0040		/* event wait indicator */
