/* SCCS_ID @(#)param.h    	3.9	 15:54:24 - 82/02/03 */


#ifndef LOCALS_INCLUDED
# include <sys/local.h>
#endif  LOCALS_INCLUDED

/* KLUDGE for broken C compiler */
#define USTOI(x) ((x) & 0xffff)

/*
 * tunable variables
 */

extern int nproc;               /* max number of processes */
extern int nbuf;                /* size of buffer cache */
extern int ninode;              /* number of in core inodes */
extern int nfile;               /* number of in core file structures */
extern int nmount;              /* number of mountable file systems */
extern int maxuprc;             /* max processes per user */
extern int cmapsiz;             /* size of core allocation area */
extern int smapsiz;             /* size of swap allocation area */
extern int ncall;               /* max simultaneous time callouts */
extern int ntext;               /* max number of pure texts */
extern int nclist;              /* max total clist size */
extern int msgbufs;             /* Characters saved from error messages */

#define	NOFILE	20		/* max open files per process */
#define MAXMEM  ((2*1024*1024)>>CSHIFT) /* max core per process - first # is Kb */
#define	SSIZE	((4*1024)>>CSHIFT)	/* initial stack size (*CLICK bytes) */
#define	SINCR	((4*1024)>>CSHIFT)	/* increment of stack (*CLICK bytes) */
					/* -- not used */
#define	CANBSIZ	256		/* max size of typewriter line */

#define	HZ	100		/* Ticks/second of the clock */
#define	NCARGS	5120		/* # characters in exec arglist */
#ifdef	UCB_METER
#define	MAXSLP	20		/* max time a process sleeps in core */
#endif  UCB_METER

/*
 * priorities
 * probably should not be
 * altered too much
 */

#ifdef	CGL_RTP
#define	PRTP	0
#define	PSWP	5
#else   CGL_RTP
#define	PSWP	0
#endif  CGL_RTP
#define	PINOD	10
#define	PRIBIO	20
#define	PZERO	25
#define	NZERO	20
#define	PPIPE	26
#define	PWAIT	30
#define	PSLEP	40
#define	PUSER	50

/*
 * signals
 * dont change
 */

#define	NSIG	17
/*
 * No more than 16 signals (1-16) because they are
 * stored in bits in a word.
 */
#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt (rubout) */
#define	SIGQUIT	3	/* quit (FS) */
#define	SIGINS	4	/* illegal instruction */
#define	SIGTRC	5	/* trace or breakpoint */
#define	SIGIOT	6	/* iot */
#define	SIGEMT	7	/* emt */
#define	SIGFPT	8	/* floating exception */
#define	SIGKIL	9	/* kill, uncatchable termination */
#define	SIGBUS	10	/* bus error */
#define	SIGSEG	11	/* segmentation violation */
#define	SIGSYS	12	/* bad system call */
#define	SIGPIPE	13	/* end of pipe */
#define	SIGCLK	14	/* alarm clock */
#define	SIGTRM	15	/* Catchable termination */

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define NREGS	(16+2)		/* user registers + pc + ps (in regloc) */
#define	NBPW	sizeof(int)	/* number of bytes in an integer */
#define WSHIFT	2		/* log2(NBPW) */
#ifdef UCB_NKB

/* Pick the number of 512-byte blocks in a file system block */
/* 1=512, 2=1K, 4=2K, etc. */
#define CLSIZE  2

#if CLSIZE == 1
#define CLSHIFT 0
#define	BSIZE	512		/* size of secondary block (bytes) */
#define	INOPB	8		/* 8 inodes per block */
#define	BMASK	0777		/* BSIZE-1 */
#define	BSHIFT	9		/* LOG2(BSIZE) */
#define	NMASK	0177		/* NINDIR-1 */
#define	NSHIFT	7		/* LOG2(NINDIR) */
#define	NICINOD	100		/* number of superblock inodes */
#define	NICFREE	50		/* number of superblock free blocks */

#endif

#if CLSIZE == 2
#define CLSHIFT 1
#define	BSIZE	1024
#define	INOPB	16
#define	BMASK	01777
#define	BSHIFT	10
#define	NMASK	0377
#define	NSHIFT	8
#define	NICINOD	100
#define	NICFREE	178
#endif

#if CLSIZE == 4
#define CLSHIFT 2
#define	BSIZE	2048
#define	INOPB	32
#define	BMASK	03777
#define	BSHIFT	11
#define	NMASK	0777
#define	NSHIFT	9
#define	NICINOD	100
#define	NICFREE	434
#endif

#ifndef INTRLVE
/* macros replacing interleaving functions */
#define	dkblock(bp)	((bp)->b_blkno)
#define	dkunit(bp)	(minor((bp)->b_dev) >> 3)
#endif

#define	PGSIZE	512		/* bytes per addressable disk sector */
#define PGSHIFT 9
				/* LOG2(PGSIZE) */

/* inumber to disk address and inumber to disk offset */
#define itod(x) ((daddr_t)(((/***(unsigned)***/(x)+2*INOPB-1)/INOPB)))
#define	itoo(x)	((int)(((x)+2*INOPB-1)%INOPB))

/* file system blocks to disk blocks and back */
#define fsbtodb(b)      ((daddr_t)((daddr_t)(b)<<CLSHIFT))
#define dbtofsb(b)      ((daddr_t)((daddr_t)(b)>>CLSHIFT))

#else  UCB_NKB
#define	BSIZE	512		/* size of secondary block (bytes) */
#endif UCB_NKB
/* BSLOP can be 0 unless you have a TIU/Spider */
#define	BSLOP	0		/* In case some device needs bigger buffers */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#ifndef UCB_NKB
#define	BMASK	0777		/* BSIZE-1 */
#define	BSHIFT	9		/* LOG2(BSIZE) */
#define	NMASK	0177		/* NINDIR-1 */
#define	NSHIFT	7		/* LOG2(NINDIR) */
#endif UCB_NKB

#define	SEGMENT	(64*1024)	/* memory segment size (bytes) */
#ifdef	M3240
#define	CLICK	2048		/* memory click size (bytes) */
#define CSHIFT  11
				/* LOG2(CLICK) */
#define	UBASE	0xff0000		/* abs. addr of user block */
#define NUSEGS	256	/* number of user segmentation regs. */
#define	USIZE	((4*1024)>>CSHIFT)	/* size of user block (*CLICK) */
#else   M3240
#define	CLICK	256		/* memory click size (bytes) */
#define CSHIFT  8
				/* LOG2(CLICK) */
#define	UBASE	0xf0000		/* abs. addr of user block */
#define NUSEGS	16	/* number of user segmentation regs. */
#define	USIZE	((2*1024)>>CSHIFT)	/* size of user block (*CLICK) */
#endif  M3240

#define	NULL	0
#define	CMASK	0		/* default mask for file creation */
#define	NODEV	(dev_t)(-1)
#ifdef V6
#define ROOTINO	((ino_t)1)	/* i number of all roots */
#else
#define	ROOTINO	((ino_t)2)	/* i number of all roots */
#endif
#define	SUPERB	((daddr_t)1)	/* block number of the super block */
#define	DIRSIZ	14		/* max characters per directory */
#ifndef UCB_NKB
#ifdef V6
#define NICINOD	50		/* number of superblock inodes */
#else
#define	NICINOD	100		/* number of superblock inodes */
#endif
#define	NICFREE	50		/* number of superblock free blocks */
#endif UCB_NKB
#define	INFSIZE	138		/* size of per-proc info for users */
/* CBTOTAL is total size of each clist block -- must be power of 2 */
/* CBSIZE is number of usable characters in a clist block */
#define CBTOTAL 64
#define CBSIZE  (CBTOTAL - sizeof (char *))
#define CROUND  (CBTOTAL - 1)   /* clist rounding mask */

/*
 * Some macros for units conversion
 */
/* Core clicks to segments and vice versa */
#define	ctos(x)	((x+((SEGMENT/CLICK)-1))/(SEGMENT/CLICK))
#define stoc(x) ((x)*(SEGMENT/CLICK))

#ifdef UCB_NKB
/* round a number of 512-byte blocks up to a whole cluster */
#define clrnd(i)        (((i) + (CLSIZE-1)) & ~(CLSIZE-1))
/* round a number of bytes to a page */
#define pgrnd(i)        (((i) + (PGSIZE-1)) & ~(PGSIZE-1))
#define bytetopage(x) (pgrnd(x) / PGSIZE)
#endif UCB_NKB

/* Core clicks to PGSIZE disk blocks */
#if CSHIFT > PGSHIFT
#define ctod(x) ((x)<<(CSHIFT-PGSHIFT))
#else
#define ctod(x) (((x) + ((1 << (PGSHIFT-CSHIFT)) - 1)) >> (PGSHIFT-CSHIFT))
#endif

#ifndef UCB_NKB
/* inumber to disk address */
#define	itod(x)	(daddr_t)(((/***(unsigned)***/x+15)>>3))

/* inumber to disk offset */
#define	itoo(x)	(int)((x+15)&07)
#endif  UCB_NKB

/* clicks to bytes */
#define	ctob(x)	(x<<CSHIFT)

/* bytes to clicks */
#define	btoc(x)	(((/***(unsigned)***/x+(CLICK-1))>>CSHIFT))

/* major part of a device */
#define	major(x)	(int)((/***(unsigned)***/x>>8))

/* minor part of a device */
#define	minor(x)	(int)(x&0377)

/* make a device number */
#define	makedev(x,y)	(dev_t)((x)<<8 | (y))

typedef	struct { int r[1]; } *	physadr;
typedef	long		daddr_t;
typedef char *		caddr_t;
typedef	unsigned short	ino_t;
typedef	long		time_t;
typedef	int		label_t[9];	/* regs 7-15 */
typedef short		dev_t;
typedef	long		off_t;

/*
 * Machine-dependent bits and macros
 */
#define	UMODE	0x100		/* usermode bits */
#define	USERMODE(ps)	(ps & UMODE)

#define	INTPRI	0340		/* Priority bits */
#define	BASEPRI(ps)	((ps & INTPRI) != 0)

#ifdef	CGL_AUTOB
#define	CSW	((physadr)0177570)	/* console switch register */
#define	SNGLU	070			/* single user mode */
#endif
#define trace(x,y,z)

/* this is the nop trace macro */

