.DA "September 7, 1984"
.TH RESTOR
.SH Name
restor \- Invokes incremental file system restorer.
.SH Syntax
restor\^
.I key [ arguments ]
.sp
.SH Description
.I Restor\^
is used to read or extract files from archive media backed up with the
.I dump\^
or
.I sysadmin\^
command.
The
.I key\^
specifies what is to be done.
You must use only one of these
.I keys:\^
.BR rRxt , XTc 
as an option. You may optionally use the
.BR f
key in combination with one of the others.
.TP
.B  f
Always uses the first
.I argument\^
in the argument list
as the name of the archive instead of the default.
.TP
.BR  r , R  
The archive is read and loaded into the file system
specified in
.IR argument .
If the key is
.BR R ,
.I restor\^
asks which archive of a multivolume set to start on.
This allows
.I restor\^
to be interrupted and then
restarted (an
.I fsck\^
must be done before the restart).
Only unmounted file systems may be used when restoring complete file
systems.
.TP
.B  x
Only files on the archive and named in the
.I argument\^
list are extracted.
The filename has all ``mount'' prefixes removed so you must identify
the file without using the complete file system pathname.
For example, if
.B /usr
is a mounted file system,
.B /usr/bin/lpr
is named
.B /bin/lpr
on the archive.
The extracted file is placed in the current working directory
represented as the inode number by
.I restor.\^
In order to keep the amount of archive read to a minimum,
the following procedure is recommended:
.RS
.TP
1.
Log on as
.I root.\^
.TP
2.
Type the
.I restor\^
command with the appropriate arguments.
.TP
3.
Insert volume 1; it contains header information.
.TP
4.
Follow the directions on the screen.
.RE
.TP
.B t
You are prompted to insert Volume 1. After inserting and pressing
RETURN,\^
two dates from the header record are given. The first is the date
of the backup. The second is the date of the last backup at that level.
.TP
.B T
Same as
.B t
but also lists all files that were dumped along with their names
and inode numbers.
.TP
.B X
Same as 
.B x
except recursively extracts files or directories in the specified
subtree.
.TP
.B c
Compares the archive with the file system specified in the argument
and notes any inconsistencies. It is suggested that a
.I restor\^
with the
.B c
option be done immediately after a
.I dump\^
to verify that the file system has been backed up accurately.
.PP
The
.B r
option should only be used to restore
a complete backup archive onto a clear file system,
or to restore an incremental backup archive onto
a file system so created.
Typically the file system is created with
.I mkfs\^
or using
.I restor\^
with the
.B r
option. Another
.I restor\^
can then be done to complete an incremental backup on top of the
first
.I restor.\^
The
.B r
option will restore only unmounted file systems.
.SH Files
.TP 23
rst*
Temporary files
.TP
/etc/default/restor
Name of default archive device
.PP
The default archive unit varies with installation.
.SH "See Also"
dump, dumpdir, fsck, mkfs
.SH Diagnostics
There are various diagnostics
involved with reading the archive and writing the disk.
There are also diagnostics if the i-list or the free list
of the file system is not large enough to hold the dump.
.PP
If the dump extends over more than one disk or tape,
it may ask you to change disks or tapes.
Reply with a newline when the next unit has been mounted.
.SH Notes
You can not do a complete restore of an active root file system.
.PP
To be sure you get the most recent version of a file, start with
the most current backup and work your way backwards.
