/***********************************************************************
*
* screen.c - IBM 7090 emulator Screen control routines, Uses ANSI control
*         sequences.
*
* Changes:
*   10/20/03   DGP   Original.
*   
***********************************************************************/

#include <stdio.h>

#if defined(USS) || defined(OS390)
#define ESCAPE  0x27
#else
#define ESCAPE  0x1B
#endif
 
/***********************************************************************
* clearscreen - clear the screen
***********************************************************************/
 
void
clearscreen (void)
{
#ifdef ANSICRT
   fprintf (stdout,
	    "%c[2J",
	    ESCAPE);
#endif
}
 
/***********************************************************************
* clearline - clear the line
***********************************************************************/
 
void
clearline (void)
{
#ifdef ANSICRT
   fprintf (stdout,
	    "%c[2K",
	    ESCAPE);
#endif
}
 
/***********************************************************************
* screen position - position on the screen
***********************************************************************/
 
void
screenposition (int row,
		int col)
{
#ifdef ANSICRT
   fprintf (stdout,
	    "%c[%d;%dH",
	    ESCAPE,
	    row,
	    col);
#endif
}
