/*
	ASCII2CB - convert ASCII card image to archive column-binary.

			   The program takes two arguments - input ASCII filename
												 output archive filename
*/

#include <stdio.h>
#include <string.h>
#include "cvtables.h"

void main(int argc, char *argv[])
{
	int i;
	int j;
	char code;
	char eof;
	FILE *iF;
	FILE *oF;
	char iN[80];
	char oN[80];
	int lp;
	char ch;
	char Line[256];

	lp = 0;
	eof = EOF;

	printf("Convert ASCII card deck.\n");

	if (argc > 1) {
		strcpy(iN, argv[1]);
	} else {
		strcpy(iN, "input.asc");
	}
	printf("  Input file: %s\n", iN);
	iF = fopen(iN, "r");
	if (iF == 0) {
		printf("No such input file - %s\n", iN);
		exit();
	}

	if (argc > 2) {
		strcpy(oN, argv[2]);
	} else {
		strcpy(oN, "output.crd");
	}
	printf("  Output file: %s\n", oN);
	oF = fopen(oN, "w");
	if (oF == 0) {
		printf("Cannot open output file - %s\n", oN);
		fclose(iF);
		exit();
	}

	fprintf(oF, "$COLUMN_BINARY\n");

	while (!feof(iF)) {
		for (i=0; i<255 && (ch=fgetc(iF))!=eof && ch!='\n'; )
			if (ch!='\r') Line[i++] = ch;
		if (i==0) break;
		while (i<80)
			Line[i++] = ' ';
		Line[i] = '\0';
		lp++;
		for (i=0; i<80; i++) {
			code = T5[Line[i]&127];
			fputc(T3[code], oF); fputc(T3[code+128], oF);
		}
		fputc('\n', oF);
	}

	fprintf(oF, "$END\n");

	fclose(iF);
	fclose(oF);

	printf("  Lines processed: %d\n", lp);
	printf("Conversion complete.\n\n");
}
