/***********************************************************************
* Screen control routines, Uses ANSI control sequences.
***********************************************************************/
 
#include <stdio.h>

#if defined(OPENMVS) || defined(OS390)
#define ESCAPE  0x27
#else
#define ESCAPE  0x1B
#endif
 
/***********************************************************************
* clearscreen - clear the screen
***********************************************************************/
 
void
clearscreen (void)
{
#ifdef ANSICRT
   fprintf (stdout,
	    "%c[2J",
	    ESCAPE);
#endif
}
 
/***********************************************************************
* clearline - clear the line
***********************************************************************/
 
void
clearline (void)
{
#ifdef ANSICRT
   fprintf (stdout,
	    "%c[2K",
	    ESCAPE);
#endif
}
 
/***********************************************************************
* screen position - position on the screen
***********************************************************************/
 
void
screenposition (int row,
		int col)
{
#ifdef ANSICRT
   fprintf (stdout,
	    "%c[%d;%dH",
	    ESCAPE,
	    row,
	    col);
#endif
}
