/***********************************************************************
*
* asmdef.h - Assembler header for the IBM 7090 computer.
*
* Changes:
*   05/21/03   DGP   Original.
*   08/20/03   DGP   Changed to call the SLR(1) parser.
*	
***********************************************************************/

#include <stdio.h>

/*
** Definitions
*/

#define NORMAL 0
#define ABORT  12

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define VERSION "1.1.1"

#define COMMENTSYM '*'
#define LITERALSYM '='

#define MAXLINE 256
#define LINESPAGE 60
#define NOOPERAND 30
#define TTLSIZE 60

#define TEMPSPEC "asXXXXXX"

/*
** Object output formats
*/

#define OBJFORMAT "%c%4.4o%2.2o%1o%5.5o"
#define OBJAFORMAT "%c%1o%5.5o%1o%5.5o"
#define OBJDFORMAT "%c%4.4o%2.2o%6.6o"
#define EXTRNFORMAT "%c%-6.6s%6.6o"
#define GLOBALFORMAT "%c%-6.6s%6.6o"
#define OCT1FORMAT "%c%2.2o%10.10o"
#define OCT2FORMAT "%c%6.6o%6.6o"
#define WORDFORMAT "%c%12.12o"
#define SEQFORMAT "%6.6d\n"

/*
** Listing formats
*/

#define H1FORMAT "ASM7090 %-8.8s  %-24.24s  %s Page %04d\n" 
#define H2FORMAT "%s\n\n"

#define L1FORMAT " %s  %s  %4d %s"
#define L2FORMAT " %s  %s\n"

#define PCBLANKS "     "
#define PCFORMAT "%05o"

#define OPBLANKS "                "
#define OPFORMAT "%c%4.4o %2.2o %1o %5.5o"
#define OPAFORMAT "%c%1o %5.5o %1o %5.5o"
#define OPDFORMAT "%c%4.4o %2.2o  %6.6o"
#define ADDRFORMAT "           %5.5o"
#define CHAR1FORMAT "%2.2o"
#define OP1FORMAT "%c%2.2o%10.10o   "
#define OP2FORMAT "%c%6.6o%6.6o   "
#define LITFORMAT " %s  %s  %s\n"

#define SYMFORMAT " %-8.8s %5.5o%c "

/*
** Data type definitions
*/

#define int8            char
#define int16           short
#define int32           int
typedef int             t_stat;                         /* status */
typedef int             t_bool;                         /* boolean */
typedef unsigned int8   uint8;
typedef unsigned int16  uint16;
typedef unsigned int32  uint32, t_addr;                 /* address */

#if defined (WIN32)                                     /* Windows */
#define t_int64 __int64
#elif defined (__ALPHA) && defined (VMS)                /* Alpha VMS */
#define t_int64 __int64
#elif defined (__ALPHA) && defined (__unix__)           /* Alpha UNIX */
#define t_int64 long
#else                                                   /* default GCC */
#define t_int64 long long
#endif                                                  /* end OS's */
typedef unsigned t_int64        t_uint64, t_value;      /* value */
typedef t_int64                 t_svalue;               /* signed value */

#if defined(__s390__) || defined(OPENMVS) || defined(sparc)
#define MSL 0
#define LSL 1
#else
#define MSL 1
#define LSL 0
#endif

/*
** OpCode table definition
*/

#define NUMOPS 255

enum optypes
{
   TYPE_A=1,	/* O DDDDD T AAAAA */
   TYPE_B,	/* OOOO FF T AAAAA */
   TYPE_C,	/* OOOO CC T AAAAA */
   TYPE_D,	/* OOOO FF  MMMMMM */
   TYPE_E,	/* OOOO FF T OOOOO */
   TYPE_P  	/* Pseudo op */
};

enum psops
{
   BCD_T=1,
   BCI_T,
   BES_T,
   BSS_T,
   DEC_T,
   END_T,
   ENT_T,
   EJE_T,
   EQU_T,
   EXT_T,
   OCT_T,
   ORG_T,
   REM_T,
   SPC_T,
   TTL_T
};

typedef struct
{
   char *opcode;
   unsigned opvalue;
   unsigned opmod;
   int optype;
} OpCode;

/*
** Symbol table
*/

#define MAXSYMLEN 6
#define MAXSYMBOLS 2000

typedef struct Xref_Node
{
   struct Xref_Node *next;
   int line;
} XrefNode;

typedef struct
{
   XrefNode *xref_head;
   XrefNode *xref_tail;
   char symbol[32];
   int value;
   int relocatable;
   int external;
   int global;
   int line;
   int predefine;
} SymNode;

/*
** Token types from tokscan
*/

enum toktypes
{
   PC = 1,
   SYM,
   DECNUM,
   OCTNUM,
   LITERAL,
   EOL
};
 
/*
** Expression scanner states.
*/

enum states
{
   START_STATE,
   ADD_STATE,
   SUB_STATE,
   MUL_STATE,
   DIV_STATE,
   END_STATE
};

/*
** Object tags
*/

#define ORG_TAG		'0'
#define DATA_TAG	'1'
#define BSS_TAG		'2'
#define ABSINST_TAG	'3'
#define RELINST_TAG 	'4'
#define EXTRN_TAG	'5'
#define GLOBAL_TAG	'6'
#define ABSENTRY_TAG	'7'
#define RELENTRY_TAG	'8'

#define CHARSPERREC	66  /* Chars per object record */
#define WORDTAGLEN	13 /* Word + Object Tag length */
#define EXTRNLEN	13 /* Tag + SYMBOL + addr */
#define GLOBALLEN	13 /* Tag + SYMBOL + addr */
#define SEQUENCENUM	74 /* Where to put the sequence */

/*
** Pass 1 error table - pass 2 does the printing.
*/

#define MAXERRORS 1000

typedef struct
{
   char *errortext;
   int errorline;
} ErrTable;

/*
** Parser definitions
*/

#include "asm7090.tok"

#define FLTNUM EOS-1

typedef uint8  tchar;  /* 0..255 */
typedef uint8  pstate; /* 0..255 */
typedef uint16 toktyp; /* 0..0x7F */
typedef uint16 tokval;

#define TOKENLEN  80 /* symbol and string length */
#define VALUEZERO 0

/*
** External definitions
*/

extern int asmpass1 (FILE *);
extern int asmpass2 (FILE *, FILE *, int, FILE *);

extern OpCode *oplookup (char *);

extern char *tokscan (char *, char **, int *, int *, char *);
extern SymNode *symlookup (char *, int, int);
extern char *exprscan (char *, int *, char *, int *, int, int, int);

extern tokval Parser (char *, int *, int *, int, int, int);
extern toktyp Scanner (char *, int *, tokval *, char *, char *);

#ifdef NEEDSTRTOLL
extern t_int64 strtoll (char *, char **, int);
#endif
