/***********************************************************************
*
* regs.h - IBM 7090 emulator Register and Channel definitions.
*
* Changes:
*   ??/??/??   PP    Original.
*   01/20/05   DGP   Changes for correct channel operation.
*   01/28/05   DGP   Revamped channel and tape controls.
*	
***********************************************************************/

#define NUMCHAN 4		/* Maximum current channels on a system */
#define MAXCHAN 8		/* Maximum channels on a system */
#define MAXTAPE 8		/* Maximum tapes on a channel */


#define SIGN	0200
#define QCARRY	0040
#define Q	0020
#define P	0010
#define HMSK	0007

#define MEMLIMIT 32767

EXTERN uint8 memh[MEMLIMIT+1];
#ifndef SMALL
EXTERN uint32 meml[MEMLIMIT + 1];
#define getmeml(a) meml[a]
#define setmeml(a, v) meml[a] = v
#else /* SMALL */
EXTERN uint32 getmeml();
#endif

EXTERN uint8 srh; EXTERN uint32 srl;
EXTERN uint8 sr2h; EXTERN uint32 sr2l;
EXTERN uint8 ach; EXTERN uint32 acl;
EXTERN uint8 mqh; EXTERN uint32 mql;
EXTERN uint8 sih; EXTERN uint32 sil;
EXTERN uint8 kyh; EXTERN uint32 kyl;
EXTERN uint8 adderh; EXTERN uint32 adderl;
EXTERN uint8 ssw;
EXTERN uint8 sl;
EXTERN uint16 ic;
EXTERN uint16 xr[8];

EXTERN uint8 automatic;
EXTERN uint8 run;
EXTERN uint8 stop;
EXTERN uint8 trap;
EXTERN uint8 simulate;
EXTERN uint8 multtag;
EXTERN uint8 acoflo;
EXTERN uint8 mqoflo;
EXTERN uint8 rwsel;
EXTERN uint8 divchk;
EXTERN uint8 iochk;
EXTERN uint8 machchk;

EXTERN uint16 op;
EXTERN uint8 tag;
EXTERN uint8 flag;
EXTERN uint16 addr;
EXTERN uint16 decr;
EXTERN uint16 y;
EXTERN uint8 shcnt;
EXTERN uint16 spill;

EXTERN int32 cpumode;
EXTERN int32 windowlen;
EXTERN uint32 cycle_count;
EXTERN uint32 next_steal;
EXTERN uint8 single_cycle;
#define NEXTLIGHTS 83333
EXTERN uint32 next_lights;
#define CYCLE() \
	cycle_count++; \
	if (cycle_count >= next_steal) steal_cycle();
#define DCYCLE() \
	if (cycle_count >= next_steal-1) steal_cycle(); \
	else { CYCLE() }

#define ACCESS(a) srh = memh[a]; srl = getmeml(a); CYCLE()
#define ACCESS2(a) sr2h = memh[a]; sr2l = getmeml(a); CYCLE()

EXTERN uint32 ctrap_enb;
EXTERN uint8 ctrap_ind;
EXTERN uint8 chan_in_op;

#define MAXRECLEN 196610	/* Maximum tape record size */

#define READ_SEL	1
#define WRITE_SEL	2
#define BSR_SEL 	3
#define BSF_SEL 	4
#define WEF_SEL 	5

#define TAPEIDLE	0
#define TAPEREAD	1
#define TAPEWRITE	2

typedef struct 
{
   uint32 curloc;		/* Current location on tape */
   uint32 reclen;		/* Record length */
   uint8  eof;			/* Tape at EOF */
   uint8  bot;			/* Tape at BOT */
   uint8  eot;			/* Tape at EOT */
   uint8  eor;			/* Tape at EOR */
   uint8  state;		/* Tape state: 0 idle, 1 read, 2 write */
   uint8  buf[MAXRECLEN];	/* Tape buffer */
} Tape_t;

typedef struct 
{
   uint8  cop;		/* Channel Operation */
   uint16 car;		/* Channel Address Register */
   uint16 cwr;		/* Channel Word Count */
   uint16 clr;		/* Channel Operation */
   uint8  cdrh;		/* Channel Operation */
   uint32 cdrl;		/* Channel Operation */
   uint16 cunit;	/* Channel Unit */
   uint8  csel;		/* Channel Selected  */
   uint8  cchk;		/* Channel I/O check */
   uint8  ceof;		/* Channel EOF */
   uint8  cbot;		/* Channel BOT */
   uint8  ceot;		/* Channel EOT */
   uint8  ceor;		/* Channel EOR */
   uint8  ctrp;		/* Channel Trap */
   uint32 ccyc;		/* Channel Cycle */
   uint8  cact;		/* Channel Active */
   uint8  ctm;		/* Channel Tape mark */
   Tape_t tapes[MAXTAPE]; /* Tapes on this channel */
} Channel_t;

EXTERN Channel_t channel[MAXCHAN];

